/*     */ package org.jboss.deployers.structure.spi.helpers;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.Comparator;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.SortedSet;
/*     */ import java.util.TreeSet;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import java.util.concurrent.CopyOnWriteArraySet;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.deployers.client.spi.Deployment;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.DeploymentState;
/*     */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*     */ import org.jboss.deployers.spi.attachments.helpers.ManagedObjectsWithTransientAttachmentsImpl;
/*     */ import org.jboss.deployers.structure.spi.ClassLoaderFactory;
/*     */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*     */ import org.jboss.deployers.structure.spi.DeploymentContextVisitor;
/*     */ import org.jboss.deployers.structure.spi.DeploymentResourceLoader;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.structure.spi.scope.ScopeBuilder;
/*     */ import org.jboss.deployers.structure.spi.scope.helpers.DefaultScopeBuilder;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.MutableMetaData;
/*     */ import org.jboss.metadata.spi.context.MetaDataContext;
/*     */ import org.jboss.metadata.spi.loader.MutableMetaDataLoader;
/*     */ import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ 
/*     */ public class AbstractDeploymentContext extends ManagedObjectsWithTransientAttachmentsImpl
/*     */   implements DeploymentContext
/*     */ {
/*     */   private static final long serialVersionUID = 7368360479461613969L;
/*  73 */   private static final Logger log = Logger.getLogger(AbstractDeploymentContext.class);
/*     */   private String name;
/*     */   private Set<Object> controllerContextNames;
/*     */   private String simpleName;
/*     */   private String relativePath;
/*     */   private DeploymentState state;
/*     */   private Throwable problem;
/*     */   private Deployment deployment;
/*     */   private transient DeploymentUnit unit;
/*     */   private transient ClassLoader classLoader;
/*     */   private transient ClassLoaderFactory classLoaderFactory;
/*     */   private transient ClassLoader resourceClassLoader;
/*     */   private boolean deployed;
/*     */   private DeploymentContext parent;
/* 115 */   private Set<String> deploymentTypes = new CopyOnWriteArraySet();
/*     */   private SortedSet<DeploymentContext> children;
/* 121 */   private List<DeploymentContext> components = new CopyOnWriteArrayList();
/*     */   private int relativeOrder;
/* 127 */   private Comparator<DeploymentContext> comparator = DefaultDeploymentContextComparator.INSTANCE;
/*     */   private ScopeKey scope;
/*     */   private ScopeKey mutableScope;
/*     */ 
/*     */   public static ScopeBuilder getScopeBuilder(DeploymentContext deploymentContext)
/*     */   {
/* 143 */     if (deploymentContext == null)
/* 144 */       throw new IllegalArgumentException("Null deployment context");
/* 145 */     ScopeBuilder builder = (ScopeBuilder)deploymentContext.getTransientAttachments().getAttachment(ScopeBuilder.class);
/* 146 */     if (builder != null)
/* 147 */       return builder;
/* 148 */     DeploymentContext parent = deploymentContext.getParent();
/* 149 */     if (parent != null)
/* 150 */       return getScopeBuilder(parent);
/* 151 */     return DefaultScopeBuilder.INSTANCE;
/*     */   }
/*     */ 
/*     */   public static MutableMetaDataRepository getRepository(DeploymentContext deploymentContext)
/*     */   {
/* 162 */     if (deploymentContext == null) {
/* 163 */       throw new IllegalArgumentException("Null deployment context");
/*     */     }
/* 165 */     MutableMetaDataRepository repository = (MutableMetaDataRepository)deploymentContext.getTransientAttachments().getAttachment(MutableMetaDataRepository.class);
/* 166 */     if (repository != null)
/* 167 */       return repository;
/* 168 */     DeploymentContext parent = deploymentContext.getParent();
/* 169 */     if (parent == null)
/* 170 */       return null;
/* 171 */     return getRepository(parent);
/*     */   }
/*     */ 
/*     */   public static void cleanupRepository(DeploymentContext deploymentContext)
/*     */   {
/* 181 */     MutableMetaDataRepository repository = getRepository(deploymentContext);
/* 182 */     if (repository == null) {
/* 183 */       return;
/*     */     }
/*     */     try
/*     */     {
/* 187 */       ScopeKey scope = deploymentContext.getScope();
/* 188 */       repository.removeMetaDataRetrieval(scope);
/*     */     }
/*     */     catch (Throwable ignored)
/*     */     {
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 196 */       ScopeKey scope = deploymentContext.getMutableScope();
/* 197 */       repository.removeMetaDataRetrieval(scope);
/*     */     }
/*     */     catch (Throwable ignored)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public static MetaData getMetaData(DeploymentContext deploymentContext)
/*     */   {
/* 212 */     MutableMetaDataRepository repository = getRepository(deploymentContext);
/* 213 */     if (repository == null) {
/* 214 */       return null;
/*     */     }
/* 216 */     MetaData metaData = repository.getMetaData(deploymentContext.getScope());
/* 217 */     if (metaData == null)
/*     */     {
/* 219 */       initMetaDataRetrieval(repository, deploymentContext);
/* 220 */       metaData = repository.getMetaData(deploymentContext.getScope());
/*     */     }
/* 222 */     return metaData;
/*     */   }
/*     */ 
/*     */   public static MutableMetaDataLoader getMutableMetaData(DeploymentContext deploymentContext)
/*     */   {
/* 233 */     MutableMetaDataRepository repository = getRepository(deploymentContext);
/* 234 */     if (repository == null) {
/* 235 */       return null;
/*     */     }
/* 237 */     ScopeKey mutableScope = deploymentContext.getMutableScope();
/* 238 */     MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(mutableScope);
/* 239 */     if (retrieval == null)
/*     */     {
/* 241 */       initMutableMetaDataRetrieval(repository, deploymentContext);
/* 242 */       retrieval = repository.getMetaDataRetrieval(mutableScope);
/*     */     }
/*     */ 
/* 246 */     if (retrieval == null) {
/* 247 */       return null;
/*     */     }
/*     */ 
/* 250 */     if ((retrieval instanceof MutableMetaDataLoader)) {
/* 251 */       return (MutableMetaDataLoader)retrieval;
/*     */     }
/*     */ 
/* 254 */     if ((retrieval instanceof MetaDataContext))
/*     */     {
/* 256 */       MetaDataContext context = (MetaDataContext)retrieval;
/* 257 */       List locals = context.getLocalRetrievals();
/* 258 */       if (locals != null)
/*     */       {
/* 260 */         for (MetaDataRetrieval local : locals)
/*     */         {
/* 262 */           if ((local instanceof MutableMetaDataLoader))
/* 263 */             return (MutableMetaDataLoader)local;
/*     */         }
/*     */       }
/*     */     }
/* 267 */     return null;
/*     */   }
/*     */ 
/*     */   private static void initMetaDataRetrieval(MutableMetaDataRepository repository, DeploymentContext deploymentContext)
/*     */   {
/* 278 */     if (deploymentContext == null) {
/* 279 */       throw new IllegalArgumentException("Null deployment context");
/*     */     }
/* 281 */     ScopeBuilder builder = (ScopeBuilder)deploymentContext.getTransientAttachments().getAttachment(ScopeBuilder.class);
/* 282 */     if (builder == null)
/* 283 */       builder = DefaultScopeBuilder.INSTANCE;
/* 284 */     builder.initMetaDataRetrieval(repository, deploymentContext);
/*     */   }
/*     */ 
/*     */   private static void initMutableMetaDataRetrieval(MutableMetaDataRepository repository, DeploymentContext deploymentContext)
/*     */   {
/* 295 */     if (deploymentContext == null) {
/* 296 */       throw new IllegalArgumentException("Null deployment context");
/*     */     }
/* 298 */     ScopeBuilder builder = (ScopeBuilder)deploymentContext.getTransientAttachments().getAttachment(ScopeBuilder.class);
/* 299 */     if (builder == null)
/* 300 */       builder = DefaultScopeBuilder.INSTANCE;
/* 301 */     builder.initMutableMetaDataRetrieval(repository, deploymentContext);
/*     */   }
/*     */ 
/*     */   public AbstractDeploymentContext()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractDeploymentContext(String name, String relativePath)
/*     */   {
/* 320 */     this(name, name, relativePath);
/*     */   }
/*     */ 
/*     */   public AbstractDeploymentContext(String name, String simpleName, String relativePath)
/*     */   {
/* 333 */     if (name == null)
/* 334 */       throw new IllegalArgumentException("Null name");
/* 335 */     if (relativePath == null)
/* 336 */       throw new IllegalArgumentException("Null relative path");
/* 337 */     this.name = name;
/* 338 */     this.simpleName = simpleName;
/* 339 */     if (simpleName == null)
/* 340 */       this.simpleName = name;
/* 341 */     this.relativePath = relativePath;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 346 */     return this.name;
/*     */   }
/*     */ 
/*     */   public Set<Object> getControllerContextNames()
/*     */   {
/* 351 */     return this.controllerContextNames != null ? Collections.unmodifiableSet(this.controllerContextNames) : null;
/*     */   }
/*     */ 
/*     */   public synchronized void addControllerContextName(Object name)
/*     */   {
/* 356 */     if (this.controllerContextNames == null)
/* 357 */       this.controllerContextNames = new HashSet();
/* 358 */     this.controllerContextNames.add(name);
/*     */   }
/*     */ 
/*     */   public synchronized void removeControllerContextName(Object name)
/*     */   {
/* 363 */     if (this.controllerContextNames != null)
/*     */     {
/* 365 */       this.controllerContextNames.remove(name);
/* 366 */       if (this.controllerContextNames.isEmpty())
/* 367 */         this.controllerContextNames = null;
/*     */     }
/*     */     else {
/* 370 */       log.warn("Removing name on null names: " + name);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getSimpleName() {
/* 375 */     return this.simpleName;
/*     */   }
/*     */ 
/*     */   public String getRelativePath()
/*     */   {
/* 380 */     return this.relativePath;
/*     */   }
/*     */ 
/*     */   public int getRelativeOrder()
/*     */   {
/* 385 */     return this.relativeOrder;
/*     */   }
/*     */ 
/*     */   public void setRelativeOrder(int relativeOrder)
/*     */   {
/* 390 */     this.relativeOrder = relativeOrder;
/*     */   }
/*     */ 
/*     */   public Comparator<DeploymentContext> getComparator()
/*     */   {
/* 395 */     return this.comparator;
/*     */   }
/*     */ 
/*     */   public void setComparator(Comparator<DeploymentContext> comparator)
/*     */   {
/* 400 */     if (comparator == null)
/* 401 */       comparator = DefaultDeploymentContextComparator.INSTANCE;
/* 402 */     this.comparator = comparator;
/*     */   }
/*     */ 
/*     */   public Set<String> getTypes()
/*     */   {
/* 407 */     return this.deploymentTypes;
/*     */   }
/*     */ 
/*     */   public ScopeKey getScope()
/*     */   {
/* 412 */     if (this.scope == null)
/*     */     {
/* 414 */       ScopeBuilder builder = getScopeBuilder(this);
/* 415 */       this.scope = builder.getDeploymentScope(this);
/*     */     }
/* 417 */     return this.scope;
/*     */   }
/*     */ 
/*     */   public void setScope(ScopeKey scope)
/*     */   {
/* 422 */     this.scope = scope;
/*     */   }
/*     */ 
/*     */   public ScopeKey getMutableScope()
/*     */   {
/* 427 */     if (this.mutableScope == null)
/*     */     {
/* 429 */       ScopeBuilder builder = getScopeBuilder(this);
/* 430 */       this.mutableScope = builder.getMutableDeploymentScope(this);
/*     */     }
/* 432 */     return this.mutableScope;
/*     */   }
/*     */ 
/*     */   public void setMutableScope(ScopeKey mutableScope)
/*     */   {
/* 437 */     this.mutableScope = mutableScope;
/*     */   }
/*     */ 
/*     */   public MetaData getMetaData()
/*     */   {
/* 442 */     return getMetaData(this);
/*     */   }
/*     */ 
/*     */   public MutableMetaData getMutableMetaData()
/*     */   {
/* 447 */     return getMutableMetaData(this);
/*     */   }
/*     */ 
/*     */   public DeploymentState getState()
/*     */   {
/* 452 */     return this.state;
/*     */   }
/*     */ 
/*     */   public void setState(DeploymentState state)
/*     */   {
/* 457 */     if (state == null)
/* 458 */       throw new IllegalArgumentException("Null state");
/* 459 */     this.state = state;
/*     */   }
/*     */ 
/*     */   public Deployment getDeployment()
/*     */   {
/* 464 */     return this.deployment;
/*     */   }
/*     */ 
/*     */   public void setDeployment(Deployment deployment)
/*     */   {
/* 469 */     if (deployment == null)
/* 470 */       throw new IllegalArgumentException("Null deployment");
/* 471 */     this.deployment = deployment;
/* 472 */     this.deployment.setTypes(getTypes());
/*     */   }
/*     */ 
/*     */   public DeploymentUnit getDeploymentUnit()
/*     */   {
/* 477 */     if (this.unit == null)
/* 478 */       this.unit = createDeploymentUnit();
/* 479 */     return this.unit;
/*     */   }
/*     */ 
/*     */   public void setDeploymentUnit(DeploymentUnit unit)
/*     */   {
/* 484 */     this.unit = unit;
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader()
/*     */   {
/* 489 */     return this.classLoader;
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoader classLoader)
/*     */   {
/* 494 */     this.classLoader = classLoader;
/* 495 */     if (classLoader != null)
/* 496 */       log.trace("ClassLoader for " + this.name + " is " + classLoader);
/*     */   }
/*     */ 
/*     */   public boolean createClassLoader(ClassLoaderFactory factory) throws DeploymentException
/*     */   {
/* 501 */     if (factory == null) {
/* 502 */       throw new IllegalArgumentException("Null factory");
/*     */     }
/* 504 */     ClassLoader cl = getClassLoader();
/* 505 */     if (cl != null) {
/* 506 */       return false;
/*     */     }
/*     */     try
/*     */     {
/* 510 */       cl = factory.createClassLoader(this);
/* 511 */       if (cl != null)
/*     */       {
/* 513 */         setClassLoader(cl);
/* 514 */         this.classLoaderFactory = factory;
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 519 */       throw DeploymentException.rethrowAsDeploymentException("Error creating classloader for " + getName(), t);
/*     */     }
/* 521 */     return true;
/*     */   }
/*     */ 
/*     */   public void removeClassLoader()
/*     */   {
/* 526 */     if (this.classLoaderFactory == null)
/* 527 */       return;
/*     */     try
/*     */     {
/* 530 */       this.classLoaderFactory.removeClassLoader(this);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 534 */       log.warn("Error removing classloader for " + getName(), t);
/*     */     }
/* 536 */     this.classLoaderFactory = null;
/* 537 */     setClassLoader(null);
/*     */   }
/*     */ 
/*     */   public void removeClassLoader(ClassLoaderFactory factory)
/*     */   {
/* 542 */     if (this.classLoaderFactory == factory)
/* 543 */       removeClassLoader();
/*     */   }
/*     */ 
/*     */   public boolean isTopLevel()
/*     */   {
/* 548 */     return this.parent == null;
/*     */   }
/*     */ 
/*     */   public DeploymentContext getTopLevel()
/*     */   {
/* 553 */     DeploymentContext result = this;
/* 554 */     DeploymentContext parent = getParent();
/* 555 */     while (parent != null)
/*     */     {
/* 557 */       result = parent;
/* 558 */       parent = parent.getParent();
/*     */     }
/* 560 */     return result;
/*     */   }
/*     */ 
/*     */   public DeploymentContext getParent()
/*     */   {
/* 565 */     return this.parent;
/*     */   }
/*     */ 
/*     */   public void setParent(DeploymentContext parent)
/*     */   {
/* 570 */     if ((parent != null) && (this.parent != null))
/* 571 */       throw new IllegalStateException("Context already has a parent " + getName());
/* 572 */     this.parent = parent;
/*     */   }
/*     */ 
/*     */   public List<DeploymentContext> getChildren()
/*     */   {
/* 577 */     if ((this.children == null) || (this.children.isEmpty())) {
/* 578 */       return Collections.emptyList();
/*     */     }
/* 580 */     return new ArrayList(this.children);
/*     */   }
/*     */ 
/*     */   public void addChild(DeploymentContext child)
/*     */   {
/* 585 */     if (child == null)
/* 586 */       throw new IllegalArgumentException("Null child");
/* 587 */     if (this.children == null)
/* 588 */       this.children = new TreeSet(this.comparator);
/* 589 */     this.children.add(child);
/*     */   }
/*     */ 
/*     */   public boolean removeChild(DeploymentContext child)
/*     */   {
/* 594 */     if (child == null)
/* 595 */       throw new IllegalArgumentException("Null child");
/* 596 */     if (this.children == null)
/* 597 */       return false;
/* 598 */     return this.children.remove(child);
/*     */   }
/*     */ 
/*     */   public boolean isComponent()
/*     */   {
/* 603 */     return false;
/*     */   }
/*     */ 
/*     */   public List<DeploymentContext> getComponents()
/*     */   {
/* 608 */     return Collections.unmodifiableList(this.components);
/*     */   }
/*     */ 
/*     */   public void addComponent(DeploymentContext component)
/*     */   {
/* 613 */     if (component == null)
/* 614 */       throw new IllegalArgumentException("Null component");
/* 615 */     deployed();
/* 616 */     this.components.add(component);
/* 617 */     log.debug("Added component " + component.getName() + " to " + getName());
/*     */   }
/*     */ 
/*     */   public boolean removeComponent(DeploymentContext component)
/*     */   {
/* 622 */     if (component == null) {
/* 623 */       throw new IllegalArgumentException("Null component");
/*     */     }
/* 625 */     List componentComponents = component.getComponents();
/* 626 */     if (!componentComponents.isEmpty())
/* 627 */       log.warn("Removing component " + this.name + " which still has components " + componentComponents);
/* 628 */     boolean result = this.components.remove(component);
/* 629 */     component.cleanup();
/* 630 */     if (result)
/* 631 */       log.debug("Removed component " + component.getName() + " from " + getName());
/* 632 */     return result;
/*     */   }
/*     */ 
/*     */   public ClassLoader getResourceClassLoader()
/*     */   {
/* 637 */     if (this.resourceClassLoader != null) {
/* 638 */       return this.resourceClassLoader;
/*     */     }
/* 640 */     DeploymentResourceLoader loader = getResourceLoader();
/* 641 */     this.resourceClassLoader = new DeploymentResourceClassLoader(loader);
/* 642 */     return this.resourceClassLoader;
/*     */   }
/*     */ 
/*     */   public DeploymentResourceLoader getResourceLoader()
/*     */   {
/* 647 */     return EmptyResourceLoader.INSTANCE;
/*     */   }
/*     */ 
/*     */   public DependencyInfo getDependencyInfo()
/*     */   {
/* 652 */     ControllerContext controllerContext = (ControllerContext)getTransientAttachments().getAttachment(ControllerContext.class);
/* 653 */     if (controllerContext != null) {
/* 654 */       return controllerContext.getDependencyInfo();
/*     */     }
/*     */ 
/* 657 */     DeploymentContext parent = getParent();
/* 658 */     if (parent == null)
/* 659 */       throw new IllegalStateException("Deployment ControllerContext has not been set");
/* 660 */     return parent.getDependencyInfo();
/*     */   }
/*     */ 
/*     */   public void visit(DeploymentContextVisitor visitor)
/*     */     throws DeploymentException
/*     */   {
/* 666 */     if (visitor == null) {
/* 667 */       throw new IllegalArgumentException("Null visitor");
/*     */     }
/* 669 */     visit(this, visitor);
/*     */   }
/*     */ 
/*     */   private void visit(DeploymentContext context, DeploymentContextVisitor visitor)
/*     */     throws DeploymentException
/*     */   {
/* 681 */     visitor.visit(context);
/*     */     try
/*     */     {
/* 684 */       List children = context.getChildren();
/* 685 */       if (children.isEmpty()) {
/* 686 */         return;
/*     */       }
/* 688 */       DeploymentContext[] childContexts = (DeploymentContext[])children.toArray(new DeploymentContext[children.size()]);
/* 689 */       for (int i = 0; i < childContexts.length; i++)
/*     */       {
/* 691 */         if (childContexts[i] == null)
/* 692 */           throw new IllegalStateException("Null child context for " + context.getName() + " children=" + children);
/*     */         try
/*     */         {
/* 695 */           visit(childContexts[i], visitor);
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 699 */           for (int j = i - 1; j >= 0; j--)
/* 700 */             visitError(childContexts[j], visitor, true);
/* 701 */           throw DeploymentException.rethrowAsDeploymentException("Error visiting: " + childContexts[i].getName(), t);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 707 */       visitError(context, visitor, false);
/* 708 */       throw DeploymentException.rethrowAsDeploymentException("Error visiting: " + context.getName(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void visitError(DeploymentContext context, DeploymentContextVisitor visitor, boolean visitChildren)
/*     */     throws DeploymentException
/*     */   {
/* 722 */     if (visitChildren)
/*     */     {
/* 724 */       List children = context.getChildren();
/* 725 */       if (children.isEmpty()) {
/* 726 */         return;
/*     */       }
/* 728 */       for (DeploymentContext child : children)
/*     */       {
/*     */         try
/*     */         {
/* 732 */           visitError(child, visitor, true);
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 736 */           log.warn("Error during visit error: " + child.getName(), t);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 743 */       visitor.error(context);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 747 */       log.warn("Error during visit error: " + context.getName(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Throwable getProblem()
/*     */   {
/* 753 */     return this.problem;
/*     */   }
/*     */ 
/*     */   public void setProblem(Throwable problem)
/*     */   {
/* 758 */     this.problem = problem;
/*     */   }
/*     */ 
/*     */   public boolean isDeployed()
/*     */   {
/* 763 */     return this.deployed;
/*     */   }
/*     */ 
/*     */   public void deployed()
/*     */   {
/* 768 */     this.deployed = true;
/*     */   }
/*     */ 
/*     */   public void cleanup()
/*     */   {
/* 773 */     cleanupRepository(this);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 779 */     StringBuilder buffer = new StringBuilder();
/* 780 */     buffer.append(getClass().getSimpleName());
/* 781 */     buffer.append('@');
/* 782 */     buffer.append(System.identityHashCode(this));
/* 783 */     buffer.append('{').append(this.name).append('}');
/* 784 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   protected DeploymentUnit createDeploymentUnit()
/*     */   {
/* 794 */     return new AbstractDeploymentUnit(this);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 800 */     super.readExternal(in);
/* 801 */     this.name = in.readUTF();
/* 802 */     this.simpleName = in.readUTF();
/* 803 */     this.relativePath = in.readUTF();
/* 804 */     this.state = ((DeploymentState)in.readObject());
/* 805 */     this.problem = ((Throwable)in.readObject());
/* 806 */     this.deployment = ((Deployment)in.readObject());
/* 807 */     this.deployed = in.readBoolean();
/* 808 */     this.parent = ((DeploymentContext)in.readObject());
/* 809 */     this.deploymentTypes = ((Set)in.readObject());
/* 810 */     this.children = ((SortedSet)in.readObject());
/* 811 */     this.components = ((List)in.readObject());
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 831 */     super.writeExternal(out);
/* 832 */     out.writeUTF(this.name);
/* 833 */     out.writeUTF(this.simpleName);
/* 834 */     out.writeUTF(this.relativePath);
/* 835 */     out.writeObject(this.state);
/* 836 */     out.writeObject(this.problem);
/* 837 */     out.writeObject(this.deployment);
/* 838 */     out.writeBoolean(this.deployed);
/* 839 */     out.writeObject(this.parent);
/* 840 */     out.writeObject(this.deploymentTypes);
/* 841 */     out.writeObject(this.children);
/* 842 */     out.writeObject(this.components);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.structure.spi.helpers.AbstractDeploymentContext
 * JD-Core Version:    0.6.0
 */