/*     */ package org.jboss.deployers.structure.spi.helpers;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.attachments.Attachments;
/*     */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*     */ import org.jboss.deployers.spi.attachments.helpers.AbstractMutableAttachments;
/*     */ import org.jboss.deployers.structure.spi.ClassLoaderFactory;
/*     */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*     */ import org.jboss.deployers.structure.spi.DeploymentResourceLoader;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.MutableMetaData;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ 
/*     */ public class AbstractDeploymentUnit extends AbstractMutableAttachments
/*     */   implements DeploymentUnit
/*     */ {
/*     */   private static final long serialVersionUID = 1513962148798298768L;
/*     */   private DeploymentContext deploymentContext;
/*     */ 
/*     */   public AbstractDeploymentUnit()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractDeploymentUnit(DeploymentContext deploymentContext)
/*     */   {
/*  81 */     if (deploymentContext == null)
/*  82 */       throw new IllegalArgumentException("Null deployment context");
/*  83 */     this.deploymentContext = deploymentContext;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  88 */     return this.deploymentContext.getName();
/*     */   }
/*     */ 
/*     */   public Set<Object> getControllerContextNames()
/*     */   {
/*  93 */     return this.deploymentContext.getControllerContextNames();
/*     */   }
/*     */ 
/*     */   public void addControllerContextName(Object name)
/*     */   {
/*  98 */     this.deploymentContext.addControllerContextName(name);
/*     */   }
/*     */ 
/*     */   public void removeControllerContextName(Object name)
/*     */   {
/* 103 */     this.deploymentContext.removeControllerContextName(name);
/*     */   }
/*     */ 
/*     */   public String getSimpleName()
/*     */   {
/* 108 */     return this.deploymentContext.getSimpleName();
/*     */   }
/*     */ 
/*     */   public String getRelativePath()
/*     */   {
/* 113 */     return this.deploymentContext.getRelativePath();
/*     */   }
/*     */ 
/*     */   public Set<String> getTypes()
/*     */   {
/* 118 */     return this.deploymentContext.getTypes();
/*     */   }
/*     */ 
/*     */   public ScopeKey getScope()
/*     */   {
/* 123 */     return this.deploymentContext.getScope();
/*     */   }
/*     */ 
/*     */   public void setScope(ScopeKey key)
/*     */   {
/* 128 */     this.deploymentContext.setScope(key);
/*     */   }
/*     */ 
/*     */   public ScopeKey getMutableScope()
/*     */   {
/* 133 */     return this.deploymentContext.getMutableScope();
/*     */   }
/*     */ 
/*     */   public void setMutableScope(ScopeKey key)
/*     */   {
/* 138 */     this.deploymentContext.setMutableScope(key);
/*     */   }
/*     */ 
/*     */   public MetaData getMetaData()
/*     */   {
/* 143 */     return this.deploymentContext.getMetaData();
/*     */   }
/*     */ 
/*     */   public MutableMetaData getMutableMetaData()
/*     */   {
/* 148 */     return this.deploymentContext.getMutableMetaData();
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader()
/*     */   {
/* 153 */     ClassLoader cl = this.deploymentContext.getClassLoader();
/* 154 */     if (cl == null)
/* 155 */       throw new IllegalStateException("ClassLoader has not been set");
/* 156 */     this.deploymentContext.deployed();
/* 157 */     return cl;
/*     */   }
/*     */ 
/*     */   public boolean createClassLoader(ClassLoaderFactory factory) throws DeploymentException
/*     */   {
/* 162 */     return this.deploymentContext.createClassLoader(factory);
/*     */   }
/*     */ 
/*     */   public void removeClassLoader(ClassLoaderFactory factory)
/*     */   {
/* 167 */     this.deploymentContext.removeClassLoader(factory);
/*     */   }
/*     */ 
/*     */   public DeploymentUnit getTopLevel()
/*     */   {
/* 172 */     DeploymentUnit top = getParent();
/* 173 */     if (top == null)
/* 174 */       top = this;
/* 175 */     return top;
/*     */   }
/*     */ 
/*     */   public DeploymentUnit getParent()
/*     */   {
/* 180 */     DeploymentContext parent = this.deploymentContext.getParent();
/* 181 */     if (parent == null)
/* 182 */       return null;
/* 183 */     return parent.getDeploymentUnit();
/*     */   }
/*     */ 
/*     */   public List<DeploymentUnit> getChildren()
/*     */   {
/* 188 */     List children = this.deploymentContext.getChildren();
/* 189 */     if ((children == null) || (children.isEmpty())) {
/* 190 */       return Collections.emptyList();
/*     */     }
/* 192 */     List result = new ArrayList(children.size());
/* 193 */     for (DeploymentContext child : children)
/*     */     {
/* 195 */       DeploymentUnit unit = child.getDeploymentUnit();
/* 196 */       result.add(unit);
/*     */     }
/* 198 */     return result;
/*     */   }
/*     */ 
/*     */   public List<DeploymentUnit> getComponents()
/*     */   {
/* 203 */     List components = this.deploymentContext.getComponents();
/* 204 */     if ((components == null) || (components.isEmpty())) {
/* 205 */       return Collections.emptyList();
/*     */     }
/* 207 */     List result = new ArrayList(components.size());
/* 208 */     for (DeploymentContext component : components)
/*     */     {
/* 210 */       DeploymentUnit unit = component.getDeploymentUnit();
/* 211 */       result.add(unit);
/*     */     }
/* 213 */     return result;
/*     */   }
/*     */ 
/*     */   protected DeploymentContext createComponentDeploymentContext(String name, DeploymentContext parent)
/*     */   {
/* 225 */     return new ComponentDeploymentContext(name, parent);
/*     */   }
/*     */ 
/*     */   protected DeploymentUnit createComponentDeploymentUnit(DeploymentContext component)
/*     */   {
/* 236 */     return new AbstractDeploymentUnit(component);
/*     */   }
/*     */ 
/*     */   public boolean isComponent()
/*     */   {
/* 241 */     return this.deploymentContext.isComponent();
/*     */   }
/*     */ 
/*     */   public DeploymentUnit addComponent(String name)
/*     */   {
/* 246 */     DeploymentContext component = createComponentDeploymentContext(name, this.deploymentContext);
/* 247 */     DeploymentUnit unit = createComponentDeploymentUnit(component);
/* 248 */     component.setDeploymentUnit(unit);
/* 249 */     this.deploymentContext.addComponent(component);
/* 250 */     return unit;
/*     */   }
/*     */ 
/*     */   public boolean removeComponent(String name)
/*     */   {
/* 255 */     if (name == null) {
/* 256 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 258 */     for (DeploymentContext component : this.deploymentContext.getComponents())
/*     */     {
/* 260 */       if (name.equals(component.getName()))
/* 261 */         return this.deploymentContext.removeComponent(component);
/*     */     }
/* 263 */     return false;
/*     */   }
/*     */ 
/*     */   public <T> Set<? extends T> getAllMetaData(Class<T> type)
/*     */   {
/* 268 */     if (type == null) {
/* 269 */       throw new IllegalArgumentException("Null type");
/*     */     }
/* 271 */     Set result = new HashSet();
/* 272 */     Map attachments = getAttachments();
/* 273 */     for (Iterator i$ = attachments.values().iterator(); i$.hasNext(); ) { Object object = i$.next();
/*     */ 
/* 275 */       if (type.isInstance(object))
/*     */       {
/* 277 */         Object t = type.cast(object);
/* 278 */         result.add(t);
/*     */       }
/*     */     }
/* 281 */     if (!result.isEmpty())
/* 282 */       this.deploymentContext.deployed();
/* 283 */     return result;
/*     */   }
/*     */ 
/*     */   public MutableAttachments getTransientManagedObjects()
/*     */   {
/* 288 */     return this.deploymentContext.getTransientManagedObjects();
/*     */   }
/*     */ 
/*     */   public Object addAttachment(String name, Object attachment)
/*     */   {
/* 293 */     this.deploymentContext.deployed();
/* 294 */     return this.deploymentContext.getTransientAttachments().addAttachment(name, attachment);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 299 */     this.deploymentContext.getTransientAttachments().clear();
/* 300 */     this.deploymentContext.getTransientManagedObjects().clear();
/*     */   }
/*     */ 
/*     */   public void clearChangeCount()
/*     */   {
/* 305 */     this.deploymentContext.getTransientAttachments().clearChangeCount();
/* 306 */     this.deploymentContext.getTransientManagedObjects().clearChangeCount();
/*     */   }
/*     */ 
/*     */   public int getChangeCount()
/*     */   {
/* 311 */     return this.deploymentContext.getTransientAttachments().getChangeCount() + this.deploymentContext.getTransientManagedObjects().getChangeCount();
/*     */   }
/*     */ 
/*     */   public Object removeAttachment(String name)
/*     */   {
/* 316 */     return this.deploymentContext.getTransientAttachments().removeAttachment(name);
/*     */   }
/*     */ 
/*     */   public Object getAttachment(String name)
/*     */   {
/* 321 */     DeploymentContext parent = this.deploymentContext.getParent();
/* 322 */     if (!this.deploymentContext.isComponent())
/* 323 */       parent = null;
/* 324 */     Object result = this.deploymentContext.getPredeterminedManagedObjects().getAttachment(name);
/* 325 */     if (result != null)
/*     */     {
/* 327 */       this.deploymentContext.deployed();
/* 328 */       return result;
/*     */     }
/* 330 */     if (parent != null)
/*     */     {
/* 332 */       result = parent.getPredeterminedManagedObjects().getAttachment(name);
/* 333 */       if (result != null)
/*     */       {
/* 335 */         this.deploymentContext.deployed();
/* 336 */         return result;
/*     */       }
/*     */     }
/* 339 */     result = this.deploymentContext.getTransientManagedObjects().getAttachment(name);
/* 340 */     if (result != null)
/*     */     {
/* 342 */       this.deploymentContext.deployed();
/* 343 */       return result;
/*     */     }
/* 345 */     if (parent != null)
/*     */     {
/* 347 */       result = parent.getTransientManagedObjects().getAttachment(name);
/* 348 */       if (result != null)
/*     */       {
/* 350 */         this.deploymentContext.deployed();
/* 351 */         return result;
/*     */       }
/*     */     }
/* 354 */     result = this.deploymentContext.getTransientAttachments().getAttachment(name);
/* 355 */     if (result != null)
/*     */     {
/* 357 */       this.deploymentContext.deployed();
/* 358 */       return result;
/*     */     }
/* 360 */     if (parent != null)
/*     */     {
/* 362 */       result = parent.getTransientAttachments().getAttachment(name);
/* 363 */       if (result != null)
/*     */       {
/* 365 */         this.deploymentContext.deployed();
/* 366 */         return result;
/*     */       }
/*     */     }
/* 369 */     return null;
/*     */   }
/*     */ 
/*     */   public Map<String, Object> getAttachments()
/*     */   {
/* 374 */     DeploymentContext parent = this.deploymentContext.getParent();
/* 375 */     if (!this.deploymentContext.isComponent())
/* 376 */       parent = null;
/* 377 */     HashMap result = new HashMap();
/* 378 */     if (parent != null)
/* 379 */       result.putAll(parent.getTransientAttachments().getAttachments());
/* 380 */     result.putAll(this.deploymentContext.getTransientAttachments().getAttachments());
/* 381 */     if (parent != null)
/* 382 */       result.putAll(parent.getTransientManagedObjects().getAttachments());
/* 383 */     result.putAll(this.deploymentContext.getTransientManagedObjects().getAttachments());
/* 384 */     if (parent != null)
/* 385 */       result.putAll(parent.getPredeterminedManagedObjects().getAttachments());
/* 386 */     result.putAll(this.deploymentContext.getPredeterminedManagedObjects().getAttachments());
/* 387 */     if (!result.isEmpty())
/* 388 */       this.deploymentContext.deployed();
/* 389 */     return Collections.unmodifiableMap(result);
/*     */   }
/*     */ 
/*     */   public boolean hasAttachments()
/*     */   {
/* 394 */     if (this.deploymentContext.getTransientAttachments().hasAttachments())
/* 395 */       return true;
/* 396 */     if (this.deploymentContext.getTransientManagedObjects().hasAttachments())
/* 397 */       return true;
/* 398 */     if (this.deploymentContext.getPredeterminedManagedObjects().hasAttachments()) {
/* 399 */       return true;
/*     */     }
/* 401 */     if (this.deploymentContext.isComponent())
/* 402 */       return this.deploymentContext.getParent().getDeploymentUnit().hasAttachments();
/* 403 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isAttachmentPresent(String name)
/*     */   {
/* 408 */     return getAttachment(name) != null;
/*     */   }
/*     */ 
/*     */   public ClassLoader getResourceClassLoader()
/*     */   {
/* 413 */     return this.deploymentContext.getResourceClassLoader();
/*     */   }
/*     */ 
/*     */   public DeploymentResourceLoader getResourceLoader()
/*     */   {
/* 418 */     return this.deploymentContext.getResourceLoader();
/*     */   }
/*     */ 
/*     */   public void addIDependOn(DependencyItem dependency)
/*     */   {
/* 423 */     getDependencyInfo().addIDependOn(dependency);
/*     */   }
/*     */ 
/*     */   public DependencyInfo getDependencyInfo()
/*     */   {
/* 428 */     return this.deploymentContext.getDependencyInfo();
/*     */   }
/*     */ 
/*     */   public void removeIDependOn(DependencyItem dependency)
/*     */   {
/* 433 */     getDependencyInfo().removeIDependOn(dependency);
/*     */   }
/*     */ 
/*     */   protected DeploymentContext getDeploymentContext()
/*     */   {
/* 443 */     return this.deploymentContext;
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/* 448 */     super.readExternal(in);
/* 449 */     this.deploymentContext = ((DeploymentContext)in.readObject());
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 459 */     super.writeExternal(out);
/* 460 */     out.writeObject(this.deploymentContext);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.structure.spi.helpers.AbstractDeploymentUnit
 * JD-Core Version:    0.6.0
 */