/*     */ package org.jboss.deployers.structure.spi.helpers;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.util.Comparator;
/*     */ import java.util.List;
/*     */ import org.jboss.deployers.client.spi.Deployment;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.DeploymentState;
/*     */ import org.jboss.deployers.spi.attachments.Attachments;
/*     */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*     */ import org.jboss.deployers.spi.structure.ContextInfo;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaData;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
/*     */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*     */ import org.jboss.deployers.structure.spi.StructureBuilder;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class AbstractStructureBuilder
/*     */   implements StructureBuilder
/*     */ {
/*  48 */   private final Logger log = Logger.getLogger(getClass());
/*     */ 
/*     */   public DeploymentContext populateContext(Deployment deployment, StructureMetaData metaData) throws DeploymentException
/*     */   {
/*  52 */     if (deployment == null)
/*  53 */       throw new IllegalArgumentException("Null deployment");
/*  54 */     if (metaData == null) {
/*  55 */       throw new IllegalArgumentException("Null metaData");
/*     */     }
/*  57 */     boolean trace = this.log.isTraceEnabled();
/*  58 */     if (trace)
/*  59 */       this.log.trace("Populating deployment " + deployment.getName() + " metaData=" + metaData);
/*     */     DeploymentContext result;
/*     */     try
/*     */     {
/*  64 */       result = createRootDeploymentContext(deployment);
/*  65 */       if (result == null)
/*  66 */         throw new IllegalStateException("Root deployment context is null");
/*  67 */       result.setDeployment(deployment);
/*     */ 
/*  69 */       ContextInfo contextInfo = metaData.getContext("");
/*  70 */       if (contextInfo == null)
/*  71 */         contextInfo = StructureMetaDataFactory.createContextInfo("", null);
/*  72 */       contextInfo.setPredeterminedManagedObjects(deployment.getPredeterminedManagedObjects());
/*  73 */       applyContextInfo(result, contextInfo);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  77 */       throw DeploymentException.rethrowAsDeploymentException("Error populating deployment " + deployment.getName(), t);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  82 */       result.getTransientManagedObjects().addAttachment(StructureMetaData.class, metaData);
/*  83 */       populateContext(result, metaData);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  87 */       result.setProblem(t);
/*  88 */       result.setState(DeploymentState.ERROR);
/*  89 */       this.log.warn("Error populating deployment " + deployment.getName(), t);
/*     */     }
/*  91 */     return result;
/*     */   }
/*     */ 
/*     */   protected void populateContext(DeploymentContext context, StructureMetaData metaData)
/*     */     throws Exception
/*     */   {
/* 103 */     if (context == null)
/* 104 */       throw new IllegalArgumentException("Null context");
/* 105 */     if (metaData == null) {
/* 106 */       throw new IllegalArgumentException("Null metaData");
/*     */     }
/* 108 */     boolean trace = this.log.isTraceEnabled();
/* 109 */     if (trace) {
/* 110 */       this.log.trace("Populating Context " + context.getName() + " metaData=" + metaData);
/*     */     }
/* 112 */     List contexts = metaData.getContexts();
/* 113 */     if (contexts == null) {
/* 114 */       return;
/*     */     }
/*     */     try
/*     */     {
/* 118 */       for (ContextInfo child : contexts)
/*     */       {
/* 121 */         if (!"".equals(child.getPath()))
/*     */         {
/* 123 */           DeploymentContext childContext = createChildDeploymentContext(context, child);
/* 124 */           if (childContext == null) {
/* 125 */             throw new IllegalStateException("Child deployment context is null");
/*     */           }
/* 127 */           context.addChild(childContext);
/* 128 */           childContext.setParent(context);
/*     */ 
/* 130 */           applyContextInfo(childContext, child);
/*     */ 
/* 132 */           Attachments attachments = child.getPredeterminedManagedObjects();
/* 133 */           if (attachments != null)
/*     */           {
/* 135 */             StructureMetaData childStructure = (StructureMetaData)attachments.getAttachment(StructureMetaData.class);
/* 136 */             if (childStructure != null)
/* 137 */               populateContext(childContext, childStructure);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 144 */       throw DeploymentException.rethrowAsDeploymentException("Error populating context " + context.getName(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void applyContextInfo(DeploymentContext context, ContextInfo contextInfo)
/*     */     throws Exception
/*     */   {
/* 158 */     Attachments attachments = contextInfo.getPredeterminedManagedObjects();
/* 159 */     if (attachments != null) {
/* 160 */       context.setPredeterminedManagedObjects(attachments);
/*     */     }
/* 162 */     context.setRelativeOrder(contextInfo.getRelativeOrder());
/* 163 */     applyComparator(context, contextInfo);
/*     */   }
/*     */ 
/*     */   protected void applyComparator(DeploymentContext context, ContextInfo contextInfo)
/*     */     throws Exception
/*     */   {
/* 176 */     String className = contextInfo.getComparatorClassName();
/* 177 */     if (className == null)
/* 178 */       return;
/* 179 */     Object o = null;
/*     */     try
/*     */     {
/* 182 */       Class clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
/*     */       try
/*     */       {
/* 185 */         Field field = clazz.getField("INSTANCE");
/* 186 */         o = field.get(null);
/*     */       }
/*     */       catch (NoSuchFieldException ignored)
/*     */       {
/*     */       }
/* 191 */       if (o == null)
/* 192 */         o = clazz.newInstance();
/* 193 */       Comparator comparator = (Comparator)Comparator.class.cast(o);
/* 194 */       context.setComparator(comparator);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 198 */       this.log.warn("Unable to load/set comparator: " + className);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected DeploymentContext createRootDeploymentContext(Deployment deployment)
/*     */     throws Exception
/*     */   {
/* 211 */     return new AbstractDeploymentContext(deployment.getName(), "");
/*     */   }
/*     */ 
/*     */   protected DeploymentContext createChildDeploymentContext(DeploymentContext parent, ContextInfo child)
/*     */     throws Exception
/*     */   {
/* 224 */     String path = child.getPath();
/* 225 */     String name = parent.getName() + "/" + path;
/* 226 */     return new AbstractDeploymentContext(name, path);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.structure.spi.helpers.AbstractStructureBuilder
 * JD-Core Version:    0.6.0
 */