/*     */ package org.jboss.deployers.structure.spi.scope.helpers;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*     */ import org.jboss.deployers.structure.spi.scope.ScopeBuilder;
/*     */ import org.jboss.metadata.plugins.context.AbstractMetaDataContext;
/*     */ import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
/*     */ import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.scope.CommonLevels;
/*     */ import org.jboss.metadata.spi.scope.Scope;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ 
/*     */ public class DefaultScopeBuilder
/*     */   implements ScopeBuilder
/*     */ {
/*  45 */   public static final DefaultScopeBuilder INSTANCE = new DefaultScopeBuilder();
/*     */ 
/*     */   public ScopeKey getDeploymentScope(DeploymentContext context)
/*     */   {
/*  49 */     if (context == null) {
/*  50 */       throw new IllegalArgumentException("Null context");
/*     */     }
/*  52 */     DeploymentContext top = context.getTopLevel();
/*     */ 
/*  54 */     ScopeKey result = ScopeKey.DEFAULT_SCOPE.clone();
/*  55 */     result.addScope(CommonLevels.APPLICATION, top.getName());
/*  56 */     result.addScope(CommonLevels.DEPLOYMENT, context.getName());
/*  57 */     return result;
/*     */   }
/*     */ 
/*     */   public ScopeKey getMutableDeploymentScope(DeploymentContext context)
/*     */   {
/*  62 */     if (context == null) {
/*  63 */       throw new IllegalArgumentException("Null context");
/*     */     }
/*  65 */     if (context.isTopLevel()) {
/*  66 */       return new ScopeKey(CommonLevels.APPLICATION, context.getName());
/*     */     }
/*  68 */     return new ScopeKey(CommonLevels.DEPLOYMENT, context.getName());
/*     */   }
/*     */ 
/*     */   public ScopeKey getComponentScope(DeploymentContext context)
/*     */   {
/*  73 */     if (context == null) {
/*  74 */       throw new IllegalArgumentException("Null context");
/*     */     }
/*  76 */     DeploymentContext parent = context;
/*  77 */     while (parent.isComponent())
/*     */     {
/*  79 */       parent = context.getParent();
/*  80 */       if (parent == null)
/*  81 */         throw new IllegalStateException("Component has no regular parent?");
/*     */     }
/*  83 */     ScopeKey result = parent.getScope().clone();
/*  84 */     result.addScope(CommonLevels.INSTANCE, context.getName());
/*  85 */     return result;
/*     */   }
/*     */ 
/*     */   public ScopeKey getMutableComponentScope(DeploymentContext context)
/*     */   {
/*  90 */     if (context == null) {
/*  91 */       throw new IllegalArgumentException("Null context");
/*     */     }
/*  93 */     return new ScopeKey(CommonLevels.INSTANCE, context.getName());
/*     */   }
/*     */ 
/*     */   public void initMetaDataRetrieval(MutableMetaDataRepository repository, DeploymentContext context)
/*     */   {
/*  98 */     if (repository == null)
/*  99 */       throw new IllegalArgumentException("Null repository");
/* 100 */     if (context == null) {
/* 101 */       throw new IllegalArgumentException("Null context");
/*     */     }
/* 103 */     ScopeKey scopeKey = context.getScope();
/*     */ 
/* 105 */     ArrayList retrievals = new ArrayList();
/* 106 */     for (Scope scope : scopeKey.getScopes())
/*     */     {
/* 108 */       ScopeKey thisScope = new ScopeKey(scope);
/* 109 */       MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(thisScope);
/* 110 */       if (retrieval == null)
/*     */       {
/* 112 */         retrieval = new MemoryMetaDataLoader(thisScope);
/* 113 */         repository.addMetaDataRetrieval(retrieval);
/*     */       }
/* 115 */       retrievals.add(0, retrieval);
/*     */     }
/* 117 */     AbstractMetaDataContext metaDataContext = new AbstractMetaDataContext(null, retrievals);
/* 118 */     repository.addMetaDataRetrieval(metaDataContext);
/*     */   }
/*     */ 
/*     */   public void initMutableMetaDataRetrieval(MutableMetaDataRepository repository, DeploymentContext context)
/*     */   {
/* 123 */     if (repository == null)
/* 124 */       throw new IllegalArgumentException("Null repository");
/* 125 */     if (context == null) {
/* 126 */       throw new IllegalArgumentException("Null context");
/*     */     }
/* 128 */     ScopeKey scopeKey = context.getMutableScope();
/* 129 */     MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(scopeKey);
/* 130 */     if (retrieval == null)
/*     */     {
/* 132 */       retrieval = new MemoryMetaDataLoader(scopeKey);
/* 133 */       repository.addMetaDataRetrieval(retrieval);
/*     */     }
/* 135 */     AbstractMetaDataContext metaDataContext = new AbstractMetaDataContext(null, retrieval);
/* 136 */     repository.addMetaDataRetrieval(metaDataContext);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.structure.spi.scope.helpers.DefaultScopeBuilder
 * JD-Core Version:    0.6.0
 */