/*    */ package org.jboss.deployers.vfs.deployer.kernel;
/*    */ 
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.beans.metadata.spi.NamedAliasMetaData;
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
/*    */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.kernel.spi.dependency.KernelController;
/*    */ 
/*    */ public class DeploymentAliasMetaDataDeployer extends AbstractSimpleRealDeployer<NamedAliasMetaData>
/*    */ {
/*    */   private final KernelController controller;
/*    */ 
/*    */   public DeploymentAliasMetaDataDeployer(Kernel kernel)
/*    */   {
/* 50 */     super(NamedAliasMetaData.class);
/* 51 */     addInput(BeanMetaData.class);
/* 52 */     if (kernel == null)
/* 53 */       throw new IllegalArgumentException("Null kernel");
/* 54 */     this.controller = kernel.getController();
/* 55 */     setComponentsOnly(true);
/*    */   }
/*    */ 
/*    */   public void deploy(DeploymentUnit unit, NamedAliasMetaData deployment)
/*    */     throws DeploymentException
/*    */   {
/*    */     try
/*    */     {
/* 63 */       this.controller.addAlias(deployment.getAliasValue(), deployment.getName());
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 67 */       throw DeploymentException.rethrowAsDeploymentException("Error deploying alias: " + deployment.getName(), t);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void undeploy(DeploymentUnit unit, NamedAliasMetaData deployment)
/*    */   {
/* 74 */     this.controller.removeAlias(deployment.getAliasValue());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.deployer.kernel.DeploymentAliasMetaDataDeployer
 * JD-Core Version:    0.6.0
 */