/*     */ package org.jboss.deployers.vfs.plugins.classloader;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.security.CodeSource;
/*     */ import java.security.PermissionCollection;
/*     */ import java.security.Policy;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.security.cert.Certificate;
/*     */ import java.util.Arrays;
/*     */ import java.util.Set;
/*     */ import java.util.jar.Manifest;
/*     */ import org.jboss.classloader.spi.ClassLoaderPolicy;
/*     */ import org.jboss.classloader.spi.PackageInformation;
/*     */ import org.jboss.deployers.structure.spi.classloading.ExportAll;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VFS;
/*     */ import org.jboss.virtual.VFSUtils;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class VFSClassLoaderPolicy extends ClassLoaderPolicy
/*     */ {
/*  52 */   private static Logger log = Logger.getLogger(VFSClassLoaderPolicy.class);
/*     */   private VirtualFile[] roots;
/*     */   private ExportAll exportAll;
/*     */   private String[] exportedPackages;
/*     */   private boolean importAll;
/*     */ 
/*     */   public static VFSClassLoaderPolicy createVFSClassLoaderPolicy(VirtualFile[] roots)
/*     */   {
/*  75 */     return new VFSClassLoaderPolicy(roots);
/*     */   }
/*     */ 
/*     */   public VFSClassLoaderPolicy(VirtualFile[] roots)
/*     */   {
/*  86 */     if (roots == null)
/*  87 */       throw new IllegalArgumentException("Null roots");
/*  88 */     for (VirtualFile root : roots)
/*     */     {
/*  90 */       if (root == null) {
/*  91 */         throw new IllegalArgumentException("Null root in " + Arrays.asList(roots));
/*     */       }
/*     */     }
/*  94 */     this.roots = roots;
/*     */   }
/*     */ 
/*     */   public ExportAll isExportAll()
/*     */   {
/* 104 */     return this.exportAll;
/*     */   }
/*     */ 
/*     */   public void setExportAll(ExportAll exportAll)
/*     */   {
/* 114 */     this.exportAll = exportAll;
/* 115 */     if (exportAll != null)
/* 116 */       this.exportedPackages = ((String[])determineAllPackages().toArray(new String[0]));
/*     */     else
/* 118 */       this.exportedPackages = null;
/*     */   }
/*     */ 
/*     */   public boolean isImportAll()
/*     */   {
/* 124 */     return this.importAll;
/*     */   }
/*     */ 
/*     */   public void setImportAll(boolean importAll)
/*     */   {
/* 134 */     this.importAll = importAll;
/*     */   }
/*     */ 
/*     */   public String[] getPackageNames()
/*     */   {
/* 140 */     return this.exportedPackages;
/*     */   }
/*     */ 
/*     */   public void setExportedPackages(String[] exportedPackages)
/*     */   {
/* 150 */     this.exportedPackages = exportedPackages;
/*     */   }
/*     */ 
/*     */   public URL getResource(String path)
/*     */   {
/* 156 */     VirtualFile child = findChild(path);
/* 157 */     if (child != null)
/*     */     {
/*     */       try
/*     */       {
/* 161 */         return child.toURL();
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/* 165 */         log.trace("Error determining URL for " + child, ignored);
/* 166 */         return null;
/*     */       }
/*     */     }
/* 169 */     return null;
/*     */   }
/*     */ 
/*     */   public InputStream getResourceAsStream(String path)
/*     */   {
/* 175 */     VirtualFile child = findChild(path);
/* 176 */     if (child != null)
/*     */     {
/*     */       try
/*     */       {
/* 180 */         return child.openStream();
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/* 184 */         log.trace("Error opening stream for " + child, ignored);
/* 185 */         return null;
/*     */       }
/*     */     }
/* 188 */     return null;
/*     */   }
/*     */ 
/*     */   public void getResources(String name, Set<URL> urls)
/*     */     throws IOException
/*     */   {
/* 194 */     for (VirtualFile root : this.roots)
/*     */     {
/*     */       try
/*     */       {
/* 198 */         VirtualFile child = root.findChild(name);
/* 199 */         urls.add(child.toURL());
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/* 203 */         log.trace("Error getting resources for " + root, ignored);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected VirtualFile findChild(String path)
/*     */   {
/* 216 */     for (VirtualFile root : this.roots)
/*     */     {
/*     */       try
/*     */       {
/* 220 */         return root.findChild(path);
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 227 */     return null;
/*     */   }
/*     */ 
/*     */   public PackageInformation getPackageInformation(String packageName)
/*     */   {
/* 233 */     String path = packageName.replace('.', '/');
/* 234 */     VirtualFile pkge = findChild(path);
/* 235 */     if (pkge == null)
/* 236 */       return null;
/*     */     try
/*     */     {
/* 239 */       Manifest manifest = VFSUtils.getManifest(pkge.getVFS());
/* 240 */       return new PackageInformation(packageName, manifest);
/*     */     }
/*     */     catch (IOException ignored)
/*     */     {
/* 244 */       log.trace("Unable to retrieve manifest for " + pkge + " " + ignored.getMessage());
/* 245 */     }return null;
/*     */   }
/*     */ 
/*     */   protected void toLongString(StringBuilder builder)
/*     */   {
/* 252 */     builder.append(" roots=").append(Arrays.asList(this.roots)).append(" ");
/* 253 */     super.toLongString(builder);
/* 254 */     if (this.exportAll != null)
/* 255 */       builder.append(this.exportAll);
/*     */   }
/*     */ 
/*     */   protected ProtectionDomain getProtectionDomain(String className, String path)
/*     */   {
/* 261 */     VirtualFile clazz = findChild(path);
/* 262 */     if (clazz == null)
/*     */     {
/* 264 */       log.trace("Unable to determine class file for " + className);
/* 265 */       return null;
/*     */     }
/*     */     try
/*     */     {
/* 269 */       VirtualFile root = clazz.getVFS().getRoot();
/* 270 */       URL codeSourceURL = root.toURL();
/* 271 */       Certificate[] certs = null;
/* 272 */       CodeSource cs = new CodeSource(codeSourceURL, certs);
/* 273 */       PermissionCollection permissions = Policy.getPolicy().getPermissions(cs);
/* 274 */       return new ProtectionDomain(cs, permissions);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 278 */     throw new Error("Error determining protection domain for " + clazz, e);
/*     */   }
/*     */ 
/*     */   protected Set<String> determineAllPackages()
/*     */   {
/* 290 */     PackageVisitor visitor = new PackageVisitor(this.exportAll);
/* 291 */     for (VirtualFile root : this.roots)
/*     */     {
/*     */       try
/*     */       {
/* 295 */         visitor.setRoot(root);
/* 296 */         root.visit(visitor);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 300 */         throw new Error("Error visiting " + root, e);
/*     */       }
/*     */     }
/* 303 */     return visitor.getPackages();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.classloader.VFSClassLoaderPolicy
 * JD-Core Version:    0.6.0
 */