/*    */ package org.jboss.deployers.vfs.plugins.classloader;
/*    */ 
/*    */ import java.net.URL;
/*    */ import java.util.Set;
/*    */ import org.jboss.deployers.plugins.classloading.AbstractTopLevelClassLoaderSystemDeployer;
/*    */ import org.jboss.deployers.plugins.classloading.Module;
/*    */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*    */ import org.jboss.deployers.vfs.spi.structure.helpers.ClassPathVisitor;
/*    */ import org.jboss.virtual.VirtualFile;
/*    */ import org.jboss.virtual.plugins.context.memory.MemoryContextFactory;
/*    */ import org.jboss.virtual.spi.VirtualFileHandler;
/*    */ 
/*    */ public class VFSTopLevelClassLoaderSystemDeployer extends AbstractTopLevelClassLoaderSystemDeployer
/*    */ {
/*    */   protected VFSClassLoaderPolicy createTopLevelClassLoaderPolicy(DeploymentContext context, Module module)
/*    */     throws Exception
/*    */   {
/* 45 */     ClassPathVisitor visitor = new ClassPathVisitor();
/* 46 */     context.visit(visitor);
/* 47 */     Set classPath = visitor.getClassPath();
/*    */ 
/* 49 */     VirtualFile[] roots = new VirtualFile[classPath.size() + 1];
/* 50 */     int i = 0;
/* 51 */     for (VirtualFile path : classPath) {
/* 52 */       roots[(i++)] = path;
/*    */     }
/* 54 */     MemoryContextFactory factory = MemoryContextFactory.getInstance();
/* 55 */     factory.createRoot(module.getDynamicClassRoot());
/*    */ 
/* 57 */     URL url = new URL(module.getDynamicClassRoot() + "/classes");
/* 58 */     roots[(i++)] = factory.createDirectory(url).getVirtualFile();
/*    */ 
/* 60 */     VFSClassLoaderPolicy policy = new VFSClassLoaderPolicy(roots);
/* 61 */     policy.setExportAll(module.getExportAll());
/* 62 */     policy.setImportAll(module.isImportAll());
/*    */ 
/* 64 */     return policy;
/*    */   }
/*    */ 
/*    */   protected void cleanup(DeploymentContext context, Module module)
/*    */     throws Exception
/*    */   {
/* 70 */     MemoryContextFactory factory = MemoryContextFactory.getInstance();
/* 71 */     factory.deleteRoot(module.getDynamicClassRoot());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.classloader.VFSTopLevelClassLoaderSystemDeployer
 * JD-Core Version:    0.6.0
 */