/*    */ package org.jboss.deployers.vfs.plugins.structure;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.Arrays;
/*    */ import java.util.List;
/*    */ import org.jboss.deployers.client.spi.Deployment;
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.structure.ClassPathEntry;
/*    */ import org.jboss.deployers.spi.structure.ContextInfo;
/*    */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*    */ import org.jboss.deployers.structure.spi.helpers.AbstractStructureBuilder;
/*    */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*    */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.virtual.VFSUtils;
/*    */ import org.jboss.virtual.VirtualFile;
/*    */ import org.jboss.virtual.VisitorAttributes;
/*    */ import org.jboss.virtual.plugins.vfs.helpers.SuffixMatchFilter;
/*    */ 
/*    */ public class VFSStructureBuilder extends AbstractStructureBuilder
/*    */ {
/* 51 */   private static final Logger log = Logger.getLogger(VFSStructureBuilder.class);
/*    */ 
/*    */   protected DeploymentContext createRootDeploymentContext(Deployment deployment) throws Exception
/*    */   {
/* 55 */     if ((deployment instanceof VFSDeployment))
/*    */     {
/* 57 */       VFSDeployment vfsDeployment = (VFSDeployment)deployment;
/* 58 */       return new AbstractVFSDeploymentContext(vfsDeployment.getRoot(), "");
/*    */     }
/* 60 */     return super.createRootDeploymentContext(deployment);
/*    */   }
/*    */ 
/*    */   protected DeploymentContext createChildDeploymentContext(DeploymentContext parent, ContextInfo child) throws Exception
/*    */   {
/* 65 */     if ((parent instanceof VFSDeploymentContext))
/*    */     {
/* 67 */       VFSDeploymentContext vfsParent = (VFSDeploymentContext)parent;
/* 68 */       String path = child.getPath();
/*    */       try
/*    */       {
/* 71 */         VirtualFile parentFile = vfsParent.getRoot();
/* 72 */         VirtualFile file = parentFile.findChild(path);
/* 73 */         return new AbstractVFSDeploymentContext(file, path);
/*    */       }
/*    */       catch (Throwable t)
/*    */       {
/* 77 */         throw DeploymentException.rethrowAsDeploymentException("Unable to determine child " + path + " from parent " + vfsParent.getRoot().getName(), t);
/*    */       }
/*    */     }
/* 80 */     return super.createChildDeploymentContext(parent, child);
/*    */   }
/*    */ 
/*    */   protected void applyContextInfo(DeploymentContext context, ContextInfo contextInfo) throws Exception
/*    */   {
/* 85 */     super.applyContextInfo(context, contextInfo);
/*    */ 
/* 87 */     if ((context instanceof VFSDeploymentContext))
/*    */     {
/* 89 */       boolean trace = log.isTraceEnabled();
/* 90 */       log.trace("Apply context: " + context.getName() + " " + contextInfo);
/*    */ 
/* 92 */       VFSDeploymentContext vfsContext = (VFSDeploymentContext)context;
/* 93 */       List metaDataPath = contextInfo.getMetaDataPath();
/* 94 */       if ((metaDataPath != null) && (!metaDataPath.isEmpty())) {
/* 95 */         vfsContext.setMetaDataPath(contextInfo.getMetaDataPath());
/*    */       }
/* 97 */       boolean classPathHadVF = false;
/*    */ 
/* 99 */       List classPathEntries = contextInfo.getClassPath();
/* 100 */       VFSDeploymentContext top = vfsContext.getTopLevel();
/* 101 */       VirtualFile root = top.getRoot();
/* 102 */       List classPath = new ArrayList();
/*    */ 
/* 104 */       if (classPathEntries != null)
/*    */       {
/* 106 */         for (ClassPathEntry entry : classPathEntries)
/*    */         {
/* 108 */           if (trace)
/* 109 */             log.trace("Resolving classpath entry " + entry + " for " + context.getName());
/* 110 */           String suffixes = entry.getSuffixes();
/*    */           VirtualFile child;
/*    */           VirtualFile child;
/* 112 */           if (entry.getPath().length() == 0) {
/* 113 */             child = root;
/*    */           }
/*    */           else {
/*    */             try
/*    */             {
/* 118 */               child = root.findChild(entry.getPath());
/*    */             }
/*    */             catch (Throwable t)
/*    */             {
/* 122 */               throw DeploymentException.rethrowAsDeploymentException("Unable to find class path entry " + entry + " from " + root.getName(), t);
/*    */             }
/*    */           }
/* 125 */           if (suffixes == null)
/*    */           {
/* 127 */             classPath.add(child);
/* 128 */             if (!classPathHadVF)
/* 129 */               classPathHadVF = child.equals(root);
/*    */           }
/*    */           else
/*    */           {
/* 133 */             String[] suffs = suffixes.split(",");
/* 134 */             SuffixMatchFilter filter = new SuffixMatchFilter(Arrays.asList(suffs), VisitorAttributes.DEFAULT);
/* 135 */             List matches = child.getChildren(filter);
/* 136 */             if (matches != null)
/*    */             {
/* 138 */               classPath.addAll(matches);
/* 139 */               if (trace) {
/* 140 */                 log.trace("Added classpath matches: " + matches);
/*    */               }
/* 142 */               for (VirtualFile file : matches)
/*    */               {
/* 144 */                 VFSUtils.addManifestLocations(file, classPath);
/* 145 */                 if (!classPathHadVF) {
/* 146 */                   classPathHadVF = file.equals(root);
/*    */                 }
/*    */               }
/*    */             }
/*    */           }
/*    */         }
/*    */       }
/* 153 */       VirtualFile file = vfsContext.getRoot();
/* 154 */       if ((!classPathHadVF) && (!SecurityActions.isLeaf(file))) {
/* 155 */         VFSUtils.addManifestLocations(file, classPath);
/*    */       }
/* 157 */       if (!classPath.isEmpty())
/* 158 */         vfsContext.setClassPath(classPath);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.structure.VFSStructureBuilder
 * JD-Core Version:    0.6.0
 */