/*     */ package org.jboss.deployers.vfs.plugins.structure.explicit;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.LinkedHashSet;
/*     */ import org.jboss.deployers.plugins.structure.ClassPathEntryImpl;
/*     */ import org.jboss.deployers.plugins.structure.ContextInfoImpl;
/*     */ import org.jboss.deployers.plugins.structure.StructureMetaDataImpl;
/*     */ import org.jboss.deployers.spi.structure.ClassPathEntry;
/*     */ import org.jboss.xb.binding.ObjectModelFactory;
/*     */ import org.jboss.xb.binding.UnmarshallingContext;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class StructureMetaDataObjectFactory
/*     */   implements ObjectModelFactory
/*     */ {
/*     */   public StructureMetaDataImpl newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*     */     StructureMetaDataImpl metaData;
/*     */     StructureMetaDataImpl metaData;
/*  46 */     if (root != null)
/*  47 */       metaData = (StructureMetaDataImpl)root;
/*     */     else {
/*  49 */       metaData = new StructureMetaDataImpl();
/*     */     }
/*  51 */     return metaData;
/*     */   }
/*     */ 
/*     */   public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name)
/*     */   {
/*  56 */     return root;
/*     */   }
/*     */ 
/*     */   public Object newChild(StructureMetaDataImpl parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  61 */     Object child = null;
/*  62 */     if (localName.equals("context"))
/*  63 */       child = new ContextInfoImpl("", null);
/*  64 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newChild(ContextInfoImpl parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  69 */     Object child = null;
/*  70 */     if ("path".equals(localName))
/*     */     {
/*  72 */       String path = attrs.getValue("name");
/*  73 */       parent.setPath(path);
/*     */     }
/*  75 */     else if ("metaDataPath".equals(localName)) {
/*  76 */       child = new LinkedHashSet();
/*  77 */     } else if (localName.equals("classpath")) {
/*  78 */       child = new ArrayList();
/*     */     }
/*  80 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newChild(LinkedHashSet<String> parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  85 */     Object child = null;
/*  86 */     if ("path".equals(localName))
/*     */     {
/*  88 */       String path = attrs.getValue("name");
/*  89 */       parent.add(path);
/*     */     }
/*  91 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newChild(ArrayList<ClassPathEntry> parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  96 */     Object child = null;
/*  97 */     if ("path".equals(localName))
/*     */     {
/*  99 */       String name = attrs.getValue("name");
/* 100 */       String suffixes = attrs.getValue("suffixes");
/* 101 */       ClassPathEntry path = new ClassPathEntryImpl(name, suffixes);
/* 102 */       parent.add(path);
/*     */     }
/* 104 */     return child;
/*     */   }
/*     */ 
/*     */   public void addChild(StructureMetaDataImpl parent, ContextInfoImpl context, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 109 */     parent.addContext(context);
/*     */   }
/*     */ 
/*     */   public void addChild(ContextInfoImpl context, LinkedHashSet<String> metaDataPath, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 114 */     context.setMetaDataPath(new ArrayList(metaDataPath));
/*     */   }
/*     */ 
/*     */   public void addChild(ContextInfoImpl context, ArrayList<ClassPathEntry> classpath, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 119 */     context.setClassPath(classpath);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.structure.explicit.StructureMetaDataObjectFactory
 * JD-Core Version:    0.6.0
 */