/*     */ package org.jboss.deployers.vfs.plugins.structure.jar;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.Set;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.structure.ContextInfo;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaData;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
/*     */ import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.plugins.context.jar.JarUtils;
/*     */ 
/*     */ public class JARStructure extends AbstractStructureDeployer
/*     */ {
/*     */   public JARStructure()
/*     */   {
/*  48 */     this(null);
/*     */   }
/*     */ 
/*     */   public JARStructure(Set<String> suffixes)
/*     */   {
/*  58 */     if (suffixes != null)
/*  59 */       setSuffixes(suffixes);
/*  60 */     setRelativeOrder(10000);
/*     */   }
/*     */ 
/*     */   public Set<String> getSuffixes()
/*     */   {
/*  70 */     return JarUtils.getSuffixes();
/*     */   }
/*     */ 
/*     */   public void setSuffixes(Set<String> suffixes)
/*     */   {
/*  79 */     JarUtils.setJarSuffixes(suffixes);
/*     */   }
/*     */ 
/*     */   public boolean determineStructure(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData metaData, VFSStructuralDeployers deployers) throws DeploymentException
/*     */   {
/*  84 */     ContextInfo context = null;
/*     */     try
/*     */     {
/*  87 */       if (!isLeaf(file))
/*     */       {
/*  91 */         if (!JarUtils.isArchive(file.getName()))
/*     */         {
/*  93 */           if (!isTopLevel(parent))
/*     */           {
/*     */             try
/*     */             {
/*  97 */               file.findChild("META-INF");
/*  98 */               this.log.trace("... ok - non top level directory has a META-INF subdirectory");
/*     */             }
/*     */             catch (IOException e)
/*     */             {
/* 102 */               this.log.trace("... no - doesn't look like a jar and no META-INF subdirectory.");
/* 103 */               return false;
/*     */             }
/*     */           }
/*     */           else
/*     */           {
/* 108 */             this.log.trace("... ok - doesn't look like a jar but it is a top level directory.");
/*     */           }
/*     */         }
/*     */       }
/* 112 */       else if (JarUtils.isArchive(file.getName()))
/*     */       {
/* 114 */         this.log.trace("... ok - its an archive or at least pretending to be.");
/*     */       }
/*     */       else
/*     */       {
/* 118 */         this.log.trace("... no - not a directory or an archive.");
/* 119 */         return false;
/*     */       }
/*     */ 
/* 123 */       context = createContext(file, "META-INF", metaData);
/*     */ 
/* 126 */       super.addClassPath(root, file, true, true, context);
/*     */ 
/* 129 */       addAllChildren(root, file, metaData, deployers);
/* 130 */       return true;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 135 */       if (context != null)
/* 136 */         metaData.removeContext(context);
/*     */     }
/* 138 */     throw DeploymentException.rethrowAsDeploymentException("Error determining structure: " + file.getName(), e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.structure.jar.JARStructure
 * JD-Core Version:    0.6.0
 */