/*     */ package org.jboss.deployers.vfs.spi.deployer;
/*     */ 
/*     */ import java.util.List;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.helpers.AbstractParsingDeployerWithOutput;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public abstract class AbstractVFSParsingDeployer<T> extends AbstractParsingDeployerWithOutput<T>
/*     */ {
/*     */   public AbstractVFSParsingDeployer(Class<T> output)
/*     */   {
/*  49 */     super(output);
/*     */   }
/*     */ 
/*     */   protected boolean accepts(VFSDeploymentUnit unit)
/*     */     throws DeploymentException
/*     */   {
/*  61 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean accepts(DeploymentUnit unit)
/*     */     throws DeploymentException
/*     */   {
/*  68 */     if (!(unit instanceof VFSDeploymentUnit))
/*     */     {
/*  70 */       this.log.trace("Not a vfs deployment: " + unit.getName());
/*  71 */       return false;
/*     */     }
/*  73 */     return accepts((VFSDeploymentUnit)unit);
/*     */   }
/*     */ 
/*     */   protected T parse(DeploymentUnit unit, String name, T root)
/*     */     throws Exception
/*     */   {
/*  80 */     VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
/*     */ 
/*  82 */     VirtualFile file = vfsDeploymentUnit.getMetaDataFile(name);
/*  83 */     if (file == null) {
/*  84 */       return null;
/*     */     }
/*  86 */     Object result = parse(vfsDeploymentUnit, file, root);
/*  87 */     if (result != null)
/*  88 */       init(vfsDeploymentUnit, result, file);
/*  89 */     return result;
/*     */   }
/*     */ 
/*     */   protected T parse(DeploymentUnit unit, String name, String suffix, T root)
/*     */     throws Exception
/*     */   {
/*  97 */     if ((name == null) && (isIncludeDeploymentFile())) {
/*  98 */       name = unit.getName();
/*     */     }
/*     */ 
/* 101 */     VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
/* 102 */     List files = vfsDeploymentUnit.getMetaDataFiles(name, suffix);
/* 103 */     if (files.size() == 0) {
/* 104 */       return null;
/*     */     }
/*     */ 
/* 107 */     if (files.size() > 1) {
/* 108 */       throw new DeploymentException("Only one file is allowed, found=" + files);
/*     */     }
/* 110 */     VirtualFile file = (VirtualFile)files.get(0);
/*     */ 
/* 112 */     Object result = parse(vfsDeploymentUnit, file, root);
/* 113 */     if (result != null)
/* 114 */       init(vfsDeploymentUnit, result, file);
/* 115 */     return result;
/*     */   }
/*     */ 
/*     */   protected abstract T parse(VFSDeploymentUnit paramVFSDeploymentUnit, VirtualFile paramVirtualFile, T paramT)
/*     */     throws Exception;
/*     */ 
/*     */   protected void init(VFSDeploymentUnit unit, T metaData, VirtualFile file)
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer
 * JD-Core Version:    0.6.0
 */