/*     */ package org.jboss.deployers.vfs.spi.deployer;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;
/*     */ 
/*     */ public abstract class SchemaResolverDeployer<T> extends AbstractVFSParsingDeployer<T>
/*     */ {
/*  45 */   private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
/*     */ 
/*  48 */   private static final SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
/*     */ 
/*  51 */   private boolean useSchemaValidation = true;
/*     */ 
/*  54 */   private boolean useValidation = true;
/*     */ 
/*     */   public SchemaResolverDeployer(Class<T> output)
/*     */   {
/*  64 */     super(output);
/*     */   }
/*     */ 
/*     */   public boolean isUseSchemaValidation()
/*     */   {
/*  74 */     return this.useSchemaValidation;
/*     */   }
/*     */ 
/*     */   public void setUseSchemaValidation(boolean useSchemaValidation)
/*     */   {
/*  84 */     this.useSchemaValidation = useSchemaValidation;
/*     */   }
/*     */ 
/*     */   public boolean isUseValidation()
/*     */   {
/*  94 */     return this.useValidation;
/*     */   }
/*     */ 
/*     */   public void setUseValidation(boolean useValidation)
/*     */   {
/* 104 */     this.useValidation = useValidation;
/*     */   }
/*     */ 
/*     */   protected T parse(VFSDeploymentUnit unit, VirtualFile file, T root) throws Exception
/*     */   {
/* 109 */     if (file == null) {
/* 110 */       throw new IllegalArgumentException("Null file");
/*     */     }
/* 112 */     this.log.debug("Parsing file: " + file + " for deploymentType: " + getOutput());
/* 113 */     Unmarshaller unmarshaller = factory.newUnmarshaller();
/* 114 */     unmarshaller.setSchemaValidation(isUseSchemaValidation());
/* 115 */     unmarshaller.setValidation(isUseValidation());
/* 116 */     InputStream is = file.openStream();
/* 117 */     Object parsed = null;
/*     */     try
/*     */     {
/* 120 */       parsed = unmarshaller.unmarshal(is, resolver);
/* 121 */       this.log.debug("Parsed file: " + file + " to: " + parsed);
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 127 */         is.close();
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/*     */       }
/*     */     }
/* 133 */     if (parsed == null) {
/* 134 */       throw new DeploymentException("The xml " + file.getPathName() + " is not well formed!");
/*     */     }
/* 136 */     return getOutput().cast(parsed);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.spi.deployer.SchemaResolverDeployer
 * JD-Core Version:    0.6.0
 */