/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.AnnotatedElement;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.DeploymentStages;
/*     */ import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.annotation.creator.client.ApplicationClient5MetaDataCreator;
/*     */ import org.jboss.metadata.annotation.creator.ejb.EjbJar30Creator;
/*     */ import org.jboss.metadata.annotation.creator.web.Web25MetaDataCreator;
/*     */ import org.jboss.metadata.annotation.finder.AnnotationFinder;
/*     */ import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
/*     */ import org.jboss.metadata.client.jboss.JBossClientMetaData;
/*     */ import org.jboss.metadata.client.spec.ApplicationClient5MetaData;
/*     */ import org.jboss.metadata.client.spec.ApplicationClientMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*     */ import org.jboss.metadata.ejb.spec.EjbJar30MetaData;
/*     */ import org.jboss.metadata.ejb.spec.EjbJarMetaData;
/*     */ import org.jboss.metadata.web.jboss.JBossWebMetaData;
/*     */ import org.jboss.metadata.web.spec.Web25MetaData;
/*     */ import org.jboss.metadata.web.spec.WebMetaData;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class AnnotationMetaDataDeployer extends AbstractDeployer
/*     */ {
/*  60 */   public static final String EJB_ANNOTATED_ATTACHMENT_NAME = "annotated." + EjbJarMetaData.class.getName();
/*  61 */   public static final String CLIENT_ANNOTATED_ATTACHMENT_NAME = "annotated." + ApplicationClientMetaData.class.getName();
/*  62 */   public static final String WEB_ANNOTATED_ATTACHMENT_NAME = "annotated." + WebMetaData.class.getName();
/*     */ 
/*  64 */   private boolean metaDataCompleteIsDefault = true;
/*     */ 
/*     */   public AnnotationMetaDataDeployer()
/*     */   {
/*  68 */     setStage(DeploymentStages.POST_CLASSLOADER);
/*  69 */     addOutput(EJB_ANNOTATED_ATTACHMENT_NAME);
/*  70 */     addOutput(CLIENT_ANNOTATED_ATTACHMENT_NAME);
/*  71 */     addOutput(WEB_ANNOTATED_ATTACHMENT_NAME);
/*     */   }
/*     */ 
/*     */   public boolean isMetaDataCompleteIsDefault()
/*     */   {
/*  77 */     return this.metaDataCompleteIsDefault;
/*     */   }
/*     */ 
/*     */   public void setMetaDataCompleteIsDefault(boolean metaDataCompleteIsDefault) {
/*  81 */     this.metaDataCompleteIsDefault = metaDataCompleteIsDefault;
/*     */   }
/*     */ 
/*     */   public void deploy(DeploymentUnit unit) throws DeploymentException
/*     */   {
/*  86 */     if (!(unit instanceof VFSDeploymentUnit)) {
/*  87 */       return;
/*     */     }
/*  89 */     VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
/*  90 */     deploy(vfsDeploymentUnit);
/*     */   }
/*     */ 
/*     */   public void undeploy(DeploymentUnit unit)
/*     */   {
/*  95 */     if (!(unit instanceof VFSDeploymentUnit)) {
/*  96 */       return;
/*     */     }
/*  98 */     VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
/*  99 */     undeploy(vfsDeploymentUnit);
/*     */   }
/*     */ 
/*     */   protected void deploy(VFSDeploymentUnit unit)
/*     */     throws DeploymentException
/*     */   {
/* 112 */     boolean isComplete = this.metaDataCompleteIsDefault;
/* 113 */     JBossMetaData jbossMetaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
/* 114 */     if (jbossMetaData != null)
/* 115 */       isComplete &= jbossMetaData.isMetadataComplete();
/* 116 */     JBossWebMetaData jbossWebMetaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
/* 117 */     if (jbossWebMetaData != null)
/* 118 */       isComplete &= jbossWebMetaData.isMetadataComplete();
/* 119 */     JBossClientMetaData jbossClientMetaData = (JBossClientMetaData)unit.getAttachment(JBossClientMetaData.class);
/* 120 */     if (jbossClientMetaData != null)
/* 121 */       isComplete &= jbossClientMetaData.isMetadataComplete();
/* 122 */     if (isComplete) {
/* 123 */       return;
/*     */     }
/* 125 */     VirtualFile root = unit.getRoot();
/* 126 */     boolean isLeaf = true;
/*     */     try
/*     */     {
/* 129 */       isLeaf = root.isLeaf();
/*     */     }
/*     */     catch (IOException ignore)
/*     */     {
/*     */     }
/* 134 */     if (isLeaf == true) {
/* 135 */       return;
/*     */     }
/* 137 */     ClassLoader loader = unit.getClassLoader();
/* 138 */     List classpath = unit.getClassPath();
/* 139 */     if (classpath == null) {
/* 140 */       return;
/*     */     }
/*     */     try
/*     */     {
/* 144 */       Map classpathClasses = new HashMap();
/* 145 */       for (VirtualFile path : classpath)
/*     */       {
/* 147 */         AnnotatedClassFilter classVisitor = new AnnotatedClassFilter(unit, loader, path);
/* 148 */         path.visit(classVisitor);
/* 149 */         Map classes = classVisitor.getAnnotatedClasses();
/* 150 */         if ((classes != null) && (classes.size() > 0))
/*     */         {
/* 152 */           this.log.info("Annotated classes: " + classes);
/* 153 */           classpathClasses.putAll(classes);
/*     */         }
/*     */       }
/*     */ 
/* 157 */       if (classpathClasses.size() > 0)
/*     */       {
/* 159 */         AnnotationFinder finder = new DefaultAnnotationFinder();
/* 160 */         if (jbossWebMetaData != null)
/* 161 */           processJBossWebMetaData(unit, finder, classpathClasses);
/* 162 */         else if (jbossClientMetaData != null)
/* 163 */           processJBossClientMetaData(unit, finder, classpathClasses);
/*     */         else
/* 165 */           processJBossMetaData(unit, finder, classpathClasses);
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 170 */       throw new DeploymentException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void undeploy(VFSDeploymentUnit unit)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void processJBossMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Map<VirtualFile, Class<?>> classes)
/*     */   {
/* 193 */     EjbJar30Creator creator = new EjbJar30Creator(finder);
/* 194 */     EjbJar30MetaData annotationMetaData = creator.create(classes.values());
/* 195 */     if (annotationMetaData != null)
/* 196 */       unit.addAttachment(EJB_ANNOTATED_ATTACHMENT_NAME, annotationMetaData, EjbJarMetaData.class);
/*     */   }
/*     */ 
/*     */   protected void processJBossWebMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Map<VirtualFile, Class<?>> classes)
/*     */   {
/* 201 */     Web25MetaDataCreator creator = new Web25MetaDataCreator(finder);
/* 202 */     Web25MetaData annotationMetaData = creator.create(classes.values());
/* 203 */     if (annotationMetaData != null)
/* 204 */       unit.addAttachment(WEB_ANNOTATED_ATTACHMENT_NAME, annotationMetaData, WebMetaData.class);
/*     */   }
/*     */ 
/*     */   protected void processJBossClientMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Map<VirtualFile, Class<?>> classes)
/*     */   {
/* 209 */     ApplicationClient5MetaDataCreator creator = new ApplicationClient5MetaDataCreator(finder);
/* 210 */     ApplicationClient5MetaData annotationMetaData = creator.create(classes.values());
/* 211 */     if (annotationMetaData != null)
/* 212 */       unit.addAttachment(CLIENT_ANNOTATED_ATTACHMENT_NAME, annotationMetaData, ApplicationClientMetaData.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.AnnotationMetaDataDeployer
 * JD-Core Version:    0.6.0
 */