/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import javax.security.jacc.PolicyConfiguration;
/*     */ import javax.security.jacc.PolicyConfigurationFactory;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.metadata.ear.jboss.JBossAppMetaData;
/*     */ 
/*     */ public class EARInitializingDeployer extends AbstractSimpleRealDeployer<JBossAppMetaData>
/*     */ {
/*     */   public EARInitializingDeployer()
/*     */   {
/*  49 */     super(JBossAppMetaData.class);
/*  50 */     setOutput(PolicyConfiguration.class);
/*     */   }
/*     */ 
/*     */   public void deploy(DeploymentUnit unit, JBossAppMetaData deployment)
/*     */     throws DeploymentException
/*     */   {
/*  57 */     String contextID = shortNameFromDeploymentName(unit.getSimpleName());
/*  58 */     PolicyConfigurationFactory pcFactory = null;
/*     */     try
/*     */     {
/*  61 */       pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
/*  62 */       PolicyConfiguration pc = pcFactory.getPolicyConfiguration(contextID, true);
/*  63 */       unit.addAttachment(PolicyConfiguration.class, pc);
/*     */     }
/*     */     catch (PolicyContextException e)
/*     */     {
/*  67 */       throw new DeploymentException("PolicyContextException generated in deploy", e);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  71 */       throw new DeploymentException("Exception generated in deploy", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void undeploy(DeploymentUnit unit, JBossAppMetaData deployment)
/*     */   {
/*  80 */     unit.removeAttachment(PolicyConfiguration.class);
/*     */   }
/*     */ 
/*     */   public static String shortNameFromDeploymentName(String name)
/*     */   {
/*  92 */     String shortName = name.trim();
/*  93 */     String[] parts = name.split("/|\\.|\\!");
/*  94 */     if (parts.length > 1)
/*     */     {
/*  97 */       if (parts[(parts.length - 1)].equals("ear")) {
/*  98 */         shortName = parts[(parts.length - 2)];
/*     */       }
/*     */       else
/* 101 */         shortName = parts[(parts.length - 1)];
/*     */     }
/* 103 */     return shortName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.EARInitializingDeployer
 * JD-Core Version:    0.6.0
 */