/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class J2eeModuleMetaData extends MetaData
/*     */ {
/*     */   public static final int EJB = 0;
/*     */   public static final int WEB = 1;
/*     */   public static final int CLIENT = 2;
/*     */   public static final int CONNECTOR = 3;
/*     */   public static final int SERVICE = 4;
/*     */   public static final int HAR = 5;
/*  47 */   private static final String[] tags = { "ejb", "web", "java", "connector", "service", "har" };
/*     */   int type;
/*     */   String fileName;
/*     */   String alternativeDD;
/*     */   String webContext;
/*     */ 
/*     */   public J2eeModuleMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public J2eeModuleMetaData(int type, String fileName)
/*     */   {
/*  75 */     this.type = type;
/*  76 */     this.fileName = fileName;
/*  77 */     if (type == 1)
/*     */     {
/*  79 */       int dot = fileName.lastIndexOf('.');
/*  80 */       if (dot >= 0)
/*  81 */         this.webContext = fileName.substring(0, dot);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getType()
/*     */   {
/*  87 */     return this.type;
/*     */   }
/*     */ 
/*     */   public void setType(int type) {
/*  91 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public boolean isEjb()
/*     */   {
/*  96 */     return this.type == 0;
/*     */   }
/*     */ 
/*     */   public boolean isWeb()
/*     */   {
/* 101 */     return this.type == 1;
/*     */   }
/*     */ 
/*     */   public boolean isJava()
/*     */   {
/* 106 */     return this.type == 2;
/*     */   }
/*     */ 
/*     */   public boolean isConnector()
/*     */   {
/* 111 */     return this.type == 3;
/*     */   }
/*     */ 
/*     */   public String getFileName()
/*     */   {
/* 117 */     return this.fileName;
/*     */   }
/*     */ 
/*     */   public void setFileName(String name) {
/* 121 */     this.fileName = name;
/* 122 */     if (this.type == 1)
/*     */     {
/* 124 */       int dot = this.fileName.lastIndexOf('.');
/* 125 */       if (dot >= 0)
/* 126 */         this.webContext = this.fileName.substring(0, dot);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getAlternativeDD()
/*     */   {
/* 132 */     return this.alternativeDD;
/*     */   }
/*     */ 
/*     */   public void setAlternativeDD(String dd) {
/* 136 */     this.alternativeDD = dd;
/*     */   }
/*     */ 
/*     */   public String getWebContext()
/*     */   {
/* 141 */     if (this.type == 1)
/*     */     {
/* 143 */       return this.webContext;
/*     */     }
/*     */ 
/* 147 */     return null;
/*     */   }
/*     */ 
/*     */   public void setWebContext(String context)
/*     */   {
/* 152 */     this.webContext = context;
/*     */   }
/*     */ 
/*     */   public void importXml(Element rootElement) throws DeploymentException
/*     */   {
/* 157 */     String rootTag = rootElement.getOwnerDocument().getDocumentElement().getTagName();
/* 158 */     if (rootTag.equals("application"))
/* 159 */       importXml(rootElement, false);
/* 160 */     else if (rootTag.equals("jboss-app"))
/* 161 */       importXml(rootElement, true);
/*     */     else
/* 163 */       throw new DeploymentException("Unrecognized root tag: " + rootTag);
/*     */   }
/*     */ 
/*     */   protected void importXml(Element element, boolean jbossSpecific) throws DeploymentException
/*     */   {
/* 168 */     String name = element.getTagName();
/* 169 */     if (name.equals("module"))
/*     */     {
/* 171 */       boolean done = false;
/* 172 */       for (int i = 0; (!done) && (i < tags.length); i++)
/*     */       {
/* 174 */         Element child = getOptionalChild(element, tags[i]);
/* 175 */         if (child == null)
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/* 180 */         this.type = i;
/* 181 */         switch (this.type)
/*     */         {
/*     */         case 4:
/* 184 */           if (jbossSpecific)
/*     */             break;
/* 186 */           throw new DeploymentException("Service archives must be in jboss-app.xml");
/*     */         case 5:
/* 190 */           if (!jbossSpecific)
/*     */           {
/* 192 */             throw new DeploymentException("Hibernate archives must be in jboss-app.xml");
/*     */           }
/*     */         case 0:
/*     */         case 2:
/*     */         case 3:
/* 197 */           this.fileName = getElementContent(child);
/* 198 */           this.alternativeDD = getElementContent(getOptionalChild(element, "alt-dd"));
/* 199 */           break;
/*     */         case 1:
/* 201 */           this.fileName = getElementContent(getUniqueChild(child, "web-uri"));
/* 202 */           this.webContext = getElementContent(getOptionalChild(child, "context-root"));
/* 203 */           this.alternativeDD = getElementContent(getOptionalChild(element, "alt-dd"));
/*     */         }
/*     */ 
/* 206 */         done = true;
/*     */       }
/*     */ 
/* 210 */       if (!done)
/*     */       {
/* 212 */         StringBuffer msg = new StringBuffer("Invalid module content, must be one of: ");
/* 213 */         for (int i = 0; i < tags.length; i++)
/*     */         {
/* 215 */           msg.append(tags[i]);
/* 216 */           msg.append(", ");
/*     */         }
/* 218 */         throw new DeploymentException(msg.toString());
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 223 */       throw new DeploymentException("non-module tag in application dd: " + name);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 229 */     StringBuilder buffer = new StringBuilder();
/* 230 */     buffer.append(getClass().getSimpleName());
/* 231 */     buffer.append('@');
/* 232 */     buffer.append(System.identityHashCode(this));
/* 233 */     buffer.append("{fileName=").append(this.fileName).append(",type=").append(this.type).append('}');
/* 234 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.J2eeModuleMetaData
 * JD-Core Version:    0.6.0
 */