/*    */ package org.jboss.deployment;
/*    */ 
/*    */ import javax.security.jacc.PolicyConfiguration;
/*    */ import javax.security.jacc.PolicyContextException;
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
/*    */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*    */ 
/*    */ public class JaccCommitDeployer extends AbstractRealDeployer
/*    */ {
/*    */   public JaccCommitDeployer()
/*    */   {
/* 45 */     setInput(PolicyConfiguration.class);
/*    */   }
/*    */ 
/*    */   public void internalDeploy(DeploymentUnit unit) throws DeploymentException
/*    */   {
/* 50 */     PolicyConfiguration pc = (PolicyConfiguration)unit.getAttachment(PolicyConfiguration.class);
/* 51 */     if (pc == null) {
/* 52 */       return;
/*    */     }
/* 54 */     DeploymentUnit parent = unit.getParent();
/* 55 */     if (parent == null)
/* 56 */       throw new IllegalStateException("Unit has not parent: " + unit);
/* 57 */     PolicyConfiguration parentPc = (PolicyConfiguration)parent.getAttachment(PolicyConfiguration.class);
/*    */     try
/*    */     {
/* 60 */       if ((parentPc != null) && (pc != parentPc))
/*    */       {
/* 62 */         parentPc.linkConfiguration(pc);
/*    */       }
/* 64 */       pc.commit();
/*    */     }
/*    */     catch (PolicyContextException e)
/*    */     {
/* 68 */       throw new RuntimeException("Failed to commit PolicyConfiguration for unit: " + unit.getName(), e);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.JaccCommitDeployer
 * JD-Core Version:    0.6.0
 */