/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.loading.RepositoryClassLoader;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.system.ServiceControllerMBean;
/*     */ 
/*     */ public abstract class SimpleSubDeployerSupport extends SubDeployerSupport
/*     */ {
/*     */   private ServiceControllerMBean serviceController;
/*  47 */   private boolean registeredClassLoader = false;
/*     */ 
/*     */   public abstract String getExtension();
/*     */ 
/*     */   public abstract String getMetaDataURL();
/*     */ 
/*     */   public abstract String getObjectName(DeploymentInfo paramDeploymentInfo)
/*     */     throws DeploymentException;
/*     */ 
/*     */   public abstract String getDeploymentClass();
/*     */ 
/*     */   public boolean accepts(DeploymentInfo di)
/*     */   {
/*  80 */     String urlStr = di.url.toString();
/*  81 */     String extension = getExtension();
/*  82 */     return (urlStr.endsWith(extension)) || (urlStr.endsWith(extension + '/'));
/*     */   }
/*     */ 
/*     */   public void init(DeploymentInfo di) throws DeploymentException
/*     */   {
/*  87 */     URL url = getMetaDataResource(di);
/*  88 */     parseMetaData(di, url);
/*  89 */     resolveWatch(di, url);
/*  90 */     super.init(di);
/*     */   }
/*     */ 
/*     */   public void create(DeploymentInfo di) throws DeploymentException
/*     */   {
/*  95 */     determineObjectName(di);
/*  96 */     ObjectName uclName = registerClassLoader(di);
/*     */     try
/*     */     {
/*  99 */       registerDeployment(di, uclName);
/*     */       try
/*     */       {
/* 102 */         createService(di);
/*     */         try
/*     */         {
/* 105 */           super.create(di);
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 109 */           destroyService(di);
/*     */         }
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 114 */         unregisterDeployment(di);
/* 115 */         throw t;
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 120 */       unregisterClassLoader(di);
/* 121 */       DeploymentException.rethrowAsDeploymentException("Error creating deployment " + di.url, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start(DeploymentInfo di) throws DeploymentException
/*     */   {
/* 127 */     startService(di);
/*     */     try
/*     */     {
/* 130 */       super.start(di);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 134 */       stopService(di);
/* 135 */       DeploymentException.rethrowAsDeploymentException("Error in start for deployment " + di.url, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop(DeploymentInfo di) throws DeploymentException
/*     */   {
/* 141 */     stopService(di);
/* 142 */     super.stop(di);
/*     */   }
/*     */ 
/*     */   public void destroy(DeploymentInfo di) throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 149 */       destroyService(di);
/* 150 */       super.destroy(di);
/*     */     }
/*     */     finally
/*     */     {
/* 154 */       unregisterDeployment(di);
/* 155 */       unregisterClassLoader(di);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean done)
/*     */   {
/* 161 */     super.postRegister(done);
/*     */ 
/* 163 */     if (done.booleanValue())
/*     */     {
/* 165 */       this.serviceController = ((ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, ServiceControllerMBean.OBJECT_NAME, this.server));
/*     */     }
/*     */   }
/*     */ 
/*     */   protected URL getMetaDataResource(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/* 181 */     URL url = di.localCl.findResource(getMetaDataURL());
/* 182 */     if (url == null)
/* 183 */       throw new DeploymentException("Could not find meta data " + getMetaDataURL() + " for deployment " + di.url);
/* 184 */     return url;
/*     */   }
/*     */ 
/*     */   protected abstract void parseMetaData(DeploymentInfo paramDeploymentInfo, URL paramURL)
/*     */     throws DeploymentException;
/*     */ 
/*     */   protected void resolveWatch(DeploymentInfo di, URL url)
/*     */     throws DeploymentException
/*     */   {
/* 206 */     di.watch = di.url;
/*     */ 
/* 209 */     if (di.url.getProtocol().equals("file"))
/*     */     {
/* 211 */       File file = new File(di.url.getFile());
/* 212 */       if (file.isDirectory())
/* 213 */         di.watch = url;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void determineObjectName(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/* 225 */     String objectName = getObjectName(di);
/*     */     try
/*     */     {
/* 228 */       di.deployedObject = new ObjectName(objectName);
/*     */     }
/*     */     catch (MalformedObjectNameException e)
/*     */     {
/* 232 */       throw new DeploymentException("INTERNAL ERROR: Bad object name. " + objectName);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected ObjectName registerClassLoader(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/* 245 */     ObjectName uclName = null;
/*     */     try
/*     */     {
/* 248 */       RepositoryClassLoader ucl = di.ucl;
/* 249 */       uclName = ucl.getObjectName();
/* 250 */       if (!this.server.isRegistered(uclName))
/*     */       {
/* 252 */         this.server.registerMBean(di.ucl, uclName);
/* 253 */         this.registeredClassLoader = true;
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 258 */       DeploymentException.rethrowAsDeploymentException("Error registering classloader " + uclName, t);
/*     */     }
/* 260 */     return uclName;
/*     */   }
/*     */ 
/*     */   protected void unregisterClassLoader(DeploymentInfo di)
/*     */   {
/* 270 */     ObjectName uclName = null;
/*     */     try
/*     */     {
/* 273 */       RepositoryClassLoader ucl = di.ucl;
/* 274 */       if (ucl != null)
/*     */       {
/* 276 */         uclName = ucl.getObjectName();
/* 277 */         if ((this.registeredClassLoader) && (this.server.isRegistered(uclName)))
/*     */         {
/* 279 */           this.server.unregisterMBean(uclName);
/* 280 */           this.registeredClassLoader = false;
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 286 */       this.log.warn("Error unregistering classloader " + uclName, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void registerDeployment(DeploymentInfo di, ObjectName uclName)
/*     */     throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 301 */       String deploymentClass = getDeploymentClass();
/* 302 */       this.server.createMBean(deploymentClass, di.deployedObject, uclName, new Object[] { di }, new String[] { DeploymentInfo.class.getName() });
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 306 */       DeploymentException.rethrowAsDeploymentException("Error registering deployment " + di.url, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void unregisterDeployment(DeploymentInfo di)
/*     */   {
/*     */     try
/*     */     {
/* 319 */       if (this.server.isRegistered(di.deployedObject))
/* 320 */         this.server.unregisterMBean(di.deployedObject);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 324 */       this.log.warn("Error unregistering deployment " + di.deployedObject, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void createService(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 338 */       this.serviceController.create(di.deployedObject);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 342 */       DeploymentException.rethrowAsDeploymentException("Error in create for deployment " + di.url, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void startService(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 356 */       this.serviceController.start(di.deployedObject);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 360 */       DeploymentException.rethrowAsDeploymentException("Error in start for deployment " + di.url, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService(DeploymentInfo di)
/*     */   {
/*     */     try
/*     */     {
/* 373 */       if (di.deployedObject != null)
/* 374 */         this.serviceController.stop(di.deployedObject);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 378 */       this.log.warn("Error in stop for deployment " + di.url, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void destroyService(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 391 */       if (di.deployedObject != null)
/* 392 */         this.serviceController.destroy(di.deployedObject);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 396 */       this.log.warn("Error in destroy for deployment " + di.url, t);
/*     */     }
/*     */     try
/*     */     {
/* 400 */       if (di.deployedObject != null)
/* 401 */         this.serviceController.remove(di.deployedObject);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 405 */       this.log.warn("Error in remove for deployment " + di.url, t);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.SimpleSubDeployerSupport
 * JD-Core Version:    0.6.0
 */