/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.net.URL;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.server.Invocation;
/*     */ import org.jboss.system.InterceptorServiceMBeanSupport;
/*     */ 
/*     */ public abstract class SubDeployerInterceptorSupport extends InterceptorServiceMBeanSupport
/*     */   implements SubDeployerInterceptorMBean
/*     */ {
/*     */   public SubDeployerInterceptorSupport()
/*     */   {
/*     */   }
/*     */ 
/*     */   public SubDeployerInterceptorSupport(Class type)
/*     */   {
/*  71 */     super(type);
/*     */   }
/*     */ 
/*     */   public SubDeployerInterceptorSupport(String category)
/*     */   {
/*  83 */     super(category);
/*     */   }
/*     */ 
/*     */   public SubDeployerInterceptorSupport(Logger log)
/*     */   {
/*  95 */     super(log);
/*     */   }
/*     */ 
/*     */   protected void attach()
/*     */     throws Exception
/*     */   {
/* 109 */     super.attach(new XMBeanInterceptor());
/*     */   }
/*     */ 
/*     */   protected Object init(Invocation invocation, DeploymentInfo di)
/*     */     throws Throwable
/*     */   {
/* 119 */     return invokeNext(invocation);
/*     */   }
/*     */ 
/*     */   protected Object create(Invocation invocation, DeploymentInfo di)
/*     */     throws Throwable
/*     */   {
/* 127 */     return invokeNext(invocation);
/*     */   }
/*     */ 
/*     */   protected Object start(Invocation invocation, DeploymentInfo di)
/*     */     throws Throwable
/*     */   {
/* 135 */     return invokeNext(invocation);
/*     */   }
/*     */ 
/*     */   protected Object stop(Invocation invocation, DeploymentInfo di)
/*     */     throws Throwable
/*     */   {
/* 143 */     return invokeNext(invocation);
/*     */   }
/*     */ 
/*     */   protected Object destroy(Invocation invocation, DeploymentInfo di)
/*     */     throws Throwable
/*     */   {
/* 151 */     return invokeNext(invocation);
/*     */   }
/*     */ 
/*     */   private class XMBeanInterceptor extends SubDeployerInterceptor
/*     */   {
/*     */     public XMBeanInterceptor()
/*     */     {
/* 164 */       super();
/*     */     }
/*     */ 
/*     */     protected Object init(Invocation invocation, DeploymentInfo di) throws Throwable
/*     */     {
/* 169 */       logSubDeployerInvocation(invocation, di);
/*     */ 
/* 172 */       return SubDeployerInterceptorSupport.this.init(invocation, di);
/*     */     }
/*     */ 
/*     */     protected Object create(Invocation invocation, DeploymentInfo di) throws Throwable
/*     */     {
/* 177 */       logSubDeployerInvocation(invocation, di);
/*     */ 
/* 180 */       return SubDeployerInterceptorSupport.this.create(invocation, di);
/*     */     }
/*     */ 
/*     */     protected Object start(Invocation invocation, DeploymentInfo di) throws Throwable
/*     */     {
/* 185 */       logSubDeployerInvocation(invocation, di);
/*     */ 
/* 188 */       return SubDeployerInterceptorSupport.this.start(invocation, di);
/*     */     }
/*     */ 
/*     */     protected Object stop(Invocation invocation, DeploymentInfo di) throws Throwable
/*     */     {
/* 193 */       logSubDeployerInvocation(invocation, di);
/*     */ 
/* 196 */       return SubDeployerInterceptorSupport.this.stop(invocation, di);
/*     */     }
/*     */ 
/*     */     protected Object destroy(Invocation invocation, DeploymentInfo di) throws Throwable
/*     */     {
/* 201 */       logSubDeployerInvocation(invocation, di);
/*     */ 
/* 204 */       return SubDeployerInterceptorSupport.this.destroy(invocation, di);
/*     */     }
/*     */ 
/*     */     protected void logSubDeployerInvocation(Invocation invocation, DeploymentInfo di)
/*     */     {
/* 209 */       if (SubDeployerInterceptorSupport.this.log.isTraceEnabled())
/*     */       {
/* 211 */         StringBuffer sbuf = new StringBuffer();
/* 212 */         sbuf.append("intercepting ").append(invocation.getName()).append("(), url=").append(di.url.toString()).append(", state=").append(di.state.toString());
/*     */ 
/* 216 */         SubDeployerInterceptorSupport.this.log.trace(sbuf.toString());
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.SubDeployerInterceptorSupport
 * JD-Core Version:    0.6.0
 */