/*     */ package org.jboss.deployment.scanner;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.deployment.Deployer;
/*     */ import org.jboss.deployment.MainDeployerMBean;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.mx.util.MBeanProxyInstance;
/*     */ import org.jboss.system.MissingAttributeException;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.util.NullArgumentException;
/*     */ 
/*     */ public abstract class AbstractDeploymentScanner extends ServiceMBeanSupport
/*     */   implements DeploymentScanner, DeploymentScannerMBean
/*     */ {
/*     */   protected long scanPeriod;
/*     */   protected boolean scanEnabled;
/*     */   protected long stopTimeOut;
/*     */   protected Deployer deployer;
/*     */   protected MainDeployerMBean mainDeployer;
/*     */   protected ScannerThread scannerThread;
/*     */   private Thread shutdownHook;
/*     */ 
/*     */   public AbstractDeploymentScanner()
/*     */   {
/*  53 */     this.scanPeriod = 5000L;
/*     */ 
/*  56 */     this.scanEnabled = true;
/*     */ 
/*  59 */     this.stopTimeOut = 60000L;
/*     */   }
/*     */ 
/*     */   public void setDeployer(ObjectName deployerName)
/*     */   {
/*  79 */     if (deployerName == null) {
/*  80 */       throw new NullArgumentException("deployerName");
/*     */     }
/*  82 */     this.deployer = ((Deployer)MBeanProxyExt.create(Deployer.class, deployerName, this.server));
/*     */   }
/*     */ 
/*     */   public ObjectName getDeployer()
/*     */   {
/*  88 */     return ((MBeanProxyInstance)this.deployer).getMBeanProxyObjectName();
/*     */   }
/*     */ 
/*     */   public void setScanPeriod(long period)
/*     */   {
/*  96 */     if (period < 0L) {
/*  97 */       throw new IllegalArgumentException("ScanPeriod must be >= 0; have: " + period);
/*     */     }
/*  99 */     this.scanPeriod = period;
/*     */   }
/*     */ 
/*     */   public long getScanPeriod()
/*     */   {
/* 104 */     return this.scanPeriod;
/*     */   }
/*     */ 
/*     */   public void setScanEnabled(boolean flag)
/*     */   {
/* 109 */     this.scanEnabled = flag;
/*     */   }
/*     */ 
/*     */   public boolean isScanEnabled()
/*     */   {
/* 114 */     return this.scanEnabled;
/*     */   }
/*     */ 
/*     */   public long getStopTimeOut()
/*     */   {
/* 119 */     return this.stopTimeOut;
/*     */   }
/*     */ 
/*     */   public void setStopTimeOut(long stopTimeOut)
/*     */   {
/* 124 */     this.stopTimeOut = stopTimeOut;
/*     */   }
/*     */ 
/*     */   public abstract void scan()
/*     */     throws Exception;
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/* 294 */     if (this.deployer == null)
/* 295 */       throw new MissingAttributeException("Deployer");
/* 296 */     this.mainDeployer = ((MainDeployerMBean)MBeanProxyExt.create(MainDeployerMBean.class, MainDeployerMBean.OBJECT_NAME, this.server));
/*     */ 
/* 298 */     this.scannerThread = new ScannerThread(false);
/* 299 */     this.scannerThread.setDaemon(true);
/* 300 */     this.scannerThread.start();
/* 301 */     this.log.debug("Scanner thread started");
/*     */ 
/* 310 */     ScannerThread _scannerThread = this.scannerThread;
/* 311 */     this.shutdownHook = new Thread("DeploymentScanner Shutdown Hook", _scannerThread)
/*     */     {
/* 313 */       AbstractDeploymentScanner.ScannerThread thread = this.val$_scannerThread;
/*     */ 
/*     */       public void run()
/*     */       {
/* 317 */         this.thread.shutdown();
/*     */       }
/*     */     };
/*     */     try
/*     */     {
/* 323 */       Runtime.getRuntime().addShutdownHook(this.shutdownHook);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 327 */       this.log.warn("Failed to add shutdown hook", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/* 333 */     synchronized (this.scannerThread)
/*     */     {
/* 336 */       this.scannerThread.doScan();
/*     */ 
/* 339 */       this.scannerThread.setEnabled(this.scanEnabled);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */     throws Exception
/*     */   {
/* 346 */     if (this.scannerThread != null)
/*     */     {
/* 348 */       this.scannerThread.setEnabled(false);
/* 349 */       this.scannerThread.waitForInactive();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void destroyService()
/*     */     throws Exception
/*     */   {
/* 356 */     this.deployer = null;
/*     */ 
/* 359 */     if (this.scannerThread != null)
/*     */     {
/* 361 */       synchronized (this.scannerThread)
/*     */       {
/* 363 */         this.scannerThread.shutdown();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 372 */       Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/*     */ 
/* 379 */     this.shutdownHook = null;
/* 380 */     this.scannerThread = null;
/*     */   }
/*     */ 
/*     */   public class ScannerThread extends Thread
/*     */   {
/* 146 */     protected Logger scannerLog = Logger.getLogger(ScannerThread.class);
/*     */ 
/* 149 */     protected SynchronizedBoolean enabled = new SynchronizedBoolean(false);
/*     */ 
/* 152 */     protected SynchronizedBoolean shuttingDown = new SynchronizedBoolean(false);
/*     */ 
/* 155 */     protected Object lock = new Object();
/*     */ 
/* 158 */     protected SynchronizedBoolean active = new SynchronizedBoolean(false);
/*     */ 
/*     */     public ScannerThread(boolean enabled)
/*     */     {
/* 162 */       super();
/*     */ 
/* 164 */       this.enabled.set(enabled);
/*     */     }
/*     */ 
/*     */     public void setEnabled(boolean enabled)
/*     */     {
/* 169 */       this.enabled.set(enabled);
/*     */ 
/* 171 */       synchronized (this.lock)
/*     */       {
/* 173 */         this.lock.notifyAll();
/*     */       }
/*     */ 
/* 176 */       this.scannerLog.debug("Notified that enabled: " + enabled);
/*     */     }
/*     */ 
/*     */     public void shutdown()
/*     */     {
/* 181 */       this.enabled.set(false);
/* 182 */       this.shuttingDown.set(true);
/*     */ 
/* 184 */       synchronized (this.lock)
/*     */       {
/* 186 */         this.lock.notifyAll();
/*     */       }
/*     */ 
/* 189 */       this.scannerLog.debug("Notified to shutdown");
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 196 */       this.scannerLog.debug("Running");
/*     */ 
/* 198 */       this.active.set(true);
/*     */       try
/*     */       {
/* 201 */         while (!this.shuttingDown.get())
/*     */         {
/* 204 */           if (!this.enabled.get())
/*     */           {
/* 206 */             synchronized (this.active)
/*     */             {
/* 208 */               this.active.set(false);
/* 209 */               this.active.notifyAll();
/*     */             }
/*     */             try
/*     */             {
/* 213 */               this.scannerLog.debug("Disabled, waiting for notification");
/* 214 */               synchronized (this.lock)
/*     */               {
/* 216 */                 this.lock.wait();
/*     */               }
/*     */             }
/*     */             catch (InterruptedException ignore)
/*     */             {
/*     */             }
/* 222 */             this.active.set(true);
/*     */           }
/*     */ 
/* 225 */           loop();
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 230 */         synchronized (this.active)
/*     */         {
/* 232 */           this.active.set(false);
/* 233 */           this.active.notifyAll();
/*     */         }
/*     */       }
/*     */ 
/* 237 */       this.scannerLog.debug("Shutdown");
/*     */     }
/*     */ 
/*     */     protected void waitForInactive()
/*     */     {
/* 242 */       boolean interrupted = false;
/* 243 */       synchronized (this.active)
/*     */       {
/*     */         try
/*     */         {
/* 247 */           if ((this.active.get()) && (AbstractDeploymentScanner.this.stopTimeOut > 0L))
/* 248 */             this.active.wait(AbstractDeploymentScanner.this.stopTimeOut);
/*     */         }
/*     */         catch (InterruptedException ignored)
/*     */         {
/* 252 */           interrupted = true;
/*     */         }
/*     */       }
/* 255 */       if (interrupted)
/* 256 */         Thread.currentThread().interrupt();
/*     */     }
/*     */ 
/*     */     public void doScan()
/*     */     {
/*     */       try
/*     */       {
/* 263 */         AbstractDeploymentScanner.this.scan();
/*     */       }
/*     */       catch (Exception e) {
/* 266 */         this.scannerLog.error("Scanning failed; continuing", e);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void loop()
/*     */     {
/* 272 */       while ((this.enabled.get()) && (!this.shuttingDown.get()))
/*     */       {
/* 274 */         doScan();
/*     */         try
/*     */         {
/* 279 */           this.scannerLog.trace("Sleeping...");
/* 280 */           Thread.sleep(AbstractDeploymentScanner.this.scanPeriod);
/*     */         }
/*     */         catch (InterruptedException ignore)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.scanner.AbstractDeploymentScanner
 * JD-Core Version:    0.6.0
 */