/*     */ package org.jboss.deployment.scanner;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.Comparator;
/*     */ import org.jboss.deployment.DefaultDeploymentSorter;
/*     */ 
/*     */ public class AlphaNumericDeploymentSorter
/*     */   implements Comparator, DefaultDeploymentSorter
/*     */ {
/*  41 */   private PrefixDeploymentSorter sorter = new PrefixDeploymentSorter();
/*     */ 
/*     */   public String[] getSuffixOrder()
/*     */   {
/*  45 */     return this.sorter.getSuffixOrder();
/*     */   }
/*     */ 
/*     */   public void setSuffixOrder(String[] suffixOrder)
/*     */   {
/*  50 */     this.sorter.setSuffixOrder(suffixOrder);
/*     */   }
/*     */ 
/*     */   public int compare(Object o1, Object o2)
/*     */   {
/*  55 */     int comp = this.sorter.compare(o1, o2);
/*     */ 
/*  57 */     return comp == 0 ? alphaCompare(o1, o2) : comp;
/*     */   }
/*     */ 
/*     */   private String convertURLToString(URL url)
/*     */   {
/*  62 */     String path = url.getPath();
/*  63 */     int nameEnd = path.length() - 1;
/*  64 */     if (nameEnd <= 0) {
/*  65 */       return "";
/*     */     }
/*     */ 
/*  69 */     if (path.charAt(nameEnd) == '/') {
/*  70 */       nameEnd--;
/*     */     }
/*     */ 
/*  74 */     int nameStart = path.lastIndexOf('/', nameEnd) + 1;
/*     */ 
/*  76 */     return path.substring(nameStart);
/*     */   }
/*     */ 
/*     */   public int alphaCompare(Object o1, Object o2)
/*     */   {
/*  82 */     String s1 = convertURLToString((URL)o1);
/*  83 */     boolean s1IsDigit = Character.isDigit(s1.charAt(0));
/*  84 */     String s2 = convertURLToString((URL)o2);
/*  85 */     boolean s2IsDigit = Character.isDigit(s2.charAt(0));
/*     */ 
/*  87 */     if ((s1IsDigit) && (!s2IsDigit))
/*     */     {
/*  89 */       return 1;
/*     */     }
/*  91 */     if ((!s1IsDigit) && (s2IsDigit))
/*     */     {
/*  93 */       return -1;
/*     */     }
/*  95 */     if ((s1IsDigit) && (s2IsDigit))
/*     */     {
/*  97 */       int num1 = getNumericPrefix(s1);
/*  98 */       int num2 = getNumericPrefix(s2);
/*  99 */       int diff = num1 - num2;
/* 100 */       if (diff != 0)
/*     */       {
/* 102 */         return diff;
/*     */       }
/*     */ 
/* 106 */       String s1Suf = getAlphaSuffix(s1);
/* 107 */       String s2Sef = getAlphaSuffix(s2);
/* 108 */       return s1Suf.compareToIgnoreCase(s2Sef);
/*     */     }
/*     */ 
/* 113 */     return s1.compareToIgnoreCase(s2);
/*     */   }
/*     */ 
/*     */   private String getAlphaSuffix(String s1)
/*     */   {
/* 119 */     int x = 0;
/* 120 */     while (Character.isDigit(s1.charAt(x++)));
/* 121 */     return s1.substring(x);
/*     */   }
/*     */ 
/*     */   private int getNumericPrefix(String s1)
/*     */   {
/* 126 */     int x = 0;
/* 127 */     String numS1 = null;
/* 128 */     while (Character.isDigit(s1.charAt(x++)))
/*     */     {
/* 130 */       numS1 = s1.substring(0, x);
/*     */     }
/* 132 */     int number = Integer.parseInt(numS1);
/* 133 */     return number;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.scanner.AlphaNumericDeploymentSorter
 * JD-Core Version:    0.6.0
 */