/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import java.util.Stack;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class AllowedOperationsAssociation
/*     */   implements AllowedOperationsFlags
/*     */ {
/*  50 */   private static final Logger log = Logger.getLogger(AllowedOperationsAssociation.class);
/*     */ 
/*  54 */   public static final HashMap methodMap = new LinkedHashMap();
/*     */   private static ThreadLocal threadLocal;
/*     */ 
/*     */   public static void pushInMethodFlag(int inMethodFlag)
/*     */   {
/*  98 */     Stack inMethodStack = (Stack)threadLocal.get();
/*  99 */     inMethodStack.push(new Integer(inMethodFlag));
/*     */   }
/*     */ 
/*     */   public static void popInMethodFlag()
/*     */   {
/* 107 */     Stack inMethodStack = (Stack)threadLocal.get();
/* 108 */     inMethodStack.pop();
/*     */   }
/*     */ 
/*     */   public static int peekInMethodFlag()
/*     */   {
/* 116 */     Stack inMethodStack = (Stack)threadLocal.get();
/* 117 */     if (!inMethodStack.isEmpty()) {
/* 118 */       return ((Integer)inMethodStack.peek()).intValue();
/*     */     }
/* 120 */     return -1;
/*     */   }
/*     */ 
/*     */   public static String peekInMethodFlagAsString()
/*     */   {
/* 129 */     int currentMethodFlag = peekInMethodFlag();
/*     */ 
/* 131 */     return (String)methodMap.get(new Integer(currentMethodFlag));
/*     */   }
/*     */ 
/*     */   public static void assertAllowedIn(String ctxMethod, int flags)
/*     */   {
/* 140 */     Stack inMethodStack = (Stack)threadLocal.get();
/*     */ 
/* 143 */     if (inMethodStack.empty())
/*     */     {
/* 145 */       throw new IllegalStateException("Cannot obtain inMethodFlag for: " + ctxMethod);
/*     */     }
/*     */ 
/* 150 */     if (!inMethodStack.empty())
/*     */     {
/* 154 */       Integer inMethodFlag = (Integer)inMethodStack.peek();
/* 155 */       if (((inMethodFlag.intValue() & flags) == 0) && (inMethodFlag.intValue() != IN_INTERCEPTOR_METHOD))
/*     */       {
/* 157 */         String message = ctxMethod + " should not be access from this bean method: " + methodMap.get(inMethodFlag);
/* 158 */         IllegalStateException ex = new IllegalStateException(message);
/* 159 */         log.error(message + ", allowed is " + getAllowedMethodList(flags), ex);
/* 160 */         throw ex;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static List getAllowedMethodList(int flags)
/*     */   {
/* 170 */     ArrayList allowed = new ArrayList();
/* 171 */     Iterator it = methodMap.entrySet().iterator();
/* 172 */     while (it.hasNext())
/*     */     {
/* 174 */       Map.Entry entry = (Map.Entry)it.next();
/* 175 */       Integer flag = (Integer)entry.getKey();
/* 176 */       if ((flag.intValue() & flags) > 0)
/* 177 */         allowed.add(entry.getValue());
/*     */     }
/* 179 */     return allowed;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  57 */     methodMap.put(new Integer(IN_INTERCEPTOR_METHOD), "IN_INTERCEPTOR_METHOD");
/*  58 */     methodMap.put(new Integer(IN_EJB_ACTIVATE), "IN_EJB_ACTIVATE");
/*  59 */     methodMap.put(new Integer(IN_EJB_PASSIVATE), "IN_EJB_PASSIVATE");
/*  60 */     methodMap.put(new Integer(IN_EJB_REMOVE), "IN_EJB_REMOVE");
/*  61 */     methodMap.put(new Integer(IN_EJB_CREATE), "IN_EJB_CREATE");
/*  62 */     methodMap.put(new Integer(IN_EJB_POST_CREATE), "IN_EJB_POST_CREATE");
/*  63 */     methodMap.put(new Integer(IN_EJB_FIND), "IN_EJB_FIND");
/*  64 */     methodMap.put(new Integer(IN_EJB_HOME), "IN_EJB_HOME");
/*  65 */     methodMap.put(new Integer(IN_EJB_TIMEOUT), "IN_EJB_TIMEOUT");
/*  66 */     methodMap.put(new Integer(IN_EJB_LOAD), "IN_EJB_LOAD");
/*  67 */     methodMap.put(new Integer(IN_EJB_STORE), "IN_EJB_STORE");
/*  68 */     methodMap.put(new Integer(IN_SET_ENTITY_CONTEXT), "IN_SET_ENTITY_CONTEXT");
/*  69 */     methodMap.put(new Integer(IN_UNSET_ENTITY_CONTEXT), "IN_UNSET_ENTITY_CONTEXT");
/*  70 */     methodMap.put(new Integer(IN_SET_SESSION_CONTEXT), "IN_SET_SESSION_CONTEXT");
/*  71 */     methodMap.put(new Integer(IN_SET_MESSAGE_DRIVEN_CONTEXT), "IN_SET_MESSAGE_DRIVEN_CONTEXT");
/*  72 */     methodMap.put(new Integer(IN_AFTER_BEGIN), "IN_AFTER_BEGIN");
/*  73 */     methodMap.put(new Integer(IN_BEFORE_COMPLETION), "IN_BEFORE_COMPLETION");
/*  74 */     methodMap.put(new Integer(IN_AFTER_COMPLETION), "IN_AFTER_COMPLETION");
/*  75 */     methodMap.put(new Integer(IN_BUSINESS_METHOD), "IN_BUSINESS_METHOD");
/*  76 */     methodMap.put(new Integer(IN_SERVICE_ENDPOINT_METHOD), "IN_SERVICE_ENDPOINT_METHOD");
/*     */ 
/*  82 */     threadLocal = new ThreadLocal()
/*     */     {
/*     */       protected Object initialValue() {
/*  85 */         return new Stack();
/*     */       }
/*     */     };
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.AllowedOperationsAssociation
 * JD-Core Version:    0.6.0
 */