/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.MarshalledObject;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class CacheKey
/*     */   implements Externalizable
/*     */ {
/*     */   static final long serialVersionUID = -7108821554259950778L;
/*     */   protected Object id;
/*     */   protected MarshalledObject mo;
/*     */   protected int hashCode;
/*     */ 
/*     */   public Object getId()
/*     */   {
/*  74 */     return this.id;
/*     */   }
/*     */ 
/*     */   public CacheKey()
/*     */   {
/*     */   }
/*     */ 
/*     */   public CacheKey(Object id)
/*     */   {
/*  95 */     if (id == null) throw new Error("id may not be null");
/*     */ 
/*  97 */     this.id = id;
/*     */     try
/*     */     {
/*     */       try
/*     */       {
/* 106 */         Class[] equalsArgs = { Object.class };
/* 107 */         Method equals = id.getClass().getDeclaredMethod("equals", equalsArgs);
/* 108 */         Class[] hashCodeArgs = new Class[0];
/* 109 */         Method hash = id.getClass().getDeclaredMethod("hashCode", hashCodeArgs);
/*     */ 
/* 111 */         this.hashCode = id.hashCode();
/*     */       }
/*     */       catch (NoSuchMethodException ex)
/*     */       {
/* 116 */         this.mo = new MarshalledObject(id);
/*     */ 
/* 118 */         this.hashCode = this.mo.hashCode();
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 123 */       Logger log = Logger.getLogger(getClass());
/* 124 */       log.error("failed to initialize, id=" + id, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 139 */     out.writeObject(this.id);
/* 140 */     out.writeObject(this.mo);
/* 141 */     out.writeInt(this.hashCode);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 147 */     this.id = in.readObject();
/* 148 */     this.mo = ((MarshalledObject)in.readObject());
/* 149 */     this.hashCode = in.readInt();
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 161 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/* 172 */     boolean equals = false;
/* 173 */     if ((object instanceof CacheKey))
/*     */     {
/* 175 */       CacheKey ckey = (CacheKey)object;
/* 176 */       Object key = ckey.id;
/*     */ 
/* 178 */       if (this.mo == null)
/* 179 */         equals = this.id.equals(key);
/*     */       else
/* 181 */         equals = this.mo.equals(ckey.mo);
/*     */     }
/* 183 */     return equals;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 188 */     return this.id.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.CacheKey
 * JD-Core Version:    0.6.0
 */