/*      */ package org.jboss.ejb;
/*      */ 
/*      */ import java.lang.reflect.Method;
/*      */ import java.rmi.RemoteException;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.Enumeration;
/*      */ import java.util.HashMap;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import javax.ejb.EJBException;
/*      */ import javax.ejb.EJBHome;
/*      */ import javax.ejb.EJBLocalHome;
/*      */ import javax.ejb.EJBLocalObject;
/*      */ import javax.ejb.EJBMetaData;
/*      */ import javax.ejb.EJBObject;
/*      */ import javax.ejb.Handle;
/*      */ import javax.ejb.HomeHandle;
/*      */ import javax.ejb.RemoveException;
/*      */ import javax.ejb.TimedObject;
/*      */ import javax.ejb.Timer;
/*      */ import javax.management.MBeanServer;
/*      */ import javax.management.ObjectName;
/*      */ import javax.transaction.Transaction;
/*      */ import org.jboss.invocation.Invocation;
/*      */ import org.jboss.invocation.InvocationType;
/*      */ import org.jboss.invocation.MarshalledInvocation;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.metadata.ApplicationMetaData;
/*      */ import org.jboss.metadata.BeanMetaData;
/*      */ import org.jboss.metadata.ConfigurationMetaData;
/*      */ import org.jboss.metadata.EntityMetaData;
/*      */ import org.jboss.monitor.StatisticsProvider;
/*      */ import org.jboss.proxy.ejb.ClusterProxyFactory;
/*      */ import org.jboss.util.UnreachableStatementException;
/*      */ import org.jboss.util.collection.SerializableEnumeration;
/*      */ 
/*      */ public class EntityContainer extends Container
/*      */   implements EJBProxyFactoryContainer, InstancePoolContainer, EntityContainerMBean
/*      */ {
/*      */   protected Map homeMapping;
/*      */   protected Map beanMapping;
/*      */   protected EntityPersistenceManager persistenceManager;
/*      */   protected InstanceCache instanceCache;
/*      */   protected InstancePool instancePool;
/*      */   protected Interceptor interceptor;
/*      */   protected boolean readOnly;
/*  115 */   protected static GlobalTxEntityMap globalTxEntityMap = new GlobalTxEntityMap();
/*      */ 
/*      */   public EntityContainer()
/*      */   {
/*   82 */     this.homeMapping = new HashMap();
/*      */ 
/*   88 */     this.beanMapping = new HashMap();
/*      */ 
/*  108 */     this.readOnly = false;
/*      */   }
/*      */ 
/*      */   public static GlobalTxEntityMap getGlobalTxEntityMap()
/*      */   {
/*  119 */     return globalTxEntityMap;
/*      */   }
/*      */ 
/*      */   public static void synchronizeEntitiesWithinTransaction(Transaction tx)
/*      */   {
/*  134 */     if (tx != null)
/*      */     {
/*  136 */       getGlobalTxEntityMap().synchronizeEntities(tx);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isReadOnly()
/*      */   {
/*  144 */     return this.readOnly;
/*      */   }
/*      */ 
/*      */   public LocalProxyFactory getLocalProxyFactory()
/*      */   {
/*  149 */     return this.localProxyFactory;
/*      */   }
/*      */ 
/*      */   public void setInstancePool(InstancePool ip)
/*      */   {
/*  154 */     if (ip == null) {
/*  155 */       throw new IllegalArgumentException("Null pool");
/*      */     }
/*  157 */     this.instancePool = ip;
/*  158 */     ip.setContainer(this);
/*      */   }
/*      */ 
/*      */   public InstancePool getInstancePool()
/*      */   {
/*  163 */     return this.instancePool;
/*      */   }
/*      */ 
/*      */   public void setInstanceCache(InstanceCache ic)
/*      */   {
/*  168 */     if (ic == null) {
/*  169 */       throw new IllegalArgumentException("Null cache");
/*      */     }
/*  171 */     this.instanceCache = ic;
/*  172 */     ic.setContainer(this);
/*      */   }
/*      */ 
/*      */   public InstanceCache getInstanceCache()
/*      */   {
/*  177 */     return this.instanceCache;
/*      */   }
/*      */ 
/*      */   public EntityPersistenceManager getPersistenceManager()
/*      */   {
/*  182 */     return this.persistenceManager;
/*      */   }
/*      */ 
/*      */   public void setPersistenceManager(EntityPersistenceManager pm)
/*      */   {
/*  187 */     if (pm == null) {
/*  188 */       throw new IllegalArgumentException("Null persistence manager");
/*      */     }
/*  190 */     this.persistenceManager = pm;
/*  191 */     pm.setContainer(this);
/*      */   }
/*      */ 
/*      */   public void addInterceptor(Interceptor in)
/*      */   {
/*  196 */     if (this.interceptor == null)
/*      */     {
/*  198 */       this.interceptor = in;
/*      */     }
/*      */     else
/*      */     {
/*  202 */       Interceptor current = this.interceptor;
/*  203 */       while (current.getNext() != null)
/*      */       {
/*  205 */         current = current.getNext();
/*      */       }
/*      */ 
/*  208 */       current.setNext(in);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Interceptor getInterceptor()
/*      */   {
/*  214 */     return this.interceptor;
/*      */   }
/*      */ 
/*      */   public Class getHomeClass()
/*      */   {
/*  219 */     return this.homeInterface;
/*      */   }
/*      */ 
/*      */   public Class getRemoteClass()
/*      */   {
/*  224 */     return this.remoteInterface;
/*      */   }
/*      */ 
/*      */   public Object createBeanClassInstance()
/*      */     throws Exception
/*      */   {
/*  238 */     return this.persistenceManager.createBeanClassInstance();
/*      */   }
/*      */ 
/*      */   protected void createService()
/*      */     throws Exception
/*      */   {
/*  246 */     ClassLoader oldCl = SecurityActions.getContextClassLoader();
/*  247 */     SecurityActions.setContextClassLoader(getClassLoader());
/*  248 */     pushENC();
/*      */     try
/*      */     {
/*  252 */       if (this.metaData.getHome() != null)
/*  253 */         this.homeInterface = this.classLoader.loadClass(this.metaData.getHome());
/*  254 */       if (this.metaData.getRemote() != null) {
/*  255 */         this.remoteInterface = this.classLoader.loadClass(this.metaData.getRemote());
/*      */       }
/*      */ 
/*  258 */       super.createService();
/*      */ 
/*  261 */       checkCoherency();
/*      */ 
/*  264 */       setupBeanMapping();
/*      */ 
/*  267 */       setupHomeMapping();
/*      */ 
/*  270 */       setupMarshalledInvocationMapping();
/*      */       try
/*      */       {
/*  275 */         ObjectName containerName = super.getJmxName();
/*  276 */         Hashtable props = containerName.getKeyPropertyList();
/*  277 */         props.put("plugin", "pool");
/*  278 */         ObjectName poolName = new ObjectName(containerName.getDomain(), props);
/*  279 */         this.server.registerMBean(this.instancePool, poolName);
/*      */       }
/*      */       catch (Throwable t)
/*      */       {
/*  283 */         this.log.debug("Failed to register cache as mbean", t);
/*      */       }
/*      */ 
/*  286 */       this.instancePool.create();
/*      */ 
/*  288 */       for (Iterator it = this.proxyFactories.keySet().iterator(); it.hasNext(); )
/*      */       {
/*  290 */         String invokerBinding = (String)it.next();
/*  291 */         EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
/*  292 */         ci.create();
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  298 */         ObjectName containerName = super.getJmxName();
/*  299 */         Hashtable props = containerName.getKeyPropertyList();
/*  300 */         props.put("plugin", "cache");
/*  301 */         ObjectName cacheName = new ObjectName(containerName.getDomain(), props);
/*  302 */         this.server.registerMBean(this.instanceCache, cacheName);
/*      */       }
/*      */       catch (Throwable t)
/*      */       {
/*  306 */         this.log.debug("Failed to register cache as mbean", t);
/*      */       }
/*      */ 
/*  309 */       this.instanceCache.create();
/*      */ 
/*  312 */       this.persistenceManager.create();
/*      */ 
/*  315 */       Interceptor in = this.interceptor;
/*  316 */       while (in != null)
/*      */       {
/*  318 */         in.setContainer(this);
/*  319 */         in.create();
/*  320 */         in = in.getNext();
/*      */       }
/*  322 */       this.readOnly = ((EntityMetaData)this.metaData).isReadOnly();
/*      */     }
/*      */     finally
/*      */     {
/*  326 */       popENC();
/*      */ 
/*  328 */       SecurityActions.setContextClassLoader(oldCl);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void startService()
/*      */     throws Exception
/*      */   {
/*  335 */     ClassLoader oldCl = SecurityActions.getContextClassLoader();
/*  336 */     SecurityActions.setContextClassLoader(getClassLoader());
/*  337 */     pushENC();
/*      */     try
/*      */     {
/*  341 */       super.startService();
/*      */ 
/*  344 */       for (Iterator it = this.proxyFactories.keySet().iterator(); it.hasNext(); )
/*      */       {
/*  346 */         String invokerBinding = (String)it.next();
/*  347 */         EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
/*  348 */         ci.start();
/*      */       }
/*      */ 
/*  352 */       this.instanceCache.start();
/*      */ 
/*  355 */       this.instancePool.start();
/*      */ 
/*  357 */       Interceptor i = this.interceptor;
/*  358 */       while (i != null)
/*      */       {
/*  360 */         i.start();
/*  361 */         i = i.getNext();
/*      */       }
/*      */ 
/*  365 */       restoreTimers();
/*      */     }
/*      */     finally
/*      */     {
/*  369 */       popENC();
/*      */ 
/*  371 */       SecurityActions.setContextClassLoader(oldCl);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void stopService()
/*      */     throws Exception
/*      */   {
/*  378 */     ClassLoader oldCl = SecurityActions.getContextClassLoader();
/*  379 */     SecurityActions.setContextClassLoader(getClassLoader());
/*  380 */     pushENC();
/*      */     try
/*      */     {
/*  387 */       Interceptor in = this.interceptor;
/*  388 */       while (in != null)
/*      */       {
/*  390 */         in.stop();
/*  391 */         in = in.getNext();
/*      */       }
/*      */ 
/*  395 */       this.instancePool.stop();
/*      */ 
/*  399 */       this.persistenceManager.stop();
/*      */ 
/*  402 */       this.instanceCache.stop();
/*      */ 
/*  405 */       for (Iterator it = this.proxyFactories.keySet().iterator(); it.hasNext(); )
/*      */       {
/*  407 */         String invokerBinding = (String)it.next();
/*  408 */         EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
/*  409 */         ci.stop();
/*      */       }
/*      */ 
/*  413 */       super.stopService();
/*      */     }
/*      */     finally
/*      */     {
/*  417 */       popENC();
/*      */ 
/*  419 */       SecurityActions.setContextClassLoader(oldCl);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void destroyService()
/*      */     throws Exception
/*      */   {
/*  426 */     ClassLoader oldCl = SecurityActions.getContextClassLoader();
/*  427 */     SecurityActions.setContextClassLoader(getClassLoader());
/*  428 */     pushENC();
/*      */     try
/*      */     {
/*  432 */       for (Iterator it = this.proxyFactories.keySet().iterator(); it.hasNext(); )
/*      */       {
/*  434 */         String invokerBinding = (String)it.next();
/*  435 */         EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
/*  436 */         ci.destroy();
/*      */       }
/*      */ 
/*  440 */       this.instanceCache.destroy();
/*  441 */       this.instanceCache.setContainer(null);
/*      */       try
/*      */       {
/*  444 */         ObjectName containerName = super.getJmxName();
/*  445 */         Hashtable props = containerName.getKeyPropertyList();
/*  446 */         props.put("plugin", "cache");
/*  447 */         ObjectName cacheName = new ObjectName(containerName.getDomain(), props);
/*  448 */         this.server.unregisterMBean(cacheName);
/*      */       }
/*      */       catch (Throwable ignore)
/*      */       {
/*      */       }
/*      */ 
/*  455 */       this.persistenceManager.destroy();
/*  456 */       this.persistenceManager.setContainer(null);
/*      */ 
/*  459 */       this.instancePool.destroy();
/*  460 */       this.instancePool.setContainer(null);
/*      */       try
/*      */       {
/*  463 */         ObjectName containerName = super.getJmxName();
/*  464 */         Hashtable props = containerName.getKeyPropertyList();
/*  465 */         props.put("plugin", "pool");
/*  466 */         ObjectName poolName = new ObjectName(containerName.getDomain(), props);
/*  467 */         this.server.unregisterMBean(poolName);
/*      */       }
/*      */       catch (Throwable ignore)
/*      */       {
/*      */       }
/*      */ 
/*  474 */       Interceptor in = this.interceptor;
/*  475 */       while (in != null)
/*      */       {
/*  477 */         in.destroy();
/*  478 */         in.setContainer(null);
/*  479 */         in = in.getNext();
/*      */       }
/*      */ 
/*  482 */       MarshalledInvocation.removeHashes(this.homeInterface);
/*  483 */       MarshalledInvocation.removeHashes(this.remoteInterface);
/*      */ 
/*  486 */       super.destroyService();
/*      */     }
/*      */     finally
/*      */     {
/*  490 */       popENC();
/*      */ 
/*  492 */       SecurityActions.setContextClassLoader(oldCl);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object internalInvokeHome(Invocation mi) throws Exception
/*      */   {
/*  498 */     Method method = mi.getMethod();
/*  499 */     if ((method != null) && (method.getName().equals("remove")))
/*      */     {
/*  502 */       InvocationType type = mi.getType();
/*  503 */       if (type == InvocationType.HOME)
/*  504 */         mi.setType(InvocationType.REMOTE);
/*  505 */       else if (type == InvocationType.LOCALHOME)
/*  506 */         mi.setType(InvocationType.LOCAL);
/*  507 */       mi.setMethod(EJBOBJECT_REMOVE);
/*      */ 
/*  510 */       Object arg = mi.getArguments()[0];
/*  511 */       if ((arg instanceof Handle))
/*      */       {
/*  513 */         if (arg == null)
/*  514 */           throw new RemoteException("Null handle");
/*  515 */         Handle handle = (Handle)arg;
/*  516 */         EJBObject ejbObject = handle.getEJBObject();
/*  517 */         mi.setId(ejbObject.getPrimaryKey());
/*      */       }
/*      */       else {
/*  520 */         mi.setId(arg);
/*      */       }
/*  522 */       mi.setArguments(new Object[0]);
/*  523 */       return getInterceptor().invoke(mi);
/*      */     }
/*      */ 
/*  526 */     return getInterceptor().invokeHome(mi);
/*      */   }
/*      */ 
/*      */   public Object internalInvoke(Invocation mi)
/*      */     throws Exception
/*      */   {
/*  532 */     return getInterceptor().invoke(mi);
/*      */   }
/*      */ 
/*      */   public void remove(Invocation mi)
/*      */     throws RemoteException, RemoveException
/*      */   {
/*  542 */     Transaction tx = mi.getTransaction();
/*  543 */     if (!getBeanMetaData().getContainerConfiguration().getSyncOnCommitOnly()) {
/*  544 */       synchronizeEntitiesWithinTransaction(tx);
/*      */     }
/*      */ 
/*  547 */     EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
/*  548 */     getPersistenceManager().removeEntity(ctx);
/*      */ 
/*  550 */     Object pk = ctx.getId();
/*  551 */     removeTimerService(pk);
/*      */ 
/*  557 */     ctx.setId(null);
/*  558 */     this.removeCount += 1L;
/*      */   }
/*      */ 
/*      */   public Handle getHandle(Invocation mi)
/*      */     throws RemoteException
/*      */   {
/*  568 */     throw new Error("Not yet implemented");
/*      */   }
/*      */ 
/*      */   public Object getPrimaryKey(Invocation mi)
/*      */     throws RemoteException
/*      */   {
/*  574 */     return mi.getId();
/*      */   }
/*      */ 
/*      */   public EJBHome getEJBHome(Invocation mi)
/*      */     throws RemoteException
/*      */   {
/*  583 */     EJBProxyFactory ci = getProxyFactory();
/*  584 */     if (ci == null)
/*      */     {
/*  586 */       String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
/*  587 */       throw new IllegalStateException(msg);
/*      */     }
/*  589 */     return (EJBHome)ci.getEJBHome();
/*      */   }
/*      */ 
/*      */   public boolean isIdentical(Invocation mi)
/*      */     throws RemoteException
/*      */   {
/*  595 */     EJBProxyFactory ci = getProxyFactory();
/*  596 */     if (ci == null)
/*      */     {
/*  598 */       String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
/*  599 */       throw new IllegalStateException(msg);
/*      */     }
/*      */ 
/*  602 */     return ci.isIdentical(this, mi);
/*      */   }
/*      */ 
/*      */   public EJBLocalHome getEJBLocalHome(Invocation mi)
/*      */   {
/*  610 */     return this.localProxyFactory.getEJBLocalHome();
/*      */   }
/*      */ 
/*      */   public void removeLocalHome(Invocation mi)
/*      */     throws RemoteException, RemoveException
/*      */   {
/*  619 */     throw new Error("Not Yet Implemented");
/*      */   }
/*      */ 
/*      */   public EJBLocalObject createLocalHome(Invocation mi)
/*      */     throws Exception
/*      */   {
/*  629 */     EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
/*  630 */     getPersistenceManager().createEntity(mi.getMethod(), mi.getArguments(), ctx);
/*      */ 
/*  633 */     this.createCount += 1L;
/*  634 */     return this.localProxyFactory.getEntityEJBLocalObject(ctx.getId(), true);
/*      */   }
/*      */ 
/*      */   public void postCreateLocalHome(Invocation mi)
/*      */     throws Exception
/*      */   {
/*  643 */     getPersistenceManager().postCreateEntity(mi.getMethod(), mi.getArguments(), (EntityEnterpriseContext)mi.getEnterpriseContext());
/*      */   }
/*      */ 
/*      */   public Object findLocal(Invocation mi)
/*      */     throws Exception
/*      */   {
/*  650 */     Method method = mi.getMethod();
/*  651 */     Object[] args = mi.getArguments();
/*  652 */     EntityEnterpriseContext instance = (EntityEnterpriseContext)mi.getEnterpriseContext();
/*      */ 
/*  654 */     boolean syncOnCommitOnly = this.metaData.getContainerConfiguration().getSyncOnCommitOnly();
/*  655 */     Transaction tx = mi.getTransaction();
/*      */ 
/*  657 */     Class returnType = method.getReturnType();
/*  658 */     if ((Collection.class.isAssignableFrom(returnType)) || (returnType == Enumeration.class))
/*      */     {
/*  661 */       if (!syncOnCommitOnly)
/*      */       {
/*  663 */         synchronizeEntitiesWithinTransaction(tx);
/*      */       }
/*      */ 
/*  667 */       Collection c = getPersistenceManager().findEntities(method, args, instance, this.localProxyFactory);
/*      */ 
/*  670 */       if (returnType == Enumeration.class)
/*      */       {
/*  672 */         return Collections.enumeration(c);
/*      */       }
/*      */ 
/*  676 */       return c;
/*      */     }
/*      */ 
/*  681 */     return findSingleObject(tx, method, args, instance, this.localProxyFactory);
/*      */   }
/*      */ 
/*      */   public Object find(Invocation mi)
/*      */     throws Exception
/*      */   {
/*  694 */     EJBProxyFactory ci = getProxyFactory();
/*  695 */     if (ci == null)
/*      */     {
/*  697 */       String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
/*  698 */       throw new IllegalStateException(msg);
/*      */     }
/*      */ 
/*  701 */     Method method = mi.getMethod();
/*  702 */     Object[] args = mi.getArguments();
/*  703 */     EntityEnterpriseContext instance = (EntityEnterpriseContext)mi.getEnterpriseContext();
/*      */ 
/*  705 */     boolean syncOnCommitOnly = this.metaData.getContainerConfiguration().getSyncOnCommitOnly();
/*  706 */     Transaction tx = mi.getTransaction();
/*      */ 
/*  708 */     Class returnType = method.getReturnType();
/*  709 */     if ((Collection.class.isAssignableFrom(returnType)) || (returnType == Enumeration.class))
/*      */     {
/*  712 */       if (!syncOnCommitOnly)
/*      */       {
/*  714 */         synchronizeEntitiesWithinTransaction(tx);
/*      */       }
/*      */ 
/*  718 */       Collection c = getPersistenceManager().findEntities(method, args, instance, ci);
/*      */ 
/*  722 */       if (returnType == Enumeration.class)
/*      */       {
/*  724 */         return new SerializableEnumeration(c);
/*      */       }
/*      */ 
/*  728 */       return c;
/*      */     }
/*      */ 
/*  733 */     return findSingleObject(tx, method, args, instance, ci);
/*      */   }
/*      */ 
/*      */   public void invokeEjbStore(EntityEnterpriseContext ctx)
/*      */     throws Exception
/*      */   {
/*  744 */     if (ctx.getId() != null)
/*      */     {
/*  746 */       EntityPersistenceManager pm = getPersistenceManager();
/*  747 */       pm.invokeEjbStore(ctx);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void storeEntity(EntityEnterpriseContext ctx)
/*      */     throws Exception
/*      */   {
/*  756 */     if (ctx.getId() != null)
/*      */     {
/*  758 */       EntityPersistenceManager pm = getPersistenceManager();
/*  759 */       if (pm.isStoreRequired(ctx))
/*      */       {
/*  761 */         pm.storeEntity(ctx);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void postCreateHome(Invocation mi)
/*      */     throws Exception
/*      */   {
/*  772 */     getPersistenceManager().postCreateEntity(mi.getMethod(), mi.getArguments(), (EntityEnterpriseContext)mi.getEnterpriseContext());
/*      */   }
/*      */ 
/*      */   public EJBObject createHome(Invocation mi)
/*      */     throws Exception
/*      */   {
/*  784 */     getPersistenceManager().createEntity(mi.getMethod(), mi.getArguments(), (EntityEnterpriseContext)mi.getEnterpriseContext());
/*      */ 
/*  788 */     this.createCount += 1L;
/*  789 */     return ((EntityEnterpriseContext)mi.getEnterpriseContext()).getEJBObject();
/*      */   }
/*      */ 
/*      */   public EJBObject getEJBObject(Invocation mi)
/*      */     throws RemoteException
/*      */   {
/*  798 */     EJBProxyFactory ci = getProxyFactory();
/*  799 */     if (ci == null)
/*      */     {
/*  801 */       String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
/*  802 */       throw new IllegalStateException(msg);
/*      */     }
/*      */ 
/*  805 */     return (EJBObject)ci.getEntityEJBObject(((EntityCache)this.instanceCache).createCacheKey(mi.getId()));
/*      */   }
/*      */ 
/*      */   public void removeHome(Invocation mi)
/*      */     throws RemoteException, RemoveException
/*      */   {
/*  816 */     throw new Error("Not yet implemented");
/*      */   }
/*      */ 
/*      */   public EJBMetaData getEJBMetaDataHome(Invocation mi)
/*      */     throws RemoteException
/*      */   {
/*  822 */     EJBProxyFactory ci = getProxyFactory();
/*  823 */     if (ci == null)
/*      */     {
/*  825 */       String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
/*  826 */       throw new IllegalStateException(msg);
/*      */     }
/*  828 */     return ci.getEJBMetaData();
/*      */   }
/*      */ 
/*      */   public HomeHandle getHomeHandleHome(Invocation mi)
/*      */     throws RemoteException
/*      */   {
/*  838 */     throw new Error("Not yet implemented");
/*      */   }
/*      */ 
/*      */   public long getCacheSize()
/*      */   {
/*  847 */     return this.instanceCache.getCacheSize();
/*      */   }
/*      */ 
/*      */   public void flushCache()
/*      */   {
/*  855 */     this.instanceCache.flush();
/*      */   }
/*      */ 
/*      */   public Map retrieveStatistic()
/*      */   {
/*  863 */     Map lStatistics = new HashMap();
/*  864 */     StatisticsProvider lProvider = (StatisticsProvider)getPersistenceManager();
/*  865 */     lStatistics.putAll(lProvider.retrieveStatistic());
/*  866 */     lProvider = (StatisticsProvider)getInstancePool();
/*  867 */     lStatistics.putAll(lProvider.retrieveStatistic());
/*  868 */     return lStatistics;
/*      */   }
/*      */ 
/*      */   public void resetStatistic()
/*      */   {
/*      */   }
/*      */ 
/*      */   private void setupHomeMappingImpl(Method[] m, String finderName, String append)
/*      */     throws Exception
/*      */   {
/*  883 */     boolean isEJB1x = this.metaData.getApplicationMetaData().isEJB1x();
/*      */ 
/*  885 */     for (int i = 0; i < m.length; i++)
/*      */     {
/*  887 */       String methodName = m[i].getName();
/*      */       try
/*      */       {
/*  892 */         String ejbHomeMethodName = "ejbHome" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
/*  893 */         this.homeMapping.put(m[i], this.beanClass.getMethod(ejbHomeMethodName, m[i].getParameterTypes()));
/*      */       }
/*      */       catch (NoSuchMethodException ignore)
/*      */       {
/*  901 */         if (methodName.startsWith("find"))
/*      */         {
/*  903 */           this.homeMapping.put(m[i], getClass().getMethod(finderName, new Class[] { Invocation.class }));
/*      */         }
/*  905 */         else if ((methodName.equals("create")) || ((!isEJB1x) && (methodName.startsWith("create"))))
/*      */         {
/*  908 */           this.homeMapping.put(m[i], getClass().getMethod("create" + append, new Class[] { Invocation.class }));
/*  909 */           this.beanMapping.put(m[i], getClass().getMethod("postCreate" + append, new Class[] { Invocation.class }));
/*      */         }
/*      */         else
/*      */         {
/*  913 */           this.homeMapping.put(m[i], getClass().getMethod(methodName + append, new Class[] { Invocation.class }));
/*      */         }
/*      */       }
/*      */       catch (NoSuchMethodException e)
/*      */       {
/*  918 */         throw new NoSuchMethodException("Could not find matching method for " + m[i]);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void setupHomeMapping() throws Exception
/*      */   {
/*      */     try {
/*  926 */       if (this.homeInterface != null)
/*      */       {
/*  928 */         Method[] m = this.homeInterface.getMethods();
/*  929 */         setupHomeMappingImpl(m, "find", "Home");
/*      */       }
/*  931 */       if (this.localHomeInterface != null)
/*      */       {
/*  933 */         Method[] m = this.localHomeInterface.getMethods();
/*  934 */         setupHomeMappingImpl(m, "findLocal", "LocalHome");
/*      */       }
/*      */ 
/*  940 */       Class handleClass = Class.forName("javax.ejb.Handle");
/*      */ 
/*  943 */       Method[] handleMethods = handleClass.getMethods();
/*      */ 
/*  946 */       for (int j = 0; j < handleMethods.length; j++)
/*      */       {
/*  949 */         if (!handleMethods[j].getName().equals("getEJBObject")) {
/*      */           continue;
/*      */         }
/*  952 */         this.homeMapping.put(handleMethods[j], getClass().getMethod("getEJBObject", new Class[] { Invocation.class }));
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  961 */       this.homeMapping.clear();
/*  962 */       this.beanMapping.clear();
/*      */ 
/*  964 */       throw e;
/*      */     }
/*      */   }
/*      */ 
/*      */   private void setupBeanMappingImpl(Method[] m, String intfName)
/*      */     throws Exception
/*      */   {
/*  971 */     for (int i = 0; i < m.length; i++)
/*      */     {
/*  973 */       if (!m[i].getDeclaringClass().getName().equals(intfName))
/*      */       {
/*  976 */         this.beanMapping.put(m[i], this.beanClass.getMethod(m[i].getName(), m[i].getParameterTypes()));
/*      */       }
/*      */       else
/*      */       {
/*  981 */         this.beanMapping.put(m[i], getClass().getMethod(m[i].getName(), new Class[] { Invocation.class }));
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void setupBeanMapping() throws Exception
/*      */   {
/*      */     try
/*      */     {
/*  990 */       if (this.remoteInterface != null)
/*      */       {
/*  992 */         Method[] m = this.remoteInterface.getMethods();
/*  993 */         setupBeanMappingImpl(m, "javax.ejb.EJBObject");
/*      */       }
/*  995 */       if (this.localInterface != null)
/*      */       {
/*  997 */         Method[] m = this.localInterface.getMethods();
/*  998 */         setupBeanMappingImpl(m, "javax.ejb.EJBLocalObject");
/*      */       }
/* 1000 */       if (TimedObject.class.isAssignableFrom(this.beanClass))
/*      */       {
/* 1002 */         this.beanMapping.put(TimedObject.class.getMethod("ejbTimeout", new Class[] { Timer.class }), this.beanClass.getMethod("ejbTimeout", new Class[] { Timer.class }));
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1011 */       this.homeMapping.clear();
/* 1012 */       this.beanMapping.clear();
/*      */ 
/* 1014 */       throw e;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void setupMarshalledInvocationMapping()
/*      */     throws Exception
/*      */   {
/* 1021 */     if (this.homeInterface != null)
/*      */     {
/* 1023 */       Method[] m = this.homeInterface.getMethods();
/* 1024 */       for (int i = 0; i < m.length; i++)
/*      */       {
/* 1026 */         this.marshalledInvocationMapping.put(new Long(MarshalledInvocation.calculateHash(m[i])), m[i]);
/*      */       }
/*      */     }
/*      */ 
/* 1030 */     if (this.remoteInterface != null)
/*      */     {
/* 1032 */       Method[] m = this.remoteInterface.getMethods();
/* 1033 */       for (int j = 0; j < m.length; j++)
/*      */       {
/* 1035 */         this.marshalledInvocationMapping.put(new Long(MarshalledInvocation.calculateHash(m[j])), m[j]);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1040 */     Method getEJBObjectMethod = Class.forName("javax.ejb.Handle").getMethod("getEJBObject", new Class[0]);
/*      */ 
/* 1043 */     this.marshalledInvocationMapping.put(new Long(MarshalledInvocation.calculateHash(getEJBObjectMethod)), getEJBObjectMethod);
/*      */   }
/*      */ 
/*      */   Interceptor createContainerInterceptor()
/*      */   {
/* 1048 */     return new ContainerInterceptor();
/*      */   }
/*      */ 
/*      */   protected void checkCoherency()
/*      */     throws Exception
/*      */   {
/* 1055 */     if (this.metaData.isClustered())
/*      */     {
/* 1057 */       boolean clusteredProxyFactoryFound = false;
/* 1058 */       for (Iterator it = this.proxyFactories.keySet().iterator(); it.hasNext(); )
/*      */       {
/* 1060 */         String invokerBinding = (String)it.next();
/* 1061 */         EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
/* 1062 */         if ((ci instanceof ClusterProxyFactory)) {
/* 1063 */           clusteredProxyFactoryFound = true;
/*      */         }
/*      */       }
/* 1066 */       if (!clusteredProxyFactoryFound)
/*      */       {
/* 1068 */         this.log.warn("*** EJB '" + this.metaData.getEjbName() + "' deployed as CLUSTERED but not a single clustered-invoker is bound to container ***");
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private Object findSingleObject(Transaction tx, Method method, Object[] args, EntityEnterpriseContext instance, GenericEntityObjectFactory factory)
/*      */     throws Exception
/*      */   {
/* 1080 */     if (method.getName().equals("findByPrimaryKey"))
/*      */     {
/* 1082 */       if (args[0] == null) {
/* 1083 */         throw new IllegalArgumentException("findByPrimaryKey called with null argument.");
/*      */       }
/* 1085 */       if (this.metaData.getContainerConfiguration().getCommitOption() != 1)
/*      */       {
/* 1087 */         Object key = instance.getCacheKey();
/* 1088 */         if (key == null)
/*      */         {
/* 1090 */           key = ((EntityCache)this.instanceCache).createCacheKey(args[0]);
/*      */         }
/*      */ 
/* 1093 */         if (this.instanceCache.isActive(key))
/*      */         {
/* 1095 */           return factory.getEntityEJBObject(key);
/*      */         }
/*      */       }
/*      */     }
/* 1099 */     else if (!this.metaData.getContainerConfiguration().getSyncOnCommitOnly())
/*      */     {
/* 1101 */       synchronizeEntitiesWithinTransaction(tx);
/*      */     }
/*      */ 
/* 1104 */     return getPersistenceManager().findEntity(method, args, instance, factory);
/*      */   }
/*      */ 
/*      */   class ContainerInterceptor extends Container.AbstractContainerInterceptor
/*      */   {
/*      */     ContainerInterceptor()
/*      */     {
/* 1112 */       super();
/*      */     }
/*      */ 
/*      */     public Object invokeHome(Invocation mi)
/*      */       throws Exception
/*      */     {
/* 1118 */       Method miMethod = mi.getMethod();
/* 1119 */       Method m = (Method)EntityContainer.this.homeMapping.get(miMethod);
/* 1120 */       if (m == null)
/*      */       {
/* 1122 */         String msg = "Invalid invocation, check your deployment packaging, method=" + miMethod;
/*      */ 
/* 1124 */         throw new EJBException(msg);
/*      */       }
/*      */ 
/* 1127 */       if (m.getDeclaringClass().equals(EntityContainer.class))
/*      */       {
/*      */         try
/*      */         {
/* 1131 */           return mi.performCall(EntityContainer.this, m, new Object[] { mi });
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/* 1135 */           rethrow(e);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1140 */         EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
/*      */         try
/*      */         {
/* 1143 */           AllowedOperationsAssociation.pushInMethodFlag(AllowedOperationsAssociation.IN_EJB_HOME);
/* 1144 */           localObject1 = mi.performCall(ctx.getInstance(), m, mi.getArguments());
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/*      */           Object localObject1;
/* 1148 */           rethrow(e);
/*      */         }
/*      */         finally {
/* 1151 */           AllowedOperationsAssociation.popInMethodFlag();
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1156 */       throw new UnreachableStatementException();
/*      */     }
/*      */ 
/*      */     public Object invoke(Invocation mi)
/*      */       throws Exception
/*      */     {
/* 1162 */       Method miMethod = mi.getMethod();
/* 1163 */       Method m = (Method)EntityContainer.this.beanMapping.get(miMethod);
/* 1164 */       if (m == null)
/*      */       {
/* 1166 */         String msg = "Invalid invocation, check your deployment packaging, method=" + miMethod;
/*      */ 
/* 1168 */         throw new EJBException(msg);
/*      */       }
/*      */ 
/* 1172 */       if (m.getDeclaringClass().equals(EntityContainer.class))
/*      */       {
/*      */         try
/*      */         {
/* 1177 */           return mi.performCall(EntityContainer.this, m, new Object[] { mi });
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/* 1181 */           rethrow(e);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*      */         try
/*      */         {
/* 1189 */           EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
/* 1190 */           Object instance = ctx.getInstance();
/*      */ 
/* 1192 */           return mi.performCall(instance, m, mi.getArguments());
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/* 1196 */           rethrow(e);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1201 */       throw new UnreachableStatementException();
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.EntityContainer
 * JD-Core Version:    0.6.0
 */