/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.rmi.RemoteException;
/*     */ import java.security.Principal;
/*     */ import java.util.Collection;
/*     */ import java.util.Date;
/*     */ import javax.ejb.EJBContext;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBLocalHome;
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.EntityBean;
/*     */ import javax.ejb.EntityContext;
/*     */ import javax.ejb.Timer;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.transaction.UserTransaction;
/*     */ import org.jboss.ejb.plugins.lock.NonReentrantLock;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.ConfigurationMetaData;
/*     */ 
/*     */ public class EntityEnterpriseContext extends EnterpriseContext
/*     */ {
/*     */   private EJBObject ejbObject;
/*     */   private EJBLocalObject ejbLocalObject;
/*     */   private EntityContext ctx;
/*  66 */   private boolean hasTxSynchronization = false;
/*     */ 
/*  71 */   private GlobalTxEntityMap.TxAssociation txAssociation = GlobalTxEntityMap.NONE;
/*     */ 
/*  78 */   private boolean valid = false;
/*     */ 
/*  83 */   private boolean readOnly = false;
/*     */   private Object persistenceCtx;
/*     */   private Object key;
/*  94 */   private NonReentrantLock methodLock = new NonReentrantLock();
/*     */   private boolean passivateAfterCommit;
/*     */ 
/*     */   public EntityEnterpriseContext(Object instance, Container con)
/*     */     throws RemoteException
/*     */   {
/* 102 */     super(instance, con);
/* 103 */     this.ctx = new EntityContextImpl();
/*     */     try
/*     */     {
/* 106 */       AllowedOperationsAssociation.pushInMethodFlag(IN_SET_ENTITY_CONTEXT);
/* 107 */       ((EntityBean)instance).setEntityContext(this.ctx);
/*     */     }
/*     */     finally
/*     */     {
/* 111 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */   }
/*     */ 
/*     */   public NonReentrantLock getMethodLock()
/*     */   {
/* 122 */     return this.methodLock;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 127 */     super.clear();
/*     */ 
/* 129 */     this.hasTxSynchronization = false;
/* 130 */     this.valid = false;
/* 131 */     this.readOnly = false;
/* 132 */     this.key = null;
/* 133 */     this.persistenceCtx = null;
/* 134 */     this.ejbObject = null;
/* 135 */     this.ejbLocalObject = null;
/* 136 */     this.txAssociation = GlobalTxEntityMap.NONE;
/* 137 */     this.passivateAfterCommit = false;
/*     */   }
/*     */ 
/*     */   public void discard() throws RemoteException
/*     */   {
/* 142 */     ((EntityBean)this.instance).unsetEntityContext();
/*     */   }
/*     */ 
/*     */   public EJBContext getEJBContext()
/*     */   {
/* 147 */     return this.ctx;
/*     */   }
/*     */ 
/*     */   public void setEJBObject(EJBObject eo)
/*     */   {
/* 152 */     this.ejbObject = eo;
/*     */   }
/*     */ 
/*     */   public EJBObject getEJBObject()
/*     */   {
/* 159 */     if ((this.ejbObject == null) && (this.con.getProxyFactory() != null))
/*     */     {
/* 161 */       this.ejbObject = ((EJBObject)this.con.getProxyFactory().getEntityEJBObject(this.id));
/*     */     }
/* 163 */     return this.ejbObject;
/*     */   }
/*     */ 
/*     */   public void setEJBLocalObject(EJBLocalObject eo)
/*     */   {
/* 168 */     this.ejbLocalObject = eo;
/*     */   }
/*     */ 
/*     */   public EJBLocalObject getEJBLocalObject()
/*     */   {
/* 173 */     if ((this.ejbLocalObject == null) && (this.con.getLocalHomeClass() != null))
/*     */     {
/* 175 */       this.ejbLocalObject = ((EntityContainer)this.con).getLocalProxyFactory().getEntityEJBLocalObject(this.id);
/*     */     }
/* 177 */     return this.ejbLocalObject;
/*     */   }
/*     */ 
/*     */   public void setCacheKey(Object key)
/*     */   {
/* 182 */     this.key = key;
/*     */   }
/*     */ 
/*     */   public Object getCacheKey()
/*     */   {
/* 187 */     return this.key;
/*     */   }
/*     */ 
/*     */   public void setPersistenceContext(Object ctx)
/*     */   {
/* 192 */     this.persistenceCtx = ctx;
/*     */   }
/*     */ 
/*     */   public Object getPersistenceContext()
/*     */   {
/* 197 */     return this.persistenceCtx;
/*     */   }
/*     */ 
/*     */   public void hasTxSynchronization(boolean value)
/*     */   {
/* 202 */     this.hasTxSynchronization = value;
/*     */   }
/*     */ 
/*     */   public boolean hasTxSynchronization()
/*     */   {
/* 207 */     return this.hasTxSynchronization;
/*     */   }
/*     */ 
/*     */   public GlobalTxEntityMap.TxAssociation getTxAssociation()
/*     */   {
/* 212 */     return this.txAssociation;
/*     */   }
/*     */ 
/*     */   public void setTxAssociation(GlobalTxEntityMap.TxAssociation txAssociation)
/*     */   {
/* 217 */     this.txAssociation = txAssociation;
/*     */   }
/*     */ 
/*     */   public void setValid(boolean valid)
/*     */   {
/* 222 */     this.valid = valid;
/*     */   }
/*     */ 
/*     */   public boolean isValid()
/*     */   {
/* 227 */     return this.valid;
/*     */   }
/*     */ 
/*     */   public void setReadOnly(boolean readOnly)
/*     */   {
/* 232 */     this.readOnly = readOnly;
/*     */   }
/*     */ 
/*     */   public boolean isReadOnly()
/*     */   {
/* 237 */     return this.readOnly;
/*     */   }
/*     */ 
/*     */   public boolean isPassivateAfterCommit()
/*     */   {
/* 242 */     return this.passivateAfterCommit;
/*     */   }
/*     */ 
/*     */   public void setPassivateAfterCommit(boolean passivateAfterCommit)
/*     */   {
/* 247 */     this.passivateAfterCommit = passivateAfterCommit;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 252 */     return getContainer().getBeanMetaData().getEjbName() + '#' + getId();
/*     */   }
/*     */ 
/*     */   public class TimerServiceWrapper
/*     */     implements TimerService
/*     */   {
/*     */     private TimerService timerService;
/*     */ 
/*     */     public TimerServiceWrapper(EnterpriseContext.EJBContextImpl ctx, TimerService timerService)
/*     */     {
/* 407 */       this.timerService = timerService;
/*     */     }
/*     */ 
/*     */     public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException
/*     */     {
/* 412 */       assertAllowedIn("TimerService.createTimer");
/* 413 */       return this.timerService.createTimer(duration, info);
/*     */     }
/*     */ 
/*     */     public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException
/*     */     {
/* 418 */       assertAllowedIn("TimerService.createTimer");
/* 419 */       return this.timerService.createTimer(initialDuration, intervalDuration, info);
/*     */     }
/*     */ 
/*     */     public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException
/*     */     {
/* 424 */       assertAllowedIn("TimerService.createTimer");
/* 425 */       return this.timerService.createTimer(expiration, info);
/*     */     }
/*     */ 
/*     */     public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException
/*     */     {
/* 430 */       assertAllowedIn("TimerService.createTimer");
/* 431 */       return this.timerService.createTimer(initialExpiration, intervalDuration, info);
/*     */     }
/*     */ 
/*     */     public Collection getTimers() throws IllegalStateException, EJBException
/*     */     {
/* 436 */       assertAllowedIn("TimerService.getTimers");
/* 437 */       return this.timerService.getTimers();
/*     */     }
/*     */ 
/*     */     private void assertAllowedIn(String timerMethod)
/*     */     {
/* 442 */       AllowedOperationsAssociation.assertAllowedIn(timerMethod, AllowedOperationsFlags.IN_EJB_POST_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_LOAD | AllowedOperationsFlags.IN_EJB_STORE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class EntityContextImpl extends EnterpriseContext.EJBContextImpl
/*     */     implements EntityContext
/*     */   {
/*     */     protected EntityContextImpl()
/*     */     {
/* 255 */       super();
/*     */     }
/*     */ 
/*     */     public EJBHome getEJBHome()
/*     */     {
/* 261 */       AllowedOperationsAssociation.assertAllowedIn("getEJBHome", AllowedOperationsFlags.IN_SET_ENTITY_CONTEXT | AllowedOperationsFlags.IN_UNSET_ENTITY_CONTEXT | AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_POST_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_FIND | AllowedOperationsFlags.IN_EJB_HOME | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_EJB_LOAD | AllowedOperationsFlags.IN_EJB_STORE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */ 
/* 267 */       return super.getEJBHome();
/*     */     }
/*     */ 
/*     */     public EJBLocalHome getEJBLocalHome()
/*     */     {
/* 272 */       AllowedOperationsAssociation.assertAllowedIn("getEJBLocalHome", AllowedOperationsFlags.IN_SET_ENTITY_CONTEXT | AllowedOperationsFlags.IN_UNSET_ENTITY_CONTEXT | AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_POST_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_FIND | AllowedOperationsFlags.IN_EJB_HOME | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_EJB_LOAD | AllowedOperationsFlags.IN_EJB_STORE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */ 
/* 278 */       return super.getEJBLocalHome();
/*     */     }
/*     */ 
/*     */     public Principal getCallerPrincipal()
/*     */     {
/* 283 */       AllowedOperationsAssociation.assertAllowedIn("getCallerPrincipal", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_POST_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_FIND | AllowedOperationsFlags.IN_EJB_HOME | AllowedOperationsFlags.IN_EJB_LOAD | AllowedOperationsFlags.IN_EJB_STORE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */ 
/* 288 */       return super.getCallerPrincipal();
/*     */     }
/*     */ 
/*     */     public boolean getRollbackOnly()
/*     */     {
/* 293 */       AllowedOperationsAssociation.assertAllowedIn("getRollbackOnly", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_POST_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_FIND | AllowedOperationsFlags.IN_EJB_HOME | AllowedOperationsFlags.IN_EJB_LOAD | AllowedOperationsFlags.IN_EJB_STORE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */ 
/* 298 */       return super.getRollbackOnly();
/*     */     }
/*     */ 
/*     */     public void setRollbackOnly()
/*     */     {
/* 303 */       AllowedOperationsAssociation.assertAllowedIn("setRollbackOnly", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_POST_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_FIND | AllowedOperationsFlags.IN_EJB_HOME | AllowedOperationsFlags.IN_EJB_LOAD | AllowedOperationsFlags.IN_EJB_STORE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */ 
/* 308 */       super.setRollbackOnly();
/*     */     }
/*     */ 
/*     */     public boolean isCallerInRole(String id)
/*     */     {
/* 313 */       AllowedOperationsAssociation.assertAllowedIn("getCallerInRole", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_POST_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_FIND | AllowedOperationsFlags.IN_EJB_HOME | AllowedOperationsFlags.IN_EJB_LOAD | AllowedOperationsFlags.IN_EJB_STORE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */ 
/* 317 */       return super.isCallerInRole(id);
/*     */     }
/*     */ 
/*     */     public UserTransaction getUserTransaction()
/*     */     {
/* 322 */       AllowedOperationsAssociation.assertAllowedIn("getUserTransaction", 0);
/*     */ 
/* 324 */       return super.getUserTransaction();
/*     */     }
/*     */ 
/*     */     public EJBObject getEJBObject()
/*     */     {
/* 329 */       AllowedOperationsAssociation.assertAllowedIn("getEJBObject", AllowedOperationsFlags.IN_EJB_POST_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_EJB_LOAD | AllowedOperationsFlags.IN_EJB_STORE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */ 
/* 334 */       if (((EntityContainer)EntityEnterpriseContext.this.con).getRemoteClass() == null)
/*     */       {
/* 336 */         throw new IllegalStateException("No remote interface defined.");
/*     */       }
/*     */ 
/* 339 */       if (EntityEnterpriseContext.this.ejbObject == null)
/*     */       {
/* 342 */         Object cacheKey = ((EntityCache)((EntityContainer)EntityEnterpriseContext.this.con).getInstanceCache()).createCacheKey(EntityEnterpriseContext.this.id);
/* 343 */         EJBProxyFactory proxyFactory = EntityEnterpriseContext.this.con.getProxyFactory();
/* 344 */         if (proxyFactory == null)
/*     */         {
/* 346 */           String defaultInvokerName = EntityEnterpriseContext.this.con.getBeanMetaData().getContainerConfiguration().getDefaultInvokerName();
/*     */ 
/* 348 */           proxyFactory = EntityEnterpriseContext.this.con.lookupProxyFactory(defaultInvokerName);
/*     */         }
/* 350 */         EntityEnterpriseContext.access$002(EntityEnterpriseContext.this, (EJBObject)proxyFactory.getEntityEJBObject(cacheKey));
/*     */       }
/*     */ 
/* 353 */       return EntityEnterpriseContext.this.ejbObject;
/*     */     }
/*     */ 
/*     */     public EJBLocalObject getEJBLocalObject()
/*     */     {
/* 358 */       AllowedOperationsAssociation.assertAllowedIn("getEJBLocalObject", AllowedOperationsFlags.IN_EJB_POST_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_EJB_LOAD | AllowedOperationsFlags.IN_EJB_STORE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */ 
/* 363 */       if (EntityEnterpriseContext.this.con.getLocalHomeClass() == null) {
/* 364 */         throw new IllegalStateException("No local interface for bean.");
/*     */       }
/* 366 */       if (EntityEnterpriseContext.this.ejbLocalObject == null)
/*     */       {
/* 368 */         Object cacheKey = ((EntityCache)((EntityContainer)EntityEnterpriseContext.this.con).getInstanceCache()).createCacheKey(EntityEnterpriseContext.this.id);
/* 369 */         EntityEnterpriseContext.access$102(EntityEnterpriseContext.this, ((EntityContainer)EntityEnterpriseContext.this.con).getLocalProxyFactory().getEntityEJBLocalObject(cacheKey));
/*     */       }
/* 371 */       return EntityEnterpriseContext.this.ejbLocalObject;
/*     */     }
/*     */ 
/*     */     public Object getPrimaryKey()
/*     */     {
/* 376 */       AllowedOperationsAssociation.assertAllowedIn("getPrimaryKey", AllowedOperationsFlags.IN_EJB_POST_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_EJB_LOAD | AllowedOperationsFlags.IN_EJB_STORE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */ 
/* 381 */       return EntityEnterpriseContext.this.id;
/*     */     }
/*     */ 
/*     */     public TimerService getTimerService() throws IllegalStateException
/*     */     {
/* 386 */       AllowedOperationsAssociation.assertAllowedIn("getTimerService", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_POST_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_HOME | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_EJB_LOAD | AllowedOperationsFlags.IN_EJB_STORE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
/*     */ 
/* 391 */       return new EntityEnterpriseContext.TimerServiceWrapper(EntityEnterpriseContext.this, this, EntityEnterpriseContext.this.getContainer().getTimerService(EntityEnterpriseContext.this.id));
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.EntityEnterpriseContext
 * JD-Core Version:    0.6.0
 */