/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ 
/*     */ public class GlobalTxEntityMap
/*     */ {
/*  51 */   private static final Logger log = Logger.getLogger(GlobalTxEntityMap.class);
/*     */   private final TransactionLocal txSynch;
/*  97 */   public static final TxAssociation NONE = new TxAssociation()
/*     */   {
/*     */     public void scheduleSync(Transaction tx, EntityEnterpriseContext instance)
/*     */       throws SystemException, RollbackException
/*     */     {
/* 102 */       EntityContainer.getGlobalTxEntityMap().associate(tx, instance);
/* 103 */       instance.setTxAssociation(GlobalTxEntityMap.SYNC_SCHEDULED);
/*     */     }
/*     */ 
/*     */     public void synchronize(Thread thread, Transaction tx, EntityEnterpriseContext instance)
/*     */     {
/* 108 */       throw new UnsupportedOperationException();
/*     */     }
/*     */ 
/*     */     public void invokeEjbStore(Thread thread, EntityEnterpriseContext instance)
/*     */     {
/* 113 */       throw new UnsupportedOperationException();
/*     */     }
/*  97 */   };
/*     */ 
/* 117 */   public static final TxAssociation SYNC_SCHEDULED = new TxAssociation()
/*     */   {
/*     */     public void scheduleSync(Transaction tx, EntityEnterpriseContext instance)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void invokeEjbStore(Thread thread, EntityEnterpriseContext instance) throws Exception
/*     */     {
/* 125 */       if (instance.getId() != null)
/*     */       {
/* 127 */         EntityContainer container = (EntityContainer)instance.getContainer();
/*     */ 
/* 129 */         SecurityActions.setContextClassLoader(thread, container.getClassLoader());
/* 130 */         container.pushENC();
/*     */         try
/*     */         {
/* 134 */           container.invokeEjbStore(instance);
/*     */         }
/*     */         finally
/*     */         {
/* 138 */           container.popENC();
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public void synchronize(Thread thread, Transaction tx, EntityEnterpriseContext instance)
/*     */       throws Exception
/*     */     {
/* 148 */       if (instance.getId() != null)
/*     */       {
/* 150 */         EntityContainer container = (EntityContainer)instance.getContainer();
/*     */ 
/* 153 */         SecurityActions.setContextClassLoader(thread, container.getClassLoader());
/* 154 */         container.pushENC();
/*     */         try
/*     */         {
/* 158 */           container.storeEntity(instance);
/*     */ 
/* 160 */           instance.setTxAssociation(GlobalTxEntityMap.SYNCHRONIZED);
/*     */         }
/*     */         finally
/*     */         {
/* 164 */           container.popENC();
/*     */         }
/*     */       }
/*     */     }
/* 117 */   };
/*     */ 
/* 170 */   public static final TxAssociation SYNCHRONIZED = new TxAssociation()
/*     */   {
/*     */     public void scheduleSync(Transaction tx, EntityEnterpriseContext instance)
/*     */     {
/* 174 */       instance.setTxAssociation(GlobalTxEntityMap.SYNC_SCHEDULED);
/*     */     }
/*     */ 
/*     */     public void invokeEjbStore(Thread thread, EntityEnterpriseContext instance)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void synchronize(Thread thread, Transaction tx, EntityEnterpriseContext instance)
/*     */     {
/*     */     }
/* 170 */   };
/*     */ 
/* 186 */   public static final TxAssociation PREVENT_SYNC = new TxAssociation()
/*     */   {
/*     */     public void scheduleSync(Transaction tx, EntityEnterpriseContext instance)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void synchronize(Thread thread, Transaction tx, EntityEnterpriseContext instance) throws Exception
/*     */     {
/* 194 */       EntityContainer container = (EntityContainer)instance.getContainer();
/* 195 */       if (container.getPersistenceManager().isStoreRequired(instance))
/*     */       {
/* 197 */         throw new EJBException("The instance of " + container.getBeanMetaData().getEjbName() + " with pk=" + instance.getId() + " was not stored to prevent potential inconsistency of data in the database:" + " the instance was evicted from the cache during the transaction" + " and the database was possibly updated by another process.");
/*     */       }
/*     */     }
/*     */ 
/*     */     public void invokeEjbStore(Thread thread, EntityEnterpriseContext instance)
/*     */       throws Exception
/*     */     {
/* 209 */       GlobalTxEntityMap.SYNC_SCHEDULED.invokeEjbStore(thread, instance);
/*     */     }
/* 186 */   };
/*     */ 
/* 217 */   public static final TxAssociation NOT_READY = new TxAssociation() { public void scheduleSync(Transaction tx, EntityEnterpriseContext instance) {  } 
/*     */     public void synchronize(Thread thread, Transaction tx, EntityEnterpriseContext instance) throws Exception {  }
/*     */ 
/*     */     public void invokeEjbStore(Thread thread, EntityEnterpriseContext instance) throws Exception {  } } ;
/*     */ 
/*     */   public GlobalTxEntityMap()
/*     */   {
/*  53 */     this.txSynch = new TransactionLocal();
/*     */   }
/*     */ 
/*     */   public void synchronizeEntities(Transaction tx)
/*     */   {
/* 238 */     GlobalTxSynchronization globalSync = (GlobalTxSynchronization)this.txSynch.get(tx);
/* 239 */     if (globalSync != null)
/*     */     {
/* 241 */       globalSync.synchronize();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void associate(Transaction tx, EntityEnterpriseContext entity)
/*     */     throws RollbackException, SystemException
/*     */   {
/* 251 */     GlobalTxSynchronization globalSync = (GlobalTxSynchronization)this.txSynch.get(tx);
/* 252 */     if (globalSync == null)
/*     */     {
/* 254 */       globalSync = new GlobalTxSynchronization(tx);
/* 255 */       this.txSynch.set(tx, globalSync);
/* 256 */       tx.registerSynchronization(globalSync);
/*     */     }
/*     */ 
/* 263 */     globalSync.associate(entity);
/*     */   }
/*     */ 
/*     */   private class GlobalTxSynchronization
/*     */     implements Synchronization
/*     */   {
/*     */     private Transaction tx;
/* 274 */     private List instances = new ArrayList();
/*     */     private boolean synchronizing;
/*     */ 
/*     */     public GlobalTxSynchronization(Transaction tx)
/*     */     {
/* 279 */       this.tx = tx;
/*     */     }
/*     */ 
/*     */     public void associate(EntityEnterpriseContext ctx)
/*     */     {
/* 284 */       this.instances.add(ctx);
/*     */     }
/*     */ 
/*     */     public void synchronize()
/*     */     {
/* 289 */       if ((this.synchronizing) || (this.instances.isEmpty()))
/*     */       {
/* 291 */         return;
/*     */       }
/*     */ 
/* 294 */       this.synchronizing = true;
/*     */ 
/* 298 */       Thread currentThread = Thread.currentThread();
/* 299 */       ClassLoader oldCl = SecurityActions.getContextClassLoader();
/*     */ 
/* 301 */       EntityEnterpriseContext instance = null;
/*     */       try
/*     */       {
/* 304 */         for (int i = 0; i < this.instances.size(); i++)
/*     */         {
/* 308 */           if (this.tx.getStatus() == 1)
/*     */           {
/*     */             return;
/*     */           }
/* 313 */           instance = (EntityEnterpriseContext)this.instances.get(i);
/* 314 */           instance.getTxAssociation().invokeEjbStore(currentThread, instance);
/*     */         }
/*     */ 
/* 317 */         for (int i = 0; i < this.instances.size(); i++)
/*     */         {
/* 321 */           if (this.tx.getStatus() == 1)
/*     */           {
/*     */             return;
/*     */           }
/*     */ 
/* 327 */           instance = (EntityEnterpriseContext)this.instances.get(i);
/* 328 */           instance.getTxAssociation().synchronize(currentThread, this.tx, instance);
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Exception causeByException)
/*     */       {
/*     */         try
/*     */         {
/* 344 */           this.tx.setRollbackOnly();
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 348 */           GlobalTxEntityMap.log.warn("Exception while trying to rollback tx: " + this.tx, e);
/*     */         }
/*     */ 
/* 352 */         if ((causeByException instanceof EJBException))
/*     */         {
/* 354 */           throw ((EJBException)causeByException);
/*     */         }
/* 356 */         throw new EJBException("Exception in store of entity:" + ((instance == null) || (instance.getId() == null) ? "<null>" : instance.getId().toString()), causeByException);
/*     */       }
/*     */       finally
/*     */       {
/* 362 */         SecurityActions.setContextClassLoader(oldCl);
/* 363 */         this.synchronizing = false;
/*     */       }
/*     */     }
/*     */ 
/*     */     public void beforeCompletion()
/*     */     {
/* 371 */       if (GlobalTxEntityMap.log.isTraceEnabled())
/*     */       {
/* 373 */         GlobalTxEntityMap.log.trace("beforeCompletion called for tx " + this.tx);
/*     */       }
/*     */ 
/* 378 */       synchronize();
/*     */     }
/*     */ 
/*     */     public void afterCompletion(int status)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract interface TxAssociation
/*     */   {
/*     */     public abstract void scheduleSync(Transaction paramTransaction, EntityEnterpriseContext paramEntityEnterpriseContext)
/*     */       throws SystemException, RollbackException;
/*     */ 
/*     */     public abstract void synchronize(Thread paramThread, Transaction paramTransaction, EntityEnterpriseContext paramEntityEnterpriseContext)
/*     */       throws Exception;
/*     */ 
/*     */     public abstract void invokeEjbStore(Thread paramThread, EntityEnterpriseContext paramEntityEnterpriseContext)
/*     */       throws Exception;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.GlobalTxEntityMap
 * JD-Core Version:    0.6.0
 */