/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBLocalHome;
/*     */ import javax.ejb.EJBMetaData;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.HomeHandle;
/*     */ import javax.ejb.RemoveException;
/*     */ import javax.ejb.TimedObject;
/*     */ import javax.ejb.Timer;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.MarshalledInvocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.SessionMetaData;
/*     */ import org.jboss.proxy.ejb.ClusterProxyFactory;
/*     */ 
/*     */ public abstract class SessionContainer extends Container
/*     */ {
/*     */   protected Map homeMapping;
/*     */   protected Map beanMapping;
/*     */   protected Interceptor interceptor;
/*     */   protected Class serviceEndpoint;
/*     */   protected InstancePool instancePool;
/*     */ 
/*     */   public void setInstancePool(InstancePool ip)
/*     */   {
/*  88 */     if (ip == null) {
/*  89 */       throw new IllegalArgumentException("Null pool");
/*     */     }
/*  91 */     this.instancePool = ip;
/*  92 */     ip.setContainer(this);
/*     */   }
/*     */ 
/*     */   public InstancePool getInstancePool()
/*     */   {
/*  98 */     return this.instancePool;
/*     */   }
/*     */ 
/*     */   public LocalProxyFactory getLocalProxyFactory()
/*     */   {
/* 104 */     return this.localProxyFactory;
/*     */   }
/*     */ 
/*     */   public void addInterceptor(Interceptor in)
/*     */   {
/* 110 */     if (this.interceptor == null)
/*     */     {
/* 112 */       this.interceptor = in;
/*     */     }
/*     */     else
/*     */     {
/* 116 */       Interceptor current = this.interceptor;
/* 117 */       while (current.getNext() != null)
/*     */       {
/* 119 */         current = current.getNext();
/*     */       }
/*     */ 
/* 122 */       current.setNext(in);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Interceptor getInterceptor()
/*     */   {
/* 129 */     return this.interceptor;
/*     */   }
/*     */ 
/*     */   public Class getServiceEndpoint()
/*     */   {
/* 135 */     return this.serviceEndpoint;
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/* 143 */     ClassLoader oldCl = SecurityActions.getContextClassLoader();
/* 144 */     SecurityActions.setContextClassLoader(getClassLoader());
/* 145 */     pushENC();
/*     */     try
/*     */     {
/* 149 */       if (this.metaData.getHome() != null)
/* 150 */         this.homeInterface = this.classLoader.loadClass(this.metaData.getHome());
/* 151 */       if (this.metaData.getRemote() != null)
/* 152 */         this.remoteInterface = this.classLoader.loadClass(this.metaData.getRemote());
/* 153 */       if (((SessionMetaData)this.metaData).getServiceEndpoint() != null)
/*     */       {
/* 155 */         this.serviceEndpoint = this.classLoader.loadClass(((SessionMetaData)this.metaData).getServiceEndpoint());
/*     */       }
/*     */ 
/* 160 */       super.createService();
/*     */ 
/* 163 */       checkCoherency();
/*     */ 
/* 166 */       setupBeanMapping();
/*     */ 
/* 169 */       setupHomeMapping();
/*     */ 
/* 172 */       setupMarshalledInvocationMapping();
/*     */ 
/* 174 */       createInvokers();
/*     */ 
/* 176 */       createInstanceCache();
/*     */ 
/* 178 */       createInstancePool();
/*     */ 
/* 180 */       createPersistenceManager();
/*     */ 
/* 182 */       createInterceptors();
/*     */     }
/*     */     finally
/*     */     {
/* 186 */       popENC();
/*     */ 
/* 188 */       SecurityActions.setContextClassLoader(oldCl);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected abstract void setupHomeMapping()
/*     */     throws Exception;
/*     */ 
/*     */   protected void setUpBeanMappingImpl(Map map, Method[] methods, String declaringClass)
/*     */     throws NoSuchMethodException
/*     */   {
/* 201 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 203 */       Method m = methods[i];
/* 204 */       if (!m.getDeclaringClass().getName().equals(declaringClass))
/*     */       {
/*     */         try
/*     */         {
/* 209 */           Method beanMethod = this.beanClass.getMethod(m.getName(), m.getParameterTypes());
/* 210 */           map.put(m, beanMethod);
/*     */         }
/*     */         catch (NoSuchMethodException ex)
/*     */         {
/* 214 */           throw new NoSuchMethodException("Not found in bean class: " + m);
/*     */         }
/*     */ 
/* 217 */         this.log.debug("Mapped " + m.getName() + " HASH " + m.hashCode() + "to " + map.get(m));
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/* 224 */           Method containerMethod = getClass().getMethod(m.getName(), new Class[] { Invocation.class });
/* 225 */           map.put(m, containerMethod);
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/* 229 */           throw new NoSuchMethodException("Not found in container class: " + m);
/*     */         }
/*     */ 
/* 232 */         this.log.debug("Mapped Container method " + m.getName() + " HASH " + m.hashCode());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setupBeanMapping()
/*     */     throws NoSuchMethodException
/*     */   {
/* 240 */     Map map = new HashMap();
/*     */ 
/* 242 */     if (this.remoteInterface != null)
/*     */     {
/* 244 */       Method[] m = this.remoteInterface.getMethods();
/* 245 */       setUpBeanMappingImpl(map, m, "javax.ejb.EJBObject");
/*     */     }
/*     */ 
/* 248 */     if (this.localInterface != null)
/*     */     {
/* 250 */       Method[] m = this.localInterface.getMethods();
/* 251 */       setUpBeanMappingImpl(map, m, "javax.ejb.EJBLocalObject");
/*     */     }
/*     */ 
/* 254 */     if (TimedObject.class.isAssignableFrom(this.beanClass))
/*     */     {
/* 256 */       Method[] m = { TimedObject.class.getMethod("ejbTimeout", new Class[] { Timer.class }) };
/* 257 */       setUpBeanMappingImpl(map, m, "javax.ejb.Timer");
/*     */     }
/*     */ 
/* 260 */     if (this.serviceEndpoint != null)
/*     */     {
/* 262 */       Method[] m = this.serviceEndpoint.getMethods();
/* 263 */       setUpBeanMappingImpl(map, m, "java.rmi.Remote");
/*     */     }
/*     */ 
/* 266 */     this.beanMapping = map;
/*     */   }
/*     */ 
/*     */   protected void setupMarshalledInvocationMapping()
/*     */     throws Exception
/*     */   {
/* 277 */     if (this.homeInterface != null)
/*     */     {
/* 279 */       Method[] m = this.homeInterface.getMethods();
/* 280 */       for (int i = 0; i < m.length; i++)
/*     */       {
/* 282 */         this.marshalledInvocationMapping.put(new Long(MarshalledInvocation.calculateHash(m[i])), m[i]);
/*     */       }
/*     */     }
/*     */ 
/* 286 */     if (this.remoteInterface != null)
/*     */     {
/* 288 */       Method[] m = this.remoteInterface.getMethods();
/* 289 */       for (int j = 0; j < m.length; j++)
/*     */       {
/* 291 */         this.marshalledInvocationMapping.put(new Long(MarshalledInvocation.calculateHash(m[j])), m[j]);
/*     */       }
/*     */     }
/*     */ 
/* 295 */     Method getEJBObjectMethod = Class.forName("javax.ejb.Handle").getMethod("getEJBObject", new Class[0]);
/*     */ 
/* 300 */     this.marshalledInvocationMapping.put(new Long(MarshalledInvocation.calculateHash(getEJBObjectMethod)), getEJBObjectMethod);
/*     */   }
/*     */ 
/*     */   protected void checkCoherency()
/*     */     throws Exception
/*     */   {
/* 307 */     if (this.metaData.isClustered())
/*     */     {
/* 309 */       boolean clusteredProxyFactoryFound = false;
/* 310 */       Iterator it = this.proxyFactories.keySet().iterator();
/* 311 */       while (it.hasNext())
/*     */       {
/* 313 */         String invokerBinding = (String)it.next();
/* 314 */         EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
/* 315 */         if ((ci instanceof ClusterProxyFactory)) {
/* 316 */           clusteredProxyFactoryFound = true;
/*     */         }
/*     */       }
/* 319 */       if (!clusteredProxyFactoryFound)
/*     */       {
/* 321 */         this.log.warn("*** EJB '" + this.metaData.getEjbName() + "' deployed as CLUSTERED but not a single clustered-invoker is bound to container ***");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void createInstancePool()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 335 */       ObjectName containerName = super.getJmxName();
/* 336 */       Hashtable props = containerName.getKeyPropertyList();
/* 337 */       props.put("plugin", "pool");
/* 338 */       ObjectName poolName = new ObjectName(containerName.getDomain(), props);
/* 339 */       this.server.registerMBean(this.instancePool, poolName);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 343 */       this.log.debug("Failed to register pool as mbean", t);
/*     */     }
/*     */ 
/* 346 */     this.instancePool.create();
/*     */   }
/*     */ 
/*     */   protected void createInstanceCache()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void createInvokers()
/*     */     throws Exception
/*     */   {
/* 360 */     for (Iterator it = this.proxyFactories.keySet().iterator(); it.hasNext(); )
/*     */     {
/* 362 */       String invokerBinding = (String)it.next();
/* 363 */       EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
/* 364 */       ci.create();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void createInterceptors()
/*     */     throws Exception
/*     */   {
/* 371 */     Interceptor in = this.interceptor;
/* 372 */     while (in != null)
/*     */     {
/* 374 */       in.setContainer(this);
/* 375 */       in.create();
/* 376 */       in = in.getNext();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void createPersistenceManager()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 390 */     ClassLoader oldCl = SecurityActions.getContextClassLoader();
/* 391 */     SecurityActions.setContextClassLoader(getClassLoader());
/* 392 */     pushENC();
/*     */     try
/*     */     {
/* 396 */       super.startService();
/*     */ 
/* 398 */       startInvokers();
/*     */ 
/* 400 */       startInstanceCache();
/*     */ 
/* 402 */       startInstancePool();
/*     */ 
/* 404 */       startPersistenceManager();
/*     */ 
/* 406 */       startInterceptors();
/*     */ 
/* 409 */       restoreTimers();
/*     */     }
/*     */     finally
/*     */     {
/* 413 */       popENC();
/*     */ 
/* 415 */       SecurityActions.setContextClassLoader(oldCl);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void startPersistenceManager()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void startInstanceCache()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void startInvokers()
/*     */     throws Exception
/*     */   {
/* 436 */     for (Iterator it = this.proxyFactories.keySet().iterator(); it.hasNext(); )
/*     */     {
/* 438 */       String invokerBinding = (String)it.next();
/* 439 */       EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
/* 440 */       ci.start();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void startInstancePool()
/*     */     throws Exception
/*     */   {
/* 447 */     this.instancePool.start();
/*     */   }
/*     */ 
/*     */   protected void startInterceptors()
/*     */     throws Exception
/*     */   {
/* 453 */     Interceptor in = this.interceptor;
/* 454 */     while (in != null)
/*     */     {
/* 456 */       in.start();
/* 457 */       in = in.getNext();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */     throws Exception
/*     */   {
/* 464 */     ClassLoader oldCl = SecurityActions.getContextClassLoader();
/* 465 */     SecurityActions.setContextClassLoader(getClassLoader());
/* 466 */     pushENC();
/*     */     try
/*     */     {
/* 470 */       super.stopService();
/*     */ 
/* 472 */       stopInvokers();
/*     */ 
/* 474 */       stopInstanceCache();
/*     */ 
/* 476 */       stopInstancePool();
/*     */ 
/* 478 */       stopPersistenceManager();
/*     */ 
/* 480 */       stopInterceptors();
/*     */     }
/*     */     finally
/*     */     {
/* 484 */       popENC();
/*     */ 
/* 486 */       SecurityActions.setContextClassLoader(oldCl);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopInterceptors()
/*     */   {
/* 493 */     Interceptor in = this.interceptor;
/* 494 */     while (in != null)
/*     */     {
/* 496 */       in.stop();
/* 497 */       in = in.getNext();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopPersistenceManager()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void stopInstancePool()
/*     */   {
/* 509 */     this.instancePool.stop();
/*     */   }
/*     */ 
/*     */   protected void stopInstanceCache()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void stopInvokers()
/*     */   {
/* 520 */     for (Iterator it = this.proxyFactories.keySet().iterator(); it.hasNext(); )
/*     */     {
/* 522 */       String invokerBinding = (String)it.next();
/* 523 */       EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
/* 524 */       ci.stop();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void destroyService()
/*     */     throws Exception
/*     */   {
/* 531 */     ClassLoader oldCl = SecurityActions.getContextClassLoader();
/* 532 */     SecurityActions.setContextClassLoader(getClassLoader());
/* 533 */     pushENC();
/*     */     try
/*     */     {
/* 536 */       destroyInvokers();
/*     */ 
/* 538 */       destroyInstanceCache();
/*     */ 
/* 540 */       destroyInstancePool();
/*     */ 
/* 542 */       destroyPersistenceManager();
/*     */ 
/* 544 */       destroyInterceptors();
/*     */ 
/* 546 */       destroyMarshalledInvocationMapping();
/*     */ 
/* 548 */       this.homeInterface = null;
/* 549 */       this.remoteInterface = null;
/* 550 */       this.serviceEndpoint = null;
/* 551 */       this.beanMapping.clear();
/*     */ 
/* 554 */       super.destroyService();
/*     */     }
/*     */     finally
/*     */     {
/* 558 */       popENC();
/*     */ 
/* 560 */       SecurityActions.setContextClassLoader(oldCl);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void destroyMarshalledInvocationMapping()
/*     */   {
/* 566 */     MarshalledInvocation.removeHashes(this.homeInterface);
/* 567 */     MarshalledInvocation.removeHashes(this.remoteInterface);
/*     */   }
/*     */ 
/*     */   protected void destroyInterceptors()
/*     */   {
/* 573 */     Interceptor in = this.interceptor;
/* 574 */     while (in != null)
/*     */     {
/* 576 */       in.destroy();
/* 577 */       in.setContainer(null);
/* 578 */       in = in.getNext();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void destroyPersistenceManager()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void destroyInstancePool()
/*     */   {
/* 589 */     this.instancePool.destroy();
/* 590 */     this.instancePool.setContainer(null);
/*     */     try
/*     */     {
/* 593 */       ObjectName containerName = super.getJmxName();
/* 594 */       Hashtable props = containerName.getKeyPropertyList();
/* 595 */       props.put("plugin", "pool");
/* 596 */       ObjectName poolName = new ObjectName(containerName.getDomain(), props);
/* 597 */       this.server.unregisterMBean(poolName);
/*     */     }
/*     */     catch (Throwable ignore)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void destroyInstanceCache()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void destroyInvokers()
/*     */   {
/* 611 */     for (Iterator it = this.proxyFactories.keySet().iterator(); it.hasNext(); )
/*     */     {
/* 613 */       String invokerBinding = (String)it.next();
/* 614 */       EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
/* 615 */       ci.destroy();
/* 616 */       ci.setContainer(null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object internalInvokeHome(Invocation mi) throws Exception
/*     */   {
/* 622 */     Method method = mi.getMethod();
/* 623 */     if ((method != null) && (method.getName().equals("remove")))
/*     */     {
/* 626 */       Object arg = mi.getArguments()[0];
/* 627 */       if ((arg instanceof Handle))
/*     */       {
/* 629 */         if (arg == null)
/* 630 */           throw new RemoteException("Null handle");
/* 631 */         Handle handle = (Handle)arg;
/* 632 */         EJBObject ejbObject = handle.getEJBObject();
/* 633 */         ejbObject.remove();
/* 634 */         return null;
/*     */       }
/*     */ 
/* 637 */       throw new RemoveException("EJBHome.remove(Object) not allowed for session beans");
/*     */     }
/*     */ 
/* 640 */     return getInterceptor().invokeHome(mi);
/*     */   }
/*     */ 
/*     */   public Object internalInvoke(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 651 */     return getInterceptor().invoke(mi);
/*     */   }
/*     */ 
/*     */   public Handle getHandle(Invocation mi)
/*     */     throws RemoteException
/*     */   {
/* 667 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getPrimaryKey(Invocation mi) throws RemoteException
/*     */   {
/* 672 */     return getPrimaryKey();
/*     */   }
/*     */ 
/*     */   public Object getPrimaryKey() throws RemoteException
/*     */   {
/* 677 */     throw new RemoteException("Call to getPrimaryKey not allowed on session bean");
/*     */   }
/*     */ 
/*     */   public EJBHome getEJBHome(Invocation mi) throws RemoteException
/*     */   {
/* 682 */     EJBProxyFactory ci = getProxyFactory();
/* 683 */     if (ci == null)
/*     */     {
/* 685 */       String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
/* 686 */       throw new IllegalStateException(msg);
/*     */     }
/*     */ 
/* 689 */     return (EJBHome)ci.getEJBHome();
/*     */   }
/*     */ 
/*     */   public boolean isIdentical(Invocation mi)
/*     */     throws RemoteException
/*     */   {
/* 697 */     EJBProxyFactory ci = getProxyFactory();
/* 698 */     if (ci == null)
/*     */     {
/* 700 */       String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
/* 701 */       throw new IllegalStateException(msg);
/*     */     }
/*     */ 
/* 704 */     return ci.isIdentical(this, mi);
/*     */   }
/*     */ 
/*     */   public EJBMetaData getEJBMetaDataHome(Invocation mi) throws RemoteException
/*     */   {
/* 709 */     return getEJBMetaDataHome();
/*     */   }
/*     */ 
/*     */   public EJBMetaData getEJBMetaDataHome() throws RemoteException
/*     */   {
/* 714 */     EJBProxyFactory ci = getProxyFactory();
/* 715 */     if (ci == null)
/*     */     {
/* 717 */       String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
/* 718 */       throw new IllegalStateException(msg);
/*     */     }
/*     */ 
/* 721 */     return ci.getEJBMetaData();
/*     */   }
/*     */ 
/*     */   public HomeHandle getHomeHandleHome(Invocation mi) throws RemoteException
/*     */   {
/* 726 */     return getHomeHandleHome();
/*     */   }
/*     */ 
/*     */   public HomeHandle getHomeHandleHome() throws RemoteException
/*     */   {
/* 731 */     EJBProxyFactory ci = getProxyFactory();
/* 732 */     if (ci == null)
/*     */     {
/* 734 */       String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
/* 735 */       throw new IllegalStateException(msg);
/*     */     }
/*     */ 
/* 738 */     EJBHome home = (EJBHome)ci.getEJBHome();
/* 739 */     return home.getHomeHandle();
/*     */   }
/*     */ 
/*     */   public EJBLocalHome getEJBLocalHome(Invocation mi)
/*     */   {
/* 748 */     return this.localProxyFactory.getEJBLocalHome();
/*     */   }
/*     */ 
/*     */   protected Map getHomeMapping()
/*     */   {
/* 757 */     return this.homeMapping;
/*     */   }
/*     */ 
/*     */   protected Map getBeanMapping()
/*     */   {
/* 766 */     return this.beanMapping;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.SessionContainer
 * JD-Core Version:    0.6.0
 */