/*     */ package org.jboss.ejb;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import java.security.Principal;
/*     */ import java.util.Collection;
/*     */ import java.util.Date;
/*     */ import javax.ejb.EJBContext;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBLocalHome;
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.SessionBean;
/*     */ import javax.ejb.SessionContext;
/*     */ import javax.ejb.Timer;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.transaction.HeuristicMixedException;
/*     */ import javax.transaction.HeuristicRollbackException;
/*     */ import javax.transaction.NotSupportedException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.UserTransaction;
/*     */ import javax.xml.rpc.handler.MessageContext;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.ConfigurationMetaData;
/*     */ 
/*     */ public class StatelessSessionEnterpriseContext extends EnterpriseContext
/*     */ {
/*     */   EJBObject ejbObject;
/*     */   EJBLocalObject ejbLocalObject;
/*     */   MessageContext soapMessageContext;
/*     */   SessionContext ctx;
/*     */ 
/*     */   public StatelessSessionEnterpriseContext(Object instance, Container con)
/*     */     throws Exception
/*     */   {
/*  66 */     super(instance, con);
/*  67 */     this.ctx = new SessionContextImpl();
/*     */     try
/*     */     {
/*  71 */       AllowedOperationsAssociation.pushInMethodFlag(IN_SET_SESSION_CONTEXT);
/*  72 */       ((SessionBean)instance).setSessionContext(this.ctx);
/*     */     }
/*     */     finally
/*     */     {
/*  76 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  81 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_CREATE);
/*  82 */       Method ejbCreate = instance.getClass().getMethod("ejbCreate", new Class[0]);
/*  83 */       ejbCreate.invoke(instance, new Object[0]);
/*     */     }
/*     */     catch (InvocationTargetException e) {
/*  86 */       Throwable ex = e.getTargetException();
/*  87 */       if ((ex instanceof EJBException))
/*  88 */         throw ((Exception)ex);
/*  89 */       if ((ex instanceof RuntimeException))
/*  90 */         throw new EJBException((Exception)ex);
/*  91 */       if ((ex instanceof Exception)) {
/*  92 */         throw ((Exception)ex);
/*     */       }
/*  94 */       throw ((Error)ex);
/*     */     }
/*     */     finally
/*     */     {
/*  98 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setEJBObject(EJBObject eo)
/*     */   {
/* 105 */     this.ejbObject = eo;
/*     */   }
/*     */ 
/*     */   public EJBObject getEJBObject() {
/* 109 */     return this.ejbObject;
/*     */   }
/*     */ 
/*     */   public void setEJBLocalObject(EJBLocalObject eo) {
/* 113 */     this.ejbLocalObject = eo;
/*     */   }
/*     */ 
/*     */   public EJBLocalObject getEJBLocalObject() {
/* 117 */     return this.ejbLocalObject;
/*     */   }
/*     */ 
/*     */   public SessionContext getSessionContext() {
/* 121 */     return this.ctx;
/*     */   }
/*     */ 
/*     */   public void setMessageContext(MessageContext msgContext)
/*     */   {
/* 126 */     this.soapMessageContext = msgContext;
/*     */   }
/*     */ 
/*     */   public void discard()
/*     */     throws RemoteException
/*     */   {
/* 133 */     ((SessionBean)this.instance).ejbRemove();
/*     */   }
/*     */ 
/*     */   public EJBContext getEJBContext()
/*     */   {
/* 138 */     return this.ctx;
/*     */   }
/*     */ 
/*     */   public class TimerServiceWrapper
/*     */     implements TimerService
/*     */   {
/*     */     private EnterpriseContext.EJBContextImpl context;
/*     */     private TimerService timerService;
/*     */ 
/*     */     public TimerServiceWrapper(EnterpriseContext.EJBContextImpl ctx, TimerService timerService)
/*     */     {
/* 327 */       this.context = ctx;
/* 328 */       this.timerService = timerService;
/*     */     }
/*     */ 
/*     */     public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException
/*     */     {
/* 333 */       assertAllowedIn("TimerService.createTimer");
/* 334 */       return this.timerService.createTimer(duration, info);
/*     */     }
/*     */ 
/*     */     public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException
/*     */     {
/* 339 */       assertAllowedIn("TimerService.createTimer");
/* 340 */       return this.timerService.createTimer(initialDuration, intervalDuration, info);
/*     */     }
/*     */ 
/*     */     public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException
/*     */     {
/* 345 */       assertAllowedIn("TimerService.createTimer");
/* 346 */       return this.timerService.createTimer(expiration, info);
/*     */     }
/*     */ 
/*     */     public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException
/*     */     {
/* 351 */       assertAllowedIn("TimerService.createTimer");
/* 352 */       return this.timerService.createTimer(initialExpiration, intervalDuration, info);
/*     */     }
/*     */ 
/*     */     public Collection getTimers() throws IllegalStateException, EJBException
/*     */     {
/* 357 */       assertAllowedIn("TimerService.getTimers");
/* 358 */       return this.timerService.getTimers();
/*     */     }
/*     */ 
/*     */     private void assertAllowedIn(String timerMethod)
/*     */     {
/* 363 */       AllowedOperationsAssociation.assertAllowedIn(timerMethod, AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class SessionContextImpl extends EnterpriseContext.EJBContextImpl
/*     */     implements SessionContext
/*     */   {
/*     */     protected SessionContextImpl()
/*     */     {
/* 149 */       super();
/*     */     }
/*     */ 
/*     */     public EJBHome getEJBHome()
/*     */     {
/* 155 */       AllowedOperationsAssociation.assertAllowedIn("getEJBHome", AllowedOperationsFlags.IN_SET_SESSION_CONTEXT | AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
/*     */ 
/* 159 */       return super.getEJBHome();
/*     */     }
/*     */ 
/*     */     public EJBLocalHome getEJBLocalHome()
/*     */     {
/* 164 */       AllowedOperationsAssociation.assertAllowedIn("getEJBLocalHome", AllowedOperationsFlags.IN_SET_SESSION_CONTEXT | AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
/*     */ 
/* 168 */       return super.getEJBLocalHome();
/*     */     }
/*     */ 
/*     */     public EJBObject getEJBObject()
/*     */     {
/* 173 */       AllowedOperationsAssociation.assertAllowedIn("getEJBObject", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
/*     */ 
/* 176 */       if (((StatelessSessionContainer)StatelessSessionEnterpriseContext.this.con).getProxyFactory() == null) {
/* 177 */         throw new IllegalStateException("No remote interface defined.");
/*     */       }
/* 179 */       if (StatelessSessionEnterpriseContext.this.ejbObject == null)
/*     */       {
/* 181 */         EJBProxyFactory proxyFactory = StatelessSessionEnterpriseContext.this.con.getProxyFactory();
/* 182 */         if (proxyFactory == null)
/*     */         {
/* 184 */           String defaultInvokerName = StatelessSessionEnterpriseContext.this.con.getBeanMetaData().getContainerConfiguration().getDefaultInvokerName();
/*     */ 
/* 186 */           proxyFactory = StatelessSessionEnterpriseContext.this.con.lookupProxyFactory(defaultInvokerName);
/*     */         }
/* 188 */         StatelessSessionEnterpriseContext.this.ejbObject = ((EJBObject)proxyFactory.getStatelessSessionEJBObject());
/*     */       }
/*     */ 
/* 191 */       return StatelessSessionEnterpriseContext.this.ejbObject;
/*     */     }
/*     */ 
/*     */     public Object getBusinessObject(Class businessInterface) throws IllegalStateException
/*     */     {
/* 196 */       throw new RuntimeException("NOT IMPLEMENTED");
/*     */     }
/*     */ 
/*     */     public Class getInvokedBusinessInterface() throws IllegalStateException
/*     */     {
/* 201 */       throw new RuntimeException("NOT IMPLEMENTED");
/*     */     }
/*     */ 
/*     */     public EJBLocalObject getEJBLocalObject()
/*     */     {
/* 206 */       AllowedOperationsAssociation.assertAllowedIn("getEJBLocalObject", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
/*     */ 
/* 209 */       if (StatelessSessionEnterpriseContext.this.con.getLocalHomeClass() == null)
/* 210 */         throw new IllegalStateException("No local interface for bean.");
/* 211 */       if (StatelessSessionEnterpriseContext.this.ejbLocalObject == null) {
/* 212 */         StatelessSessionEnterpriseContext.this.ejbLocalObject = ((StatelessSessionContainer)StatelessSessionEnterpriseContext.this.con).getLocalProxyFactory().getStatelessSessionEJBLocalObject();
/*     */       }
/* 214 */       return StatelessSessionEnterpriseContext.this.ejbLocalObject;
/*     */     }
/*     */ 
/*     */     public TimerService getTimerService() throws IllegalStateException
/*     */     {
/* 219 */       AllowedOperationsAssociation.assertAllowedIn("getTimerService", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
/*     */ 
/* 221 */       return new StatelessSessionEnterpriseContext.TimerServiceWrapper(StatelessSessionEnterpriseContext.this, this, super.getTimerService());
/*     */     }
/*     */ 
/*     */     public Principal getCallerPrincipal()
/*     */     {
/* 226 */       AllowedOperationsAssociation.assertAllowedIn("getCallerPrincipal", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
/*     */ 
/* 228 */       return super.getCallerPrincipal();
/*     */     }
/*     */ 
/*     */     public boolean getRollbackOnly()
/*     */     {
/* 233 */       AllowedOperationsAssociation.assertAllowedIn("getRollbackOnly", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
/*     */ 
/* 235 */       return super.getRollbackOnly();
/*     */     }
/*     */ 
/*     */     public void setRollbackOnly()
/*     */     {
/* 240 */       AllowedOperationsAssociation.assertAllowedIn("setRollbackOnly", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
/*     */ 
/* 242 */       super.setRollbackOnly();
/*     */     }
/*     */ 
/*     */     public boolean isCallerInRole(String id)
/*     */     {
/* 247 */       AllowedOperationsAssociation.assertAllowedIn("isCallerInRole", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
/*     */ 
/* 249 */       return super.isCallerInRole(id);
/*     */     }
/*     */ 
/*     */     public UserTransaction getUserTransaction()
/*     */     {
/* 254 */       AllowedOperationsAssociation.assertAllowedIn("getUserTransaction", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
/*     */ 
/* 256 */       UserTransaction ut = super.getUserTransaction();
/* 257 */       return new UserTransaction(ut)
/*     */       {
/*     */         public void begin() throws NotSupportedException, SystemException
/*     */         {
/* 261 */           StatelessSessionEnterpriseContext.SessionContextImpl.this.checkUserTransactionMethods();
/* 262 */           this.val$ut.begin();
/*     */         }
/*     */ 
/*     */         public void commit()
/*     */           throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException
/*     */         {
/* 272 */           StatelessSessionEnterpriseContext.SessionContextImpl.this.checkUserTransactionMethods();
/* 273 */           this.val$ut.commit();
/*     */         }
/*     */ 
/*     */         public void rollback() throws IllegalStateException, SecurityException, SystemException
/*     */         {
/* 278 */           StatelessSessionEnterpriseContext.SessionContextImpl.this.checkUserTransactionMethods();
/* 279 */           this.val$ut.rollback();
/*     */         }
/*     */ 
/*     */         public void setRollbackOnly() throws IllegalStateException, SystemException
/*     */         {
/* 284 */           StatelessSessionEnterpriseContext.SessionContextImpl.this.checkUserTransactionMethods();
/* 285 */           this.val$ut.setRollbackOnly();
/*     */         }
/*     */ 
/*     */         public int getStatus() throws SystemException
/*     */         {
/* 290 */           StatelessSessionEnterpriseContext.SessionContextImpl.this.checkUserTransactionMethods();
/* 291 */           return this.val$ut.getStatus();
/*     */         }
/*     */ 
/*     */         public void setTransactionTimeout(int seconds) throws SystemException
/*     */         {
/* 296 */           StatelessSessionEnterpriseContext.SessionContextImpl.this.checkUserTransactionMethods();
/* 297 */           this.val$ut.setTransactionTimeout(seconds);
/*     */         }
/*     */       };
/*     */     }
/*     */ 
/*     */     private void checkUserTransactionMethods() {
/* 304 */       AllowedOperationsAssociation.assertAllowedIn("UserTransaction methods", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT | AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
/*     */     }
/*     */ 
/*     */     public MessageContext getMessageContext()
/*     */       throws IllegalStateException
/*     */     {
/* 310 */       AllowedOperationsAssociation.assertAllowedIn("getMessageContext", AllowedOperationsFlags.IN_SERVICE_ENDPOINT_METHOD);
/*     */ 
/* 312 */       return StatelessSessionEnterpriseContext.this.soapMessageContext;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.StatelessSessionEnterpriseContext
 * JD-Core Version:    0.6.0
 */