/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import javax.ejb.CreateException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EntityBean;
/*     */ import javax.ejb.FinderException;
/*     */ import javax.ejb.RemoveException;
/*     */ import org.jboss.ejb.AllowedOperationsAssociation;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EntityCache;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.EntityPersistenceManager;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class BMPPersistenceManager
/*     */   implements EntityPersistenceManager
/*     */ {
/*  61 */   private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
/*     */ 
/*  63 */   Logger log = Logger.getLogger(BMPPersistenceManager.class);
/*     */   EntityContainer con;
/*     */   Method ejbLoad;
/*     */   Method ejbStore;
/*     */   Method ejbActivate;
/*     */   Method ejbPassivate;
/*     */   Method ejbRemove;
/*     */   Method isModified;
/*  78 */   HashMap createMethods = new HashMap();
/*  79 */   HashMap postCreateMethods = new HashMap();
/*  80 */   HashMap finderMethods = new HashMap();
/*     */ 
/*     */   public void setContainer(Container c)
/*     */   {
/*  89 */     this.con = ((EntityContainer)c);
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*  95 */     this.ejbLoad = EntityBean.class.getMethod("ejbLoad", new Class[0]);
/*  96 */     this.ejbStore = EntityBean.class.getMethod("ejbStore", new Class[0]);
/*  97 */     this.ejbActivate = EntityBean.class.getMethod("ejbActivate", new Class[0]);
/*  98 */     this.ejbPassivate = EntityBean.class.getMethod("ejbPassivate", new Class[0]);
/*  99 */     this.ejbRemove = EntityBean.class.getMethod("ejbRemove", new Class[0]);
/*     */ 
/* 102 */     if (this.con.getHomeClass() != null)
/*     */     {
/* 104 */       Method[] methods = this.con.getHomeClass().getMethods();
/* 105 */       createMethodCache(methods);
/*     */     }
/* 107 */     if (this.con.getLocalHomeClass() != null)
/*     */     {
/* 109 */       Method[] methods = this.con.getLocalHomeClass().getMethods();
/* 110 */       createMethodCache(methods);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 115 */       this.isModified = this.con.getBeanClass().getMethod("isModified", new Class[0]);
/* 116 */       if (!this.isModified.getReturnType().equals(Boolean.TYPE))
/* 117 */         this.isModified = null;
/*     */     }
/*     */     catch (NoSuchMethodException ignored)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object createBeanClassInstance()
/*     */     throws Exception
/*     */   {
/* 128 */     return this.con.getBeanClass().newInstance();
/*     */   }
/*     */ 
/*     */   private void createMethodCache(Method[] methods)
/*     */     throws NoSuchMethodException
/*     */   {
/* 134 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 136 */       String name = methods[i].getName();
/* 137 */       if (!name.startsWith("create"))
/*     */         continue;
/* 139 */       String nameSuffix = name.substring(0, 1).toUpperCase() + name.substring(1);
/*     */       try
/*     */       {
/* 142 */         this.createMethods.put(methods[i], this.con.getBeanClass().getMethod("ejb" + nameSuffix, methods[i].getParameterTypes()));
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/* 146 */         this.log.error("Home Method " + methods[i] + " not implemented in bean class " + this.con.getBeanClass() + " looking for method named: ejb" + nameSuffix);
/*     */ 
/* 148 */         throw e;
/*     */       }
/*     */       try
/*     */       {
/* 152 */         this.postCreateMethods.put(methods[i], this.con.getBeanClass().getMethod("ejbPost" + nameSuffix, methods[i].getParameterTypes()));
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/* 156 */         this.log.error("Home Method " + methods[i] + " not implemented in bean class " + this.con.getBeanClass() + " looking for method named: ejbPost" + nameSuffix);
/* 157 */         throw e;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 163 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 165 */       if (!methods[i].getName().startsWith("find"))
/*     */         continue;
/*     */       try
/*     */       {
/* 169 */         this.finderMethods.put(methods[i], this.con.getBeanClass().getMethod("ejbF" + methods[i].getName().substring(1), methods[i].getParameterTypes()));
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/* 173 */         this.log.error("Home Method " + methods[i] + " not implemented in bean class");
/* 174 */         throw e;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void createEntity(Method m, Object[] args, EntityEnterpriseContext ctx)
/*     */     throws Exception
/*     */   {
/* 199 */     Object id = null;
/*     */     try
/*     */     {
/* 203 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_CREATE);
/* 204 */       Method createMethod = (Method)this.createMethods.get(m);
/* 205 */       id = createMethod.invoke(ctx.getInstance(), args);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 209 */       throw new EJBException(e);
/*     */     }
/*     */     catch (InvocationTargetException ite) {
/* 212 */       Throwable e = ite.getTargetException();
/* 213 */       if ((e instanceof CreateException))
/*     */       {
/* 216 */         throw ((CreateException)e);
/*     */       }
/* 218 */       if ((e instanceof RemoteException))
/*     */       {
/* 221 */         throw ((RemoteException)e);
/*     */       }
/* 223 */       if ((e instanceof EJBException))
/*     */       {
/* 226 */         throw ((EJBException)e);
/*     */       }
/* 228 */       if ((e instanceof RuntimeException))
/*     */       {
/* 231 */         throw new EJBException((Exception)e);
/*     */       }
/* 233 */       if ((e instanceof Exception))
/*     */       {
/* 235 */         throw ((Exception)e);
/*     */       }
/*     */ 
/* 239 */       throw ((Error)e);
/*     */     }
/*     */     finally
/*     */     {
/* 243 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */ 
/* 247 */     ctx.setId(id);
/*     */ 
/* 250 */     Object cacheKey = ((EntityCache)this.con.getInstanceCache()).createCacheKey(id);
/*     */ 
/* 253 */     ctx.setCacheKey(cacheKey);
/*     */   }
/*     */ 
/*     */   public void postCreateEntity(Method m, Object[] args, EntityEnterpriseContext ctx)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 264 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_POST_CREATE);
/* 265 */       Method postCreateMethod = (Method)this.postCreateMethods.get(m);
/* 266 */       postCreateMethod.invoke(ctx.getInstance(), args);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 270 */       throw new EJBException(e);
/*     */     }
/*     */     catch (InvocationTargetException ite) {
/* 273 */       Throwable e = ite.getTargetException();
/* 274 */       if ((e instanceof CreateException))
/*     */       {
/* 277 */         throw ((CreateException)e);
/*     */       }
/* 279 */       if ((e instanceof RemoteException))
/*     */       {
/* 282 */         throw ((RemoteException)e);
/*     */       }
/* 284 */       if ((e instanceof EJBException))
/*     */       {
/* 287 */         throw ((EJBException)e);
/*     */       }
/* 289 */       if ((e instanceof RuntimeException))
/*     */       {
/* 292 */         throw new EJBException((Exception)e);
/*     */       }
/* 294 */       if ((e instanceof Exception))
/*     */       {
/* 296 */         throw ((Exception)e);
/*     */       }
/*     */ 
/* 300 */       throw ((Error)e);
/*     */     }
/*     */     finally
/*     */     {
/* 304 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 313 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_FIND);
/*     */ 
/* 316 */       Object objectId = callFinderMethod(finderMethod, args, ctx);
/*     */ 
/* 318 */       Object cacheKey = ((EntityCache)this.con.getInstanceCache()).createCacheKey(objectId);
/* 319 */       Object localObject1 = factory.getEntityEJBObject(cacheKey);
/*     */       return localObject1; } finally { AllowedOperationsAssociation.popInMethodFlag(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   public Collection findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory)
/*     */     throws Exception
/*     */   {
/*     */     Object result;
/*     */     try
/*     */     {
/* 334 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_FIND);
/* 335 */       result = callFinderMethod(finderMethod, args, ctx);
/*     */     }
/*     */     finally
/*     */     {
/* 339 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */ 
/* 342 */     if (result == null)
/*     */     {
/* 347 */       return new ArrayList();
/*     */     }
/*     */ 
/* 350 */     if ((result instanceof Enumeration))
/*     */     {
/* 353 */       ArrayList array = new ArrayList();
/* 354 */       Enumeration e = (Enumeration)result;
/* 355 */       while (e.hasMoreElements() == true)
/*     */       {
/* 358 */         Object cacheKey = ((EntityCache)this.con.getInstanceCache()).createCacheKey(e.nextElement());
/* 359 */         Object o = factory.getEntityEJBObject(cacheKey);
/* 360 */         array.add(o);
/*     */       }
/* 362 */       return array;
/*     */     }
/* 364 */     if ((result instanceof Collection))
/*     */     {
/* 367 */       ArrayList array = new ArrayList(((Collection)result).size());
/* 368 */       Iterator i = ((Collection)result).iterator();
/* 369 */       while (i.hasNext())
/*     */       {
/* 372 */         Object cacheKey = ((EntityCache)this.con.getInstanceCache()).createCacheKey(i.next());
/* 373 */         Object o = factory.getEntityEJBObject(cacheKey);
/* 374 */         array.add(o);
/*     */       }
/* 376 */       return array;
/*     */     }
/*     */ 
/* 382 */     throw new EJBException("result of finder method is not a valid return type: " + result.getClass());
/*     */   }
/*     */ 
/*     */   public void activateEntity(EntityEnterpriseContext ctx)
/*     */     throws RemoteException
/*     */   {
/* 391 */     Object id = ctx.getId();
/* 392 */     Object cacheKey = ((EntityCache)this.con.getInstanceCache()).createCacheKey(id);
/*     */ 
/* 395 */     ctx.setCacheKey(cacheKey);
/*     */     try
/*     */     {
/* 399 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_ACTIVATE);
/* 400 */       this.ejbActivate.invoke(ctx.getInstance(), EMPTY_OBJECT_ARRAY);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 404 */       throw new EJBException(e);
/*     */     }
/*     */     catch (InvocationTargetException ite) {
/* 407 */       Throwable e = ite.getTargetException();
/* 408 */       if ((e instanceof RemoteException))
/*     */       {
/* 411 */         throw ((RemoteException)e);
/*     */       }
/* 413 */       if ((e instanceof EJBException))
/*     */       {
/* 416 */         throw ((EJBException)e);
/*     */       }
/* 418 */       if ((e instanceof RuntimeException))
/*     */       {
/* 421 */         throw new EJBException((Exception)e);
/*     */       }
/*     */     }
/*     */     finally {
/* 425 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void loadEntity(EntityEnterpriseContext ctx)
/*     */     throws RemoteException
/*     */   {
/*     */     try
/*     */     {
/* 434 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_LOAD);
/* 435 */       this.ejbLoad.invoke(ctx.getInstance(), EMPTY_OBJECT_ARRAY);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 439 */       throw new EJBException(e);
/*     */     }
/*     */     catch (InvocationTargetException ite) {
/* 442 */       Throwable e = ite.getTargetException();
/* 443 */       if ((e instanceof RemoteException))
/*     */       {
/* 446 */         throw ((RemoteException)e);
/*     */       }
/* 448 */       if ((e instanceof EJBException))
/*     */       {
/* 451 */         throw ((EJBException)e);
/*     */       }
/* 453 */       if ((e instanceof RuntimeException))
/*     */       {
/* 456 */         throw new EJBException((Exception)e);
/*     */       }
/*     */     }
/*     */     finally {
/* 460 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isStoreRequired(EntityEnterpriseContext ctx) throws Exception
/*     */   {
/* 466 */     if (this.isModified == null)
/*     */     {
/* 468 */       return true;
/*     */     }
/*     */ 
/* 471 */     Boolean modified = (Boolean)this.isModified.invoke(ctx.getInstance(), EMPTY_OBJECT_ARRAY);
/* 472 */     return modified.booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean isModified(EntityEnterpriseContext ctx) throws Exception
/*     */   {
/* 477 */     return isStoreRequired(ctx);
/*     */   }
/*     */ 
/*     */   public void invokeEjbStore(EntityEnterpriseContext ctx)
/*     */     throws RemoteException
/*     */   {
/*     */     try
/*     */     {
/* 485 */       if (!isStoreRequired(ctx))
/*     */       {
/* 487 */         return;
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 492 */       throw new EJBException("Failed to invoke isModified().", e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 497 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_STORE);
/* 498 */       this.ejbStore.invoke(ctx.getInstance(), EMPTY_OBJECT_ARRAY);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 502 */       throw new EJBException(e);
/*     */     }
/*     */     catch (InvocationTargetException ite) {
/* 505 */       Throwable e = ite.getTargetException();
/* 506 */       if ((e instanceof RemoteException))
/*     */       {
/* 509 */         throw ((RemoteException)e);
/*     */       }
/* 511 */       if ((e instanceof EJBException))
/*     */       {
/* 514 */         throw ((EJBException)e);
/*     */       }
/* 516 */       if ((e instanceof RuntimeException))
/*     */       {
/* 519 */         throw new EJBException((Exception)e);
/*     */       }
/*     */     }
/*     */     finally {
/* 523 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void storeEntity(EntityEnterpriseContext ctx)
/*     */     throws RemoteException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void passivateEntity(EntityEnterpriseContext ctx)
/*     */     throws RemoteException
/*     */   {
/*     */     try
/*     */     {
/* 537 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_PASSIVATE);
/* 538 */       this.ejbPassivate.invoke(ctx.getInstance(), EMPTY_OBJECT_ARRAY);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 542 */       throw new EJBException(e);
/*     */     }
/*     */     catch (InvocationTargetException ite) {
/* 545 */       Throwable e = ite.getTargetException();
/* 546 */       if ((e instanceof RemoteException))
/*     */       {
/* 549 */         throw ((RemoteException)e);
/*     */       }
/* 551 */       if ((e instanceof EJBException))
/*     */       {
/* 554 */         throw ((EJBException)e);
/*     */       }
/* 556 */       if ((e instanceof RuntimeException))
/*     */       {
/* 559 */         throw new EJBException((Exception)e);
/*     */       }
/*     */     }
/*     */     finally {
/* 563 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/* 565 */     ctx.setEJBObject(null);
/* 566 */     ctx.setEJBLocalObject(null);
/*     */   }
/*     */ 
/*     */   public void removeEntity(EntityEnterpriseContext ctx)
/*     */     throws RemoteException, RemoveException
/*     */   {
/*     */     try
/*     */     {
/* 574 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_REMOVE);
/* 575 */       this.ejbRemove.invoke(ctx.getInstance(), EMPTY_OBJECT_ARRAY);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 579 */       throw new EJBException(e);
/*     */     }
/*     */     catch (InvocationTargetException ite) {
/* 582 */       Throwable e = ite.getTargetException();
/* 583 */       if ((e instanceof RemoveException))
/*     */       {
/* 586 */         throw ((RemoveException)e);
/*     */       }
/* 588 */       if ((e instanceof RemoteException))
/*     */       {
/* 591 */         throw ((RemoteException)e);
/*     */       }
/* 593 */       if ((e instanceof EJBException))
/*     */       {
/* 596 */         throw ((EJBException)e);
/*     */       }
/* 598 */       if ((e instanceof RuntimeException))
/*     */       {
/* 601 */         throw new EJBException((Exception)e);
/*     */       }
/*     */     }
/*     */     finally {
/* 605 */       AllowedOperationsAssociation.popInMethodFlag();
/*     */     }
/*     */   }
/*     */ 
/*     */   private Object callFinderMethod(Method finderMethod, Object[] args, EntityEnterpriseContext ctx)
/*     */     throws Exception
/*     */   {
/* 620 */     Method callMethod = (Method)this.finderMethods.get(finderMethod);
/*     */ 
/* 622 */     if (callMethod == null)
/*     */     {
/* 624 */       throw new EJBException("couldn't find finder method in bean class. " + finderMethod.toString());
/*     */     }
/*     */ 
/* 629 */     Object result = null;
/*     */     try
/*     */     {
/* 632 */       result = callMethod.invoke(ctx.getInstance(), args);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 636 */       throw new EJBException(e);
/*     */     }
/*     */     catch (InvocationTargetException ite) {
/* 639 */       Throwable e = ite.getTargetException();
/* 640 */       if ((e instanceof FinderException))
/*     */       {
/* 643 */         throw ((FinderException)e);
/*     */       }
/* 645 */       if ((e instanceof RemoteException))
/*     */       {
/* 648 */         throw ((RemoteException)e);
/*     */       }
/* 650 */       if ((e instanceof EJBException))
/*     */       {
/* 653 */         throw ((EJBException)e);
/*     */       }
/* 655 */       if ((e instanceof RuntimeException))
/*     */       {
/* 658 */         throw new EJBException((Exception)e);
/*     */       }
/* 660 */       if ((e instanceof Exception))
/*     */       {
/* 662 */         throw ((Exception)e);
/*     */       }
/*     */ 
/* 666 */       throw ((Error)e);
/*     */     }
/*     */ 
/* 670 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.BMPPersistenceManager
 * JD-Core Version:    0.6.0
 */