/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.Principal;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.Message;
/*     */ import javax.jms.Session;
/*     */ import javax.jms.Topic;
/*     */ import javax.jms.TopicConnection;
/*     */ import javax.jms.TopicConnectionFactory;
/*     */ import javax.jms.TopicPublisher;
/*     */ import javax.jms.TopicSession;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EjbModule;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.monitor.MetricsConstants;
/*     */ 
/*     */ public class MetricsInterceptor extends AbstractInterceptor
/*     */   implements MetricsConstants
/*     */ {
/*     */   private String applicationName;
/*     */   private String beanName;
/*     */   private Thread publisher;
/*     */   private List msgQueue;
/*     */ 
/*     */   public MetricsInterceptor()
/*     */   {
/*  65 */     this.applicationName = "<undefined>";
/*     */ 
/*  68 */     this.beanName = "<undefined>";
/*     */ 
/*  71 */     this.publisher = null;
/*     */ 
/*  80 */     this.msgQueue = new ArrayList(2000);
/*     */   }
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/*  92 */     super.setContainer(container);
/*  93 */     if (container != null)
/*     */     {
/*  95 */       this.applicationName = container.getEjbModule().getName();
/*  96 */       this.beanName = container.getBeanMetaData().getJndiName();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invokeHome(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 105 */     long begin = System.currentTimeMillis();
/*     */     try
/*     */     {
/* 109 */       localObject1 = super.invokeHome(mi);
/*     */     }
/*     */     finally
/*     */     {
/*     */       Object localObject1;
/* 113 */       if ((mi.getMethod() != null) && (this.publisher.isAlive()))
/*     */       {
/* 115 */         addEntry(mi, begin, System.currentTimeMillis());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 123 */     long begin = System.currentTimeMillis();
/*     */     try
/*     */     {
/* 127 */       localObject1 = super.invoke(mi);
/*     */     }
/*     */     finally
/*     */     {
/*     */       Object localObject1;
/* 131 */       if ((mi.getMethod() != null) && (this.publisher.isAlive()))
/*     */       {
/* 133 */         addEntry(mi, begin, System.currentTimeMillis());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void create()
/*     */   {
/* 143 */     this.log.warn("\n----------------------------------------------------------------------\nDeprecated MetricsInterceptor activated for bean: '" + this.beanName + "'\n" + "Invocation metrics will be published in JMS Topic: 'topic/metrics'\n" + "----------------------------------------------------------------------");
/*     */ 
/* 152 */     this.publisher = new Thread(new Publisher(null));
/* 153 */     this.publisher.setName("Metrics Publisher Thread for " + this.beanName);
/* 154 */     this.publisher.setDaemon(true);
/* 155 */     this.publisher.start();
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 163 */     this.publisher.interrupt();
/*     */   }
/*     */ 
/*     */   private final void addEntry(Invocation mi, long begin, long end)
/*     */   {
/* 180 */     Transaction tx = mi.getTransaction();
/* 181 */     Principal princ = mi.getPrincipal();
/* 182 */     Method method = mi.getMethod();
/* 183 */     Entry start = new Entry(princ, method, tx, begin, "START");
/* 184 */     Entry stop = new Entry(princ, method, tx, end, "STOP");
/*     */ 
/* 188 */     synchronized (this.msgQueue)
/*     */     {
/* 193 */       this.msgQueue.add(start);
/* 194 */       this.msgQueue.add(stop);
/*     */     }
/*     */   }
/*     */ 
/*     */   private Message createMessage(Session session, String principal, int txID, String method, String checkpoint, long time)
/*     */   {
/*     */     try
/*     */     {
/* 204 */       Message msg = session.createMessage();
/*     */ 
/* 206 */       msg.setJMSType("Invocation");
/* 207 */       msg.setStringProperty("CHECKPOINT", checkpoint);
/* 208 */       msg.setStringProperty("BEAN", this.beanName);
/* 209 */       msg.setObjectProperty("METHOD", method);
/* 210 */       msg.setLongProperty("TIME", time);
/*     */ 
/* 212 */       if (txID != -1) {
/* 213 */         msg.setStringProperty("ID", String.valueOf(txID));
/*     */       }
/* 215 */       if (principal != null) {
/* 216 */         msg.setStringProperty("PRINCIPAL", principal);
/*     */       }
/* 218 */       return msg;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */ 
/* 224 */     return null;
/*     */   }
/* 378 */   private final class Entry { int id = -1;
/*     */     long time;
/* 380 */     String principal = null;
/*     */     String checkpoint;
/*     */     String method;
/*     */ 
/* 386 */     Entry(Principal principal, Method method, Transaction tx, long time, String checkpoint) { this.time = time;
/* 387 */       this.checkpoint = checkpoint;
/* 388 */       this.method = method.getName();
/*     */ 
/* 390 */       if (tx != null)
/* 391 */         this.id = tx.hashCode();
/* 392 */       if (principal != null)
/* 393 */         this.principal = principal.getName();
/*     */     }
/*     */   }
/*     */ 
/*     */   private class Publisher
/*     */     implements Runnable
/*     */   {
/* 235 */     private boolean running = true;
/*     */ 
/* 237 */     private int delay = 2000;
/*     */ 
/* 239 */     private TopicConnection connection = null;
/*     */ 
/*     */     private Publisher()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       try
/*     */       {
/* 261 */         boolean IS_TRANSACTED = true;
/* 262 */         int ACKNOWLEDGE_MODE = 3;
/*     */ 
/* 265 */         Context namingContext = new InitialContext();
/* 266 */         TopicConnectionFactory fact = (TopicConnectionFactory)namingContext.lookup("java:/ConnectionFactory");
/*     */ 
/* 268 */         this.connection = fact.createTopicConnection();
/*     */ 
/* 270 */         Topic topic = (Topic)namingContext.lookup("topic/metrics");
/* 271 */         TopicSession session = this.connection.createTopicSession(true, 3);
/* 272 */         TopicPublisher pub = session.createPublisher(topic);
/*     */ 
/* 274 */         pub.setDeliveryMode(1);
/* 275 */         pub.setPriority(4);
/* 276 */         pub.setTimeToLive(0L);
/*     */ 
/* 279 */         this.connection.start();
/*     */ 
/* 282 */         while (this.running)
/*     */         {
/* 286 */           long sleepTime = this.delay;
/*     */           try
/*     */           {
/* 290 */             Thread.sleep(sleepTime);
/*     */ 
/* 294 */             long begin = System.currentTimeMillis();
/*     */             Object[] array;
/* 298 */             synchronized (MetricsInterceptor.this.msgQueue)
/*     */             {
/* 300 */               array = MetricsInterceptor.this.msgQueue.toArray();
/* 301 */               MetricsInterceptor.this.msgQueue.clear();
/*     */             }
/*     */ 
/* 305 */             for (int i = 0; i < array.length; i++)
/*     */             {
/* 307 */               Message msg = MetricsInterceptor.this.createMessage(session, ((MetricsInterceptor.Entry)array[i]).principal, ((MetricsInterceptor.Entry)array[i]).id, ((MetricsInterceptor.Entry)array[i]).method, ((MetricsInterceptor.Entry)array[i]).checkpoint, ((MetricsInterceptor.Entry)array[i]).time);
/*     */ 
/* 315 */               pub.publish(msg);
/*     */             }
/*     */ 
/*     */             try
/*     */             {
/* 323 */               session.commit();
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/*     */             }
/*     */ 
/* 331 */             long end = System.currentTimeMillis();
/*     */ 
/* 333 */             sleepTime = this.delay - (end - begin);
/*     */           }
/*     */           catch (InterruptedException e)
/*     */           {
/* 338 */             this.running = false;
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/* 344 */         MetricsInterceptor.this.log.warn(Thread.currentThread().getName() + " exiting", e);
/*     */       }
/*     */       catch (JMSException e)
/*     */       {
/* 348 */         MetricsInterceptor.this.log.warn(Thread.currentThread().getName() + " exiting", e);
/*     */       }
/*     */       finally
/*     */       {
/* 353 */         synchronized (MetricsInterceptor.this.msgQueue)
/*     */         {
/* 355 */           MetricsInterceptor.this.msgQueue.clear();
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 360 */           if (this.connection != null)
/* 361 */             this.connection.close();
/*     */         }
/*     */         catch (JMSException e)
/*     */         {
/* 365 */           MetricsInterceptor.this.log.warn(e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.MetricsInterceptor
 * JD-Core Version:    0.6.0
 */