/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.metadata.XmlLoadable;
/*     */ import org.jboss.monitor.Monitorable;
/*     */ import org.jboss.monitor.client.BeanCacheSnapshot;
/*     */ import org.jboss.util.CachePolicy;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class NoPassivationCachePolicy
/*     */   implements CachePolicy, Monitorable, XmlLoadable
/*     */ {
/*     */   private HashMap m_map;
/*  51 */   private boolean flushEnabled = false;
/*     */ 
/*     */   public NoPassivationCachePolicy(AbstractInstanceCache eic)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void sample(Object s)
/*     */   {
/*  70 */     if (this.m_map == null) {
/*  71 */       return;
/*     */     }
/*  73 */     synchronized (this.m_map)
/*     */     {
/*  75 */       BeanCacheSnapshot snapshot = (BeanCacheSnapshot)s;
/*  76 */       snapshot.m_passivatingBeans = 0;
/*  77 */       snapshot.m_cacheMinCapacity = 0;
/*  78 */       snapshot.m_cacheMaxCapacity = 2147483647;
/*  79 */       snapshot.m_cacheCapacity = 2147483647;
/*  80 */       snapshot.m_cacheSize = this.m_map.size();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*  87 */     this.m_map = new HashMap();
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 100 */     synchronized (this.m_map)
/*     */     {
/* 102 */       this.m_map.clear();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object get(Object key)
/*     */   {
/* 108 */     if (key == null)
/*     */     {
/* 110 */       throw new IllegalArgumentException("Requesting an object using a null key");
/*     */     }
/* 112 */     EnterpriseContext ctx = null;
/* 113 */     synchronized (this.m_map)
/*     */     {
/* 115 */       ctx = (EnterpriseContext)this.m_map.get(key);
/*     */     }
/* 117 */     return ctx;
/*     */   }
/*     */ 
/*     */   public Object peek(Object key)
/*     */   {
/* 122 */     return get(key);
/*     */   }
/*     */ 
/*     */   public void insert(Object key, Object ctx)
/*     */   {
/* 127 */     if (ctx == null)
/*     */     {
/* 129 */       throw new IllegalArgumentException("Cannot insert a null object in the cache");
/*     */     }
/* 131 */     if (key == null)
/*     */     {
/* 133 */       throw new IllegalArgumentException("Cannot insert an object in the cache with null key");
/*     */     }
/*     */ 
/* 136 */     synchronized (this.m_map)
/*     */     {
/* 138 */       Object obj = this.m_map.get(key);
/* 139 */       if (obj == null)
/*     */       {
/* 141 */         this.m_map.put(key, ctx);
/*     */       }
/*     */       else
/*     */       {
/* 145 */         throw new IllegalStateException("Attempt to put in the cache an object that is already there");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void remove(Object key)
/*     */   {
/* 152 */     if (key == null)
/*     */     {
/* 154 */       throw new IllegalArgumentException("Removing an object using a null key");
/*     */     }
/*     */ 
/* 157 */     synchronized (this.m_map)
/*     */     {
/* 159 */       Object value = this.m_map.get(key);
/* 160 */       if (value != null)
/*     */       {
/* 162 */         this.m_map.remove(key);
/*     */       }
/*     */       else
/*     */       {
/* 166 */         throw new IllegalArgumentException("Cannot remove an object that isn't in the cache");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */   {
/* 173 */     if (this.flushEnabled)
/*     */     {
/* 175 */       synchronized (this.m_map)
/*     */       {
/* 177 */         this.m_map.clear();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 184 */     synchronized (this.m_map)
/*     */     {
/* 186 */       return this.m_map.size();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void importXml(Element element) throws DeploymentException
/*     */   {
/* 192 */     String flushString = MetaData.getElementContent(MetaData.getOptionalChild(element, "flush-enabled"));
/* 193 */     this.flushEnabled = Boolean.valueOf(flushString).booleanValue();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.NoPassivationCachePolicy
 * JD-Core Version:    0.6.0
 */