/*    */ package org.jboss.ejb.plugins;
/*    */ 
/*    */ import java.security.Principal;
/*    */ import java.security.cert.X509Certificate;
/*    */ import javax.net.ssl.SSLPeerUnverifiedException;
/*    */ import javax.net.ssl.SSLSession;
/*    */ import org.jboss.ejb.Interceptor;
/*    */ import org.jboss.invocation.Invocation;
/*    */ import org.jboss.security.CertificatePrincipal;
/*    */ import org.jboss.security.auth.certs.SubjectDNMapping;
/*    */ import org.jboss.security.ssl.DomainServerSocketFactory;
/*    */ 
/*    */ public class SSLSessionInterceptor extends AbstractInterceptor
/*    */ {
/* 46 */   private CertificatePrincipal cpMapping = new SubjectDNMapping();
/*    */ 
/* 48 */   private String sessionIDKey = "SESSION_ID";
/*    */ 
/*    */   public Object invokeHome(Invocation mi) throws Exception
/*    */   {
/* 52 */     extractSessionPrincipal(mi);
/* 53 */     Object returnValue = getNext().invoke(mi);
/* 54 */     return returnValue;
/*    */   }
/*    */ 
/*    */   public CertificatePrincipal getPrincialMapping()
/*    */   {
/* 59 */     return this.cpMapping;
/*    */   }
/*    */ 
/*    */   public void setPrincialMapping(CertificatePrincipal cpMapping)
/*    */   {
/* 64 */     this.cpMapping = cpMapping;
/*    */   }
/*    */ 
/*    */   public String getSessionIDKey()
/*    */   {
/* 69 */     return this.sessionIDKey;
/*    */   }
/*    */ 
/*    */   public void setSessionIDKey(String sessionIDKey)
/*    */   {
/* 74 */     this.sessionIDKey = sessionIDKey;
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation mi) throws Exception
/*    */   {
/* 79 */     extractSessionPrincipal(mi);
/* 80 */     Object returnValue = getNext().invoke(mi);
/* 81 */     return returnValue;
/*    */   }
/*    */ 
/*    */   private void extractSessionPrincipal(Invocation mi)
/*    */     throws SSLPeerUnverifiedException
/*    */   {
/* 95 */     String sessionID = (String)mi.getValue(this.sessionIDKey);
/* 96 */     if (sessionID != null)
/*    */     {
/* 98 */       SSLSession session = DomainServerSocketFactory.getSSLSession(sessionID);
/* 99 */       if (session != null)
/*    */       {
/* 101 */         X509Certificate[] certs = (X509Certificate[])(X509Certificate[])session.getPeerCertificates();
/* 102 */         Principal caller = this.cpMapping.toPrinicipal(certs);
/* 103 */         mi.setPrincipal(caller);
/* 104 */         mi.setCredential(certs);
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.SSLSessionInterceptor
 * JD-Core Version:    0.6.0
 */