/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import javax.ejb.EJBContext;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EJBProxyFactoryContainer;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ import org.jboss.security.SecurityProxy;
/*     */ import org.jboss.security.SecurityProxyFactory;
/*     */ 
/*     */ public class SecurityProxyInterceptor extends AbstractInterceptor
/*     */ {
/*  55 */   public final String SECURITY_PROXY_FACTORY_NAME = "java:/SecurityProxyFactory";
/*     */ 
/*  59 */   protected Logger log = Logger.getLogger(getClass());
/*     */   protected AuthenticationManager securityManager;
/*     */   protected SecurityProxy securityProxy;
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/*  77 */     super.setContainer(container);
/*  78 */     if (container != null)
/*     */     {
/*  80 */       this.securityManager = container.getSecurityManager();
/*  81 */       Object secProxy = container.getSecurityProxy();
/*  82 */       if (secProxy != null)
/*     */       {
/*  86 */         if (!(secProxy instanceof SecurityProxy))
/*     */         {
/*     */           try
/*     */           {
/*  91 */             InitialContext iniCtx = new InitialContext();
/*  92 */             SecurityProxyFactory proxyFactory = (SecurityProxyFactory)iniCtx.lookup("java:/SecurityProxyFactory");
/*     */ 
/*  94 */             this.securityProxy = proxyFactory.create(secProxy);
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/*  98 */             this.log.error("Failed to initialze DefaultSecurityProxy", e);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 103 */           this.securityProxy = ((SecurityProxy)secProxy);
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 109 */           EJBProxyFactoryContainer ic = (EJBProxyFactoryContainer)container;
/*     */ 
/* 111 */           Class beanHome = ic.getHomeClass();
/* 112 */           Class beanRemote = ic.getRemoteClass();
/* 113 */           Class beanLocalHome = ic.getLocalHomeClass();
/* 114 */           Class beanLocal = ic.getLocalClass();
/* 115 */           if (beanLocal == null)
/*     */           {
/* 117 */             this.securityProxy.init(beanHome, beanRemote, this.securityManager);
/*     */           }
/*     */           else
/*     */           {
/* 121 */             this.securityProxy.init(beanHome, beanRemote, beanLocalHome, beanLocal, this.securityManager);
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 127 */           this.log.error("Failed to initialze SecurityProxy", e);
/*     */         }
/* 129 */         this.log.info("Initialized SecurityProxy=" + this.securityProxy);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 138 */     super.start();
/*     */   }
/*     */ 
/*     */   public Object invokeHome(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 144 */     if (this.securityProxy != null)
/*     */     {
/* 146 */       EJBContext ctx = null;
/* 147 */       EnterpriseContext ectx = (EnterpriseContext)mi.getEnterpriseContext();
/* 148 */       if (ectx != null)
/* 149 */         ctx = ectx.getEJBContext();
/* 150 */       Object[] args = mi.getArguments();
/* 151 */       this.securityProxy.setEJBContext(ctx);
/*     */       try
/*     */       {
/* 154 */         this.securityProxy.invokeHome(mi.getMethod(), args);
/*     */       }
/*     */       catch (SecurityException e)
/*     */       {
/* 158 */         Principal principal = mi.getPrincipal();
/* 159 */         String msg = "SecurityProxy.invokeHome exception, principal=" + principal;
/* 160 */         this.log.error(msg, e);
/* 161 */         throw e;
/*     */       }
/*     */     }
/* 164 */     return getNext().invokeHome(mi);
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 170 */     if (this.securityProxy != null)
/*     */     {
/* 172 */       EnterpriseContext ectx = (EnterpriseContext)mi.getEnterpriseContext();
/* 173 */       Object bean = ectx.getInstance();
/* 174 */       EJBContext ctx = ectx.getEJBContext();
/* 175 */       Object[] args = mi.getArguments();
/* 176 */       this.securityProxy.setEJBContext(ctx);
/*     */       try
/*     */       {
/* 179 */         this.securityProxy.invoke(mi.getMethod(), args, bean);
/*     */       }
/*     */       catch (SecurityException e)
/*     */       {
/* 183 */         Principal principal = mi.getPrincipal();
/* 184 */         String msg = "SecurityProxy.invoke exception, principal=" + principal;
/* 185 */         this.log.error(msg, e);
/* 186 */         throw e;
/*     */       }
/*     */     }
/* 189 */     return getNext().invoke(mi);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.SecurityProxyInterceptor
 * JD-Core Version:    0.6.0
 */