/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.HomeHandle;
/*     */ import javax.ejb.SessionContext;
/*     */ import org.jboss.ejb.StatefulSessionEnterpriseContext;
/*     */ 
/*     */ public class SessionObjectInputStream extends ObjectInputStream
/*     */ {
/*     */   private StatefulSessionEnterpriseContext ctx;
/*     */   private ClassLoader appCl;
/*     */ 
/*     */   public SessionObjectInputStream(StatefulSessionEnterpriseContext ctx, InputStream in)
/*     */     throws IOException
/*     */   {
/*  56 */     super(in);
/*  57 */     EnableResolveObjectAction.enableResolveObject(this);
/*     */ 
/*  59 */     this.ctx = ctx;
/*     */ 
/*  62 */     this.appCl = SecurityActions.getContextClassLoader();
/*     */   }
/*     */ 
/*     */   protected Object resolveObject(Object obj)
/*     */     throws IOException
/*     */   {
/*  69 */     Object resolved = obj;
/*     */ 
/*  74 */     if ((obj instanceof Handle)) {
/*  75 */       resolved = ((Handle)obj).getEJBObject();
/*     */     }
/*  78 */     else if ((obj instanceof HomeHandle)) {
/*  79 */       resolved = ((HomeHandle)obj).getEJBHome();
/*     */     }
/*  83 */     else if ((obj instanceof HandleWrapper))
/*     */     {
/*  85 */       HandleWrapper wrapper = (HandleWrapper)obj;
/*     */       try
/*     */       {
/*  88 */         resolved = wrapper.get();
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/*  92 */         throw new IOException("Failed to find class: " + e.getMessage());
/*     */       }
/*     */ 
/*     */     }
/*  96 */     else if ((obj instanceof StatefulSessionBeanField))
/*     */     {
/*  98 */       byte type = ((StatefulSessionBeanField)obj).type;
/*     */ 
/* 101 */       if (type == 0) {
/* 102 */         resolved = this.ctx.getSessionContext();
/*     */       }
/* 105 */       else if (type == 1)
/* 106 */         resolved = this.ctx.getSessionContext().getUserTransaction();
/*     */     }
/* 108 */     return resolved;
/*     */   }
/*     */ 
/*     */   protected Class resolveClass(ObjectStreamClass v)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*     */     try
/*     */     {
/* 118 */       return this.appCl.loadClass(v.getName());
/*     */     }
/*     */     catch (ClassNotFoundException e) {
/*     */     }
/* 122 */     return super.resolveClass(v);
/*     */   }
/*     */ 
/*     */   protected Class resolveProxyClass(String[] interfaces)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 130 */     Class clazz = null;
/* 131 */     Class[] ifaceClasses = new Class[interfaces.length];
/* 132 */     for (int i = 0; i < interfaces.length; i++)
/* 133 */       ifaceClasses[i] = Class.forName(interfaces[i], false, this.appCl);
/*     */     try
/*     */     {
/* 136 */       clazz = Proxy.getProxyClass(this.appCl, ifaceClasses);
/*     */     }
/*     */     catch (IllegalArgumentException e)
/*     */     {
/* 140 */       throw new ClassNotFoundException("Failed to resolve proxy class", e);
/*     */     }
/* 142 */     return clazz;
/*     */   }
/*     */ 
/*     */   private static class EnableResolveObjectAction implements PrivilegedAction {
/*     */     SessionObjectInputStream is;
/*     */ 
/*     */     EnableResolveObjectAction(SessionObjectInputStream is) {
/* 150 */       this.is = is;
/*     */     }
/*     */ 
/*     */     public Object run() {
/* 154 */       this.is.enableResolveObject(true);
/* 155 */       return null;
/*     */     }
/*     */ 
/*     */     static void enableResolveObject(SessionObjectInputStream is) {
/* 159 */       EnableResolveObjectAction action = new EnableResolveObjectAction(is);
/* 160 */       AccessController.doPrivileged(action);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.SessionObjectInputStream
 * JD-Core Version:    0.6.0
 */