/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.rmi.Remote;
/*     */ import java.rmi.server.RemoteObject;
/*     */ import java.rmi.server.RemoteStub;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.SessionContext;
/*     */ import javax.transaction.UserTransaction;
/*     */ 
/*     */ public class SessionObjectOutputStream extends ObjectOutputStream
/*     */ {
/*     */   public SessionObjectOutputStream(OutputStream out)
/*     */     throws IOException
/*     */   {
/*  55 */     super(out);
/*  56 */     EnableReplaceObjectAction.enableReplaceObject(this);
/*     */   }
/*     */ 
/*     */   protected Object replaceObject(Object obj)
/*     */     throws IOException
/*     */   {
/*  63 */     Object replacement = obj;
/*     */ 
/*  67 */     if ((obj instanceof EJBObject)) {
/*  68 */       replacement = ((EJBObject)obj).getHandle();
/*     */     }
/*  71 */     else if ((obj instanceof EJBHome)) {
/*  72 */       replacement = ((EJBHome)obj).getHomeHandle();
/*     */     }
/*  75 */     else if ((obj instanceof SessionContext)) {
/*  76 */       replacement = new StatefulSessionBeanField(0);
/*     */     }
/*  81 */     else if ((obj instanceof UserTransaction)) {
/*  82 */       replacement = new StatefulSessionBeanField(1);
/*     */     }
/*  84 */     else if ((obj instanceof Handle)) {
/*  85 */       replacement = new HandleWrapper((Handle)obj);
/*     */     }
/*  87 */     else if (((obj instanceof Remote)) && (!(obj instanceof RemoteStub)))
/*     */     {
/*  89 */       Remote remote = (Remote)obj;
/*     */       try
/*     */       {
/*  92 */         replacement = RemoteObject.toStub(remote);
/*     */       }
/*     */       catch (IOException ignore)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 100 */     return replacement;
/*     */   }
/*     */ 
/*     */   private static class EnableReplaceObjectAction implements PrivilegedAction {
/*     */     SessionObjectOutputStream os;
/*     */ 
/*     */     EnableReplaceObjectAction(SessionObjectOutputStream os) {
/* 108 */       this.os = os;
/*     */     }
/*     */ 
/*     */     public Object run() {
/* 112 */       this.os.enableReplaceObject(true);
/* 113 */       return null;
/*     */     }
/*     */ 
/*     */     static void enableReplaceObject(SessionObjectOutputStream os) {
/* 117 */       EnableReplaceObjectAction action = new EnableReplaceObjectAction(os);
/* 118 */       AccessController.doPrivileged(action);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.SessionObjectOutputStream
 * JD-Core Version:    0.6.0
 */