/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.ejb.BeanLockManager;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.ejb.InstancePool;
/*     */ import org.jboss.ejb.StatefulSessionContainer;
/*     */ import org.jboss.ejb.StatefulSessionEnterpriseContext;
/*     */ import org.jboss.ejb.StatefulSessionPersistenceManager;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ 
/*     */ public class StatefulSessionInstanceCache extends AbstractInstanceCache
/*     */ {
/*     */   private StatefulSessionContainer m_container;
/*  57 */   private ConcurrentReaderHashMap passivatedIDs = new ConcurrentReaderHashMap();
/*     */ 
/*  60 */   private HashSet activating = new HashSet();
/*     */ 
/*  63 */   private StringBuffer buffer = new StringBuffer();
/*     */ 
/*     */   public long getPassivatedCount()
/*     */   {
/*  77 */     return this.passivatedIDs.size();
/*     */   }
/*     */ 
/*     */   public void setContainer(Container c)
/*     */   {
/*  83 */     this.m_container = ((StatefulSessionContainer)c);
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*  88 */     synchronized (this)
/*     */     {
/*  90 */       this.m_container = null;
/*     */     }
/*  92 */     this.passivatedIDs.clear();
/*  93 */     super.destroy();
/*     */   }
/*     */ 
/*     */   protected synchronized Container getContainer()
/*     */   {
/* 102 */     return this.m_container;
/*     */   }
/*     */ 
/*     */   protected void passivate(EnterpriseContext ctx) throws RemoteException
/*     */   {
/* 107 */     this.m_container.getPersistenceManager().passivateSession((StatefulSessionEnterpriseContext)ctx);
/* 108 */     this.passivatedIDs.put(ctx.getId(), new Long(System.currentTimeMillis()));
/*     */   }
/*     */ 
/*     */   protected void activate(EnterpriseContext ctx) throws RemoteException
/*     */   {
/* 113 */     this.m_container.getPersistenceManager().activateSession((StatefulSessionEnterpriseContext)ctx);
/* 114 */     this.passivatedIDs.remove(ctx.getId());
/*     */   }
/*     */ 
/*     */   protected boolean doActivate(EnterpriseContext ctx) throws RemoteException
/*     */   {
/* 119 */     Object id = ctx.getId();
/* 120 */     synchronized (this.activating)
/*     */     {
/* 123 */       if (this.activating.contains(id))
/* 124 */         return false;
/* 125 */       this.activating.add(id);
/*     */     }
/*     */     try
/*     */     {
/* 129 */       ??? = super.doActivate(ctx);
/*     */     }
/*     */     finally
/*     */     {
/* 133 */       synchronized (this.activating)
/*     */       {
/* 135 */         this.activating.remove(id);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected EnterpriseContext acquireContext() throws Exception
/*     */   {
/* 142 */     return this.m_container.getInstancePool().get();
/*     */   }
/*     */ 
/*     */   protected void freeContext(EnterpriseContext ctx)
/*     */   {
/* 147 */     this.m_container.getInstancePool().free(ctx);
/*     */   }
/*     */ 
/*     */   protected Object getKey(EnterpriseContext ctx)
/*     */   {
/* 152 */     return ctx.getId();
/*     */   }
/*     */ 
/*     */   protected void setKey(Object id, EnterpriseContext ctx)
/*     */   {
/* 157 */     ctx.setId(id);
/*     */   }
/*     */ 
/*     */   protected boolean canPassivate(EnterpriseContext ctx)
/*     */   {
/* 162 */     if (ctx.isLocked())
/*     */     {
/* 165 */       return false;
/*     */     }
/* 167 */     if (!this.m_container.getLockManager().canPassivate(ctx.getId()))
/*     */     {
/* 169 */       return false;
/*     */     }
/*     */ 
/* 173 */     if (ctx.getTransaction() != null)
/*     */     {
/*     */       try
/*     */       {
/* 177 */         return ctx.getTransaction().getStatus() == 6;
/*     */       }
/*     */       catch (SystemException e)
/*     */       {
/* 182 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 186 */     return true;
/*     */   }
/*     */ 
/*     */   protected void removePassivated(long maxLifeAfterPassivation)
/*     */   {
/* 195 */     StatefulSessionPersistenceManager store = this.m_container.getPersistenceManager();
/* 196 */     long now = System.currentTimeMillis();
/* 197 */     log.debug("removePassivated, now=" + now + ", maxLifeAfterPassivation=" + maxLifeAfterPassivation);
/* 198 */     boolean trace = log.isTraceEnabled();
/* 199 */     Iterator entries = this.passivatedIDs.entrySet().iterator();
/* 200 */     while (entries.hasNext())
/*     */     {
/* 202 */       Map.Entry entry = (Map.Entry)entries.next();
/* 203 */       Object key = entry.getKey();
/* 204 */       Long value = (Long)entry.getValue();
/* 205 */       if (value != null)
/*     */       {
/* 207 */         long passivationTime = value.longValue();
/* 208 */         if (now - passivationTime > maxLifeAfterPassivation)
/*     */         {
/* 210 */           preRemovalPreparation(key);
/* 211 */           store.removePassivated(key);
/* 212 */           if (trace) {
/* 213 */             log(key, passivationTime);
/*     */           }
/* 215 */           entries.remove();
/* 216 */           postRemovalCleanup(key);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void preRemovalPreparation(Object key)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void postRemovalCleanup(Object key)
/*     */   {
/*     */   }
/*     */ 
/*     */   private void log(Object key, long passivationTime)
/*     */   {
/* 238 */     if (log.isTraceEnabled())
/*     */     {
/* 240 */       this.buffer.setLength(0);
/* 241 */       this.buffer.append("Removing from storage bean '");
/* 242 */       this.buffer.append(this.m_container.getBeanMetaData().getEjbName());
/* 243 */       this.buffer.append("' with id = ");
/* 244 */       this.buffer.append(key);
/* 245 */       this.buffer.append(", passivationTime=");
/* 246 */       this.buffer.append(passivationTime);
/* 247 */       log.trace(this.buffer.toString());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.StatefulSessionInstanceCache
 * JD-Core Version:    0.6.0
 */