/*     */ package org.jboss.ejb.plugins;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.TimedObject;
/*     */ import javax.ejb.Timer;
/*     */ import javax.xml.rpc.handler.MessageContext;
/*     */ import org.jboss.ejb.AllowedOperationsAssociation;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.ejb.InstancePool;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.ejb.StatelessSessionContainer;
/*     */ import org.jboss.ejb.StatelessSessionEnterpriseContext;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationKey;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ 
/*     */ public class StatelessSessionInstanceInterceptor extends AbstractInterceptor
/*     */ {
/*     */   protected StatelessSessionContainer container;
/*     */   protected static final Method ejbTimeout;
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/*  81 */     super.setContainer(container);
/*  82 */     this.container = ((StatelessSessionContainer)container);
/*     */   }
/*     */ 
/*     */   public Object invokeHome(Invocation mi)
/*     */     throws Exception
/*     */   {
/*  89 */     InstancePool pool = this.container.getInstancePool();
/*  90 */     StatelessSessionEnterpriseContext ctx = null;
/*     */     try
/*     */     {
/*  94 */       ctx = (StatelessSessionEnterpriseContext)pool.get();
/*  95 */       mi.setEnterpriseContext(ctx);
/*     */ 
/*  97 */       localObject1 = getNext().invokeHome(mi);
/*     */     }
/*     */     finally
/*     */     {
/*     */       Object localObject1;
/* 101 */       mi.setEnterpriseContext(null);
/*     */ 
/* 103 */       if (ctx != null)
/* 104 */         pool.free(ctx); 
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi) throws Exception {
/* 112 */     InstancePool pool = this.container.getInstancePool();
/* 113 */     StatelessSessionEnterpriseContext ctx = null;
/*     */     boolean isLocal;
/*     */     try {
/* 116 */       ctx = (StatelessSessionEnterpriseContext)pool.get();
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/* 120 */       throw e;
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 124 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 128 */       InvocationType type = mi.getType();
/* 129 */       isLocal = (type == InvocationType.LOCAL) || (type == InvocationType.LOCALHOME);
/* 130 */       if (isLocal) {
/* 131 */         throw new EJBException("Unable to get an instance from the pool", e);
/*     */       }
/* 133 */       throw new RemoteException("Unable to get an intance from the pool", e);
/*     */     }
/*     */ 
/* 137 */     ctx.setSecurityContext(mi.getSecurityContext());
/*     */ 
/* 139 */     ctx.setPrincipal(mi.getPrincipal());
/*     */ 
/* 141 */     EnterpriseBeanPolicyContextHandler.setEnterpriseBean(ctx.getInstance());
/*     */ 
/* 144 */     mi.setEnterpriseContext(ctx);
/*     */ 
/* 147 */     Object msgContext = mi.getValue(InvocationKey.SOAP_MESSAGE_CONTEXT);
/*     */ 
/* 150 */     if (ejbTimeout.equals(mi.getMethod()))
/*     */     {
/* 152 */       AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_TIMEOUT);
/*     */     }
/* 156 */     else if (msgContext != null)
/*     */     {
/* 158 */       if ((msgContext instanceof MessageContext)) {
/* 159 */         ctx.setMessageContext((MessageContext)msgContext);
/*     */       }
/* 161 */       AllowedOperationsAssociation.pushInMethodFlag(IN_SERVICE_ENDPOINT_METHOD);
/*     */     }
/*     */     else
/*     */     {
/* 167 */       AllowedOperationsAssociation.pushInMethodFlag(IN_BUSINESS_METHOD);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 174 */       Object obj = getNext().invoke(mi);
/* 175 */       isLocal = obj;
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 180 */       mi.setEnterpriseContext(null);
/* 181 */       throw e;
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 185 */       mi.setEnterpriseContext(null);
/* 186 */       throw e;
/*     */     }
/*     */     catch (Error e)
/*     */     {
/* 190 */       mi.setEnterpriseContext(null);
/* 191 */       throw e;
/*     */     }
/*     */     finally
/*     */     {
/* 195 */       AllowedOperationsAssociation.popInMethodFlag();
/* 196 */       EnterpriseBeanPolicyContextHandler.setEnterpriseBean(null);
/*     */ 
/* 199 */       if (mi.getEnterpriseContext() != null)
/*     */       {
/* 201 */         pool.free((EnterpriseContext)mi.getEnterpriseContext());
/*     */       }
/*     */       else
/*     */       {
/* 205 */         pool.discard(ctx);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  67 */       ejbTimeout = TimedObject.class.getMethod("ejbTimeout", new Class[] { Timer.class });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  71 */       throw new ExceptionInInitializerError(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.StatelessSessionInstanceInterceptor
 * JD-Core Version:    0.6.0
 */