/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.Enumeration;
/*     */ import java.util.List;
/*     */ import javax.ejb.FinderException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory.UTIL;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class JDBCCustomFinderQuery
/*     */   implements JDBCQueryCommand
/*     */ {
/*     */   private final Logger log;
/*     */   private final Method finderMethod;
/*     */   private final JDBCReadAheadMetaData readAheadMetaData;
/*     */   private final ReadAheadCache readAheadCache;
/*     */   private final JDBCStoreManager manager;
/*     */ 
/*     */   public JDBCCustomFinderQuery(JDBCStoreManager manager, Method finderMethod)
/*     */   {
/*  66 */     this.finderMethod = finderMethod;
/*  67 */     this.manager = manager;
/*     */ 
/*  69 */     JDBCReadAheadMetaData readAheadMetaData = manager.getMetaData().getReadAhead();
/*  70 */     if ((readAheadMetaData != null) && (readAheadMetaData.isOnLoad()))
/*     */     {
/*  72 */       this.readAheadCache = manager.getReadAheadCache();
/*  73 */       this.readAheadMetaData = readAheadMetaData;
/*     */     }
/*     */     else
/*     */     {
/*  77 */       this.readAheadCache = null;
/*  78 */       this.readAheadMetaData = null;
/*     */     }
/*     */ 
/*  81 */     this.log = Logger.getLogger(getClass().getName() + "." + manager.getMetaData().getName() + "." + finderMethod.getName());
/*     */ 
/*  88 */     if (this.log.isDebugEnabled())
/*  89 */       this.log.debug("Finder: Custom finder " + finderMethod.getName());
/*     */   }
/*     */ 
/*     */   public JDBCStoreManager getSelectManager()
/*     */   {
/*  94 */     return this.manager;
/*     */   }
/*     */ 
/*     */   public Collection execute(Method unused, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory)
/*     */     throws FinderException
/*     */   {
/*     */     Throwable ex;
/*     */     try
/*     */     {
/* 106 */       Object value = this.finderMethod.invoke(ctx.getInstance(), args);
/*     */ 
/* 110 */       if ((value instanceof Enumeration))
/*     */       {
/* 112 */         Enumeration enumeration = (Enumeration)value;
/* 113 */         List result = new ArrayList();
/* 114 */         while (enumeration.hasMoreElements())
/*     */         {
/* 116 */           result.add(enumeration.nextElement());
/*     */         }
/* 118 */         cacheResults(result);
/* 119 */         return GenericEntityObjectFactory.UTIL.getEntityCollection(factory, result);
/*     */       }
/* 121 */       if ((value instanceof Collection))
/*     */       {
/*     */         List result;
/*     */         List result;
/* 124 */         if ((value instanceof List))
/* 125 */           result = (List)value;
/*     */         else
/* 127 */           result = new ArrayList((Collection)value);
/* 128 */         cacheResults(result);
/* 129 */         return GenericEntityObjectFactory.UTIL.getEntityCollection(factory, result);
/*     */       }
/*     */ 
/* 134 */       return Collections.singleton(factory.getEntityEJBObject(value));
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 139 */       this.log.error("Error invoking custom finder " + this.finderMethod.getName(), e);
/* 140 */       throw new FinderException("Unable to access finder implementation: " + this.finderMethod.getName());
/*     */     }
/*     */     catch (IllegalArgumentException e)
/*     */     {
/* 145 */       this.log.error("Error invoking custom finder " + this.finderMethod.getName(), e);
/* 146 */       throw new FinderException("Illegal arguments for finder implementation: " + this.finderMethod.getName());
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/* 152 */       ex = e.getTargetException();
/* 153 */       if ((ex instanceof FinderException))
/*     */       {
/* 155 */         throw ((FinderException)ex);
/*     */       }
/*     */     }
/*     */ 
/* 159 */     throw new FinderException("Errror invoking cutom finder " + this.finderMethod.getName() + ": " + ex);
/*     */   }
/*     */ 
/*     */   private void cacheResults(List listOfPKs)
/*     */   {
/* 170 */     if (this.readAheadCache != null)
/*     */     {
/* 172 */       this.readAheadCache.addFinderResults(listOfPKs, this.readAheadMetaData);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCCustomFinderQuery
 * JD-Core Version:    0.6.0
 */