/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCDeclaredQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
/*     */ 
/*     */ public final class JDBCDeclaredSQLQuery extends JDBCAbstractQueryCommand
/*     */ {
/*     */   private final JDBCDeclaredQueryMetaData metadata;
/*     */ 
/*     */   public JDBCDeclaredSQLQuery(JDBCStoreManager manager, JDBCQueryMetaData q)
/*     */     throws DeploymentException
/*     */   {
/*  59 */     super(manager, q);
/*     */ 
/*  61 */     this.metadata = ((JDBCDeclaredQueryMetaData)q);
/*     */ 
/*  64 */     initSelectObject(manager);
/*     */ 
/*  67 */     JDBCReadAheadMetaData readAhead = this.metadata.getReadAhead();
/*  68 */     JDBCEntityBridge selectEntity = getSelectEntity();
/*  69 */     if ((selectEntity != null) && (readAhead.isOnFind()))
/*     */     {
/*  71 */       setEagerLoadGroup(readAhead.getEagerLoadGroup());
/*     */     }
/*     */ 
/*  75 */     String sql = buildSQL();
/*  76 */     setSQL(parseParameters(sql));
/*     */   }
/*     */ 
/*     */   private void initSelectObject(JDBCStoreManager manager)
/*     */     throws DeploymentException
/*     */   {
/*  87 */     String entityName = this.metadata.getEJBName();
/*     */ 
/*  90 */     if (entityName == null)
/*     */     {
/*  92 */       return;
/*     */     }
/*     */ 
/*  95 */     Catalog catalog = manager.getCatalog();
/*     */ 
/*  97 */     JDBCEntityBridge entity = (JDBCEntityBridge)catalog.getEntityByEJBName(entityName);
/*  98 */     if (entity == null)
/*     */     {
/* 100 */       throw new DeploymentException("Unknown entity: " + entityName);
/*     */     }
/*     */ 
/* 103 */     String fieldName = this.metadata.getFieldName();
/* 104 */     if (fieldName == null)
/*     */     {
/* 106 */       setSelectEntity(entity);
/*     */     }
/*     */     else
/*     */     {
/* 110 */       JDBCCMPFieldBridge field = entity.getCMPFieldByName(fieldName);
/* 111 */       if (field == null)
/*     */       {
/* 113 */         throw new DeploymentException("Unknown cmp field: " + fieldName);
/*     */       }
/* 115 */       setSelectField(field);
/*     */     }
/*     */   }
/*     */ 
/*     */   private String buildSQL()
/*     */   {
/* 125 */     StringBuffer sql = new StringBuffer(300);
/*     */ 
/* 127 */     sql.append("SELECT ");
/* 128 */     if (this.metadata.isSelectDistinct())
/*     */     {
/* 130 */       sql.append("DISTINCT ");
/*     */     }
/*     */ 
/* 133 */     String alias = this.metadata.getAlias();
/* 134 */     String from = this.metadata.getFrom();
/*     */     String table;
/*     */     String selectList;
/* 137 */     if (getSelectField() == null)
/*     */     {
/* 140 */       String table = getSelectEntity().getQualifiedTableName();
/*     */ 
/* 144 */       String tableAlias = getTableAlias(alias, from, getSelectEntity().getTableName());
/* 145 */       String selectList = SQLUtil.getColumnNamesClause(getSelectEntity().getPrimaryKeyFields(), tableAlias, new StringBuffer(35)).toString();
/*     */ 
/* 151 */       if (getEagerLoadGroup() != null)
/*     */       {
/* 153 */         selectList = selectList + SQLUtil.appendColumnNamesClause(getSelectEntity(), getEagerLoadGroup(), tableAlias, new StringBuffer(35));
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 163 */       JDBCCMPFieldBridge selectField = getSelectField();
/* 164 */       JDBCStoreManager manager = (JDBCStoreManager)getSelectField().getManager();
/* 165 */       table = manager.getEntityBridge().getQualifiedTableName();
/* 166 */       selectList = SQLUtil.getColumnNamesClause(selectField, getTableAlias(alias, from, manager.getEntityBridge().getTableName()), new StringBuffer()).toString();
/*     */     }
/*     */ 
/* 169 */     sql.append(selectList);
/* 170 */     String additionalColumns = this.metadata.getAdditionalColumns();
/* 171 */     if (additionalColumns != null)
/*     */     {
/* 173 */       sql.append(additionalColumns);
/*     */     }
/* 175 */     sql.append(" FROM ").append(table);
/* 176 */     if (alias != null)
/*     */     {
/* 178 */       sql.append(' ').append(alias);
/*     */     }
/* 180 */     if (from != null)
/*     */     {
/* 182 */       sql.append(' ').append(from);
/*     */     }
/*     */ 
/* 185 */     String where = this.metadata.getWhere();
/* 186 */     if ((where != null) && (where.trim().length() > 0))
/*     */     {
/* 188 */       sql.append(" WHERE ").append(where);
/*     */     }
/*     */ 
/* 191 */     String order = this.metadata.getOrder();
/* 192 */     if ((order != null) && (order.trim().length() > 0))
/*     */     {
/* 194 */       sql.append(" ORDER BY ").append(order);
/*     */     }
/*     */ 
/* 197 */     String other = this.metadata.getOther();
/* 198 */     if ((other != null) && (other.trim().length() > 0))
/*     */     {
/* 200 */       sql.append(' ').append(other);
/*     */     }
/* 202 */     return sql.toString();
/*     */   }
/*     */ 
/*     */   private static String getTableAlias(String alias, String from, String table)
/*     */   {
/*     */     String tableAlias;
/*     */     String tableAlias;
/* 208 */     if (alias != null)
/*     */     {
/* 210 */       tableAlias = alias;
/*     */     }
/*     */     else
/*     */     {
/*     */       String tableAlias;
/* 212 */       if (from != null)
/*     */       {
/* 214 */         tableAlias = table;
/*     */       }
/*     */       else
/*     */       {
/* 218 */         tableAlias = "";
/*     */       }
/*     */     }
/* 220 */     return tableAlias;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCDeclaredSQLQuery
 * JD-Core Version:    0.6.0
 */