/*    */ package org.jboss.ejb.plugins.cmp.jdbc;
/*    */ 
/*    */ import org.jboss.deployment.DeploymentException;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
/*    */ 
/*    */ public final class JDBCFindAllQuery extends JDBCAbstractQueryCommand
/*    */ {
/*    */   public JDBCFindAllQuery(JDBCStoreManager manager, JDBCQueryMetaData q)
/*    */     throws DeploymentException
/*    */   {
/* 45 */     super(manager, q);
/*    */ 
/* 47 */     JDBCEntityBridge entity = (JDBCEntityBridge)manager.getEntityBridge();
/*    */ 
/* 50 */     JDBCReadAheadMetaData readAhead = q.getReadAhead();
/* 51 */     if (readAhead.isOnFind())
/*    */     {
/* 53 */       setEagerLoadGroup(readAhead.getEagerLoadGroup());
/*    */     }
/*    */ 
/* 57 */     StringBuffer sql = new StringBuffer(300);
/* 58 */     sql.append("SELECT ");
/*    */ 
/* 60 */     SQLUtil.getColumnNamesClause(entity.getPrimaryKeyFields(), sql);
/* 61 */     if (getEagerLoadGroup() != null)
/*    */     {
/* 63 */       SQLUtil.appendColumnNamesClause(entity, getEagerLoadGroup(), sql);
/*    */     }
/* 65 */     sql.append(" FROM ").append(entity.getQualifiedTableName());
/*    */ 
/* 67 */     setSQL(sql.toString());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCFindAllQuery
 * JD-Core Version:    0.6.0
 */