/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class JDBCIdentityColumnCreateCommand extends JDBCAbstractCreateCommand
/*     */ {
/*     */   protected JDBCCMPFieldBridge pkField;
/*     */   protected String pkSQL;
/*     */ 
/*     */   protected boolean isInsertField(JDBCFieldBridge field)
/*     */   {
/*  53 */     return (super.isInsertField(field)) && (!field.isPrimaryKeyMember());
/*     */   }
/*     */ 
/*     */   protected void initGeneratedFields() throws DeploymentException
/*     */   {
/*  58 */     super.initGeneratedFields();
/*  59 */     this.pkField = getGeneratedPKField();
/*     */   }
/*     */ 
/*     */   protected int executeInsert(int paramIndex, PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException
/*     */   {
/*  64 */     int rows = ps.executeUpdate();
/*     */ 
/*  66 */     Statement s = null;
/*  67 */     ResultSet rs = null;
/*     */     try {
/*  69 */       Connection c = ps.getConnection();
/*  70 */       s = c.createStatement();
/*  71 */       rs = s.executeQuery(this.pkSQL);
/*  72 */       if (!rs.next()) {
/*  73 */         throw new EJBException("ResultSet was empty");
/*     */       }
/*  75 */       this.pkField.loadInstanceResults(rs, 1, ctx);
/*     */     } catch (RuntimeException e) {
/*  77 */       throw e;
/*     */     }
/*     */     catch (Exception e) {
/*  80 */       throw new EJBException("Error extracting generated key", e);
/*     */     } finally {
/*  82 */       JDBCUtil.safeClose(rs);
/*  83 */       JDBCUtil.safeClose(s);
/*     */     }
/*  85 */     return rows;
/*     */   }
/*     */ 
/*     */   protected SQLException processException(Throwable t)
/*     */   {
/*  94 */     if ((t instanceof InvocationTargetException)) {
/*  95 */       t = ((InvocationTargetException)t).getTargetException();
/*     */     }
/*  97 */     if ((t instanceof SQLException)) {
/*  98 */       return (SQLException)t;
/*     */     }
/* 100 */     if ((t instanceof RuntimeException)) {
/* 101 */       throw ((RuntimeException)t);
/*     */     }
/* 103 */     if ((t instanceof Error)) {
/* 104 */       throw ((Error)t);
/*     */     }
/* 106 */     this.log.error(t);
/* 107 */     throw new IllegalStateException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand
 * JD-Core Version:    0.6.0
 */