/*    */ package org.jboss.ejb.plugins.cmp.jdbc;
/*    */ 
/*    */ import java.sql.Connection;
/*    */ import java.sql.PreparedStatement;
/*    */ import java.sql.ResultSet;
/*    */ import java.sql.SQLException;
/*    */ import javax.ejb.CreateException;
/*    */ import javax.ejb.DuplicateKeyException;
/*    */ import javax.sql.DataSource;
/*    */ import org.jboss.deployment.DeploymentException;
/*    */ import org.jboss.ejb.EntityEnterpriseContext;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public abstract class JDBCInsertPKCreateCommand extends JDBCAbstractCreateCommand
/*    */ {
/*    */   protected String existsSQL;
/*    */ 
/*    */   public void init(JDBCStoreManager manager)
/*    */     throws DeploymentException
/*    */   {
/* 47 */     super.init(manager);
/*    */ 
/* 51 */     if (this.exceptionProcessor == null)
/*    */     {
/* 53 */       initExistsSQL();
/*    */     }
/*    */   }
/*    */ 
/*    */   protected void initExistsSQL()
/*    */   {
/* 59 */     StringBuffer sql = new StringBuffer(300);
/* 60 */     sql.append("SELECT ").append("COUNT(*)").append(" FROM ").append(this.entity.getQualifiedTableName()).append(" WHERE ");
/*    */ 
/* 63 */     SQLUtil.getWhereClause(this.entity.getPrimaryKeyFields(), sql);
/* 64 */     this.existsSQL = sql.toString();
/* 65 */     if (this.debug)
/*    */     {
/* 67 */       this.log.debug("Entity Exists SQL: " + this.existsSQL);
/*    */     }
/*    */   }
/*    */ 
/*    */   protected void beforeInsert(EntityEnterpriseContext ctx)
/*    */     throws CreateException
/*    */   {
/* 74 */     if (this.existsSQL != null)
/*    */     {
/* 76 */       Connection c = null;
/* 77 */       PreparedStatement ps = null;
/* 78 */       ResultSet rs = null;
/*    */       try
/*    */       {
/* 81 */         if (this.debug) {
/* 82 */           this.log.debug("Executing SQL: " + this.existsSQL);
/*    */         }
/* 84 */         c = this.entity.getDataSource().getConnection();
/* 85 */         ps = c.prepareStatement(this.existsSQL);
/*    */ 
/* 89 */         Object pk = this.entity.extractPrimaryKeyFromInstance(ctx);
/* 90 */         this.entity.setPrimaryKeyParameters(ps, 1, pk);
/*    */ 
/* 92 */         rs = ps.executeQuery();
/* 93 */         if (!rs.next())
/*    */         {
/* 95 */           throw new CreateException("Error checking if entity with primary pk " + pk + "exists: SQL returned no rows");
/*    */         }
/* 97 */         if (rs.getInt(1) > 0)
/*    */         {
/* 99 */           throw new DuplicateKeyException("Entity with primary key " + pk + " already exists");
/*    */         }
/*    */       }
/*    */       catch (SQLException e)
/*    */       {
/* 104 */         this.log.error("Error checking if entity exists", e);
/* 105 */         throw new CreateException("Error checking if entity exists:" + e);
/*    */       }
/*    */       finally
/*    */       {
/* 109 */         JDBCUtil.safeClose(rs);
/* 110 */         JDBCUtil.safeClose(ps);
/* 111 */         JDBCUtil.safeClose(c);
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCInsertPKCreateCommand
 * JD-Core Version:    0.6.0
 */