/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCJBossQLQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class JDBCJBossQLQuery extends JDBCAbstractQueryCommand
/*     */ {
/*     */   public JDBCJBossQLQuery(JDBCStoreManager manager, JDBCQueryMetaData q)
/*     */     throws DeploymentException
/*     */   {
/*  45 */     super(manager, q);
/*     */ 
/*  47 */     JDBCJBossQLQueryMetaData metadata = (JDBCJBossQLQueryMetaData)q;
/*  48 */     if (getLog().isDebugEnabled())
/*     */     {
/*  50 */       getLog().debug("JBossQL: " + metadata.getJBossQL());
/*     */     }
/*     */ 
/*  53 */     QLCompiler compiler = JDBCQueryManager.getInstance(metadata.getQLCompilerClass(), manager.getCatalog());
/*     */     try
/*     */     {
/*  57 */       compiler.compileJBossQL(metadata.getJBossQL(), metadata.getMethod().getReturnType(), metadata.getMethod().getParameterTypes(), metadata);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  65 */       t.printStackTrace();
/*  66 */       throw new DeploymentException("Error compiling JBossQL statement '" + metadata.getJBossQL() + "'", t);
/*     */     }
/*     */ 
/*  70 */     setSQL(compiler.getSQL());
/*  71 */     setOffsetParam(compiler.getOffsetParam());
/*  72 */     setOffsetValue(compiler.getOffsetValue());
/*  73 */     setLimitParam(compiler.getLimitParam());
/*  74 */     setLimitValue(compiler.getLimitValue());
/*     */ 
/*  77 */     if (compiler.isSelectEntity())
/*     */     {
/*  79 */       JDBCEntityBridge selectEntity = (JDBCEntityBridge)compiler.getSelectEntity();
/*     */ 
/*  82 */       setSelectEntity(selectEntity);
/*     */ 
/*  85 */       JDBCReadAheadMetaData readahead = metadata.getReadAhead();
/*  86 */       if (readahead.isOnFind())
/*     */       {
/*  88 */         setEagerLoadGroup(readahead.getEagerLoadGroup());
/*  89 */         setOnFindCMRList(compiler.getLeftJoinCMRList());
/*     */ 
/*  92 */         if (compiler.isSelectDistinct())
/*     */         {
/*  94 */           boolean[] mask = getEagerLoadMask();
/*  95 */           JDBCCMPFieldBridge[] tableFields = (JDBCCMPFieldBridge[])(JDBCCMPFieldBridge[])selectEntity.getTableFields();
/*  96 */           for (int i = 0; i < tableFields.length; i++)
/*     */           {
/*  98 */             if ((mask[i] == 0) || (tableFields[i].getJDBCType().isSearchable()))
/*     */               continue;
/* 100 */             mask[i] = false;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/* 106 */     else if (compiler.isSelectField())
/*     */     {
/* 108 */       setSelectField((JDBCCMPFieldBridge)compiler.getSelectField());
/*     */     }
/*     */     else
/*     */     {
/* 112 */       setSelectFunction(compiler.getSelectFunction(), (JDBCStoreManager)compiler.getStoreManager());
/*     */     }
/*     */ 
/* 116 */     setParameterList(compiler.getInputParameters());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCJBossQLQuery
 * JD-Core Version:    0.6.0
 */