/*      */ package org.jboss.ejb.plugins.cmp.jdbc;
/*      */ 
/*      */ import java.sql.Connection;
/*      */ import java.sql.Statement;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Set;
/*      */ import javax.sql.DataSource;
/*      */ import javax.transaction.Transaction;
/*      */ import javax.transaction.TransactionManager;
/*      */ import org.jboss.deployment.DeploymentException;
/*      */ import org.jboss.ejb.EntityContainer;
/*      */ import org.jboss.ejb.plugins.cmp.bridge.EntityBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
/*      */ import org.jboss.logging.Logger;
/*      */ 
/*      */ public final class JDBCStartCommand
/*      */ {
/*      */   private static final String IDX_POSTFIX = "_idx";
/*      */   private static final String COULDNT_SUSPEND = "Could not suspend current transaction before ";
/*      */   private static final String COULDNT_REATTACH = "Could not reattach original transaction after ";
/*   67 */   private static final Object CREATED_TABLES_KEY = new Object();
/*      */   private final JDBCEntityPersistenceStore manager;
/*      */   private final JDBCAbstractEntityBridge entity;
/*      */   private final JDBCEntityMetaData entityMetaData;
/*      */   private final Logger log;
/*   72 */   private int idxCount = 0;
/*      */ 
/*      */   public JDBCStartCommand(JDBCEntityPersistenceStore manager)
/*      */   {
/*   76 */     this.manager = manager;
/*   77 */     this.entity = manager.getEntityBridge();
/*   78 */     this.entityMetaData = manager.getMetaData();
/*      */ 
/*   81 */     this.log = Logger.getLogger(getClass().getName() + "." + manager.getMetaData().getName());
/*      */ 
/*   86 */     this.idxCount = 1;
/*      */ 
/*   89 */     Set tables = (Set)manager.getApplicationData(CREATED_TABLES_KEY);
/*   90 */     if (tables == null)
/*      */     {
/*   92 */       manager.putApplicationData(CREATED_TABLES_KEY, new HashSet());
/*      */     }
/*      */   }
/*      */ 
/*      */   public void execute() throws DeploymentException
/*      */   {
/*   98 */     Set existedTables = getExistedTables(this.manager);
/*      */ 
/*  100 */     boolean tableExisted = SQLUtil.tableExists(this.entity.getQualifiedTableName(), this.entity.getDataSource());
/*  101 */     if (tableExisted)
/*      */     {
/*  103 */       existedTables.add(this.entity.getEntityName());
/*      */     }
/*      */ 
/*  106 */     if (tableExisted)
/*      */     {
/*  108 */       if (this.entityMetaData.getAlterTable())
/*      */       {
/*  110 */         SQLUtil.OldColumns oldColumns = SQLUtil.getOldColumns(this.entity.getQualifiedTableName(), this.entity.getDataSource());
/*  111 */         ArrayList oldNames = oldColumns.getColumnNames();
/*  112 */         ArrayList oldTypes = oldColumns.getTypeNames();
/*  113 */         ArrayList oldSizes = oldColumns.getColumnSizes();
/*  114 */         SQLUtil.OldIndexes oldIndexes = null;
/*  115 */         ArrayList newNames = new ArrayList();
/*  116 */         JDBCFieldBridge[] fields = this.entity.getTableFields();
/*  117 */         String tableName = this.entity.getQualifiedTableName();
/*  118 */         for (int i = 0; i < fields.length; i++)
/*      */         {
/*  120 */           JDBCFieldBridge field = fields[i];
/*  121 */           JDBCType jdbcType = field.getJDBCType();
/*  122 */           String[] columnNames = jdbcType.getColumnNames();
/*  123 */           String[] sqlTypes = jdbcType.getSQLTypes();
/*  124 */           boolean[] notNull = jdbcType.getNotNull();
/*      */ 
/*  126 */           for (int j = 0; j < columnNames.length; j++)
/*      */           {
/*  128 */             String name = columnNames[j];
/*  129 */             String ucName = name.toUpperCase();
/*      */ 
/*  131 */             newNames.add(ucName);
/*      */ 
/*  133 */             int oldIndex = oldNames.indexOf(ucName);
/*  134 */             if (oldIndex == -1)
/*      */             {
/*  137 */               StringBuffer buf = new StringBuffer(sqlTypes[j]);
/*  138 */               if (notNull[j] != 0)
/*      */               {
/*  140 */                 buf.append(" NOT ").append("NULL");
/*      */               }
/*  142 */               alterTable(this.entity.getDataSource(), this.entityMetaData.getTypeMapping().getAddColumnTemplate(), tableName, name, buf.toString());
/*      */             }
/*      */             else
/*      */             {
/*  150 */               String type = (String)oldTypes.get(oldIndex);
/*  151 */               if ((!type.equals("CHAR")) && (!type.equals("VARCHAR"))) {
/*      */                 continue;
/*      */               }
/*      */               try
/*      */               {
/*  156 */                 String l = sqlTypes[j];
/*  157 */                 l = l.substring(l.indexOf('(') + 1, l.length() - 1);
/*  158 */                 Integer oldLength = (Integer)oldSizes.get(oldIndex);
/*  159 */                 if (Integer.parseInt(l) > oldLength.intValue())
/*      */                 {
/*  161 */                   alterTable(this.entity.getDataSource(), this.entityMetaData.getTypeMapping().getAlterColumnTemplate(), tableName, name, sqlTypes[j]);
/*      */                 }
/*      */ 
/*      */               }
/*      */               catch (Exception e)
/*      */               {
/*  168 */                 this.log.warn("EXCEPTION ALTER :" + e.toString());
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*  175 */           JDBCCMPFieldMetaData fieldMD = this.entity.getMetaData().getCMPFieldByName(field.getFieldName());
/*  176 */           if ((fieldMD == null) || (!fieldMD.isIndexed()))
/*      */             continue;
/*  178 */           if (oldIndexes == null)
/*      */           {
/*  180 */             oldIndexes = SQLUtil.getOldIndexes(this.entity.getQualifiedTableName(), this.entity.getDataSource());
/*  181 */             this.idxCount = oldIndexes.getIndexNames().size();
/*      */           }
/*  183 */           if (hasIndex(oldIndexes, field))
/*      */             continue;
/*  185 */           createCMPIndex(this.entity.getDataSource(), field, oldIndexes.getIndexNames());
/*      */         }
/*      */ 
/*  192 */         Iterator it = oldNames.iterator();
/*  193 */         while (it.hasNext())
/*      */         {
/*  195 */           String name = (String)(String)it.next();
/*  196 */           if (!newNames.contains(name))
/*      */           {
/*  198 */             alterTable(this.entity.getDataSource(), this.entityMetaData.getTypeMapping().getDropColumnTemplate(), tableName, name, "");
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  208 */     Set createdTables = getCreatedTables(this.manager);
/*      */ 
/*  210 */     if ((this.entityMetaData.getCreateTable()) && (!createdTables.contains(this.entity.getEntityName())))
/*      */     {
/*  212 */       DataSource dataSource = this.entity.getDataSource();
/*  213 */       createTable(dataSource, this.entity.getQualifiedTableName(), getEntityCreateTableSQL(dataSource));
/*      */ 
/*  216 */       if (!tableExisted)
/*      */       {
/*  218 */         createCMPIndices(dataSource, SQLUtil.getOldIndexes(this.entity.getQualifiedTableName(), this.entity.getDataSource()).getIndexNames());
/*      */       }
/*  224 */       else if (this.log.isDebugEnabled())
/*      */       {
/*  226 */         this.log.debug("Indices for table " + this.entity.getQualifiedTableName() + "not created as table existed");
/*      */       }
/*      */ 
/*  232 */       if (!tableExisted)
/*      */       {
/*  234 */         issuePostCreateSQL(dataSource, this.entity.getMetaData().getDefaultTablePostCreateCmd(), this.entity.getQualifiedTableName());
/*      */       }
/*      */ 
/*  239 */       createdTables.add(this.entity.getEntityName());
/*      */     }
/*      */     else
/*      */     {
/*  243 */       this.log.debug("Table not create as requested: " + this.entity.getQualifiedTableName());
/*      */     }
/*      */ 
/*  247 */     JDBCAbstractCMRFieldBridge[] cmrFields = this.entity.getCMRFields();
/*  248 */     for (int i = 0; i < cmrFields.length; i++)
/*      */     {
/*  250 */       JDBCAbstractCMRFieldBridge cmrField = cmrFields[i];
/*  251 */       JDBCRelationMetaData relationMetaData = cmrField.getMetaData().getRelationMetaData();
/*      */ 
/*  254 */       EntityBridge relatedEntity = cmrField.getRelatedEntity();
/*  255 */       if ((!relationMetaData.isTableMappingStyle()) || (!createdTables.contains(relatedEntity.getEntityName())))
/*      */         continue;
/*  257 */       DataSource dataSource = relationMetaData.getDataSource();
/*      */ 
/*  259 */       boolean relTableExisted = SQLUtil.tableExists(cmrField.getQualifiedTableName(), this.entity.getDataSource());
/*      */ 
/*  261 */       if (relTableExisted)
/*      */       {
/*  263 */         if (relationMetaData.getAlterTable())
/*      */         {
/*  265 */           ArrayList oldNames = SQLUtil.getOldColumns(cmrField.getQualifiedTableName(), dataSource).getColumnNames();
/*  266 */           ArrayList newNames = new ArrayList();
/*  267 */           JDBCFieldBridge[] leftKeys = cmrField.getTableKeyFields();
/*  268 */           JDBCFieldBridge[] rightKeys = cmrField.getRelatedCMRField().getTableKeyFields();
/*  269 */           JDBCFieldBridge[] fields = new JDBCFieldBridge[leftKeys.length + rightKeys.length];
/*  270 */           System.arraycopy(leftKeys, 0, fields, 0, leftKeys.length);
/*  271 */           System.arraycopy(rightKeys, 0, fields, leftKeys.length, rightKeys.length);
/*      */ 
/*  274 */           boolean different = false;
/*  275 */           for (int j = 0; j < fields.length; j++)
/*      */           {
/*  277 */             JDBCFieldBridge field = fields[j];
/*      */ 
/*  279 */             String name = field.getJDBCType().getColumnNames()[0].toUpperCase();
/*  280 */             newNames.add(name);
/*      */ 
/*  282 */             if (oldNames.contains(name))
/*      */               continue;
/*  284 */             different = true;
/*  285 */             break;
/*      */           }
/*      */ 
/*  289 */           if (!different)
/*      */           {
/*  291 */             Iterator it = oldNames.iterator();
/*  292 */             while (it.hasNext())
/*      */             {
/*  294 */               String name = (String)(String)it.next();
/*  295 */               if (!newNames.contains(name))
/*      */               {
/*  297 */                 different = true;
/*  298 */                 break;
/*      */               }
/*      */             }
/*      */           }
/*      */ 
/*  303 */           if (different)
/*      */           {
/*  306 */             this.log.error("CMR table structure is incorrect for " + cmrField.getQualifiedTableName());
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  315 */       if ((!relationMetaData.isTableMappingStyle()) || (relationMetaData.isTableCreated()))
/*      */         continue;
/*  317 */       if (relationMetaData.getCreateTable())
/*      */       {
/*  319 */         createTable(dataSource, cmrField.getQualifiedTableName(), getRelationCreateTableSQL(cmrField, dataSource));
/*      */       }
/*      */       else
/*      */       {
/*  324 */         this.log.debug("Relation table not created as requested: " + cmrField.getQualifiedTableName());
/*      */       }
/*      */ 
/*  327 */       createCMRIndex(dataSource, cmrField);
/*      */ 
/*  329 */       if (!relationMetaData.getCreateTable())
/*      */         continue;
/*  331 */       issuePostCreateSQL(dataSource, relationMetaData.getDefaultTablePostCreateCmd(), cmrField.getQualifiedTableName());
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addForeignKeyConstraints()
/*      */     throws DeploymentException
/*      */   {
/*  343 */     Set createdTables = getCreatedTables(this.manager);
/*      */ 
/*  345 */     JDBCAbstractCMRFieldBridge[] cmrFields = this.entity.getCMRFields();
/*  346 */     for (int i = 0; i < cmrFields.length; i++)
/*      */     {
/*  348 */       JDBCAbstractCMRFieldBridge cmrField = cmrFields[i];
/*  349 */       JDBCRelationMetaData relationMetaData = cmrField.getMetaData().getRelationMetaData();
/*      */ 
/*  352 */       EntityBridge relatedEntity = cmrField.getRelatedEntity();
/*      */ 
/*  357 */       if ((relationMetaData.isForeignKeyMappingStyle()) && (createdTables.contains(relatedEntity.getEntityName())))
/*      */       {
/*  359 */         createCMRIndex(((JDBCAbstractEntityBridge)relatedEntity).getDataSource(), cmrField);
/*      */       }
/*      */ 
/*  363 */       addForeignKeyConstraint(cmrField);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static Set getCreatedTables(JDBCEntityPersistenceStore manager)
/*      */   {
/*  369 */     String key = "CREATED_TABLES";
/*  370 */     Set createdTables = (Set)manager.getApplicationData("CREATED_TABLES");
/*  371 */     if (createdTables == null)
/*      */     {
/*  373 */       createdTables = new HashSet();
/*  374 */       manager.putApplicationData("CREATED_TABLES", createdTables);
/*      */     }
/*  376 */     return createdTables;
/*      */   }
/*      */ 
/*      */   public static Set getExistedTables(JDBCEntityPersistenceStore manager)
/*      */   {
/*  381 */     String key = "EXISTED_TABLES";
/*  382 */     Set existedTables = (Set)manager.getApplicationData("EXISTED_TABLES");
/*  383 */     if (existedTables == null)
/*      */     {
/*  385 */       existedTables = new HashSet();
/*  386 */       manager.putApplicationData("EXISTED_TABLES", existedTables);
/*      */     }
/*  388 */     return existedTables;
/*      */   }
/*      */ 
/*      */   private boolean hasIndex(SQLUtil.OldIndexes oldIndexes, JDBCFieldBridge field)
/*      */   {
/*  400 */     JDBCType jdbcType = field.getJDBCType();
/*  401 */     String[] columns = jdbcType.getColumnNames();
/*  402 */     ArrayList idxNames = oldIndexes.getIndexNames();
/*  403 */     ArrayList idxColumns = oldIndexes.getColumnNames();
/*      */ 
/*  406 */     String indexName = null;
/*  407 */     for (int i = 0; i < columns.length; i++)
/*      */     {
/*  409 */       String column = columns[i];
/*  410 */       int index = columnIndex(idxColumns, column);
/*  411 */       if (index == -1)
/*      */       {
/*  413 */         return false;
/*      */       }
/*      */ 
/*  416 */       if (indexName == null)
/*      */       {
/*  418 */         indexName = (String)idxNames.get(index);
/*      */       }
/*  420 */       else if (!indexName.equals(idxNames.get(index)))
/*      */       {
/*  422 */         return false;
/*      */       }
/*      */     }
/*      */ 
/*  426 */     return true;
/*      */   }
/*      */ 
/*      */   private int columnIndex(ArrayList idxColumns, String column)
/*      */   {
/*  483 */     for (int j = 0; j < idxColumns.size(); j++)
/*      */     {
/*  485 */       String idxColumn = (String)idxColumns.get(j);
/*  486 */       idxColumn = idxColumn.trim();
/*      */ 
/*  488 */       while ((idxColumn.charAt(0) == '"') && (idxColumn.charAt(idxColumn.charAt(idxColumn.length() - 1)) == '"'))
/*      */       {
/*  490 */         idxColumn = idxColumn.substring(1, idxColumn.length() - 1);
/*      */       }
/*      */ 
/*  493 */       if (idxColumn.equalsIgnoreCase(column))
/*      */       {
/*  495 */         return j;
/*      */       }
/*      */     }
/*  498 */     return -1;
/*      */   }
/*      */   private void alterTable(DataSource dataSource, JDBCFunctionMappingMetaData mapping, String tableName, String fieldName, String fieldStructure) throws DeploymentException {
/*  504 */     StringBuffer sqlBuf = new StringBuffer();
/*  505 */     mapping.getFunctionSql(new String[] { tableName, fieldName, fieldStructure }, sqlBuf);
/*  506 */     String sql = sqlBuf.toString();
/*      */ 
/*  508 */     this.log.warn(sql);
/*      */ 
/*  511 */     TransactionManager tm = this.manager.getContainer().getTransactionManager();
/*      */     Transaction oldTransaction;
/*      */     try { oldTransaction = tm.suspend();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  519 */       throw new DeploymentException("Could not suspend current transaction before  alter table.", e);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  524 */       Connection con = null;
/*  525 */       Statement statement = null;
/*      */       try
/*      */       {
/*  528 */         con = dataSource.getConnection();
/*  529 */         statement = con.createStatement();
/*  530 */         statement.executeUpdate(sql);
/*      */       }
/*      */       finally
/*      */       {
/*  536 */         JDBCUtil.safeClose(statement);
/*  537 */         JDBCUtil.safeClose(con);
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  542 */       this.log.error("Could not alter table " + tableName + ": " + e.getMessage());
/*  543 */       throw new DeploymentException("Error while alter table " + tableName + " " + sql, e);
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  550 */         if (oldTransaction != null)
/*      */         {
/*  552 */           tm.resume(oldTransaction);
/*      */         }
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  557 */         throw new DeploymentException("Could not reattach original transaction after alter table");
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  562 */     if (this.log.isDebugEnabled())
/*  563 */       this.log.debug("Table altered successfully.");
/*      */   }
/*      */ 
/*      */   private void createTable(DataSource dataSource, String tableName, String sql)
/*      */     throws DeploymentException
/*      */   {
/*  570 */     if (SQLUtil.tableExists(tableName, dataSource))
/*      */     {
/*  572 */       this.log.debug("Table '" + tableName + "' already exists");
/*  573 */       return;
/*      */     }
/*      */ 
/*  579 */     TransactionManager tm = this.manager.getContainer().getTransactionManager();
/*      */     Transaction oldTransaction;
/*      */     try
/*      */     {
/*  583 */       oldTransaction = tm.suspend();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  587 */       throw new DeploymentException("Could not suspend current transaction before creating table.", e);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  592 */       Connection con = null;
/*  593 */       Statement statement = null;
/*      */       try
/*      */       {
/*  597 */         if (this.log.isDebugEnabled())
/*      */         {
/*  599 */           this.log.debug("Executing SQL: " + sql);
/*      */         }
/*      */ 
/*  602 */         con = dataSource.getConnection();
/*  603 */         statement = con.createStatement();
/*  604 */         statement.executeUpdate(sql);
/*      */       }
/*      */       finally
/*      */       {
/*  610 */         JDBCUtil.safeClose(statement);
/*  611 */         JDBCUtil.safeClose(con);
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  616 */       this.log.debug("Could not create table " + tableName);
/*  617 */       throw new DeploymentException("Error while creating table " + tableName, e);
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  624 */         if (oldTransaction != null)
/*      */         {
/*  626 */           tm.resume(oldTransaction);
/*      */         }
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  631 */         throw new DeploymentException("Could not reattach original transaction after create table");
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  636 */     Set createdTables = (Set)this.manager.getApplicationData(CREATED_TABLES_KEY);
/*  637 */     createdTables.add(tableName);
/*      */   }
/*      */ 
/*      */   private void createIndex(DataSource dataSource, String tableName, String indexName, String sql) throws DeploymentException
/*      */   {
/*  655 */     TransactionManager tm = this.manager.getContainer().getTransactionManager();
/*      */     Transaction oldTransaction;
/*      */     try {
/*  659 */       oldTransaction = tm.suspend();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  663 */       throw new DeploymentException("Could not suspend current transaction before creating index.", e);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  668 */       Connection con = null;
/*  669 */       Statement statement = null;
/*      */       try
/*      */       {
/*  673 */         if (this.log.isDebugEnabled())
/*      */         {
/*  675 */           this.log.debug("Executing SQL: " + sql);
/*      */         }
/*  677 */         con = dataSource.getConnection();
/*  678 */         statement = con.createStatement();
/*  679 */         statement.executeUpdate(sql);
/*      */       }
/*      */       finally
/*      */       {
/*  685 */         JDBCUtil.safeClose(statement);
/*  686 */         JDBCUtil.safeClose(con);
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  691 */       this.log.debug("Could not create index " + indexName + "on table" + tableName);
/*  692 */       throw new DeploymentException("Error while creating table", e);
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  699 */         if (oldTransaction != null)
/*      */         {
/*  701 */           tm.resume(oldTransaction);
/*      */         }
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  706 */         throw new DeploymentException("Could not reattach original transaction after create index");
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void issuePostCreateSQL(DataSource dataSource, List sql, String table)
/*      */     throws DeploymentException
/*      */   {
/*  722 */     if (sql == null)
/*      */     {
/*  724 */       this.log.trace("issuePostCreateSQL: sql is null");
/*  725 */       return;
/*  728 */     }
/*      */ this.log.debug("issuePostCreateSQL::sql: " + sql.toString() + " on table " + table);
/*      */ 
/*  730 */     TransactionManager tm = this.manager.getContainer().getTransactionManager();
/*      */     Transaction oldTransaction;
/*      */     try {
/*  735 */       oldTransaction = tm.suspend();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  739 */       throw new DeploymentException("Could not suspend current transaction before sending sql command.", e);
/*      */     }
/*      */ 
/*  742 */     String currentCmd = "";
/*      */     try
/*      */     {
/*  746 */       Connection con = null;
/*  747 */       Statement statement = null;
/*      */       try
/*      */       {
/*  750 */         con = dataSource.getConnection();
/*  751 */         statement = con.createStatement();
/*      */ 
/*  754 */         for (int i = 0; i < sql.size(); i++)
/*      */         {
/*  756 */           currentCmd = (String)sql.get(i);
/*      */ 
/*  760 */           currentCmd = replaceTable(currentCmd, table);
/*  761 */           currentCmd = replaceIndexCounter(currentCmd);
/*  762 */           this.log.debug("Executing SQL: " + currentCmd);
/*  763 */           statement.executeUpdate(currentCmd);
/*      */         }
/*      */ 
/*      */       }
/*      */       finally
/*      */       {
/*  770 */         JDBCUtil.safeClose(statement);
/*  771 */         JDBCUtil.safeClose(con);
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  776 */       this.log.warn("Issuing sql " + currentCmd + " failed: " + e.toString());
/*  777 */       throw new DeploymentException("Error while issuing sql in post-table-create", e);
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/*  784 */         if (oldTransaction != null)
/*      */         {
/*  786 */           tm.resume(oldTransaction);
/*      */         }
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  791 */         throw new DeploymentException("Could not reattach original transaction after create index");
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  796 */     this.log.debug("Issued SQL  " + sql + " successfully.");
/*      */   }
/*      */ 
/*      */   private String getEntityCreateTableSQL(DataSource dataSource)
/*      */     throws DeploymentException
/*      */   {
/*  802 */     StringBuffer sql = new StringBuffer();
/*  803 */     sql.append("CREATE TABLE ").append(this.entity.getQualifiedTableName()).append(" (");
/*      */ 
/*  806 */     boolean comma = false;
/*  807 */     JDBCFieldBridge[] fields = this.entity.getTableFields();
/*  808 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  810 */       JDBCFieldBridge field = fields[i];
/*  811 */       JDBCType type = field.getJDBCType();
/*  812 */       if (comma)
/*      */       {
/*  814 */         sql.append(", ");
/*      */       }
/*      */       else
/*      */       {
/*  818 */         comma = true;
/*      */       }
/*  820 */       addField(type, sql);
/*      */     }
/*      */ 
/*  824 */     if (this.entityMetaData.hasPrimaryKeyConstraint())
/*      */     {
/*  826 */       JDBCFunctionMappingMetaData pkConstraint = this.manager.getMetaData().getTypeMapping().getPkConstraintTemplate();
/*  827 */       if (pkConstraint == null)
/*      */       {
/*  829 */         throw new IllegalStateException("Primary key constraint is not allowed for this type of data source");
/*      */       }
/*      */ 
/*  833 */       String defTableName = this.entity.getManager().getMetaData().getDefaultTableName();
/*  834 */       String name = "pk_" + SQLUtil.unquote(defTableName, dataSource);
/*  835 */       name = SQLUtil.fixConstraintName(name, dataSource);
/*  836 */       String[] args = { name, SQLUtil.getColumnNamesClause(this.entity.getPrimaryKeyFields(), new StringBuffer(100)).toString() };
/*      */ 
/*  840 */       sql.append(", ");
/*  841 */       pkConstraint.getFunctionSql(args, sql);
/*      */     }
/*      */ 
/*  844 */     return ')';
/*      */   }
/*      */ 
/*      */   private void createCMPIndices(DataSource dataSource, ArrayList indexNames)
/*      */     throws DeploymentException
/*      */   {
/*  858 */     JDBCFieldBridge[] cmpFields = this.entity.getTableFields();
/*  859 */     for (int i = 0; i < cmpFields.length; i++)
/*      */     {
/*  861 */       JDBCFieldBridge field = cmpFields[i];
/*  862 */       JDBCCMPFieldMetaData fieldMD = this.entity.getMetaData().getCMPFieldByName(field.getFieldName());
/*      */ 
/*  864 */       if ((fieldMD == null) || (!fieldMD.isIndexed()))
/*      */         continue;
/*  866 */       createCMPIndex(dataSource, field, indexNames);
/*      */     }
/*      */ 
/*  870 */     JDBCAbstractCMRFieldBridge[] cmrFields = this.entity.getCMRFields();
/*  871 */     if (cmrFields != null)
/*      */     {
/*  873 */       for (int i = 0; i < cmrFields.length; i++)
/*      */       {
/*  875 */         JDBCAbstractCMRFieldBridge cmrField = cmrFields[i];
/*  876 */         if (!cmrField.getRelatedCMRField().getMetaData().isIndexed())
/*      */           continue;
/*  878 */         JDBCFieldBridge[] fkFields = cmrField.getForeignKeyFields();
/*  879 */         if (fkFields == null)
/*      */           continue;
/*  881 */         for (int fkInd = 0; fkInd < fkFields.length; fkInd++)
/*      */         {
/*  883 */           createCMPIndex(dataSource, fkFields[fkInd], indexNames);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void createCMPIndex(DataSource dataSource, JDBCFieldBridge field, ArrayList indexNames) throws DeploymentException {
/*  902 */     this.log.debug("Creating index for field " + field.getFieldName());
/*  903 */     StringBuffer sql = new StringBuffer();
/*  904 */     sql.append("CREATE INDEX ");
/*      */     String indexName;
/*      */     boolean indexExists;
/*      */     do {
/*  909 */       indexName = this.entity.getQualifiedTableName() + "_idx" + this.idxCount;
/*  910 */       this.idxCount += 1;
/*  911 */       indexExists = false;
/*  912 */       if (indexNames == null)
/*      */         continue;
/*  914 */       for (int i = 0; (i < indexNames.size()) && (!indexExists); i++)
/*      */       {
/*  916 */         indexExists = indexName.equalsIgnoreCase((String)indexNames.get(i));
/*      */       }
/*      */     }
/*      */ 
/*  920 */     while (indexExists);
/*      */ 
/*  922 */     sql.append(indexName);
/*  923 */     sql.append(" ON ");
/*  924 */     sql.append(this.entity.getQualifiedTableName() + " (");
/*  925 */     SQLUtil.getColumnNamesClause(field, sql);
/*  926 */     sql.append(")");
/*      */ 
/*  928 */     createIndex(dataSource, this.entity.getQualifiedTableName(), indexName, sql.toString());
/*      */   }
/*      */ 
/*      */   private void createCMRIndex(DataSource dataSource, JDBCAbstractCMRFieldBridge field)
/*      */     throws DeploymentException
/*      */   {
/*  937 */     JDBCRelationMetaData rmd = field.getMetaData().getRelationMetaData();
/*      */ 
/*  939 */     if (rmd.isTableMappingStyle())
/*      */     {
/*  941 */       String tableName = rmd.getDefaultTableName();
/*  942 */       createFKIndex(rmd.getLeftRelationshipRole(), dataSource, tableName);
/*  943 */       createFKIndex(rmd.getRightRelationshipRole(), dataSource, tableName);
/*      */     }
/*  945 */     else if (field.hasForeignKey())
/*      */     {
/*  947 */       String tableName = field.getEntity().getQualifiedTableName();
/*  948 */       createFKIndex(field.getRelatedCMRField().getMetaData(), dataSource, tableName);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void createFKIndex(JDBCRelationshipRoleMetaData metadata, DataSource dataSource, String tableName)
/*      */     throws DeploymentException
/*      */   {
/*  955 */     Collection kfl = metadata.getKeyFields();
/*  956 */     Iterator it = kfl.iterator();
/*  957 */     while (it.hasNext())
/*      */     {
/*  959 */       JDBCCMPFieldMetaData fi = (JDBCCMPFieldMetaData)it.next();
/*  960 */       if (metadata.isIndexed())
/*      */       {
/*  962 */         createIndex(dataSource, tableName, fi.getFieldName(), createIndexSQL(fi, tableName));
/*  963 */         this.idxCount += 1;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private String createIndexSQL(JDBCCMPFieldMetaData fi, String tableName)
/*      */   {
/*  970 */     StringBuffer sql = new StringBuffer();
/*  971 */     sql.append("CREATE INDEX ");
/*  972 */     sql.append(tableName + "_idx" + this.idxCount);
/*  973 */     sql.append(" ON ");
/*  974 */     sql.append(tableName + " (");
/*  975 */     sql.append(fi.getColumnName());
/*  976 */     sql.append(')');
/*  977 */     return sql.toString();
/*      */   }
/*      */ 
/*      */   private void addField(JDBCType type, StringBuffer sqlBuffer)
/*      */     throws DeploymentException
/*      */   {
/*  983 */     if (type.getAutoIncrement()[0] != 0)
/*      */     {
/*  985 */       String columnClause = SQLUtil.getCreateTableColumnsClause(type);
/*  986 */       JDBCFunctionMappingMetaData autoIncrement = this.manager.getMetaData().getTypeMapping().getAutoIncrementTemplate();
/*      */ 
/*  988 */       if (autoIncrement == null)
/*      */       {
/*  990 */         throw new IllegalStateException("auto-increment template not found");
/*      */       }
/*  992 */       String[] args = { columnClause };
/*  993 */       autoIncrement.getFunctionSql(args, sqlBuffer);
/*      */     }
/*      */     else
/*      */     {
/*  997 */       sqlBuffer.append(SQLUtil.getCreateTableColumnsClause(type));
/*      */     }
/*      */   }
/*      */ 
/*      */   private String getRelationCreateTableSQL(JDBCAbstractCMRFieldBridge cmrField, DataSource dataSource)
/*      */     throws DeploymentException
/*      */   {
/* 1005 */     JDBCFieldBridge[] leftKeys = cmrField.getTableKeyFields();
/* 1006 */     JDBCFieldBridge[] rightKeys = cmrField.getRelatedCMRField().getTableKeyFields();
/* 1007 */     JDBCFieldBridge[] fieldsArr = new JDBCFieldBridge[leftKeys.length + rightKeys.length];
/* 1008 */     System.arraycopy(leftKeys, 0, fieldsArr, 0, leftKeys.length);
/* 1009 */     System.arraycopy(rightKeys, 0, fieldsArr, leftKeys.length, rightKeys.length);
/*      */ 
/* 1011 */     StringBuffer sql = new StringBuffer();
/* 1012 */     sql.append("CREATE TABLE ").append(cmrField.getQualifiedTableName()).append(" (").append(SQLUtil.getCreateTableColumnsClause(fieldsArr));
/*      */ 
/* 1018 */     JDBCRelationMetaData relationMetaData = cmrField.getMetaData().getRelationMetaData();
/* 1019 */     if (relationMetaData.hasPrimaryKeyConstraint())
/*      */     {
/* 1021 */       JDBCFunctionMappingMetaData pkConstraint = this.manager.getMetaData().getTypeMapping().getPkConstraintTemplate();
/*      */ 
/* 1023 */       if (pkConstraint == null)
/*      */       {
/* 1025 */         throw new IllegalStateException("Primary key constraint is not allowed for this type of data store");
/*      */       }
/*      */ 
/* 1028 */       String name = "pk_" + relationMetaData.getDefaultTableName();
/* 1029 */       name = SQLUtil.fixConstraintName(name, dataSource);
/* 1030 */       String[] args = { name, SQLUtil.getColumnNamesClause(fieldsArr, 100, new StringBuffer()).toString() };
/*      */ 
/* 1034 */       sql.append(", ");
/* 1035 */       pkConstraint.getFunctionSql(args, sql);
/*      */     }
/* 1037 */     sql.append(')');
/* 1038 */     return sql.toString();
/*      */   }
/*      */ 
/*      */   private void addForeignKeyConstraint(JDBCAbstractCMRFieldBridge cmrField)
/*      */     throws DeploymentException
/*      */   {
/* 1044 */     JDBCRelationshipRoleMetaData metaData = cmrField.getMetaData();
/* 1045 */     if (metaData.hasForeignKeyConstraint())
/*      */     {
/* 1047 */       if (metaData.getRelationMetaData().isTableMappingStyle())
/*      */       {
/* 1049 */         addForeignKeyConstraint(metaData.getRelationMetaData().getDataSource(), cmrField.getQualifiedTableName(), cmrField.getFieldName(), cmrField.getTableKeyFields(), cmrField.getEntity().getQualifiedTableName(), cmrField.getEntity().getPrimaryKeyFields());
/*      */       }
/* 1057 */       else if (cmrField.hasForeignKey())
/*      */       {
/* 1059 */         JDBCAbstractEntityBridge relatedEntity = (JDBCAbstractEntityBridge)cmrField.getRelatedEntity();
/* 1060 */         addForeignKeyConstraint(cmrField.getEntity().getDataSource(), cmrField.getEntity().getQualifiedTableName(), cmrField.getFieldName(), cmrField.getForeignKeyFields(), relatedEntity.getQualifiedTableName(), relatedEntity.getPrimaryKeyFields());
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1070 */       this.log.debug("Foreign key constraint not added as requested: relationshipRolename=" + metaData.getRelationshipRoleName());
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addForeignKeyConstraint(DataSource dataSource, String tableName, String cmrFieldName, JDBCFieldBridge[] fields, String referencesTableName, JDBCFieldBridge[] referencesFields)
/*      */     throws DeploymentException
/*      */   {
/* 1082 */     Set createdTables = (Set)this.manager.getApplicationData(CREATED_TABLES_KEY);
/* 1083 */     if (!createdTables.contains(tableName))
/*      */     {
/* 1085 */       return;
/*      */     }
/*      */ 
/* 1088 */     JDBCFunctionMappingMetaData fkConstraint = this.manager.getMetaData().getTypeMapping().getFkConstraintTemplate();
/* 1089 */     if (fkConstraint == null)
/*      */     {
/* 1091 */       throw new IllegalStateException("Foreign key constraint is not allowed for this type of datastore");
/*      */     }
/*      */ 
/* 1093 */     String a = SQLUtil.getColumnNamesClause(fields, new StringBuffer(50)).toString();
/* 1094 */     String b = SQLUtil.getColumnNamesClause(referencesFields, new StringBuffer(50)).toString();
/*      */ 
/* 1096 */     String[] args = { tableName, SQLUtil.fixConstraintName("fk_" + tableName + "_" + cmrFieldName, dataSource), a, referencesTableName, b };
/*      */ 
/* 1103 */     String sql = fkConstraint.getFunctionSql(args, new StringBuffer(100)).toString();
/*      */ 
/* 1107 */     TransactionManager tm = this.manager.getContainer().getTransactionManager();
/*      */     Transaction oldTransaction;
/*      */     try
/*      */     {
/* 1111 */       oldTransaction = tm.suspend();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1115 */       throw new DeploymentException("Could not suspend current transaction before alter table create foreign key.", e);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1120 */       Connection con = null;
/* 1121 */       Statement statement = null;
/*      */       try
/*      */       {
/* 1124 */         if (this.log.isDebugEnabled())
/*      */         {
/* 1126 */           this.log.debug("Executing SQL: " + sql);
/*      */         }
/* 1128 */         con = dataSource.getConnection();
/* 1129 */         statement = con.createStatement();
/* 1130 */         statement.executeUpdate(sql);
/*      */       }
/*      */       finally
/*      */       {
/* 1136 */         JDBCUtil.safeClose(statement);
/* 1137 */         JDBCUtil.safeClose(con);
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1142 */       this.log.warn("Could not add foreign key constraint: table=" + tableName);
/* 1143 */       throw new DeploymentException("Error while adding foreign key constraint", e);
/*      */     }
/*      */     finally
/*      */     {
/*      */       try
/*      */       {
/* 1150 */         if (oldTransaction != null)
/*      */         {
/* 1152 */           tm.resume(oldTransaction);
/*      */         }
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/* 1157 */         throw new DeploymentException("Could not reattach original transaction after create table");
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static String replaceTable(String in, String table)
/*      */   {
/* 1174 */     int pos = in.indexOf("%%t");
/*      */ 
/* 1176 */     if (pos == -1)
/*      */     {
/* 1178 */       return in;
/*      */     }
/*      */ 
/* 1181 */     String first = in.substring(0, pos);
/* 1182 */     String last = in.substring(pos + 3);
/*      */ 
/* 1184 */     return first + table + last;
/*      */   }
/*      */ 
/*      */   private String replaceIndexCounter(String in)
/*      */   {
/* 1197 */     int pos = in.indexOf("%%n");
/*      */ 
/* 1199 */     if (pos == -1)
/*      */     {
/* 1201 */       return in;
/*      */     }
/*      */ 
/* 1204 */     String first = in.substring(0, pos);
/* 1205 */     String last = in.substring(pos + 3);
/* 1206 */     this.idxCount += 1;
/* 1207 */     return first + this.idxCount + last;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCStartCommand
 * JD-Core Version:    0.6.0
 */