/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import javax.ejb.EJBException;
/*     */ 
/*     */ public final class JDBCTypeComplex
/*     */   implements JDBCType
/*     */ {
/*     */   private final JDBCTypeComplexProperty[] properties;
/*     */   private final String[] columnNames;
/*     */   private final Class[] javaTypes;
/*     */   private final int[] jdbcTypes;
/*     */   private final String[] sqlTypes;
/*     */   private final boolean[] notNull;
/*     */   private final JDBCResultSetReader[] resultSetReaders;
/*     */   private final JDBCParameterSetter[] paramSetters;
/*     */   private final Class fieldType;
/*  53 */   private final HashMap propertiesByName = new HashMap();
/*     */ 
/*     */   public JDBCTypeComplex(JDBCTypeComplexProperty[] properties, Class fieldType)
/*     */   {
/*  59 */     this.properties = properties;
/*  60 */     this.fieldType = fieldType;
/*     */ 
/*  62 */     int propNum = properties.length;
/*  63 */     this.columnNames = new String[propNum];
/*  64 */     this.javaTypes = new Class[propNum];
/*  65 */     this.jdbcTypes = new int[propNum];
/*  66 */     this.sqlTypes = new String[propNum];
/*  67 */     this.notNull = new boolean[propNum];
/*  68 */     this.resultSetReaders = new JDBCResultSetReader[propNum];
/*  69 */     this.paramSetters = new JDBCParameterSetter[propNum];
/*  70 */     for (int i = 0; i < properties.length; i++)
/*     */     {
/*  72 */       JDBCTypeComplexProperty property = properties[i];
/*  73 */       this.columnNames[i] = property.getColumnName();
/*  74 */       this.javaTypes[i] = property.getJavaType();
/*  75 */       this.jdbcTypes[i] = property.getJDBCType();
/*  76 */       this.sqlTypes[i] = property.getSQLType();
/*  77 */       this.notNull[i] = property.isNotNull();
/*  78 */       this.resultSetReaders[i] = property.getResulSetReader();
/*  79 */       this.paramSetters[i] = property.getParameterSetter();
/*  80 */       this.propertiesByName.put(property.getPropertyName(), property);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String[] getColumnNames() {
/*  85 */     return this.columnNames;
/*     */   }
/*     */ 
/*     */   public Class[] getJavaTypes() {
/*  89 */     return this.javaTypes;
/*     */   }
/*     */ 
/*     */   public int[] getJDBCTypes() {
/*  93 */     return this.jdbcTypes;
/*     */   }
/*     */ 
/*     */   public String[] getSQLTypes() {
/*  97 */     return this.sqlTypes;
/*     */   }
/*     */ 
/*     */   public boolean[] getNotNull() {
/* 101 */     return this.notNull;
/*     */   }
/*     */ 
/*     */   public boolean[] getAutoIncrement() {
/* 105 */     return new boolean[] { false };
/*     */   }
/*     */ 
/*     */   public Object getColumnValue(int index, Object value) {
/* 109 */     return getColumnValue(this.properties[index], value);
/*     */   }
/*     */ 
/*     */   public Object setColumnValue(int index, Object value, Object columnValue) {
/* 113 */     return setColumnValue(this.properties[index], value, columnValue);
/*     */   }
/*     */ 
/*     */   public boolean hasMapper()
/*     */   {
/* 118 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isSearchable()
/*     */   {
/* 123 */     return false;
/*     */   }
/*     */ 
/*     */   public JDBCResultSetReader[] getResultSetReaders()
/*     */   {
/* 128 */     return this.resultSetReaders;
/*     */   }
/*     */ 
/*     */   public JDBCParameterSetter[] getParameterSetter()
/*     */   {
/* 133 */     return this.paramSetters;
/*     */   }
/*     */ 
/*     */   public JDBCTypeComplexProperty[] getProperties() {
/* 137 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public JDBCTypeComplexProperty getProperty(String propertyName) {
/* 141 */     JDBCTypeComplexProperty prop = (JDBCTypeComplexProperty)this.propertiesByName.get(propertyName);
/* 142 */     if (prop == null) {
/* 143 */       throw new EJBException(this.fieldType.getName() + " does not have a property named " + propertyName);
/*     */     }
/*     */ 
/* 146 */     return prop;
/*     */   }
/*     */ 
/*     */   private static Object getColumnValue(JDBCTypeComplexProperty property, Object value) {
/*     */     try {
/* 151 */       return property.getColumnValue(value);
/*     */     } catch (EJBException e) {
/* 153 */       throw e; } catch (Exception e) {
/*     */     }
/* 155 */     throw new EJBException("Error getting column value", e);
/*     */   }
/*     */ 
/*     */   private Object setColumnValue(JDBCTypeComplexProperty property, Object value, Object columnValue)
/*     */   {
/* 164 */     if ((value == null) && (columnValue == null))
/*     */     {
/* 166 */       return null;
/*     */     }
/*     */     try
/*     */     {
/* 170 */       if (value == null) {
/* 171 */         value = this.fieldType.newInstance();
/*     */       }
/* 173 */       return property.setColumnValue(value, columnValue);
/*     */     } catch (Exception e) {
/* 175 */       e.printStackTrace();
/* 176 */     }throw new EJBException("Error setting column value", e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeComplex
 * JD-Core Version:    0.6.0
 */