/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldPropertyMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCMappingMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCUserTypeMappingMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCValueClassMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCValuePropertyMetaData;
/*     */ 
/*     */ public final class JDBCTypeFactory
/*     */ {
/*  67 */   public static final CMPFieldStateFactory EQUALS = new CMPFieldStateFactory()
/*     */   {
/*     */     public Object getFieldState(Object fieldValue)
/*     */     {
/*  71 */       return fieldValue;
/*     */     }
/*     */ 
/*     */     public boolean isStateValid(Object state, Object fieldValue)
/*     */     {
/*  76 */       return state == null ? false : fieldValue == null ? true : state.equals(fieldValue);
/*     */     }
/*  67 */   };
/*     */ 
/*  84 */   private static final CMPFieldStateFactory INVALID_UNLESS_NULL = new CMPFieldStateFactory()
/*     */   {
/*     */     public Object getFieldState(Object fieldValue)
/*     */     {
/*  88 */       return fieldValue;
/*     */     }
/*     */ 
/*     */     public boolean isStateValid(Object state, Object fieldValue)
/*     */     {
/*  93 */       return fieldValue == null;
/*     */     }
/*  84 */   };
/*     */ 
/* 101 */   private static final CMPFieldStateFactory MAP = new CMPFieldStateFactory()
/*     */   {
/*     */     public Object getFieldState(Object fieldValue)
/*     */     {
/* 105 */       return JDBCTypeFactory.access$000(fieldValue, Map.class);
/*     */     }
/*     */ 
/*     */     public boolean isStateValid(Object state, Object fieldValue)
/*     */     {
/* 110 */       return state == null ? false : fieldValue == null ? true : state.equals(fieldValue);
/*     */     }
/* 101 */   };
/*     */ 
/* 118 */   private static final CMPFieldStateFactory LIST = new CMPFieldStateFactory()
/*     */   {
/*     */     public Object getFieldState(Object fieldValue)
/*     */     {
/* 122 */       return JDBCTypeFactory.access$000(fieldValue, Collection.class);
/*     */     }
/*     */ 
/*     */     public boolean isStateValid(Object state, Object fieldValue)
/*     */     {
/* 127 */       return state == null ? false : fieldValue == null ? true : state.equals(fieldValue);
/*     */     }
/* 118 */   };
/*     */ 
/* 135 */   private static final CMPFieldStateFactory SET = new CMPFieldStateFactory()
/*     */   {
/*     */     public Object getFieldState(Object fieldValue)
/*     */     {
/* 139 */       return JDBCTypeFactory.access$000(fieldValue, Collection.class);
/*     */     }
/*     */ 
/*     */     public boolean isStateValid(Object state, Object fieldValue)
/*     */     {
/* 144 */       return state == null ? false : fieldValue == null ? true : state.equals(fieldValue);
/*     */     }
/* 135 */   };
/*     */ 
/* 151 */   private static final CMPFieldStateFactory ARRAY = new CMPFieldStateFactory()
/*     */   {
/*     */     public Object getFieldState(Object fieldValue)
/*     */     {
/* 155 */       Object state = null;
/* 156 */       if (fieldValue != null)
/*     */       {
/* 158 */         int length = Array.getLength(fieldValue);
/* 159 */         state = Array.newInstance(fieldValue.getClass().getComponentType(), length);
/* 160 */         System.arraycopy(fieldValue, 0, state, 0, length);
/*     */       }
/* 162 */       return state;
/*     */     }
/*     */ 
/*     */     public boolean isStateValid(Object state, Object fieldValue)
/*     */     {
/*     */       boolean valid;
/*     */       boolean valid;
/* 168 */       if (state == null)
/*     */       {
/* 170 */         valid = fieldValue == null;
/*     */       }
/*     */       else
/*     */       {
/*     */         boolean valid;
/* 174 */         if (fieldValue == null)
/*     */         {
/* 176 */           valid = false;
/*     */         }
/*     */         else
/*     */         {
/* 180 */           int stateLength = Array.getLength(state);
/*     */           boolean valid;
/* 181 */           if (stateLength != Array.getLength(fieldValue))
/*     */           {
/* 183 */             valid = false;
/*     */           }
/*     */           else
/*     */           {
/* 187 */             valid = true;
/* 188 */             for (int i = 0; i < stateLength; i++)
/*     */             {
/* 190 */               Object stateEl = Array.get(state, i);
/* 191 */               Object valueEl = Array.get(fieldValue, i);
/* 192 */               valid = stateEl == null ? false : valueEl == null ? true : stateEl.equals(valueEl);
/* 193 */               if (!valid)
/*     */               {
/*     */                 break;
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/* 201 */       return valid;
/*     */     }
/* 151 */   };
/*     */   private final JDBCTypeMappingMetaData typeMapping;
/* 367 */   private final Map complexTypes = new HashMap();
/* 368 */   private final Map mappedSimpleTypes = new HashMap();
/*     */   private final Map userTypeMappings;
/*     */ 
/*     */   public static final CMPFieldStateFactory getCMPFieldStateFactory(JDBCTypeFactory factory, String implClassName, Class clazz)
/*     */     throws DeploymentException
/*     */   {
/* 217 */     if (implClassName == null)
/*     */     {
/* 219 */       JDBCUserTypeMappingMetaData userMapping = (JDBCUserTypeMappingMetaData)factory.userTypeMappings.get(clazz.getName());
/* 220 */       if (userMapping != null)
/*     */       {
/* 222 */         implClassName = userMapping.getStateFactory();
/*     */       }
/*     */     }
/*     */     CMPFieldStateFactory stateFactory;
/*     */     CMPFieldStateFactory stateFactory;
/* 226 */     if (implClassName != null)
/*     */     {
/*     */       try
/*     */       {
/* 230 */         Class implClass = TCLAction.UTIL.getContextClassLoader().loadClass(implClassName);
/* 231 */         stateFactory = (CMPFieldStateFactory)implClass.newInstance();
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 235 */         throw new DeploymentException("Could not load state factory class: " + implClassName);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 239 */         throw new DeploymentException("Failed instantiate state factory: " + implClassName);
/*     */       }
/*     */     }
/* 242 */     else if (Map.class.isAssignableFrom(clazz))
/*     */     {
/* 244 */       stateFactory = MAP;
/*     */     }
/*     */     else
/*     */     {
/*     */       CMPFieldStateFactory stateFactory;
/* 246 */       if (List.class.isAssignableFrom(clazz))
/*     */       {
/* 248 */         stateFactory = LIST;
/*     */       }
/*     */       else
/*     */       {
/*     */         CMPFieldStateFactory stateFactory;
/* 250 */         if (Set.class.isAssignableFrom(clazz))
/*     */         {
/* 252 */           stateFactory = SET;
/*     */         }
/*     */         else
/*     */         {
/*     */           CMPFieldStateFactory stateFactory;
/* 254 */           if (clazz.isArray())
/*     */           {
/* 256 */             stateFactory = ARRAY;
/*     */           }
/*     */           else
/*     */           {
/*     */             CMPFieldStateFactory stateFactory;
/* 258 */             if (usedWithEqualsStateFactory(clazz))
/*     */             {
/* 260 */               stateFactory = EQUALS;
/*     */             }
/*     */             else
/*     */             {
/* 264 */               stateFactory = INVALID_UNLESS_NULL;
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 266 */     return stateFactory;
/*     */   }
/*     */ 
/*     */   public static final boolean checkDirtyAfterGet(JDBCTypeFactory factory, byte checkDirtyAfterGet, Class fieldType)
/*     */   {
/*     */     boolean result;
/*     */     boolean result;
/* 272 */     if (checkDirtyAfterGet == 4)
/*     */     {
/* 274 */       JDBCUserTypeMappingMetaData userMapping = (JDBCUserTypeMappingMetaData)factory.userTypeMappings.get(fieldType.getName());
/*     */       boolean result;
/* 276 */       if ((userMapping != null) && (userMapping.checkDirtyAfterGet() != 4))
/*     */       {
/* 279 */         result = userMapping.checkDirtyAfterGet() == 1;
/*     */       }
/*     */       else
/*     */       {
/* 283 */         result = !isDefaultImmutable(fieldType);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 288 */       result = checkDirtyAfterGet == 1;
/*     */     }
/* 290 */     return result;
/*     */   }
/*     */ 
/*     */   private static Object cloneValue(Object fieldValue, Class argType)
/*     */   {
/* 295 */     if (fieldValue == null)
/*     */     {
/* 297 */       return null;
/* 300 */     }
/*     */ Class valueType = fieldValue.getClass();
/*     */     Constructor ctor;
/*     */     try {
/* 304 */       ctor = valueType.getConstructor(new Class[] { argType });
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 308 */       throw new IllegalStateException("Failed to find a ctor in " + valueType + " that takes an instance of " + argType + " as an argument.");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 316 */       return ctor.newInstance(new Object[] { fieldValue });
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 320 */     throw new IllegalStateException("Failed to create an instance of " + valueType + " with the " + fieldValue + " as a ctor argument");
/*     */   }
/*     */ 
/*     */   private static final boolean usedWithEqualsStateFactory(Class clazz)
/*     */   {
/* 329 */     return (isDefaultImmutable(clazz)) || (clazz == java.util.Date.class) || (clazz == java.sql.Date.class) || (clazz == Time.class) || (clazz == Timestamp.class);
/*     */   }
/*     */ 
/*     */   private static final boolean isDefaultImmutable(Class clazz)
/*     */   {
/* 339 */     boolean result = false;
/* 340 */     if ((clazz.isPrimitive()) || (clazz == Boolean.class) || (clazz == Byte.class) || (clazz == Short.class) || (clazz == Integer.class) || (clazz == Long.class) || (clazz == Float.class) || (clazz == Double.class) || (clazz == Character.class) || (clazz == String.class) || (clazz == BigInteger.class) || (clazz == BigDecimal.class))
/*     */     {
/* 354 */       result = true;
/*     */     }
/* 356 */     return result;
/*     */   }
/*     */ 
/*     */   public JDBCTypeFactory(JDBCTypeMappingMetaData typeMapping, Collection valueClasses, Map userTypeMappings)
/*     */     throws DeploymentException
/*     */   {
/* 377 */     this.typeMapping = typeMapping;
/* 378 */     this.userTypeMappings = userTypeMappings;
/*     */ 
/* 380 */     HashMap valueClassesByType = new HashMap();
/* 381 */     for (Iterator i = valueClasses.iterator(); i.hasNext(); )
/*     */     {
/* 383 */       JDBCValueClassMetaData valueClass = (JDBCValueClassMetaData)i.next();
/* 384 */       valueClassesByType.put(valueClass.getJavaType(), valueClass);
/*     */     }
/*     */ 
/* 389 */     for (Iterator i = valueClasses.iterator(); i.hasNext(); )
/*     */     {
/* 391 */       JDBCValueClassMetaData valueClass = (JDBCValueClassMetaData)i.next();
/* 392 */       JDBCTypeComplex type = createTypeComplex(valueClass, valueClassesByType);
/* 393 */       this.complexTypes.put(valueClass.getJavaType(), type);
/*     */     }
/*     */ 
/* 396 */     Iterator i = typeMapping.getMappings().iterator();
/* 397 */     while (i.hasNext())
/*     */     {
/* 399 */       JDBCMappingMetaData mapping = (JDBCMappingMetaData)i.next();
/*     */ 
/* 401 */       String sqlType = mapping.getSqlType();
/* 402 */       int jdbcType = mapping.getJdbcType();
/* 403 */       Class javaType = loadClass(mapping.getJavaType());
/* 404 */       boolean notNull = javaType.isPrimitive();
/* 405 */       boolean autoIncrement = false;
/*     */       JDBCParameterSetter paramSetter;
/*     */       JDBCParameterSetter paramSetter;
/* 408 */       if (mapping.getParamSetter() != null)
/*     */       {
/* 410 */         paramSetter = (JDBCParameterSetter)newInstance(mapping.getParamSetter());
/*     */       }
/*     */       else
/*     */       {
/* 414 */         paramSetter = JDBCUtil.getParameterSetter(jdbcType, javaType);
/*     */       }
/*     */       JDBCResultSetReader resultReader;
/*     */       JDBCResultSetReader resultReader;
/* 418 */       if (mapping.getResultReader() != null)
/*     */       {
/* 420 */         resultReader = (JDBCResultSetReader)newInstance(mapping.getResultReader());
/*     */       }
/*     */       else
/*     */       {
/* 424 */         resultReader = JDBCUtil.getResultSetReader(jdbcType, javaType);
/*     */       }
/*     */ 
/* 427 */       JDBCTypeSimple type = new JDBCTypeSimple(null, javaType, jdbcType, sqlType, notNull, autoIncrement, null, paramSetter, resultReader);
/*     */ 
/* 430 */       this.mappedSimpleTypes.put(javaType, type);
/*     */     }
/*     */   }
/*     */ 
/*     */   public JDBCType getJDBCType(Class javaType)
/*     */   {
/* 436 */     if (this.complexTypes.containsKey(javaType))
/*     */     {
/* 438 */       return (JDBCTypeComplex)this.complexTypes.get(javaType);
/*     */     }
/*     */ 
/* 442 */     JDBCTypeSimple type = (JDBCTypeSimple)this.mappedSimpleTypes.get(javaType);
/* 443 */     if (type == null)
/*     */     {
/* 445 */       JDBCUserTypeMappingMetaData userTypeMapping = (JDBCUserTypeMappingMetaData)this.userTypeMappings.get(javaType.getName());
/*     */ 
/* 447 */       Mapper mapper = null;
/* 448 */       if (userTypeMapping != null)
/*     */       {
/* 450 */         ClassLoader cl = Thread.currentThread().getContextClassLoader();
/*     */         try
/*     */         {
/* 453 */           javaType = cl.loadClass(userTypeMapping.getMappedType());
/*     */         }
/*     */         catch (ClassNotFoundException e)
/*     */         {
/* 457 */           throw new IllegalStateException("Failed to load mapped type: " + userTypeMapping.getMappedType());
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 462 */           mapper = (Mapper)newInstance(userTypeMapping.getMapper());
/*     */         }
/*     */         catch (DeploymentException e)
/*     */         {
/* 466 */           throw new IllegalStateException("Failed to create Mapper instance of " + userTypeMapping.getMapper());
/*     */         }
/*     */       }
/*     */ 
/* 470 */       JDBCMappingMetaData typeMappingMD = this.typeMapping.getTypeMappingMetaData(javaType);
/* 471 */       String sqlType = typeMappingMD.getSqlType();
/* 472 */       int jdbcType = typeMappingMD.getJdbcType();
/* 473 */       boolean notNull = javaType.isPrimitive();
/* 474 */       boolean autoIncrement = false;
/*     */       JDBCParameterSetter paramSetter;
/* 477 */       if (typeMappingMD.getParamSetter() != null)
/*     */       {
/*     */         try
/*     */         {
/* 481 */           paramSetter = (JDBCParameterSetter)newInstance(typeMappingMD.getParamSetter());
/*     */         }
/*     */         catch (DeploymentException e)
/*     */         {
/* 485 */           throw new IllegalStateException(e.getMessage());
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 490 */         paramSetter = JDBCUtil.getParameterSetter(jdbcType, javaType);
/*     */       }
/*     */       JDBCResultSetReader resultReader;
/* 494 */       if (typeMappingMD.getResultReader() != null)
/*     */       {
/*     */         try
/*     */         {
/* 498 */           resultReader = (JDBCResultSetReader)newInstance(typeMappingMD.getResultReader());
/*     */         }
/*     */         catch (DeploymentException e)
/*     */         {
/* 502 */           throw new IllegalStateException(e.getMessage());
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 507 */         resultReader = JDBCUtil.getResultSetReader(jdbcType, javaType);
/*     */       }
/*     */ 
/* 510 */       type = new JDBCTypeSimple(null, javaType, jdbcType, sqlType, notNull, autoIncrement, mapper, paramSetter, resultReader);
/*     */     }
/*     */ 
/* 514 */     return type;
/*     */   }
/*     */ 
/*     */   public JDBCType getJDBCType(JDBCCMPFieldMetaData cmpField)
/*     */     throws DeploymentException
/*     */   {
/* 521 */     Class fieldType = cmpField.getFieldType();
/*     */     JDBCType fieldJDBCType;
/*     */     JDBCType fieldJDBCType;
/* 522 */     if (this.complexTypes.containsKey(fieldType))
/*     */     {
/* 524 */       fieldJDBCType = createTypeComplex(cmpField);
/*     */     }
/*     */     else
/*     */     {
/* 528 */       fieldJDBCType = createTypeSimple(cmpField);
/*     */     }
/* 530 */     return fieldJDBCType;
/*     */   }
/*     */ 
/*     */   public int getJDBCTypeForJavaType(Class clazz)
/*     */   {
/* 535 */     return this.typeMapping.getTypeMappingMetaData(clazz).getJdbcType();
/*     */   }
/*     */ 
/*     */   public JDBCTypeMappingMetaData getTypeMapping()
/*     */   {
/* 540 */     return this.typeMapping;
/*     */   }
/*     */ 
/*     */   private JDBCTypeComplex createTypeComplex(JDBCValueClassMetaData valueClass, HashMap valueClassesByType)
/*     */   {
/* 548 */     ArrayList propertyList = createComplexProperties(valueClass, valueClassesByType, new PropertyStack());
/*     */ 
/* 551 */     JDBCTypeComplexProperty[] properties = new JDBCTypeComplexProperty[propertyList.size()];
/* 552 */     properties = (JDBCTypeComplexProperty[])(JDBCTypeComplexProperty[])propertyList.toArray(properties);
/*     */ 
/* 554 */     return new JDBCTypeComplex(properties, valueClass.getJavaType());
/*     */   }
/*     */ 
/*     */   private JDBCTypeSimple createTypeSimple(JDBCCMPFieldMetaData cmpField) throws DeploymentException
/*     */   {
/* 559 */     String columnName = cmpField.getColumnName();
/* 560 */     Class javaType = cmpField.getFieldType();
/*     */ 
/* 562 */     JDBCMappingMetaData typeMappingMD = this.typeMapping.getTypeMappingMetaData(javaType);
/* 563 */     String paramSetter = typeMappingMD.getParamSetter();
/* 564 */     String resultReader = typeMappingMD.getResultReader();
/*     */ 
/* 567 */     String sqlType = cmpField.getSQLType();
/*     */     int jdbcType;
/*     */     int jdbcType;
/* 568 */     if (sqlType != null)
/*     */     {
/* 570 */       jdbcType = cmpField.getJDBCType();
/*     */     }
/*     */     else
/*     */     {
/* 575 */       sqlType = typeMappingMD.getSqlType();
/* 576 */       jdbcType = typeMappingMD.getJdbcType();
/*     */     }
/*     */ 
/* 579 */     boolean notNull = cmpField.isNotNull();
/* 580 */     boolean autoIncrement = cmpField.isAutoIncrement();
/*     */ 
/* 582 */     Mapper mapper = null;
/* 583 */     JDBCUserTypeMappingMetaData userTypeMapping = (JDBCUserTypeMappingMetaData)this.userTypeMappings.get(javaType.getName());
/* 584 */     if (userTypeMapping != null)
/*     */     {
/* 586 */       String mappedTypeStr = userTypeMapping.getMappedType();
/*     */       try
/*     */       {
/* 589 */         ClassLoader contextClassLoader = TCLAction.UTIL.getContextClassLoader();
/* 590 */         Class mapperClass = contextClassLoader.loadClass(userTypeMapping.getMapper());
/* 591 */         mapper = (Mapper)mapperClass.newInstance();
/* 592 */         javaType = contextClassLoader.loadClass(mappedTypeStr);
/* 593 */         if (cmpField.getSQLType() == null)
/*     */         {
/* 595 */           JDBCMappingMetaData mappingMD = this.typeMapping.getTypeMappingMetaData(javaType);
/* 596 */           sqlType = mappingMD.getSqlType();
/* 597 */           jdbcType = mappingMD.getJdbcType();
/* 598 */           paramSetter = mappingMD.getParamSetter();
/* 599 */           resultReader = mappingMD.getResultReader();
/*     */         }
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 604 */         throw new DeploymentException("Class not found for mapper: " + userTypeMapping.getMapper(), e);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 608 */         throw new DeploymentException("Could not instantiate mapper: " + userTypeMapping.getMapper(), e);
/*     */       }
/*     */     }
/*     */     JDBCParameterSetter paramSetterImpl;
/*     */     JDBCParameterSetter paramSetterImpl;
/* 613 */     if (paramSetter == null)
/*     */     {
/* 615 */       paramSetterImpl = JDBCUtil.getParameterSetter(jdbcType, javaType);
/*     */     }
/*     */     else
/*     */     {
/* 619 */       paramSetterImpl = (JDBCParameterSetter)newInstance(paramSetter);
/*     */     }
/*     */     JDBCResultSetReader resultReaderImpl;
/*     */     JDBCResultSetReader resultReaderImpl;
/* 623 */     if (resultReader == null)
/*     */     {
/* 625 */       resultReaderImpl = JDBCUtil.getResultSetReader(jdbcType, javaType);
/*     */     }
/*     */     else
/*     */     {
/* 629 */       resultReaderImpl = (JDBCResultSetReader)newInstance(resultReader);
/*     */     }
/*     */ 
/* 632 */     return new JDBCTypeSimple(columnName, javaType, jdbcType, sqlType, notNull, autoIncrement, mapper, paramSetterImpl, resultReaderImpl);
/*     */   }
/*     */ 
/*     */   private JDBCTypeComplex createTypeComplex(JDBCCMPFieldMetaData cmpField)
/*     */   {
/* 648 */     JDBCTypeComplex type = (JDBCTypeComplex)this.complexTypes.get(cmpField.getFieldType());
/* 649 */     JDBCTypeComplexProperty[] defaultProperties = type.getProperties();
/*     */ 
/* 652 */     HashMap overrides = new HashMap();
/*     */ 
/* 654 */     for (int i = 0; i < cmpField.getPropertyOverrides().size(); i++)
/*     */     {
/* 656 */       JDBCCMPFieldPropertyMetaData p = (JDBCCMPFieldPropertyMetaData)cmpField.getPropertyOverrides().get(i);
/* 657 */       overrides.put(p.getPropertyName(), p);
/*     */     }
/*     */ 
/* 661 */     JDBCTypeComplexProperty[] finalProperties = new JDBCTypeComplexProperty[defaultProperties.length];
/*     */ 
/* 664 */     for (int i = 0; i < defaultProperties.length; i++)
/*     */     {
/* 668 */       JDBCCMPFieldPropertyMetaData override = (JDBCCMPFieldPropertyMetaData)overrides.remove(defaultProperties[i].getPropertyName());
/*     */ 
/* 670 */       if (override == null)
/*     */       {
/* 672 */         finalProperties[i] = defaultProperties[i];
/* 673 */         finalProperties[i] = new JDBCTypeComplexProperty(defaultProperties[i], cmpField.getColumnName() + "_" + defaultProperties[i].getColumnName(), defaultProperties[i].getJDBCType(), defaultProperties[i].getSQLType(), (cmpField.isNotNull()) || (defaultProperties[i].isNotNull()));
/*     */       }
/*     */       else
/*     */       {
/* 684 */         String columnName = override.getColumnName();
/* 685 */         if (columnName == null)
/*     */         {
/* 687 */           columnName = cmpField.getColumnName() + "_" + defaultProperties[i].getColumnName();
/*     */         }
/*     */ 
/* 691 */         String sqlType = override.getSQLType();
/*     */         int jdbcType;
/*     */         int jdbcType;
/* 693 */         if (sqlType != null)
/*     */         {
/* 695 */           jdbcType = override.getJDBCType();
/*     */         }
/*     */         else
/*     */         {
/* 699 */           sqlType = defaultProperties[i].getSQLType();
/* 700 */           jdbcType = defaultProperties[i].getJDBCType();
/*     */         }
/*     */ 
/* 703 */         boolean notNull = (cmpField.isNotNull()) || (override.isNotNull()) || (defaultProperties[i].isNotNull());
/*     */ 
/* 707 */         finalProperties[i] = new JDBCTypeComplexProperty(defaultProperties[i], columnName, jdbcType, sqlType, notNull);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 717 */     if (overrides.size() > 0)
/*     */     {
/* 719 */       String propertyName = (String)overrides.keySet().iterator().next();
/* 720 */       throw new EJBException("Property " + propertyName + " in field " + cmpField.getFieldName() + " is not a property of value object " + cmpField.getFieldType().getName());
/*     */     }
/*     */ 
/* 726 */     return new JDBCTypeComplex(finalProperties, cmpField.getFieldType());
/*     */   }
/*     */ 
/*     */   private ArrayList createComplexProperties(JDBCValueClassMetaData valueClass, HashMap valueClassesByType, PropertyStack propertyStack)
/*     */   {
/* 735 */     ArrayList properties = new ArrayList();
/*     */ 
/* 738 */     List valueClassProperties = valueClass.getProperties();
/* 739 */     for (int i = 0; i < valueClassProperties.size(); i++)
/*     */     {
/* 741 */       JDBCValuePropertyMetaData propertyMetaData = (JDBCValuePropertyMetaData)valueClassProperties.get(i);
/*     */ 
/* 743 */       properties.addAll(createComplexProperties(propertyMetaData, valueClassesByType, propertyStack));
/*     */     }
/*     */ 
/* 746 */     return properties;
/*     */   }
/*     */ 
/*     */   private ArrayList createComplexProperties(JDBCValuePropertyMetaData propertyMetaData, HashMap valueClassesByType, PropertyStack propertyStack)
/*     */   {
/* 756 */     propertyStack.pushPropertyMetaData(propertyMetaData);
/*     */ 
/* 758 */     ArrayList properties = new ArrayList();
/*     */ 
/* 760 */     Class javaType = propertyMetaData.getPropertyType();
/* 761 */     if (!valueClassesByType.containsKey(javaType))
/*     */     {
/* 766 */       String propertyName = propertyStack.getPropertyName();
/* 767 */       String columnName = propertyStack.getColumnName();
/*     */ 
/* 769 */       String sqlType = propertyMetaData.getSqlType();
/*     */       int jdbcType;
/*     */       int jdbcType;
/* 771 */       if (sqlType != null)
/*     */       {
/* 773 */         jdbcType = propertyMetaData.getJDBCType();
/*     */       }
/*     */       else
/*     */       {
/* 778 */         JDBCMappingMetaData typeMappingMD = this.typeMapping.getTypeMappingMetaData(javaType);
/* 779 */         sqlType = typeMappingMD.getSqlType();
/* 780 */         jdbcType = typeMappingMD.getJdbcType();
/*     */       }
/*     */ 
/* 783 */       boolean notNull = propertyStack.isNotNull();
/*     */ 
/* 785 */       Method[] getters = propertyStack.getGetters();
/* 786 */       Method[] setters = propertyStack.getSetters();
/*     */ 
/* 788 */       properties.add(new JDBCTypeComplexProperty(propertyName, columnName, javaType, jdbcType, sqlType, notNull, getters, setters));
/*     */     }
/*     */     else
/*     */     {
/* 803 */       JDBCValueClassMetaData valueClass = (JDBCValueClassMetaData)valueClassesByType.get(javaType);
/*     */ 
/* 805 */       properties.addAll(createComplexProperties(valueClass, valueClassesByType, propertyStack));
/*     */     }
/*     */ 
/* 813 */     propertyStack.popPropertyMetaData();
/*     */ 
/* 815 */     return properties;
/*     */   }
/*     */ 
/*     */   private Object newInstance(String className)
/*     */     throws DeploymentException
/*     */   {
/* 914 */     Class clazz = loadClass(className);
/*     */     try
/*     */     {
/* 917 */       return clazz.newInstance();
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 921 */     throw new DeploymentException("Failed to instantiate " + className, e);
/*     */   }
/*     */ 
/*     */   private Class loadClass(String className) throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 928 */       ClassLoader contextClassLoader = TCLAction.UTIL.getContextClassLoader();
/* 929 */       return contextClassLoader.loadClass(className);
/*     */     }
/*     */     catch (ClassNotFoundException e) {
/*     */     }
/* 933 */     throw new DeploymentException("Failed to load class: " + className, e);
/*     */   }
/*     */ 
/*     */   private static final class PropertyStack
/*     */   {
/* 820 */     final ArrayList properties = new ArrayList();
/* 821 */     final ArrayList propertyNames = new ArrayList();
/* 822 */     final ArrayList columnNames = new ArrayList();
/* 823 */     final ArrayList notNulls = new ArrayList();
/* 824 */     final ArrayList getters = new ArrayList();
/* 825 */     final ArrayList setters = new ArrayList();
/*     */ 
/*     */     public final void pushPropertyMetaData(JDBCValuePropertyMetaData propertyMetaData)
/*     */     {
/* 835 */       this.propertyNames.add(propertyMetaData.getPropertyName());
/* 836 */       this.columnNames.add(propertyMetaData.getColumnName());
/* 837 */       this.notNulls.add(new Boolean(propertyMetaData.isNotNull()));
/* 838 */       this.getters.add(propertyMetaData.getGetter());
/* 839 */       this.setters.add(propertyMetaData.getSetter());
/*     */ 
/* 841 */       if (this.properties.contains(propertyMetaData))
/*     */       {
/* 843 */         throw new EJBException("Circular reference discoverd at property: " + getPropertyName());
/*     */       }
/*     */ 
/* 846 */       this.properties.add(propertyMetaData);
/*     */     }
/*     */ 
/*     */     public final void popPropertyMetaData()
/*     */     {
/* 851 */       this.propertyNames.remove(this.propertyNames.size() - 1);
/* 852 */       this.columnNames.remove(this.columnNames.size() - 1);
/* 853 */       this.notNulls.remove(this.notNulls.size() - 1);
/* 854 */       this.getters.remove(this.getters.size() - 1);
/* 855 */       this.setters.remove(this.setters.size() - 1);
/*     */ 
/* 857 */       this.properties.remove(this.properties.size() - 1);
/*     */     }
/*     */ 
/*     */     public final String getPropertyName()
/*     */     {
/* 862 */       StringBuffer buf = new StringBuffer();
/* 863 */       for (int i = 0; i < this.propertyNames.size(); i++)
/*     */       {
/* 865 */         if (i > 0)
/*     */         {
/* 867 */           buf.append(".");
/*     */         }
/* 869 */         buf.append((String)this.propertyNames.get(i));
/*     */       }
/* 871 */       return buf.toString();
/*     */     }
/*     */ 
/*     */     public final String getColumnName()
/*     */     {
/* 876 */       StringBuffer buf = new StringBuffer();
/* 877 */       for (int i = 0; i < this.columnNames.size(); i++)
/*     */       {
/* 879 */         if (i > 0)
/*     */         {
/* 881 */           buf.append("_");
/*     */         }
/* 883 */         buf.append((String)this.columnNames.get(i));
/*     */       }
/* 885 */       return buf.toString();
/*     */     }
/*     */ 
/*     */     public final boolean isNotNull()
/*     */     {
/* 890 */       for (int i = 0; i < this.notNulls.size(); i++)
/*     */       {
/* 892 */         if (((Boolean)this.notNulls.get(i)).booleanValue())
/*     */         {
/* 894 */           return true;
/*     */         }
/*     */       }
/* 897 */       return false;
/*     */     }
/*     */ 
/*     */     public final Method[] getGetters()
/*     */     {
/* 902 */       return (Method[])(Method[])this.getters.toArray(new Method[this.getters.size()]);
/*     */     }
/*     */ 
/*     */     public final Method[] getSetters()
/*     */     {
/* 907 */       return (Method[])(Method[])this.setters.toArray(new Method[this.setters.size()]);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeFactory
 * JD-Core Version:    0.6.0
 */