/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.ejb.EJBObject;
/*     */ import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public final class QueryParameter
/*     */ {
/*     */   private int argNum;
/*     */   private final boolean isPrimaryKeyParameter;
/*     */   private JDBCFieldBridge field;
/*     */   private JDBCTypeComplexProperty property;
/*     */   private String parameterString;
/*     */   private int jdbcType;
/*     */   private JDBCType type;
/*     */ 
/*     */   public static List createParameters(int argNum, JDBCFieldBridge field)
/*     */   {
/*  47 */     JDBCType type = field.getJDBCType();
/*     */     List parameters;
/*  48 */     if ((type instanceof JDBCTypeComplex))
/*     */     {
/*  50 */       JDBCTypeComplexProperty[] props = ((JDBCTypeComplex)type).getProperties();
/*  51 */       List parameters = new ArrayList(props.length);
/*  52 */       for (int i = 0; i < props.length; i++)
/*     */       {
/*  54 */         QueryParameter param = new QueryParameter(argNum, false, null, props[i], props[i].getJDBCType());
/*     */ 
/*  60 */         parameters.add(param);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  65 */       QueryParameter param = new QueryParameter(argNum, type);
/*  66 */       parameters = Collections.singletonList(param);
/*     */     }
/*  68 */     return parameters;
/*     */   }
/*     */ 
/*     */   public static List createParameters(int argNum, JDBCAbstractEntityBridge entity)
/*     */   {
/*  73 */     List parameters = new ArrayList();
/*  74 */     JDBCFieldBridge[] pkFields = entity.getPrimaryKeyFields();
/*  75 */     for (int i = 0; i < pkFields.length; i++)
/*     */     {
/*  77 */       JDBCFieldBridge pkField = pkFields[i];
/*     */ 
/*  79 */       JDBCType type = pkField.getJDBCType();
/*  80 */       if ((type instanceof JDBCTypeComplex))
/*     */       {
/*  82 */         JDBCTypeComplexProperty[] props = ((JDBCTypeComplex)type).getProperties();
/*     */ 
/*  84 */         for (int j = 0; j < props.length; j++)
/*     */         {
/*  86 */           QueryParameter param = new QueryParameter(argNum, false, pkField, props[j], props[j].getJDBCType());
/*     */ 
/*  92 */           parameters.add(param);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/*  97 */         QueryParameter param = new QueryParameter(argNum, false, pkField, null, type.getJDBCTypes()[0]);
/*     */ 
/* 103 */         param.type = type;
/* 104 */         parameters.add(param);
/*     */       }
/*     */     }
/* 107 */     return parameters;
/*     */   }
/*     */ 
/*     */   public static List createPrimaryKeyParameters(int argNum, JDBCAbstractEntityBridge entity)
/*     */   {
/* 112 */     List parameters = new ArrayList();
/* 113 */     JDBCFieldBridge[] pkFields = entity.getPrimaryKeyFields();
/* 114 */     for (int i = 0; i < pkFields.length; i++)
/*     */     {
/* 116 */       JDBCFieldBridge pkField = pkFields[i];
/*     */ 
/* 118 */       JDBCType type = pkField.getJDBCType();
/* 119 */       if ((type instanceof JDBCTypeComplex))
/*     */       {
/* 121 */         JDBCTypeComplexProperty[] props = ((JDBCTypeComplex)type).getProperties();
/* 122 */         for (int j = 0; j < props.length; j++)
/*     */         {
/* 124 */           QueryParameter param = new QueryParameter(argNum, true, pkField, props[j], props[j].getJDBCType());
/*     */ 
/* 130 */           parameters.add(param);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 135 */         QueryParameter param = new QueryParameter(argNum, true, pkField, null, type.getJDBCTypes()[0]);
/*     */ 
/* 141 */         param.type = type;
/* 142 */         parameters.add(param);
/*     */       }
/*     */     }
/* 145 */     return parameters;
/*     */   }
/*     */ 
/*     */   public QueryParameter(JDBCEntityPersistenceStore manager, Method method, String parameterString)
/*     */   {
/* 165 */     this.isPrimaryKeyParameter = false;
/*     */ 
/* 167 */     this.parameterString = parameterString;
/*     */ 
/* 169 */     if ((parameterString == null) || (parameterString.length() == 0))
/*     */     {
/* 171 */       throw new IllegalArgumentException("Parameter string is empty");
/*     */     }
/*     */ 
/* 174 */     StringTokenizer tok = new StringTokenizer(parameterString, ".");
/*     */     try
/*     */     {
/* 179 */       this.argNum = Integer.parseInt(tok.nextToken());
/*     */     }
/*     */     catch (NumberFormatException e)
/*     */     {
/* 183 */       throw new IllegalArgumentException("The parameter must begin with a number");
/*     */     }
/*     */ 
/* 187 */     if (this.argNum > method.getParameterTypes().length)
/*     */     {
/* 189 */       throw new IllegalArgumentException("The parameter index is " + this.argNum + " but the query method only has " + method.getParameterTypes().length + "parameter(s)");
/*     */     }
/*     */ 
/* 193 */     Class argType = method.getParameterTypes()[this.argNum];
/*     */     JDBCType type;
/*     */     JDBCType type;
/* 199 */     if ((EJBObject.class.isAssignableFrom(argType)) || (EJBLocalObject.class.isAssignableFrom(argType)))
/*     */     {
/* 204 */       if (!tok.hasMoreTokens())
/*     */       {
/* 206 */         throw new IllegalArgumentException("When the parameter is an ejb a field name must be supplied.");
/*     */       }
/* 208 */       String fieldName = tok.nextToken();
/*     */ 
/* 211 */       this.field = getCMPField(manager, argType, fieldName);
/* 212 */       if (!this.field.isPrimaryKeyMember())
/*     */       {
/* 214 */         throw new IllegalArgumentException("The specified field must be a primay key field");
/*     */       }
/*     */ 
/* 218 */       type = this.field.getJDBCType();
/*     */     }
/*     */     else
/*     */     {
/* 223 */       type = manager.getJDBCTypeFactory().getJDBCType(argType);
/*     */     }
/*     */ 
/* 226 */     if ((type instanceof JDBCTypeSimple))
/*     */     {
/* 228 */       if (tok.hasMoreTokens())
/*     */       {
/* 230 */         throw new IllegalArgumentException("Parameter is NOT a known dependent value class, so a properties cannot supplied.");
/*     */       }
/*     */ 
/* 233 */       this.jdbcType = type.getJDBCTypes()[0];
/* 234 */       this.type = type;
/*     */     }
/*     */     else
/*     */     {
/* 238 */       if (!tok.hasMoreTokens())
/*     */       {
/* 240 */         throw new IllegalArgumentException("Parmeter is a known dependent value class, so a property must be supplied");
/*     */       }
/*     */ 
/* 245 */       StringBuffer propertyName = new StringBuffer(parameterString.length());
/* 246 */       propertyName.append(tok.nextToken());
/* 247 */       while (tok.hasMoreTokens())
/*     */       {
/* 249 */         propertyName.append('.').append(tok.nextToken());
/*     */       }
/* 251 */       this.property = ((JDBCTypeComplex)type).getProperty(propertyName.toString());
/* 252 */       this.jdbcType = this.property.getJDBCType();
/*     */     }
/*     */   }
/*     */ 
/*     */   public QueryParameter(int argNum, JDBCType type)
/*     */   {
/* 258 */     this.argNum = argNum;
/* 259 */     this.type = type;
/* 260 */     this.jdbcType = type.getJDBCTypes()[0];
/* 261 */     this.isPrimaryKeyParameter = false;
/* 262 */     initToString();
/*     */   }
/*     */ 
/*     */   public QueryParameter(int argNum, boolean isPrimaryKeyParameter, JDBCFieldBridge field, JDBCTypeComplexProperty property, int jdbcType)
/*     */   {
/* 273 */     this.argNum = argNum;
/* 274 */     this.isPrimaryKeyParameter = isPrimaryKeyParameter;
/* 275 */     this.field = field;
/* 276 */     this.property = property;
/* 277 */     this.jdbcType = jdbcType;
/*     */ 
/* 279 */     initToString();
/*     */   }
/*     */ 
/*     */   private void initToString()
/*     */   {
/* 284 */     StringBuffer parameterBuf = new StringBuffer();
/* 285 */     parameterBuf.append(this.argNum);
/* 286 */     if (this.field != null)
/*     */     {
/* 288 */       parameterBuf.append('.').append(this.field.getFieldName());
/*     */     }
/* 290 */     if (this.property != null)
/*     */     {
/* 292 */       parameterBuf.append('.').append(this.property.getPropertyName());
/*     */     }
/* 294 */     this.parameterString = parameterBuf.toString();
/*     */   }
/*     */ 
/*     */   public void set(Logger log, PreparedStatement ps, int index, Object[] args)
/*     */     throws Exception
/*     */   {
/* 300 */     Object arg = args[this.argNum];
/*     */     JDBCParameterSetter param;
/*     */     JDBCParameterSetter param;
/* 302 */     if (this.field != null)
/*     */     {
/* 304 */       if (!this.isPrimaryKeyParameter)
/*     */       {
/* 306 */         if ((arg instanceof EJBObject))
/*     */         {
/* 308 */           arg = ((EJBObject)arg).getPrimaryKey();
/*     */         }
/* 310 */         else if ((arg instanceof EJBLocalObject))
/*     */         {
/* 312 */           arg = ((EJBLocalObject)arg).getPrimaryKey();
/*     */         }
/*     */         else
/*     */         {
/* 316 */           throw new IllegalArgumentException("Expected an instanc of EJBObject or EJBLocalObject, but got an instance of " + arg.getClass().getName());
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 321 */       arg = this.field.getPrimaryKeyValue(arg);
/*     */ 
/* 324 */       JDBCType jdbcType = this.field.getJDBCType();
/* 325 */       arg = jdbcType.getColumnValue(0, arg);
/* 326 */       param = jdbcType.getParameterSetter()[0];
/*     */     }
/*     */     else
/*     */     {
/*     */       JDBCParameterSetter param;
/* 328 */       if (this.property != null)
/*     */       {
/* 330 */         arg = this.property.getColumnValue(arg);
/* 331 */         param = this.property.getParameterSetter();
/*     */       }
/*     */       else
/*     */       {
/*     */         JDBCParameterSetter param;
/* 335 */         if (this.type != null)
/*     */         {
/* 337 */           arg = this.type.getColumnValue(0, arg);
/* 338 */           param = this.type.getParameterSetter()[0];
/*     */         }
/*     */         else
/*     */         {
/* 342 */           param = JDBCUtil.getParameterSetter(this.jdbcType, arg == null ? null : arg.getClass());
/*     */         }
/*     */       }
/*     */     }
/* 346 */     param.set(ps, index, this.jdbcType, arg, log);
/*     */   }
/*     */ 
/*     */   private static JDBCFieldBridge getCMPField(JDBCEntityPersistenceStore manager, Class intf, String fieldName)
/*     */   {
/* 355 */     Catalog catalog = manager.getCatalog();
/* 356 */     JDBCAbstractEntityBridge entityBridge = (JDBCAbstractEntityBridge)catalog.getEntityByInterface(intf);
/* 357 */     if (entityBridge == null)
/*     */     {
/* 359 */       throw new IllegalArgumentException("Entity not found in application catalog with interface=" + intf.getName());
/*     */     }
/*     */ 
/* 363 */     JDBCFieldBridge cmpField = (JDBCFieldBridge)entityBridge.getFieldByName(fieldName);
/* 364 */     if (cmpField == null)
/*     */     {
/* 366 */       throw new IllegalArgumentException("cmpField not found: cmpFieldName=" + fieldName + " entityName=" + entityBridge.getEntityName());
/*     */     }
/*     */ 
/* 370 */     return cmpField;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 375 */     return this.parameterString;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.QueryParameter
 * JD-Core Version:    0.6.0
 */