/*     */ package org.jboss.ejb.plugins.cmp.jdbc;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
/*     */ 
/*     */ public final class RelationData
/*     */ {
/*     */   private final JDBCCMRFieldBridge leftCMRField;
/*     */   private final JDBCCMRFieldBridge rightCMRField;
/*  43 */   public final Set addedRelations = new HashSet();
/*  44 */   public final Set removedRelations = new HashSet();
/*  45 */   public final Set notRelatedPairs = new HashSet();
/*     */ 
/*     */   public RelationData(JDBCCMRFieldBridge leftCMRField, JDBCCMRFieldBridge rightCMRField)
/*     */   {
/*  50 */     this.leftCMRField = leftCMRField;
/*  51 */     this.rightCMRField = rightCMRField;
/*     */   }
/*     */ 
/*     */   public JDBCCMRFieldBridge getLeftCMRField()
/*     */   {
/*  56 */     return this.leftCMRField;
/*     */   }
/*     */ 
/*     */   public JDBCCMRFieldBridge getRightCMRField()
/*     */   {
/*  61 */     return this.rightCMRField;
/*     */   }
/*     */ 
/*     */   public void addRelation(JDBCCMRFieldBridge leftCMRField, Object leftId, JDBCCMRFieldBridge rightCMRField, Object rightId)
/*     */   {
/*  70 */     if ((!leftCMRField.hasForeignKey()) && (!rightCMRField.hasForeignKey()))
/*     */     {
/*  72 */       RelationPair pair = createRelationPair(leftCMRField, leftId, rightCMRField, rightId);
/*  73 */       if (this.removedRelations.contains(pair))
/*     */       {
/*  78 */         this.removedRelations.remove(pair);
/*     */       }
/*     */       else
/*     */       {
/*  82 */         this.addedRelations.add(pair);
/*     */ 
/*  87 */         if (this.notRelatedPairs.contains(pair))
/*     */         {
/*  89 */           this.notRelatedPairs.remove(pair);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeRelation(JDBCCMRFieldBridge leftCMRField, Object leftId, JDBCCMRFieldBridge rightCMRField, Object rightId)
/*     */   {
/* 101 */     if ((!leftCMRField.hasForeignKey()) && (!rightCMRField.hasForeignKey()))
/*     */     {
/* 103 */       RelationPair pair = createRelationPair(leftCMRField, leftId, rightCMRField, rightId);
/* 104 */       if (this.addedRelations.contains(pair))
/*     */       {
/* 109 */         this.addedRelations.remove(pair);
/*     */ 
/* 118 */         this.notRelatedPairs.add(pair);
/*     */       }
/* 124 */       else if (!this.notRelatedPairs.contains(pair))
/*     */       {
/* 126 */         this.removedRelations.add(pair);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isDirty()
/*     */   {
/* 134 */     return (this.addedRelations.size() > 0) || (this.removedRelations.size() > 0);
/*     */   }
/*     */ 
/*     */   private RelationPair createRelationPair(JDBCCMRFieldBridge leftCMRField, Object leftId, JDBCCMRFieldBridge rightCMRField, Object rightId)
/*     */   {
/* 142 */     if ((this.leftCMRField == leftCMRField) && (this.rightCMRField == rightCMRField))
/*     */     {
/* 144 */       return new RelationPair(leftCMRField, leftId, rightCMRField, rightId);
/*     */     }
/*     */ 
/* 147 */     if ((this.leftCMRField == rightCMRField) && (this.rightCMRField == leftCMRField))
/*     */     {
/* 149 */       return new RelationPair(rightCMRField, rightId, leftCMRField, leftId);
/*     */     }
/* 151 */     throw new EJBException("Error: cmrFields are of wrong type");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.RelationData
 * JD-Core Version:    0.6.0
 */