/*      */ package org.jboss.ejb.plugins.cmp.jdbc;
/*      */ 
/*      */ import java.sql.Connection;
/*      */ import java.sql.DatabaseMetaData;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Statement;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Vector;
/*      */ import java.util.zip.CRC32;
/*      */ import javax.sql.DataSource;
/*      */ import org.jboss.deployment.DeploymentException;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge.FieldIterator;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*      */ import org.jboss.logging.Logger;
/*      */ 
/*      */ public final class SQLUtil
/*      */ {
/*      */   public static final String EMPTY_STRING = "";
/*      */   public static final String INSERT_INTO = "INSERT INTO ";
/*      */   public static final String VALUES = " VALUES ";
/*      */   public static final String SELECT = "SELECT ";
/*      */   public static final String DISTINCT = "DISTINCT ";
/*      */   public static final String FROM = " FROM ";
/*      */   public static final String WHERE = " WHERE ";
/*      */   public static final String ORDERBY = " ORDER BY ";
/*      */   public static final String DELETE_FROM = "DELETE FROM ";
/*      */   public static final String AND = " AND ";
/*      */   public static final String OR = " OR ";
/*      */   public static final String NOT = " NOT ";
/*      */   public static final String EXISTS = "EXISTS ";
/*      */   public static final String COMMA = ", ";
/*      */   public static final String LEFT_JOIN = " LEFT JOIN ";
/*      */   public static final String LEFT_OUTER_JOIN = " LEFT OUTER JOIN ";
/*      */   public static final String ON = " ON ";
/*      */   public static final String NOT_EQUAL = "<>";
/*      */   public static final String CREATE_TABLE = "CREATE TABLE ";
/*      */   public static final String DROP_TABLE = "DROP TABLE ";
/*      */   public static final String CREATE_INDEX = "CREATE INDEX ";
/*      */   public static final String NULL = "NULL";
/*      */   public static final String IS = " IS ";
/*      */   public static final String IN = " IN ";
/*      */   public static final String EMPTY = "EMPTY";
/*      */   public static final String BETWEEN = " BETWEEN ";
/*      */   public static final String LIKE = " LIKE ";
/*      */   public static final String MEMBER_OF = " MEMBER OF ";
/*      */   public static final String CONCAT = "CONCAT";
/*      */   public static final String SUBSTRING = "SUBSTRING";
/*      */   public static final String LCASE = "LCASE";
/*      */   public static final String UCASE = "UCASE";
/*      */   public static final String LENGTH = "LENGTH";
/*      */   public static final String LOCATE = "LOCATE";
/*      */   public static final String ABS = "ABS";
/*      */   public static final String MOD = "MOD";
/*      */   public static final String SQRT = "SQRT";
/*      */   public static final String COUNT = "COUNT";
/*      */   public static final String MAX = "MAX";
/*      */   public static final String MIN = "MIN";
/*      */   public static final String AVG = "AVG";
/*      */   public static final String SUM = "SUM";
/*      */   public static final String ASC = " ASC";
/*      */   public static final String DESC = " DESC";
/*      */   public static final String OFFSET = " OFFSET ";
/*      */   public static final String LIMIT = " LIMIT ";
/*      */   public static final String UPDATE = "UPDATE ";
/*      */   public static final String SET = " SET ";
/*      */   public static final String TYPE = " TYPE ";
/*      */   private static final String DOT = ".";
/*      */   private static final String EQ_QUESTMARK = "=?";
/*  105 */   private static final Vector rwords = new Vector();
/*      */ 
/*      */   public static String getTableNameWithoutSchema(String tableName)
/*      */   {
/*  109 */     int dot = tableName.indexOf('.');
/*  110 */     if (dot != -1)
/*      */     {
/*  112 */       char firstChar = tableName.charAt(0);
/*  113 */       tableName = tableName.substring(dot + 1);
/*  114 */       if ((firstChar == '"') || (firstChar == '\''))
/*      */       {
/*  116 */         tableName = firstChar + tableName;
/*      */       }
/*      */     }
/*  119 */     return tableName;
/*      */   }
/*      */ 
/*      */   public static String getSchema(String tableName)
/*      */   {
/*  124 */     String schema = null;
/*  125 */     int dot = tableName.indexOf('.');
/*  126 */     if (dot != -1)
/*      */     {
/*  128 */       char firstChar = tableName.charAt(0);
/*  129 */       boolean quoted = (firstChar == '"') || (firstChar == '\'');
/*  130 */       schema = tableName.substring(quoted ? 1 : 0, dot);
/*      */     }
/*  132 */     return schema;
/*      */   }
/*      */ 
/*      */   public static String fixTableName(String tableName, DataSource dataSource)
/*      */     throws DeploymentException
/*      */   {
/*  139 */     char firstChar = tableName.charAt(0);
/*  140 */     if ((firstChar == '"') || (firstChar == '\''))
/*      */     {
/*  142 */       return tableName;
/*      */     }
/*      */ 
/*  146 */     String strSchema = "";
/*      */     int iIndex;
/*  148 */     if ((iIndex = tableName.indexOf('.')) != -1)
/*      */     {
/*  150 */       strSchema = tableName.substring(0, iIndex);
/*  151 */       tableName = tableName.substring(iIndex + 1);
/*      */     }
/*      */ 
/*  157 */     if (rwords != null)
/*      */     {
/*  159 */       for (int i = 0; i < rwords.size(); i++)
/*      */       {
/*  161 */         if (!((String)rwords.elementAt(i)).equalsIgnoreCase(tableName))
/*      */           continue;
/*  163 */         tableName = "X" + tableName;
/*  164 */         break;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  169 */     Connection con = null;
/*      */     try
/*      */     {
/*  172 */       con = dataSource.getConnection();
/*  173 */       DatabaseMetaData dmd = con.getMetaData();
/*      */ 
/*  176 */       int maxLength = dmd.getMaxTableNameLength();
/*  177 */       if ((maxLength > 0) && (tableName.length() > maxLength))
/*      */       {
/*  179 */         crc = new CRC32();
/*  180 */         crc.update(tableName.getBytes());
/*  181 */         String nameCRC = Long.toString(crc.getValue(), 36);
/*      */ 
/*  183 */         tableName = tableName.substring(0, maxLength - nameCRC.length() - 2);
/*      */ 
/*  186 */         tableName = tableName + "_" + nameCRC;
/*      */       }
/*      */ 
/*  190 */       if (dmd.storesLowerCaseIdentifiers())
/*      */       {
/*  192 */         tableName = tableName.toLowerCase();
/*      */       }
/*  194 */       else if (dmd.storesUpperCaseIdentifiers())
/*      */       {
/*  196 */         tableName = tableName.toUpperCase();
/*      */       }
/*      */ 
/*  199 */       if (strSchema.length() > 0)
/*      */       {
/*  201 */         tableName = strSchema + "." + tableName;
/*      */       }
/*  203 */       crc = tableName;
/*      */     }
/*      */     catch (SQLException e)
/*      */     {
/*      */       CRC32 crc;
/*  209 */       throw new DeploymentException("Error while fixing table name", e);
/*      */     }
/*      */     finally
/*      */     {
/*  213 */       JDBCUtil.safeClose(con);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static void addToRwords(String word)
/*      */   {
/*  219 */     if (!rwords.contains(word))
/*  220 */       rwords.add(word);
/*      */   }
/*      */ 
/*      */   public static String fixConstraintName(String name, DataSource dataSource)
/*      */     throws DeploymentException
/*      */   {
/*  227 */     return fixTableName(name, dataSource).replace('.', '_');
/*      */   }
/*      */ 
/*      */   public static String getCreateTableColumnsClause(JDBCFieldBridge[] fields)
/*      */   {
/*  238 */     StringBuffer buf = new StringBuffer(100);
/*  239 */     boolean comma = false;
/*  240 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  242 */       JDBCType type = getJDBCType(fields[i]);
/*  243 */       if (type == null)
/*      */         continue;
/*  245 */       if (comma)
/*  246 */         buf.append(", ");
/*      */       else
/*  248 */         comma = true;
/*  249 */       buf.append(getCreateTableColumnsClause(type));
/*      */     }
/*      */ 
/*  252 */     return buf.toString();
/*      */   }
/*      */ 
/*      */   public static String getCreateTableColumnsClause(JDBCType type)
/*      */   {
/*  262 */     String[] columnNames = type.getColumnNames();
/*  263 */     String[] sqlTypes = type.getSQLTypes();
/*  264 */     boolean[] notNull = type.getNotNull();
/*      */ 
/*  266 */     StringBuffer buf = new StringBuffer();
/*  267 */     for (int i = 0; i < columnNames.length; i++)
/*      */     {
/*  269 */       if (i != 0)
/*  270 */         buf.append(", ");
/*  271 */       buf.append(columnNames[i]).append(' ').append(sqlTypes[i]);
/*  272 */       if (notNull[i] != 0)
/*  273 */         buf.append(" NOT ").append("NULL");
/*      */     }
/*  275 */     return buf.toString();
/*      */   }
/*      */ 
/*      */   public static StringBuffer getColumnNamesClause(JDBCFieldBridge[] fields, StringBuffer sb)
/*      */   {
/*  288 */     return getColumnNamesClause(fields, "", sb);
/*      */   }
/*      */ 
/*      */   public static StringBuffer getColumnNamesClause(JDBCFieldBridge[] fields, String identifier, StringBuffer buf)
/*      */   {
/*  298 */     boolean comma = false;
/*  299 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  301 */       JDBCType type = getJDBCType(fields[i]);
/*  302 */       if (type == null)
/*      */         continue;
/*  304 */       if (comma)
/*  305 */         buf.append(", ");
/*      */       else
/*  307 */         comma = true;
/*  308 */       getColumnNamesClause(type, identifier, buf);
/*      */     }
/*      */ 
/*  311 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer getSearchableColumnNamesClause(JDBCFieldBridge[] fields, String identifier, StringBuffer buf)
/*      */   {
/*  321 */     boolean comma = false;
/*  322 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  324 */       JDBCType type = getJDBCType(fields[i]);
/*  325 */       if ((type == null) || (!type.isSearchable()))
/*      */         continue;
/*  327 */       if (comma)
/*  328 */         buf.append(", ");
/*      */       else
/*  330 */         comma = true;
/*  331 */       getColumnNamesClause(type, identifier, buf);
/*      */     }
/*      */ 
/*  334 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer getColumnNamesClause(JDBCEntityBridge.FieldIterator loadIter, StringBuffer sb)
/*      */   {
/*  342 */     if (loadIter.hasNext())
/*  343 */       getColumnNamesClause(loadIter.next(), sb);
/*  344 */     while (loadIter.hasNext())
/*      */     {
/*  346 */       sb.append(", ");
/*  347 */       getColumnNamesClause(loadIter.next(), sb);
/*      */     }
/*  349 */     return sb;
/*      */   }
/*      */ 
/*      */   public static StringBuffer getColumnNamesClause(JDBCFieldBridge field, StringBuffer sb)
/*      */   {
/*  357 */     return getColumnNamesClause(field.getJDBCType(), sb);
/*      */   }
/*      */ 
/*      */   public static StringBuffer getColumnNamesClause(JDBCFieldBridge field, String identifier, StringBuffer sb)
/*      */   {
/*  367 */     return getColumnNamesClause(field.getJDBCType(), identifier, sb);
/*      */   }
/*      */ 
/*      */   private static StringBuffer getColumnNamesClause(JDBCType type, String identifier, StringBuffer buf)
/*      */   {
/*  377 */     String[] columnNames = type.getColumnNames();
/*  378 */     boolean hasIdentifier = identifier.length() > 0;
/*  379 */     if (hasIdentifier)
/*  380 */       buf.append(identifier).append(".");
/*  381 */     buf.append(columnNames[0]);
/*  382 */     int i = 1;
/*  383 */     while (i < columnNames.length)
/*      */     {
/*  385 */       buf.append(", ");
/*  386 */       if (hasIdentifier)
/*  387 */         buf.append(identifier).append(".");
/*  388 */       buf.append(columnNames[(i++)]);
/*      */     }
/*  390 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer appendColumnNamesClause(JDBCAbstractEntityBridge entity, String eagerLoadGroup, StringBuffer sb)
/*      */   {
/*  398 */     return appendColumnNamesClause(entity, eagerLoadGroup, "", sb);
/*      */   }
/*      */ 
/*      */   public static StringBuffer appendColumnNamesClause(JDBCAbstractEntityBridge entity, String eagerLoadGroup, String alias, StringBuffer sb)
/*      */   {
/*  409 */     return appendColumnNamesClause(entity.getTableFields(), entity.getLoadGroupMask(eagerLoadGroup), alias, sb);
/*      */   }
/*      */ 
/*      */   public static StringBuffer appendColumnNamesClause(JDBCFieldBridge[] fields, boolean[] mask, String identifier, StringBuffer buf)
/*      */   {
/*  420 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  422 */       if (mask[i] == 0)
/*      */         continue;
/*  424 */       JDBCType type = getJDBCType(fields[i]);
/*  425 */       if (type == null)
/*      */         continue;
/*  427 */       buf.append(", ");
/*  428 */       getColumnNamesClause(type, identifier, buf);
/*      */     }
/*      */ 
/*  432 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer appendSearchableColumnNamesClause(JDBCFieldBridge[] fields, boolean[] mask, String identifier, StringBuffer buf)
/*      */   {
/*  440 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  442 */       if (mask[i] == 0)
/*      */         continue;
/*  444 */       JDBCType type = getJDBCType(fields[i]);
/*  445 */       if ((type == null) || (!type.isSearchable()))
/*      */         continue;
/*  447 */       buf.append(", ");
/*  448 */       getColumnNamesClause(type, identifier, buf);
/*      */     }
/*      */ 
/*  452 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer appendColumnNamesClause(JDBCFieldBridge[] fields, String identifier, StringBuffer buf)
/*      */   {
/*  462 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  464 */       JDBCType type = getJDBCType(fields[i]);
/*  465 */       if (type == null)
/*      */         continue;
/*  467 */       buf.append(", ");
/*  468 */       getColumnNamesClause(type, identifier, buf);
/*      */     }
/*      */ 
/*  471 */     return buf;
/*      */   }
/*      */ 
/*      */   private static StringBuffer getColumnNamesClause(JDBCType type, StringBuffer buf)
/*      */   {
/*  481 */     String[] columnNames = type.getColumnNames();
/*  482 */     buf.append(columnNames[0]);
/*  483 */     int i = 1;
/*  484 */     while (i < columnNames.length)
/*      */     {
/*  486 */       buf.append(", ").append(columnNames[(i++)]);
/*      */     }
/*  488 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer getSetClause(JDBCEntityBridge.FieldIterator fieldsIter, StringBuffer buf)
/*      */   {
/*  502 */     JDBCType type = getJDBCType(fieldsIter.next());
/*  503 */     getSetClause(type, buf);
/*  504 */     while (fieldsIter.hasNext())
/*      */     {
/*  506 */       type = getJDBCType(fieldsIter.next());
/*  507 */       buf.append(", ");
/*  508 */       getSetClause(type, buf);
/*      */     }
/*  510 */     return buf;
/*      */   }
/*      */ 
/*      */   private static StringBuffer getSetClause(JDBCType type, StringBuffer buf)
/*      */   {
/*  518 */     String[] columnNames = type.getColumnNames();
/*  519 */     buf.append(columnNames[0]).append("=?");
/*  520 */     int i = 1;
/*  521 */     while (i < columnNames.length)
/*      */     {
/*  523 */       buf.append(", ").append(columnNames[(i++)]).append("=?");
/*      */     }
/*  525 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer getValuesClause(JDBCFieldBridge[] fields, StringBuffer buf)
/*      */   {
/*  538 */     boolean comma = false;
/*  539 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  541 */       JDBCType type = getJDBCType(fields[i]);
/*  542 */       if (type == null)
/*      */         continue;
/*  544 */       if (comma)
/*  545 */         buf.append(", ");
/*      */       else
/*  547 */         comma = true;
/*  548 */       getValuesClause(type, buf);
/*      */     }
/*      */ 
/*  551 */     return buf;
/*      */   }
/*      */ 
/*      */   private static StringBuffer getValuesClause(JDBCType type, StringBuffer buf)
/*      */   {
/*  559 */     int columnCount = type.getColumnNames().length;
/*  560 */     buf.append('?');
/*  561 */     int i = 1;
/*  562 */     while (i++ < columnCount)
/*  563 */       buf.append(", ").append('?');
/*  564 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer getWhereClause(JDBCFieldBridge[] fields, StringBuffer buf)
/*      */   {
/*  577 */     return getWhereClause(fields, "", buf);
/*      */   }
/*      */ 
/*      */   public static StringBuffer getWhereClause(JDBCFieldBridge[] fields, String identifier, StringBuffer buf)
/*      */   {
/*  587 */     boolean and = false;
/*  588 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  590 */       JDBCType type = getJDBCType(fields[i]);
/*  591 */       if (type == null)
/*      */         continue;
/*  593 */       if (and)
/*  594 */         buf.append(" AND ");
/*      */       else
/*  596 */         and = true;
/*  597 */       getWhereClause(type, identifier, buf);
/*      */     }
/*      */ 
/*  600 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer getWhereClause(JDBCFieldBridge[] fields, long mask, StringBuffer buf)
/*      */   {
/*  610 */     return getWhereClause(fields, mask, "", buf);
/*      */   }
/*      */ 
/*      */   private static StringBuffer getWhereClause(JDBCFieldBridge[] fields, long mask, String identifier, StringBuffer buf)
/*      */   {
/*  621 */     boolean and = false;
/*  622 */     long fieldMask = 1L;
/*  623 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  625 */       if ((fieldMask & mask) > 0L)
/*      */       {
/*  627 */         JDBCType type = getJDBCType(fields[i]);
/*  628 */         if (type != null)
/*      */         {
/*  630 */           if (and)
/*  631 */             buf.append(" AND ");
/*      */           else
/*  633 */             and = true;
/*  634 */           getWhereClause(type, identifier, buf);
/*      */         }
/*      */       }
/*  637 */       fieldMask <<= 1;
/*      */     }
/*  639 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer getWhereClause(JDBCFieldBridge field, StringBuffer buf)
/*      */   {
/*  647 */     return getWhereClause(field.getJDBCType(), "", buf);
/*      */   }
/*      */ 
/*      */   public static StringBuffer getWhereClause(JDBCType type, String identifier, StringBuffer buf)
/*      */   {
/*  657 */     if (identifier.length() > 0)
/*      */     {
/*  659 */       identifier = identifier + '.';
/*      */     }
/*      */ 
/*  662 */     String[] columnNames = type.getColumnNames();
/*  663 */     buf.append(identifier).append(columnNames[0]).append("=?");
/*  664 */     int i = 1;
/*  665 */     while (i < columnNames.length)
/*      */     {
/*  667 */       buf.append(" AND ").append(identifier).append(columnNames[(i++)]).append("=?");
/*      */     }
/*  669 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer getWhereClause(JDBCType type, String identifier, String comparison, StringBuffer buf)
/*      */   {
/*  679 */     if (identifier.length() > 0)
/*      */     {
/*  681 */       identifier = identifier + '.';
/*      */     }
/*      */ 
/*  684 */     String[] columnNames = type.getColumnNames();
/*  685 */     buf.append(identifier).append(columnNames[0]).append(comparison).append('?');
/*  686 */     int i = 1;
/*  687 */     while (i < columnNames.length)
/*      */     {
/*  689 */       buf.append(" AND ").append(identifier).append(columnNames[(i++)]).append(comparison).append('?');
/*      */     }
/*  691 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer getIsNullClause(boolean not, JDBCFieldBridge[] fields, String identifier, StringBuffer buf)
/*      */   {
/*  710 */     boolean and = false;
/*  711 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  713 */       JDBCType type = getJDBCType(fields[i]);
/*  714 */       if (type == null)
/*      */         continue;
/*  716 */       if (and)
/*  717 */         buf.append(" AND ");
/*      */       else
/*  719 */         and = true;
/*  720 */       getIsNullClause(not, type, identifier, buf);
/*      */     }
/*      */ 
/*  723 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer getIsNullClause(boolean not, JDBCFieldBridge field, String identifier, StringBuffer buf)
/*      */   {
/*  736 */     return getIsNullClause(not, field.getJDBCType(), identifier, buf);
/*      */   }
/*      */ 
/*      */   private static StringBuffer getIsNullClause(boolean not, JDBCType type, String identifier, StringBuffer buf)
/*      */   {
/*  749 */     if (identifier.length() > 0)
/*      */     {
/*  751 */       identifier = identifier + '.';
/*      */     }
/*      */ 
/*  754 */     String[] columnNames = type.getColumnNames();
/*      */ 
/*  756 */     buf.append(identifier).append(columnNames[0]).append(" IS ");
/*  757 */     (not ? buf.append(" NOT ") : buf).append("NULL");
/*  758 */     int i = 1;
/*  759 */     while (i < columnNames.length)
/*      */     {
/*  761 */       buf.append(" AND ").append(identifier).append(columnNames[(i++)]).append(" IS ");
/*  762 */       (not ? buf.append(" NOT ") : buf).append("NULL");
/*      */     }
/*  764 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer getJoinClause(JDBCAbstractCMRFieldBridge cmrField, String parentAlias, String childAlias, StringBuffer buf)
/*      */   {
/*  779 */     JDBCAbstractEntityBridge parentEntity = cmrField.getEntity();
/*  780 */     JDBCAbstractEntityBridge childEntity = (JDBCAbstractEntityBridge)cmrField.getRelatedEntity();
/*      */ 
/*  785 */     if (cmrField.hasForeignKey())
/*      */     {
/*  788 */       JDBCFieldBridge[] parentFkFields = cmrField.getForeignKeyFields();
/*  789 */       int i = 0;
/*  790 */       while (i < parentFkFields.length)
/*      */       {
/*  792 */         JDBCFieldBridge parentField = parentFkFields[(i++)];
/*  793 */         JDBCFieldBridge childField = (JDBCFieldBridge)childEntity.getFieldByName(parentField.getFieldName());
/*  794 */         getJoinClause(parentField, parentAlias, childField, childAlias, buf);
/*  795 */         if (i < parentFkFields.length) {
/*  796 */           buf.append(" AND ");
/*      */         }
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  802 */       JDBCFieldBridge[] childFkFields = cmrField.getRelatedCMRField().getForeignKeyFields();
/*  803 */       int i = 0;
/*  804 */       while (i < childFkFields.length)
/*      */       {
/*  806 */         JDBCFieldBridge childField = childFkFields[(i++)];
/*  807 */         JDBCFieldBridge parentField = (JDBCFieldBridge)parentEntity.getFieldByName(childField.getFieldName());
/*      */ 
/*  810 */         getJoinClause(parentField, parentAlias, childField, childAlias, buf);
/*  811 */         if (i >= childFkFields.length)
/*      */           continue;
/*  813 */         buf.append(" AND ");
/*      */       }
/*      */     }
/*      */ 
/*  817 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer getRelationTableJoinClause(JDBCAbstractCMRFieldBridge cmrField, String parentAlias, String relationTableAlias, StringBuffer buf)
/*      */   {
/*  825 */     JDBCAbstractEntityBridge parentEntity = cmrField.getEntity();
/*      */ 
/*  830 */     JDBCFieldBridge[] parentFields = cmrField.getTableKeyFields();
/*  831 */     int i = 0;
/*  832 */     while (i < parentFields.length)
/*      */     {
/*  834 */       JDBCFieldBridge relationField = parentFields[(i++)];
/*  835 */       JDBCFieldBridge parentField = (JDBCFieldBridge)parentEntity.getFieldByName(relationField.getFieldName());
/*  836 */       getJoinClause(parentField, parentAlias, relationField, relationTableAlias, buf);
/*  837 */       if (i < parentFields.length)
/*  838 */         buf.append(" AND ");
/*      */     }
/*  840 */     return buf;
/*      */   }
/*      */ 
/*      */   private static StringBuffer getJoinClause(JDBCFieldBridge pkField, String parent, JDBCFieldBridge fkField, String child, StringBuffer buf)
/*      */   {
/*  854 */     return getJoinClause(pkField.getJDBCType(), parent, fkField.getJDBCType(), child, buf);
/*      */   }
/*      */ 
/*      */   public static StringBuffer getJoinClause(JDBCFieldBridge[] pkFields, String parent, JDBCFieldBridge[] fkFields, String child, StringBuffer buf)
/*      */   {
/*  863 */     if (pkFields.length != fkFields.length)
/*      */     {
/*  865 */       throw new IllegalArgumentException("Error createing theta join clause: pkField.size()=" + pkFields.length + " fkField.size()=" + fkFields.length);
/*      */     }
/*      */ 
/*  871 */     boolean and = false;
/*  872 */     for (int i = 0; i < pkFields.length; i++)
/*      */     {
/*  875 */       JDBCType pkType = getJDBCType(pkFields[i]);
/*  876 */       JDBCType fkType = getJDBCType(fkFields[i]);
/*  877 */       if (and)
/*  878 */         buf.append(" AND ");
/*      */       else
/*  880 */         and = true;
/*  881 */       getJoinClause(pkType, parent, fkType, child, buf);
/*      */     }
/*  883 */     return buf;
/*      */   }
/*      */ 
/*      */   private static StringBuffer getJoinClause(JDBCType pkType, String parent, JDBCType fkType, String child, StringBuffer buf)
/*      */   {
/*  897 */     if (parent.length() > 0)
/*      */     {
/*  899 */       parent = parent + '.';
/*      */     }
/*  901 */     if (child.length() > 0)
/*      */     {
/*  903 */       child = child + '.';
/*      */     }
/*      */ 
/*  906 */     String[] pkColumnNames = pkType.getColumnNames();
/*  907 */     String[] fkColumnNames = fkType.getColumnNames();
/*  908 */     if (pkColumnNames.length != fkColumnNames.length)
/*      */     {
/*  910 */       throw new IllegalArgumentException("PK and FK have different number of columns");
/*      */     }
/*      */ 
/*  913 */     buf.append(parent).append(pkColumnNames[0]).append('=').append(child).append(fkColumnNames[0]);
/*  914 */     int i = 1;
/*  915 */     while (i < pkColumnNames.length)
/*      */     {
/*  917 */       buf.append(" AND ").append(parent).append(pkColumnNames[i]).append('=').append(child).append(fkColumnNames[(i++)]);
/*      */     }
/*      */ 
/*  924 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer getSelfCompareWhereClause(JDBCFieldBridge[] fields, String fromIdentifier, String toIdentifier, StringBuffer buf)
/*      */   {
/*  939 */     boolean and = false;
/*  940 */     for (int i = 0; i < fields.length; i++)
/*      */     {
/*  942 */       JDBCType type = getJDBCType(fields[i]);
/*  943 */       if (type == null)
/*      */         continue;
/*  945 */       if (and)
/*  946 */         buf.append(" AND ");
/*      */       else
/*  948 */         and = true;
/*  949 */       getSelfCompareWhereClause(type, fromIdentifier, toIdentifier, buf);
/*      */     }
/*      */ 
/*  952 */     return buf;
/*      */   }
/*      */ 
/*      */   private static StringBuffer getSelfCompareWhereClause(JDBCType type, String fromIdentifier, String toIdentifier, StringBuffer buf)
/*      */   {
/*  960 */     if (fromIdentifier.length() > 0)
/*  961 */       fromIdentifier = fromIdentifier + '.';
/*  962 */     if (toIdentifier.length() > 0) {
/*  963 */       toIdentifier = toIdentifier + '.';
/*      */     }
/*  965 */     String[] columnNames = type.getColumnNames();
/*      */ 
/*  967 */     buf.append(fromIdentifier).append(columnNames[0]).append('=').append(toIdentifier).append(columnNames[0]);
/*      */ 
/*  972 */     int i = 1;
/*  973 */     while (i < columnNames.length)
/*      */     {
/*  975 */       buf.append(" AND ").append(fromIdentifier).append(columnNames[i]).append('=').append(toIdentifier).append(columnNames[(i++)]);
/*      */     }
/*      */ 
/*  982 */     return buf;
/*      */   }
/*      */ 
/*      */   public static StringBuffer getSelfCompareWhereClause(JDBCFieldBridge fromField, JDBCFieldBridge toField, String fromIdentifier, String toIdentifier, String comparison, StringBuffer buf)
/*      */   {
/*  992 */     return getSelfCompareWhereClause(fromField.getJDBCType(), toField.getJDBCType(), fromIdentifier, toIdentifier, comparison, buf);
/*      */   }
/*      */ 
/*      */   private static StringBuffer getSelfCompareWhereClause(JDBCType fromType, JDBCType toType, String fromIdentifier, String toIdentifier, String comparison, StringBuffer buf)
/*      */   {
/* 1004 */     if (fromIdentifier.length() > 0)
/* 1005 */       fromIdentifier = fromIdentifier + '.';
/* 1006 */     if (toIdentifier.length() > 0) {
/* 1007 */       toIdentifier = toIdentifier + '.';
/*      */     }
/* 1009 */     String[] fromColumnNames = fromType.getColumnNames();
/* 1010 */     String[] toColumnNames = toType.getColumnNames();
/*      */ 
/* 1012 */     buf.append(fromIdentifier).append(fromColumnNames[0]).append(comparison).append(toIdentifier).append(toColumnNames[0]);
/*      */ 
/* 1017 */     int i = 1;
/* 1018 */     while (i < fromColumnNames.length)
/*      */     {
/* 1020 */       buf.append(" AND ").append(fromIdentifier).append(fromColumnNames[i]).append(comparison).append(toIdentifier).append(toColumnNames[(i++)]);
/*      */     }
/*      */ 
/* 1027 */     return buf;
/*      */   }
/*      */ 
/*      */   public static boolean tableExists(String tableName, DataSource dataSource)
/*      */     throws DeploymentException
/*      */   {
/* 1033 */     Connection con = null;
/* 1034 */     ResultSet rs = null;
/*      */     try
/*      */     {
/* 1037 */       con = dataSource.getConnection();
/*      */ 
/* 1041 */       DatabaseMetaData dmd = con.getMetaData();
/* 1042 */       String catalog = con.getCatalog();
/* 1043 */       String schema = null;
/* 1044 */       String quote = dmd.getIdentifierQuoteString();
/* 1045 */       if (tableName.startsWith(quote))
/*      */       {
/* 1047 */         if (!tableName.endsWith(quote))
/*      */         {
/* 1049 */           throw new DeploymentException("Mismatched quote in table name: " + tableName);
/*      */         }
/* 1051 */         int quoteLength = quote.length();
/* 1052 */         tableName = tableName.substring(quoteLength, tableName.length() - quoteLength);
/* 1053 */         if (dmd.storesLowerCaseQuotedIdentifiers())
/* 1054 */           tableName = tableName.toLowerCase();
/* 1055 */         else if (dmd.storesUpperCaseQuotedIdentifiers()) {
/* 1056 */           tableName = tableName.toUpperCase();
/*      */         }
/*      */ 
/*      */       }
/* 1060 */       else if (dmd.storesLowerCaseIdentifiers()) {
/* 1061 */         tableName = tableName.toLowerCase();
/* 1062 */       } else if (dmd.storesUpperCaseIdentifiers()) {
/* 1063 */         tableName = tableName.toUpperCase();
/*      */       }
/*      */       int dotIndex;
/* 1068 */       if ((dotIndex = tableName.indexOf('.')) != -1)
/*      */       {
/* 1071 */         schema = tableName.substring(0, dotIndex);
/* 1072 */         tableName = tableName.substring(dotIndex + 1);
/*      */       }
/*      */ 
/* 1075 */       rs = dmd.getTables(catalog, schema, tableName, null);
/* 1076 */       bool = rs.next();
/*      */     }
/*      */     catch (SQLException e)
/*      */     {
/*      */       boolean bool;
/* 1082 */       throw new DeploymentException("Error while checking if table aleady exists " + tableName, e);
/*      */     }
/*      */     finally
/*      */     {
/* 1086 */       JDBCUtil.safeClose(rs);
/* 1087 */       JDBCUtil.safeClose(con);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static OldColumns getOldColumns(String tableName, DataSource dataSource)
/*      */     throws DeploymentException
/*      */   {
/* 1094 */     Connection con = null;
/* 1095 */     ResultSet rs = null;
/* 1096 */     ArrayList columnNames = new ArrayList();
/* 1097 */     ArrayList typeNames = new ArrayList();
/* 1098 */     ArrayList columnSizes = new ArrayList();
/*      */     try
/*      */     {
/* 1101 */       con = dataSource.getConnection();
/*      */ 
/* 1105 */       DatabaseMetaData dmd = con.getMetaData();
/* 1106 */       String catalog = con.getCatalog();
/* 1107 */       String schema = null;
/* 1108 */       String quote = dmd.getIdentifierQuoteString();
/* 1109 */       if (tableName.startsWith(quote))
/*      */       {
/* 1111 */         if (!tableName.endsWith(quote))
/*      */         {
/* 1113 */           throw new DeploymentException("Mismatched quote in table name: " + tableName);
/*      */         }
/* 1115 */         int quoteLength = quote.length();
/* 1116 */         tableName = tableName.substring(quoteLength, tableName.length() - quoteLength);
/* 1117 */         if (dmd.storesLowerCaseQuotedIdentifiers())
/* 1118 */           tableName = tableName.toLowerCase();
/* 1119 */         else if (dmd.storesUpperCaseQuotedIdentifiers()) {
/* 1120 */           tableName = tableName.toUpperCase();
/*      */         }
/*      */ 
/*      */       }
/* 1124 */       else if (dmd.storesLowerCaseIdentifiers()) {
/* 1125 */         tableName = tableName.toLowerCase();
/* 1126 */       } else if (dmd.storesUpperCaseIdentifiers()) {
/* 1127 */         tableName = tableName.toUpperCase();
/*      */       }
/*      */       int dotIndex;
/* 1132 */       if ((dotIndex = tableName.indexOf('.')) != -1)
/*      */       {
/* 1135 */         schema = tableName.substring(0, dotIndex);
/* 1136 */         tableName = tableName.substring(dotIndex + 1);
/*      */       }
/*      */ 
/* 1139 */       rs = dmd.getColumns(catalog, schema, tableName, null);
/* 1140 */       while (rs.next())
/*      */       {
/* 1142 */         columnName = rs.getString("COLUMN_NAME");
/* 1143 */         columnNames.add(columnName == null ? null : columnName.toUpperCase());
/* 1144 */         typeNames.add(rs.getString("TYPE_NAME"));
/* 1145 */         columnSizes.add(new Integer(rs.getInt("COLUMN_SIZE")));
/*      */       }
/* 1147 */       columnName = new OldColumns(columnNames, typeNames, columnSizes, null);
/*      */     }
/*      */     catch (SQLException e)
/*      */     {
/*      */       String columnName;
/* 1154 */       throw new DeploymentException("Error while geting column names", e);
/*      */     }
/*      */     finally
/*      */     {
/* 1158 */       JDBCUtil.safeClose(rs);
/* 1159 */       JDBCUtil.safeClose(con);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static OldIndexes getOldIndexes(String tableName, DataSource dataSource)
/*      */     throws DeploymentException
/*      */   {
/* 1166 */     tableName = unquote(tableName, dataSource);
/*      */ 
/* 1168 */     Connection con = null;
/* 1169 */     ResultSet rs = null;
/* 1170 */     ArrayList indexNames = new ArrayList();
/* 1171 */     ArrayList columnNames = new ArrayList();
/* 1172 */     ArrayList ascDesc = new ArrayList();
/*      */     try
/*      */     {
/* 1175 */       con = dataSource.getConnection();
/*      */ 
/* 1179 */       DatabaseMetaData dmd = con.getMetaData();
/* 1180 */       String catalog = con.getCatalog();
/* 1181 */       String schema = null;
/* 1182 */       if (dmd.storesLowerCaseIdentifiers())
/* 1183 */         tableName = tableName.toLowerCase();
/* 1184 */       else if (dmd.storesUpperCaseIdentifiers())
/* 1185 */         tableName = tableName.toUpperCase();
/*      */       int dotIndex;
/* 1189 */       if ((dotIndex = tableName.indexOf('.')) != -1)
/*      */       {
/* 1192 */         schema = tableName.substring(0, dotIndex);
/* 1193 */         tableName = tableName.substring(dotIndex + 1);
/*      */       }
/*      */ 
/* 1196 */       rs = dmd.getIndexInfo(catalog, schema, tableName, false, false);
/* 1197 */       while (rs.next())
/*      */       {
/* 1199 */         indexNames.add(rs.getString("INDEX_NAME"));
/* 1200 */         columnNames.add(rs.getString("COLUMN_NAME"));
/* 1201 */         ascDesc.add(rs.getString("ASC_OR_DESC"));
/*      */       }
/* 1203 */       localOldIndexes = new OldIndexes(indexNames, columnNames, ascDesc, null);
/*      */     }
/*      */     catch (SQLException e)
/*      */     {
/*      */       OldIndexes localOldIndexes;
/* 1210 */       throw new DeploymentException("Error while geting column names", e);
/*      */     }
/*      */     finally
/*      */     {
/* 1214 */       JDBCUtil.safeClose(rs);
/* 1215 */       JDBCUtil.safeClose(con);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static String unquote(String tableName, DataSource ds)
/*      */     throws DeploymentException
/*      */   {
/* 1222 */     Connection con = null;
/*      */     try
/*      */     {
/* 1225 */       con = ds.getConnection();
/* 1226 */       String quote = con.getMetaData().getIdentifierQuoteString();
/* 1227 */       if (tableName.startsWith(quote))
/*      */       {
/* 1229 */         if (!tableName.endsWith(quote))
/*      */         {
/* 1231 */           throw new DeploymentException("Mismatched quote in table name: " + tableName);
/*      */         }
/* 1233 */         int quoteLength = quote.length();
/* 1234 */         tableName = tableName.substring(quoteLength, tableName.length() - quoteLength);
/*      */       }
/*      */     }
/*      */     catch (SQLException e)
/*      */     {
/* 1239 */       throw new DeploymentException("Failed to get datasource connection");
/*      */     }
/*      */     finally
/*      */     {
/* 1243 */       JDBCUtil.safeClose(con);
/*      */     }
/* 1245 */     return tableName;
/*      */   }
/*      */ 
/*      */   private static JDBCType getJDBCType(JDBCFieldBridge field)
/*      */   {
/* 1250 */     JDBCType type = field.getJDBCType();
/* 1251 */     if ((type != null) && (type.getColumnNames().length > 0))
/*      */     {
/* 1253 */       return type;
/*      */     }
/* 1255 */     return null;
/*      */   }
/*      */ 
/*      */   public static void dropTable(DataSource dataSource, String tableName)
/*      */     throws DeploymentException
/*      */   {
/* 1262 */     Logger log = Logger.getLogger("CLEANER");
/* 1263 */     String sql = "DROP TABLE " + tableName;
/*      */     try
/*      */     {
/* 1266 */       Connection con = null;
/* 1267 */       Statement statement = null;
/*      */       try
/*      */       {
/* 1271 */         con = dataSource.getConnection();
/* 1272 */         statement = con.createStatement();
/* 1273 */         statement.executeUpdate(sql);
/*      */       }
/*      */       finally
/*      */       {
/* 1279 */         JDBCUtil.safeClose(statement);
/* 1280 */         JDBCUtil.safeClose(con);
/*      */       }
/*      */     } catch (Exception e) {
/* 1283 */       throw new DeploymentException("Error while droping table " + tableName, e);
/*      */     }
/* 1285 */     log.info("Dropped table " + tableName + " succesfuly");
/*      */   }
/*      */ 
/*      */   public static class OldIndexes
/*      */   {
/*      */     private ArrayList indexNames;
/*      */     private ArrayList columnNames;
/*      */     private ArrayList columnAscDesc;
/*      */ 
/*      */     private OldIndexes(ArrayList in, ArrayList cn, ArrayList ad)
/*      */     {
/* 1331 */       this.indexNames = in;
/* 1332 */       this.columnNames = cn;
/* 1333 */       this.columnAscDesc = ad;
/*      */     }
/*      */ 
/*      */     public ArrayList getColumnNames()
/*      */     {
/* 1338 */       return this.columnNames;
/*      */     }
/*      */ 
/*      */     public ArrayList getIndexNames()
/*      */     {
/* 1343 */       return this.indexNames;
/*      */     }
/*      */ 
/*      */     public ArrayList getColumnAscDesc()
/*      */     {
/* 1348 */       return this.columnAscDesc;
/*      */     }
/*      */   }
/*      */ 
/*      */   public static class OldColumns
/*      */   {
/*      */     private ArrayList columnNames;
/*      */     private ArrayList typeNames;
/*      */     private ArrayList columnSizes;
/*      */ 
/*      */     private OldColumns(ArrayList cn, ArrayList tn, ArrayList cs)
/*      */     {
/* 1299 */       this.columnNames = cn;
/* 1300 */       this.typeNames = tn;
/* 1301 */       this.columnSizes = cs;
/*      */     }
/*      */ 
/*      */     public ArrayList getColumnNames()
/*      */     {
/* 1306 */       return this.columnNames;
/*      */     }
/*      */ 
/*      */     public ArrayList getTypeNames()
/*      */     {
/* 1311 */       return this.typeNames;
/*      */     }
/*      */ 
/*      */     public ArrayList getColumnSizes()
/*      */     {
/* 1316 */       return this.columnSizes;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.SQLUtil
 * JD-Core Version:    0.6.0
 */