/*     */ package org.jboss.ejb.plugins.cmp.jdbc.keygen;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ 
/*     */ public class JDBC30GeneratedKeysCreateCommand extends JDBCIdentityColumnCreateCommand
/*     */ {
/*     */   private static final Method CONNECTION_PREPARE;
/*     */   private static final Integer GENERATE_KEYS;
/*     */   private static final Method GET_GENERATED_KEYS;
/*     */ 
/*     */   public void init(JDBCStoreManager manager)
/*     */     throws DeploymentException
/*     */   {
/*  70 */     if (CONNECTION_PREPARE == null) {
/*  71 */       throw new DeploymentException("Create command requires JDBC 3.0 (JDK1.4+)");
/*     */     }
/*  73 */     super.init(manager);
/*     */   }
/*     */ 
/*     */   protected PreparedStatement prepareStatement(Connection c, String sql, EntityEnterpriseContext ctx) throws SQLException
/*     */   {
/*     */     try {
/*  79 */       return (PreparedStatement)CONNECTION_PREPARE.invoke(c, new Object[] { sql, GENERATE_KEYS }); } catch (Exception e) {
/*     */     }
/*  81 */     throw processException(e);
/*     */   }
/*     */ 
/*     */   protected int executeInsert(int paramIndex, PreparedStatement ps, EntityEnterpriseContext ctx)
/*     */     throws SQLException
/*     */   {
/*  87 */     int rows = ps.executeUpdate();
/*  88 */     ResultSet rs = null;
/*     */     try {
/*  90 */       rs = (ResultSet)GET_GENERATED_KEYS.invoke(ps, null);
/*  91 */       if (!rs.next())
/*     */       {
/*  93 */         throw new EJBException("getGeneratedKeys returned an empty ResultSet");
/*     */       }
/*  95 */       this.pkField.loadInstanceResults(rs, 1, ctx);
/*     */     } catch (RuntimeException e) {
/*  97 */       throw e;
/*     */     }
/*     */     catch (Exception e) {
/* 100 */       throw new EJBException("Error extracting generated keys", e);
/*     */     } finally {
/* 102 */       JDBCUtil.safeClose(rs);
/*     */     }
/* 104 */     return rows;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     Method prepare;
/*     */     Method getGeneratedKeys;
/*     */     Integer generateKeys;
/*     */     try
/*     */     {
/*  54 */       prepare = Connection.class.getMethod("prepareStatement", new Class[] { String.class, Integer.TYPE });
/*  55 */       getGeneratedKeys = PreparedStatement.class.getMethod("getGeneratedKeys", null);
/*  56 */       Field f = PreparedStatement.class.getField("RETURN_GENERATED_KEYS");
/*  57 */       generateKeys = (Integer)f.get(PreparedStatement.class);
/*     */     } catch (Exception e) {
/*  59 */       prepare = null;
/*  60 */       getGeneratedKeys = null;
/*  61 */       generateKeys = null;
/*     */     }
/*  63 */     CONNECTION_PREPARE = prepare;
/*  64 */     GET_GENERATED_KEYS = getGeneratedKeys;
/*  65 */     GENERATE_KEYS = generateKeys;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.keygen.JDBC30GeneratedKeysCreateCommand
 * JD-Core Version:    0.6.0
 */