/*     */ package org.jboss.ejb.plugins.cmp.jdbc.keygen;
/*     */ 
/*     */ import java.sql.CallableStatement;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.SQLException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JDBCOracleSequenceCreateCommand extends JDBCIdentityColumnCreateCommand
/*     */ {
/*     */   private String sequence_name;
/*     */   private int pkIndex;
/*     */   private int jdbcType;
/*     */ 
/*     */   public void init(JDBCStoreManager manager)
/*     */     throws DeploymentException
/*     */   {
/*  56 */     super.init(manager);
/*     */   }
/*     */ 
/*     */   protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException
/*     */   {
/*  61 */     super.initEntityCommand(entityCommand);
/*  62 */     this.sequence_name = entityCommand.getAttribute("sequence_name");
/*  63 */     if (this.sequence_name == null)
/*  64 */       throw new DeploymentException("sequence_name attribute must be specified inside <entity-command>");
/*     */   }
/*     */ 
/*     */   protected void initInsertSQL()
/*     */   {
/*  70 */     this.pkIndex = (1 + this.insertFields.length);
/*  71 */     this.jdbcType = this.pkField.getJDBCType().getJDBCTypes()[0];
/*     */ 
/*  73 */     StringBuffer sql = new StringBuffer();
/*  74 */     sql.append("{call INSERT INTO ").append(this.entity.getTableName());
/*  75 */     sql.append(" (");
/*  76 */     SQLUtil.getColumnNamesClause(this.pkField, sql).append(", ");
/*     */ 
/*  79 */     SQLUtil.getColumnNamesClause(this.insertFields, sql);
/*     */ 
/*  81 */     sql.append(")");
/*  82 */     sql.append(" VALUES (");
/*  83 */     String sequence_name_inst = replaceTable(this.sequence_name, this.entity.getTableName());
/*     */ 
/*  85 */     sql.append(sequence_name_inst + ".NEXTVAL, ");
/*  86 */     SQLUtil.getValuesClause(this.insertFields, sql);
/*  87 */     sql.append(")");
/*  88 */     sql.append(" RETURNING ");
/*  89 */     SQLUtil.getColumnNamesClause(this.pkField, sql).append(" INTO ? }");
/*     */ 
/*  91 */     this.insertSQL = sql.toString();
/*  92 */     if (this.debug)
/*  93 */       this.log.debug("Insert Entity SQL: " + this.insertSQL);
/*     */   }
/*     */ 
/*     */   protected PreparedStatement prepareStatement(Connection c, String sql, EntityEnterpriseContext ctx)
/*     */     throws SQLException
/*     */   {
/*  99 */     return c.prepareCall(sql);
/*     */   }
/*     */ 
/*     */   protected int executeInsert(int paramInd, PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException
/*     */   {
/* 104 */     CallableStatement cs = (CallableStatement)ps;
/* 105 */     cs.registerOutParameter(this.pkIndex, this.jdbcType);
/* 106 */     cs.execute();
/* 107 */     Object pk = JDBCUtil.getParameter(this.log, cs, this.pkIndex, this.jdbcType, this.pkField.getFieldType());
/* 108 */     this.pkField.setInstanceValue(ctx, pk);
/* 109 */     return 1;
/*     */   }
/*     */ 
/*     */   private static String replaceTable(String in, String table)
/*     */   {
/* 123 */     int pos = in.indexOf("%%t");
/*     */ 
/* 125 */     if (pos == -1) {
/* 126 */       return in;
/*     */     }
/* 128 */     String first = in.substring(0, pos);
/* 129 */     String last = in.substring(pos + 3);
/*     */ 
/* 131 */     return first + table + last;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.keygen.JDBCOracleSequenceCreateCommand
 * JD-Core Version:    0.6.0
 */